/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.ui.editor.widgetAdapter;

import com.arcway.lib.ui.editor.datatype.ConstantTextProvider;
import com.arcway.lib.ui.editor.datatype.IDataWidget;
import com.arcway.lib.ui.editor.playground.IEditorPlayground;
import com.arcway.lib.ui.editor.playground.PropertyPlayground;
import com.arcway.lib.ui.editor.widgetAdapter.AbstractPropertyWidgetAdapter;
import com.arcway.lib.ui.editor.widgetAdapter.IWidgetAdapter;
import com.arcway.lib.ui.editor.widgetAdapter.IWidgetAdapterManager;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;

public class URLWidgetURLPropertyWidgetAdapter
extends AbstractPropertyWidgetAdapter {
    private final PropertyPlayground<?, ?, ?, ?> playground;

    public URLWidgetURLPropertyWidgetAdapter(IWidgetAdapterManager widgetAdapterManager, Collection<IEditorPlayground> playgrounds) {
        super(widgetAdapterManager, playgrounds);
        this.playground = (PropertyPlayground)playgrounds.iterator().next();
    }

    @Override
    public void widgetModified() {
        IDataWidget widget = this.getWidget();
        this.removeWidgetAdapterError();
        String newValue = (String)widget.getCurrentValue();
        if (newValue.length() == 0) {
            this.playground.setValue(null, this);
            return;
        }
        if (newValue.length() > 3 && newValue.substring(0, 4).equals("www.")) {
            newValue = "http://" + newValue;
        }
        try {
            URL newURL = new URL(newValue);
            this.playground.setValue(newURL, this);
        }
        catch (MalformedURLException e) {
            this.setWidgetAdapterError(new ConstantTextProvider(e.getLocalizedMessage()));
        }
    }

    @Override
    public Object getValue(IWidgetAdapter.WidgetUpdateMode mode) {
        URL value = (URL)this.playground.getValue();
        if (value != null) {
            return value.toString();
        }
        return "";
    }

    public URL getValueAsURL() {
        return (URL)this.playground.getValue();
    }
}

