/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.ui.editor.exception;

import com.arcway.lib.Messages;
import com.arcway.lib.icons.Icons16x16;
import com.arcway.lib.resource.IStreamResource;
import com.arcway.lib.ui.editor.exception.IMessage;
import java.util.Locale;
import org.eclipse.osgi.util.NLS;

public class CompressedMessage
implements IMessage {
    private final Locale userLocale;
    private int nrOfErrors = 0;
    private int nrOfWarnings = 0;
    private int nrOfInfos = 0;
    private boolean singleTextPossible = false;
    private String singleText;
    private boolean singleIconPossible = true;
    private IStreamResource singleIcon = null;

    public CompressedMessage(Locale userLocale) {
        this.userLocale = userLocale;
    }

    public void addMessage(IMessage message) {
        int level = message.getLevel();
        if (level == 4) {
            ++this.nrOfInfos;
        } else if (level == 3) {
            ++this.nrOfWarnings;
        } else {
            ++this.nrOfErrors;
        }
        if (this.singleTextPossible) {
            String text = message.getText();
            if (this.singleText == null) {
                this.singleText = text;
            } else if (text != null && !this.singleText.equals(text)) {
                this.singleText = null;
                this.singleTextPossible = false;
            }
        }
        if (this.singleIconPossible) {
            IStreamResource icon = message.getIcon16x16();
            if (this.singleIcon == null) {
                this.singleIcon = icon;
            } else if (icon != null && !this.singleIcon.equals(icon)) {
                this.singleIcon = null;
                this.singleIconPossible = false;
            }
        }
    }

    @Override
    public int getLevel() {
        return this.nrOfErrors > 0 ? 2 : (this.nrOfWarnings > 0 ? 3 : 4);
    }

    @Override
    public String getText() {
        return this.singleText != null ? this.singleText : (this.nrOfErrors == 1 ? Messages.getString("CompressedMessage.Error", this.userLocale) : (this.nrOfErrors > 0 ? NLS.bind((String)Messages.getString("CompressedMessage.Errors", this.userLocale), (Object)Integer.toString(this.nrOfErrors)) : (this.nrOfWarnings == 1 ? Messages.getString("CompressedMessage.Warning", this.userLocale) : (this.nrOfWarnings > 0 ? NLS.bind((String)Messages.getString("CompressedMessage.Warnings", this.userLocale), (Object)Integer.toString(this.nrOfWarnings)) : (this.nrOfInfos == 1 ? Messages.getString("CompressedMessage.Info", this.userLocale) : (this.nrOfInfos > 0 ? NLS.bind((String)Messages.getString("CompressedMessage.Infos", this.userLocale), (Object)Integer.toString(this.nrOfInfos)) : Messages.getString("CompressedMessage.OK", this.userLocale)))))));
    }

    @Override
    public IStreamResource getIcon16x16() {
        return this.singleIcon != null ? this.singleIcon : (this.nrOfErrors > 0 ? Icons16x16.ERROR : (this.nrOfWarnings > 0 ? Icons16x16.WARNING : (this.nrOfInfos > 0 ? Icons16x16.INFO : Icons16x16.OK)));
    }
}

