/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.ui.contextmenus;

import com.arcway.lib.java.collections.ICollection_;
import com.arcway.lib.java.collections.IIterator_;
import com.arcway.lib.ui.contextmenus.ContextMenuContributorExtensionPoint;
import com.arcway.lib.ui.contextmenus.IContextMenuContributor;
import com.arcway.lib.ui.contextmenus.IContextMenuEntry;
import com.arcway.lib.ui.contextmenus.IContextMenuManager;
import com.arcway.lib.ui.contextmenus.ISelectionTranslationManager;
import com.arcway.lib.ui.contextmenus.SelectionTranslationManager;
import java.util.ArrayList;
import java.util.Iterator;

public class ContextMenuManager
implements IContextMenuManager {
    private final ISelectionTranslationManager selectionTranslationManager = SelectionTranslationManager.getSelectionTranslationManager();
    private static ContextMenuManager INSTANCE = null;

    public static synchronized ContextMenuManager getContextMenuManager() {
        if (INSTANCE == null) {
            INSTANCE = new ContextMenuManager();
        }
        return INSTANCE;
    }

    private ContextMenuManager() {
    }

    @Override
    public IContextMenuEntry[] getContextMenuEntries(Object[] items) {
        ArrayList<Object> contextMenuEntries = new ArrayList<Object>();
        this.selectionTranslationManager.resetSelectionTranslationCache();
        ContextMenuContributorExtensionPoint extensionPoint = ContextMenuContributorExtensionPoint.getInstance();
        ICollection_<IContextMenuContributor> contributors = extensionPoint.getContextMenuContributors();
        IIterator_ contributorIterator = contributors.iterator();
        while (contributorIterator.hasNext()) {
            IContextMenuEntry[] entries;
            Object element;
            int n;
            int n2;
            Object[] objectArray;
            Object[] itemsToWorkOn = new Object[items.length];
            IContextMenuContributor contributor = (IContextMenuContributor)contributorIterator.next();
            Class<?>[] supportedTypes = contributor.getAllSupportedTypes();
            boolean supported = false;
            int i = 0;
            while (i < items.length) {
                objectArray = supportedTypes;
                n2 = supportedTypes.length;
                n = 0;
                while (n < n2) {
                    element = objectArray[n];
                    supported = false;
                    if (((Class)element).isInstance(items[i])) {
                        itemsToWorkOn[i] = items[i];
                        supported = true;
                        break;
                    }
                    ++n;
                }
                if (!supported) {
                    Object translatedItem = this.selectionTranslationManager.translate(supportedTypes, items[i]);
                    if (translatedItem == null) break;
                    itemsToWorkOn[i] = translatedItem;
                    supported = true;
                }
                ++i;
            }
            if (!supported || (entries = contributor.getContextMenuEntries(itemsToWorkOn)) == null) continue;
            objectArray = entries;
            n2 = entries.length;
            n = 0;
            while (n < n2) {
                element = objectArray[n];
                if (element != null) {
                    contextMenuEntries.add(element);
                }
                ++n;
            }
        }
        IContextMenuEntry[] entryArray = new IContextMenuEntry[contextMenuEntries.size()];
        Iterator entryIterator = contextMenuEntries.iterator();
        int i = 0;
        while (entryIterator.hasNext()) {
            entryArray[i++] = (IContextMenuEntry)entryIterator.next();
        }
        return entryArray;
    }
}

