/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.graphics.saveimage;

class CRC {
    private static int[] crcTable = new int[256];
    private int crc = -1;

    static {
        int n = 0;
        while (n < 256) {
            int c = n;
            int k = 0;
            while (k < 8) {
                c = (c & 1) == 1 ? 0xEDB88320 ^ c >>> 1 : (c >>>= 1);
                CRC.crcTable[n] = c;
                ++k;
            }
            ++n;
        }
    }

    public void reset() {
        this.crc = -1;
    }

    public void update(byte[] data, int off, int len) {
        int n = 0;
        while (n < len) {
            this.crc = crcTable[(this.crc ^ data[off + n]) & 0xFF] ^ this.crc >>> 8;
            ++n;
        }
    }

    public void update(int data) {
        this.crc = crcTable[(this.crc ^ data) & 0xFF] ^ this.crc >>> 8;
    }

    public int getValue() {
        return ~this.crc;
    }
}

