/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.graphics.print;

import com.arcway.lib.geometry.GeoVector;
import com.arcway.lib.geometry.Point;
import com.arcway.lib.geometry.Rectangle;
import com.arcway.lib.geometry.Transformation;
import com.arcway.lib.geometry.TransformationAffiliate;
import com.arcway.lib.graphics.EXNoMoreHandles;
import com.arcway.lib.graphics.device.Device;
import com.arcway.lib.graphics.devicedrivers.IDeviceDriverOffscreenBitmap;
import com.arcway.lib.graphics.image.EXImageTooBig;
import com.arcway.lib.graphics.image.Image;
import com.arcway.lib.graphics.image.ImageCoDec;
import com.arcway.lib.graphics.image.ImageFileType;
import com.arcway.lib.graphics.print.EXEmptyResult;
import com.arcway.lib.graphics.print.IImagePrinterPageDescription;
import com.arcway.lib.graphics.print.IPrinter;
import com.arcway.lib.graphics.print.PrintingFailure;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class ImagePrinter
implements IPrinter {
    private Image image;
    private final Collection images = new ArrayList();
    protected IImagePrinterPageDescription info;
    private File directory;
    private String prefix;
    private int offset;
    private ImageFileType type;
    private final TransformationAffiliate mmToImage;
    private final TransformationAffiliate imageToMm;
    private final int[] size;
    private final Rectangle clippingAreaInPixel;

    public ImagePrinter(IImagePrinterPageDescription info) {
        assert (info != null) : "info is null";
        this.info = info;
        double FX = info.getHorizontalDPI() / 25.4;
        double FY = info.getVerticalDPI() / 25.4;
        this.mmToImage = TransformationAffiliate.newTransformationScaling(new GeoVector(FX, FY));
        this.imageToMm = this.mmToImage.getInverse();
        this.size = this.getSizeInPixels(info, this.mmToImage);
        this.clippingAreaInPixel = this.getClippingAreaInPixels(info, this.mmToImage, this.size[0] - 1, this.size[1] - 1);
    }

    public ImagePrinter(IImagePrinterPageDescription info, File directory, String prefix, int offset, ImageFileType type) {
        this(info);
        this.directory = directory;
        this.prefix = prefix;
        this.offset = offset;
        this.type = type;
    }

    private Image createNewImage(IImagePrinterPageDescription pageInfo) throws EXImageTooBig, EXNoMoreHandles {
        return new Image(this.size[0], this.size[1], pageInfo.getBGColor(), pageInfo.getHorizontalDPI() * 39.37007874015748, pageInfo.getVerticalDPI() * 39.37007874015748, false);
    }

    private int[] getSizeInPixels(IImagePrinterPageDescription infoToUse, Transformation trafo) {
        int[] calculatedSize = new int[2];
        Point point = new Point(infoToUse.getPageDimension().width, infoToUse.getPageDimension().height);
        point = point.transform(trafo);
        calculatedSize[0] = (int)Math.ceil(point.x - 1.0E-10);
        calculatedSize[1] = (int)Math.ceil(point.y - 1.0E-10);
        return calculatedSize;
    }

    private Rectangle getClippingAreaInPixels(IImagePrinterPageDescription infoToUse, Transformation trafo, int xMax, int yMax) {
        Rectangle pageArea = new Rectangle(0.0, 0.0, infoToUse.getPageDimension());
        Rectangle printableArea = pageArea.shrink(infoToUse.getPrintAreaInsets());
        Rectangle pageAreaTransformed = pageArea.transform(trafo);
        Rectangle printableAreaTransformed = printableArea.transform(trafo);
        printableAreaTransformed = printableAreaTransformed.translate(new GeoVector(pageAreaTransformed.upperLeft).turn180());
        int x1 = Math.max(0, Math.min(xMax, (int)Math.floor(printableAreaTransformed.upperLeft.x + 1.0E-10)));
        int y1 = Math.max(0, Math.min(yMax, (int)Math.floor(printableAreaTransformed.upperLeft.y + 1.0E-10)));
        int x2 = Math.max(0, Math.min(xMax, (int)Math.ceil(printableAreaTransformed.lowerRight.x - 1.0E-10)));
        int y2 = Math.max(0, Math.min(yMax, (int)Math.ceil(printableAreaTransformed.lowerRight.y - 1.0E-10)));
        return new Rectangle(x1, y1, x2, y2);
    }

    @Override
    public Rectangle getPageSize() {
        Rectangle pageSize = new Rectangle(0.0, 0.0, this.size[0], this.size[1]);
        return pageSize.transform(this.imageToMm);
    }

    @Override
    public Rectangle getDrawingArea() {
        return this.clippingAreaInPixel.transform(this.imageToMm);
    }

    @Override
    public void performJob(String jobName, IPrinter.IPrintingJobProcessor jobProcessor) throws PrintingFailure {
        jobProcessor.processPrintingJob(new IPrinter.IPrintingJob(){

            @Override
            public void drawPage(Rectangle totalDrawingHint, IPrinter.IPagePrinter pagePrinter) throws PrintingFailure {
                try {
                    ImagePrinter.this.image = ImagePrinter.this.createNewImage(ImagePrinter.this.info);
                }
                catch (EXImageTooBig e) {
                    if (e.getCause() != null) {
                        throw new PrintingFailure(e.getCause());
                    }
                    throw new PrintingFailure(e);
                }
                catch (EXNoMoreHandles e) {
                    if (e.getCause() != null) {
                        throw new PrintingFailure(e.getCause());
                    }
                    throw new PrintingFailure(e);
                }
                IDeviceDriverOffscreenBitmap deviceDriverOffscreenBitmap = ImagePrinter.this.image.createDeviceDriver();
                deviceDriverOffscreenBitmap.setClipping(ImagePrinter.this.clippingAreaInPixel);
                Device device = new Device(deviceDriverOffscreenBitmap, ImagePrinter.this.mmToImage);
                pagePrinter.printPage(device);
                deviceDriverOffscreenBitmap.dispose();
                ImagePrinter.this.images.add(ImagePrinter.this.image);
            }
        });
        if (this.directory != null) {
            this.saveCreatedImages(this.directory, this.prefix, this.offset, this.type);
        }
    }

    public Collection getCreatedImages() {
        return this.images;
    }

    public void saveCreatedImages(File directoryToUse, String prefixToUse, int offsetToUse, ImageFileType format) throws PrintingFailure {
        Iterator img = this.images.iterator();
        int count = offsetToUse;
        while (img.hasNext()) {
            Image i = (Image)img.next();
            File filename = new File(directoryToUse.getAbsolutePath(), String.valueOf(prefixToUse) + count + '.' + format.getFileExtension());
            try {
                ImageCoDec.encodeIntoFile(i, filename, format);
            }
            catch (Exception e) {
                throw new PrintingFailure(e);
            }
            ++count;
        }
    }

    public void saveImageDirectly(File file, ImageFileType format) throws PrintingFailure, EXEmptyResult {
        Iterator img = this.images.iterator();
        if (img.hasNext()) {
            Image i = (Image)img.next();
            try {
                ImageCoDec.encodeIntoFile(i, file, format);
            }
            catch (Exception e) {
                throw new PrintingFailure(e);
            }
        } else {
            throw new EXEmptyResult();
        }
    }

    public void disposeImages() {
        for (Image i : this.images) {
            i.dispose();
        }
    }
}

