/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.graphics.devicedrivers;

import com.arcway.lib.geometry.Direction;
import com.arcway.lib.graphics.Color;
import com.arcway.lib.graphics.devicedrivers.AbstractDeviceDriver;
import com.arcway.lib.graphics.linestyles.LineStyle;

public abstract class DeviceDriverAttributeStorage
extends AbstractDeviceDriver {
    private double lineWidth = 1.0;
    private double lineScale = 1.0;
    private LineStyle lineStyle = LineStyle.SOLID;
    private Color lineColor = Color.BLACK;
    private Color fillColor = Color.BLACK;
    private int fillAlpha = 255;
    private String textFontName = "Arial";
    private double textLineHeight = 1.0;
    private double textTop = 0.8;
    private double textAscent = 0.7;
    private double textDescent = -0.1;
    private Direction textDirection = Direction.ANGLE_0;
    private int textAlignment = 1;
    private Color textColor = Color.BLACK;
    private boolean textBold = false;
    private boolean textItalic = false;

    protected final LineStyle getLineStyle() {
        return this.lineStyle;
    }

    @Override
    public void setLineStyle(LineStyle lineStyle) {
        assert (lineStyle != null) : "lineStyle = null";
        this.lineStyle = lineStyle;
    }

    public final double getLineWidth() {
        return this.lineWidth;
    }

    @Override
    public void setLineWidth(double lineWidth) {
        assert (lineWidth >= -1.0E-10) : "lineWidth < null";
        this.lineWidth = lineWidth;
    }

    protected final double getLineScale() {
        return this.lineScale;
    }

    @Override
    public void setLineScale(double lineScale) {
        assert (lineScale >= -1.0E-10) : "lineScale < null";
        this.lineScale = lineScale;
    }

    protected final Color getLineColor() {
        return this.lineColor;
    }

    @Override
    public void setLineColor(Color lineColor) {
        assert (lineColor != null) : "lineColor = null";
        this.lineColor = new Color(lineColor);
    }

    protected final Color getFillColor() {
        return this.fillColor;
    }

    protected final int getFillAlpha() {
        return this.fillAlpha;
    }

    @Override
    public void setFillAttributes(Color fillColor, int fillAlpha) {
        assert (fillColor != null);
        this.fillColor = new Color(fillColor);
        this.fillAlpha = fillAlpha;
    }

    protected final String getTextFontName() {
        return this.textFontName;
    }

    @Override
    public void setTextFontName(String textFontName) {
        assert (textFontName != null) : "textFontName = null";
        this.textFontName = textFontName;
    }

    protected final Color getTextColor() {
        return this.textColor;
    }

    @Override
    public void setTextColor(Color textColor) {
        assert (textColor != null) : "textColor = null";
        this.textColor = new Color(textColor);
    }

    protected final double getTextLineHeight() {
        return this.textLineHeight;
    }

    protected final double getTextTop() {
        return this.textTop;
    }

    protected final double getTextAscent() {
        return this.textAscent;
    }

    protected final double getTextDescent() {
        return this.textDescent;
    }

    @Override
    public void setTextSize(double textLineHeight, double textTop, double textAscent, double textDescent) {
        assert (textLineHeight >= -1.0E-10) : "textLineHeight < 0";
        this.textLineHeight = textLineHeight;
        this.textTop = textTop;
        this.textAscent = textAscent;
        this.textDescent = textDescent;
    }

    protected final Direction getTextDirection() {
        return this.textDirection;
    }

    @Override
    public void setTextDirection(Direction textDirection) {
        assert (textDirection != null);
        this.textDirection = textDirection;
    }

    protected final int getTextAlignment() {
        return this.textAlignment;
    }

    @Override
    public void setTextAlignment(int textAlignment) {
        assert (textAlignment == 1 || textAlignment == 2 || textAlignment == 4);
        this.textAlignment = textAlignment;
    }

    protected final boolean isTextBold() {
        return this.textBold;
    }

    @Override
    public void setTextBold(boolean textBold) {
        this.textBold = textBold;
    }

    protected final boolean isTextItalic() {
        return this.textItalic;
    }

    @Override
    public void setTextItalic(boolean textItalic) {
        this.textItalic = textItalic;
    }
}

