/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.graphics;

public class Alignment {
    public static final int H_LEFT = 1;
    public static final int H_CENTER = 2;
    public static final int H_RIGHT = 4;
    public static final int V_TOP = 8;
    public static final int V_CENTER = 16;
    public static final int V_BOTTOM = 32;
    public int h;
    public int v;

    public static boolean isHorizintalAlignment(int alignment) {
        boolean isHorizontalAligment;
        switch (alignment) {
            case 1: 
            case 2: 
            case 4: {
                isHorizontalAligment = true;
                break;
            }
            case 8: 
            case 16: 
            case 32: {
                isHorizontalAligment = false;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return isHorizontalAligment;
    }

    public Alignment() {
        this.h = 2;
        this.v = 16;
    }

    public Alignment(Alignment a) {
        assert (a != null);
        this.h = a.h;
        this.v = a.v;
    }

    public Alignment(int h, int v) {
        assert (h == 1 || h == 2 || h == 4) : "h out of range";
        assert (v == 8 || v == 16 || v == 32) : "v out of range";
        this.h = h;
        this.v = v;
    }

    public Alignment getInverse() {
        int newV;
        int newH;
        if (this.h == 1) {
            newH = 4;
        } else if (this.h == 2) {
            newH = 2;
        } else if (this.h == 4) {
            newH = 1;
        } else {
            throw new IllegalArgumentException();
        }
        if (this.v == 32) {
            newV = 8;
        } else if (this.v == 16) {
            newV = 16;
        } else if (this.v == 8) {
            newV = 32;
        } else {
            throw new IllegalArgumentException();
        }
        return new Alignment(newH, newV);
    }

    public boolean equalsAlignment(Alignment alignment) {
        return this.h == alignment.h && this.v == alignment.v;
    }

    public int hashCodeEqualsAlignment() {
        return this.h ^ this.v;
    }

    @Deprecated
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (o instanceof Alignment) {
            Alignment alignment = (Alignment)o;
            return this.equalsAlignment(alignment);
        }
        return false;
    }

    @Deprecated
    public int hashCode() {
        return this.hashCodeEqualsAlignment();
    }
}

