/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.geometry;

import com.arcway.lib.geometry.Geo;
import com.arcway.lib.geometry.GeoVector;
import com.arcway.lib.geometry.Point;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;

public class Corner
extends Point {
    private static final ILogger logger = Logger.getLogger(Corner.class);
    private static final double RADIUS_INFINITY = Double.POSITIVE_INFINITY;
    public final double radius;
    public final boolean radiusInfinity;

    public Corner(Point point, double radius) {
        super(point);
        this.radius = radius;
        this.radiusInfinity = radius == Double.POSITIVE_INFINITY;
    }

    public Corner(double x, double y, double radius) {
        super(x, y);
        this.radius = radius;
        this.radiusInfinity = radius == Double.POSITIVE_INFINITY;
    }

    public Corner(double x, double y) {
        super(x, y);
        this.radius = Double.POSITIVE_INFINITY;
        this.radiusInfinity = true;
    }

    public Corner(Point point) {
        super(point);
        this.radius = Double.POSITIVE_INFINITY;
        this.radiusInfinity = true;
    }

    public Corner(Corner corner) {
        super(corner);
        this.radius = corner.radius;
        this.radiusInfinity = corner.radiusInfinity;
    }

    public Corner moveCorner(GeoVector v) {
        assert (v != null);
        return new Corner(this.x + v.x, this.y + v.y, this.radius);
    }

    public Corner turnCorner(Point center, double angle) {
        assert (center != null);
        GeoVector d = new GeoVector(center, this);
        d = d.turn(angle);
        d = GeoVector.add(new GeoVector(center), d);
        return new Corner(d.x, d.y, this.radius);
    }

    public boolean equalsCorner(Corner a) {
        return super.equalsPoint(a) && Geo.equals(a.radius, this.radius) && a.radiusInfinity == this.radiusInfinity;
    }

    @Override
    public String toString() {
        return "Corner(point=" + super.toString() + ", radius=" + this.radius + ", radiusInfinity=" + this.radiusInfinity + ")";
    }

    @Override
    @Deprecated
    public boolean equals(Object obj) {
        logger.debug("Don't call hashCode or equals on geometric objects.", (Throwable)new Exception());
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj instanceof Corner) {
            Corner a = (Corner)obj;
            return this.equalsCorner(a);
        }
        return false;
    }

    @Override
    @Deprecated
    public int hashCode() {
        logger.debug("Don't call hashCode or equals on geometric objects.", (Throwable)new Exception());
        return super.hashCode() ^ new Double(this.radius).hashCode();
    }
}

