/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.eclipse.uiframework.treeviews;

import com.arcway.lib.java.To;
import com.arcway.lib.java.locale.PresentationContext;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.ui.treeviews.IBrowserController;
import com.arcway.lib.ui.treeviews.ITreeViewFrontendAgent;
import com.arcway.lib.ui.treeviews.ITreeViewListener;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Display;

public class TreeBrowserController
implements IBrowserController {
    protected TreeViewer viewer;
    protected Display display;
    private RefreshThread refreshThread;
    private final boolean automaticRefresh;
    private final String threadName;
    private final ITreeViewFrontendAgent treeView;
    private final boolean isHistoryTreeView;
    private static final ILogger logger = Logger.getLogger(TreeBrowserController.class);

    public TreeBrowserController(TreeViewer viewer, Display display, ITreeViewFrontendAgent treeView, String viewName, boolean automaticRefresh, boolean isHistoryTreeView) {
        this.viewer = viewer;
        this.display = display;
        this.automaticRefresh = automaticRefresh;
        this.threadName = String.valueOf(viewName) + "-Refresher";
        this.treeView = treeView;
        this.treeView.setupTreeViewListener((ITreeViewListener)this);
        this.isHistoryTreeView = isHistoryTreeView;
    }

    public void treeViewChanged() {
        if (!this.isHistoryTreeView) {
            this.refresh();
        }
    }

    public void treeViewHasNewExparationTime(long expirationTime) {
        if (this.automaticRefresh) {
            if (this.refreshThread == null) {
                this.refreshThread = new RefreshThread(expirationTime);
                this.refreshThread.start();
            } else {
                this.refreshThread.setTimeOfNextRefresh(expirationTime);
            }
        }
    }

    public void treeViewIsShuttingDown(Object key) {
        this.dispose();
        this.treeView.dispose();
    }

    public void refresh() {
        this.stopRefreshThread();
        PresentationContext presentationContext = new PresentationContext(Locale.getDefault(), new Date(), TimeZone.getDefault());
        this.treeView.setPresentationContext(presentationContext);
        if (logger.isDebugEnabled()) {
            logger.debug("### (" + this.threadName + ") Refresh with presentation context time: " + presentationContext.getNow().toString());
        }
        if (!this.viewer.getControl().isDisposed()) {
            this.viewer.refresh();
        }
    }

    public void dispose() {
        this.stopRefreshThread();
    }

    private void stopRefreshThread() {
        if (this.refreshThread != null) {
            this.refreshThread.quit();
            this.refreshThread = null;
        }
    }

    public class RefreshAction
    extends Action {
        public RefreshAction() {
            super("Refresh");
        }

        public void run() {
            TreeBrowserController.this.refresh();
        }
    }

    private class RefreshThread
    extends Thread {
        private long timeOfNextRefresh;
        private boolean run;

        public RefreshThread(long timeOfNextRefresh) {
            if (logger.isDebugEnabled()) {
                logger.debug(String.valueOf(TreeBrowserController.this.threadName) + ": Create refresh thread with time of next refresh: " + new Date(timeOfNextRefresh).toString() + " " + To.string((Object)this));
            }
            this.timeOfNextRefresh = timeOfNextRefresh;
            this.run = true;
            this.setName(TreeBrowserController.this.threadName);
        }

        @Override
        public void run() {
            while (this.getRun()) {
                long nextRefresh = this.getTimeOfNextRefresh();
                long timeToWait = nextRefresh - System.currentTimeMillis();
                boolean interrupted = false;
                try {
                    if (logger.isDebugEnabled()) {
                        logger.debug(String.valueOf(TreeBrowserController.this.threadName) + ": Sleep " + timeToWait + " msec until: " + new Date(nextRefresh).toString() + " " + To.string((Object)this));
                    }
                    RefreshThread.sleep(Math.max(1L, timeToWait));
                }
                catch (InterruptedException e) {
                    interrupted = true;
                }
                if (!interrupted) {
                    if (logger.isDebugEnabled()) {
                        logger.debug(String.valueOf(TreeBrowserController.this.threadName) + ": Enqueue refresh with display.asyncExec(): " + To.string((Object)this));
                    }
                    TreeBrowserController.this.display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (logger.isDebugEnabled()) {
                                logger.debug("*** (" + TreeBrowserController.this.threadName + ") Viewer refresh: run() called via display.asyncExec(): " + To.string((Object)RefreshThread.this));
                            }
                            TreeBrowserController.this.refresh();
                        }
                    });
                    break;
                }
                if (!logger.isDebugEnabled()) continue;
                logger.debug(String.valueOf(TreeBrowserController.this.threadName) + " interupted: " + To.string((Object)this));
            }
        }

        private synchronized boolean getRun() {
            return this.run;
        }

        private synchronized long getTimeOfNextRefresh() {
            this.run = false;
            return this.timeOfNextRefresh;
        }

        public synchronized void setTimeOfNextRefresh(long timeOfNextRefresh) {
            if (logger.isDebugEnabled()) {
                logger.debug(String.valueOf(TreeBrowserController.this.threadName) + ": Set time of next refresh: " + new Date(timeOfNextRefresh).toString() + " " + To.string((Object)this));
            }
            this.timeOfNextRefresh = timeOfNextRefresh;
            this.run = true;
            this.interrupt();
        }

        public synchronized void quit() {
            if (logger.isDebugEnabled()) {
                logger.debug(String.valueOf(TreeBrowserController.this.threadName) + ": Quit refresh thread: " + To.string((Object)this));
            }
            this.run = false;
            this.interrupt();
        }
    }
}

