/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.eclipse.uiframework.editors.imports;

import com.arcway.lib.eclipse.uiframework.editors.EclipseUIFrameWork;
import com.arcway.lib.eclipse.uiframework.editors.EditorInput;
import com.arcway.lib.eclipse.uiframework.editors.imports.ICloseVetoChangedListener;
import com.arcway.lib.eclipse.uiframework.editors.imports.ImportEditorControl;
import com.arcway.lib.eclipse.uiframework.editors.repository.RepositoryEditorInfo;
import com.arcway.lib.eclipse.uiframework.widgets.ImportEditorPageWidget;
import com.arcway.lib.java.locale.PresentationContext;
import com.arcway.lib.java.tuples.Tuple;
import com.arcway.lib.listener.ListenerKey;
import com.arcway.lib.operating.PeriodicTaskScheduler;
import com.arcway.lib.ui.dialog.imports.IEditorMessagesChangeListener;
import com.arcway.lib.ui.dialog.imports.IExceptionHandler;
import com.arcway.lib.ui.dialog.imports.IImportDialogEditorLabelAndLayoutProvider;
import com.arcway.lib.ui.dialog.imports.IImportDialogModelChangeListener;
import com.arcway.lib.ui.dialog.imports.IImportModelAccess;
import com.arcway.lib.ui.dialog.imports.IModelChangeProvider;
import com.arcway.lib.ui.editor.IEditorClosingDecider;
import com.arcway.lib.ui.editor.IEditorController;
import com.arcway.lib.ui.editor.PlaygroundManager;
import com.arcway.lib.ui.editor.WidgetFactoryController;
import com.arcway.lib.ui.editor.datatype.EditorErrorMessage;
import com.arcway.lib.ui.editor.datatype.IEditor;
import com.arcway.lib.ui.editor.datatype.IEditorMessage;
import com.arcway.lib.ui.editor.datatype.IEditorModelAccess;
import com.arcway.lib.ui.editor.datatype.IMessageLevel;
import com.arcway.lib.ui.editor.datatype.IPageWidget;
import com.arcway.lib.ui.editor.datatype.ITextProvider;
import com.arcway.lib.ui.editor.exception.CompressedMessage;
import com.arcway.lib.ui.editor.exception.EEXNotReproducibleSnapshot;
import com.arcway.lib.ui.editor.exception.IMessage;
import com.arcway.lib.ui.editor.playground.PlaygroundError;
import com.arcway.lib.ui.editor.widgetAdapter.WidgetAdapterError;
import com.arcway.lib.ui.modelaccess.ILayout;
import com.arcway.lib.ui.window.IWindow;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class ImportEditor
extends ImportEditorControl
implements IEditor {
    private static final WidgetFactoryController WIDGET_FACTORY = new WidgetFactoryController(EclipseUIFrameWork.UI_TYPE_ID);
    private final PresentationContext presentationContext;
    private final Object importedObject;
    private Collection<IPageWidget> pages;
    private final IWindow window;
    private final Collection<Tuple<List<String>, IEditorMessage>> allErrors = new ArrayList<Tuple<List<String>, IEditorMessage>>();
    private final IEditorController editorController;
    private final IImportModelAccess modelAccess;
    private final RepositoryEditorInfo editorInfo;
    private ListenerKey messageChangeListenerKey;
    private final Collection<ICloseVetoChangedListener> allCloseVetoChangeListener = new HashSet<ICloseVetoChangedListener>();

    public ImportEditor(IWindow window, Composite parent, FormToolkit toolkit, IExceptionHandler exceptionHandler, IModelChangeProvider modelChangeProvider, final IImportModelAccess modelAccess, final Object importedObject, final PresentationContext presentationContext) {
        super(window, parent, EditorInput.getName((IImportDialogEditorLabelAndLayoutProvider)modelAccess, importedObject, presentationContext), EditorInput.getToolTipText((IImportDialogEditorLabelAndLayoutProvider)modelAccess, importedObject, presentationContext), EditorInput.getImageDescriptor((IImportDialogEditorLabelAndLayoutProvider)modelAccess, importedObject, presentationContext), presentationContext.getLocale(), toolkit, exceptionHandler, modelAccess);
        this.presentationContext = presentationContext;
        this.window = window;
        this.importedObject = importedObject;
        this.modelAccess = modelAccess;
        ILayout layout = modelAccess.createLayout(importedObject);
        this.editorController = new PlaygroundManager((IEditorModelAccess)modelAccess, layout, WIDGET_FACTORY, (IEditor)this, new IEditorClosingDecider(){

            public boolean isEditorToClose() {
                return false;
            }
        });
        boolean mergeEnabled = modelAccess.isMergeEnabled(importedObject);
        int importModeOfImportedObject = modelAccess.getImportMode(importedObject);
        if (!mergeEnabled || importModeOfImportedObject == 1) {
            modelAccess.setCompareMode(1);
        }
        this.addPages();
        this.setupMergeEnabled(mergeEnabled);
        this.setupImportMode(this.getMode());
        this.editorInfo = new RepositoryEditorInfo(this.getShell(), 2184, this.getCurrentPresentationContext());
        this.messageChangeListenerKey = new ListenerKey();
        modelAccess.getCurrentModelAndModificationsAccessAgent().getEditorMessageStorage().addMessagesChangeListener(this.messageChangeListenerKey, new IEditorMessagesChangeListener(){

            public void messagesChanged() {
                ImportEditor.this.updateMessages();
            }

            public void dispose() {
                ImportEditor.this.removeMessageChangeListener();
            }
        });
        modelChangeProvider.registerModelChangeListener(new IImportDialogModelChangeListener(){

            public void modelChanged() {
                ImportEditor.this.setImage(EditorInput.getImageDescriptor((IImportDialogEditorLabelAndLayoutProvider)modelAccess, importedObject, presentationContext));
                ImportEditor.this.setName(EditorInput.getName((IImportDialogEditorLabelAndLayoutProvider)modelAccess, importedObject, presentationContext));
                ImportEditor.this.setToolTipText(EditorInput.getToolTipText((IImportDialogEditorLabelAndLayoutProvider)modelAccess, importedObject, presentationContext));
            }
        });
        this.updateMessages();
    }

    private void removeMessageChangeListener() {
        if (this.messageChangeListenerKey != null) {
            this.modelAccess.getCurrentModelAndModificationsAccessAgent().getEditorMessageStorage().removeMessagesChangeListener(this.messageChangeListenerKey);
            this.messageChangeListenerKey = null;
        }
    }

    public Object getImportedObject() {
        return this.importedObject;
    }

    private void addPages() {
        this.pages = this.editorController.createWidgetTree();
        if (this.pages != null) {
            boolean selected = true;
            for (IPageWidget page : this.pages) {
                if (!(page instanceof ImportEditorPageWidget)) continue;
                this.addPage((ImportEditorPageWidget)page, selected);
                selected = false;
            }
        }
    }

    private void updateMessages() {
        this.updatePlaygroundMessages();
        this.updateTitleMessage();
    }

    private void updateTitleMessage() {
        if (!this.isDisposed()) {
            List<Tuple> messages;
            this.allErrors.clear();
            CompressedMessage compressedMessage = new CompressedMessage(this.getCurrentPresentationContext().getLocale());
            try {
                messages = this.modelAccess.getCurrentModelAndModificationsAccessAgent().getEditorMessageStorage().getLabledMessagesForObject(this.importedObject);
            }
            catch (EEXNotReproducibleSnapshot e) {
                List labels = Collections.emptyList();
                Tuple labelsAndMessage = new Tuple(labels, (Object)new PlaygroundError(e));
                messages = Collections.singletonList(labelsAndMessage);
            }
            for (Tuple message : messages) {
                this.allErrors.add((Tuple<List<String>, IEditorMessage>)message);
                compressedMessage.addMessage((IMessage)new EditorErrorMessage(message, this.getCurrentPresentationContext()));
            }
            for (Tuple entry : this.editorController.getAllCloseVetos()) {
                ArrayList<String> list = new ArrayList<String>();
                list.add((String)entry.getT1());
                Tuple tuple = new Tuple(list, (Object)new WidgetAdapterError(IMessageLevel.INFORMATION, (ITextProvider)entry.getT2()));
                this.allErrors.add((Tuple<List<String>, IEditorMessage>)tuple);
                compressedMessage.addMessage((IMessage)new EditorErrorMessage(tuple, this.getCurrentPresentationContext()));
            }
            this.setMessage((IMessage)compressedMessage, !this.allErrors.isEmpty());
        }
    }

    private void updatePlaygroundMessages() {
        try {
            this.editorController.updateWidgetMessages();
        }
        catch (EEXNotReproducibleSnapshot e) {
            this.getExceptionHandler().handleEEXNotReproducibleSnapshot(e);
        }
    }

    public void updatePresentationContextToNow() {
    }

    public PresentationContext getCurrentPresentationContext() {
        return this.presentationContext;
    }

    public boolean changeMode(int editorMode, boolean ignoreChanges) {
        return false;
    }

    public int getMode() {
        return this.modelAccess.getImportMode(this.importedObject);
    }

    public boolean notInCreateMode() {
        return this.getMode() != 1;
    }

    public boolean needsLocks() {
        return true;
    }

    public void turnCreateEditorToEditEditor() {
    }

    public void dirtyChanged() {
    }

    public void updateInfoLabel() {
    }

    public void refresh(boolean refreshWidgets) {
    }

    public void bringToTop() {
    }

    public void closeEditor(boolean save, boolean isEditorClosing) {
    }

    @Override
    protected void setImportMode(int mode) throws EEXNotReproducibleSnapshot {
        this.modelAccess.setImportMode(this.importedObject, mode);
    }

    @Override
    public void deactivate() {
        this.allCloseVetoChangeListener.clear();
        this.removeMessageChangeListener();
        this.editorController.dispose(true);
        super.deactivate();
    }

    @Override
    public void dispose() {
        for (IPageWidget page : this.pages) {
            ((FormPage)page).dispose();
        }
        if (this.editorInfo != null) {
            this.editorInfo.dispose();
        }
        super.dispose();
    }

    @Override
    protected void openAdditionalEditorInfo(Point location) {
        if (!this.allErrors.isEmpty()) {
            this.editorInfo.setInfo(this.allErrors);
        } else {
            this.editorInfo.setInfo(null);
        }
        this.editorInfo.setLocationRightAlignment(location);
        this.editorInfo.openInfoShell();
    }

    public IWindow getWindow() {
        return this.window;
    }

    public void addScheduledTask(Runnable task) {
        PeriodicTaskScheduler.addScheduledTask((Runnable)task);
    }

    public void removeScheduledTask(Runnable task) {
        PeriodicTaskScheduler.removeScheduledTask((Runnable)task);
    }

    public void handleCloseVetosChanged() {
        this.updateTitleMessage();
        this.notifyAllCloseVetoChangeListener();
    }

    public boolean hasCloseVetos() {
        return this.editorController.hasCloseVetos();
    }

    public void addCloseVetoChangedListener(ICloseVetoChangedListener listener) {
        this.allCloseVetoChangeListener.add(listener);
    }

    public void removeCloseVetoChangedListener(ICloseVetoChangedListener listener) {
        this.allCloseVetoChangeListener.remove(listener);
    }

    private void notifyAllCloseVetoChangeListener() {
        for (ICloseVetoChangedListener singleListener : this.allCloseVetoChangeListener) {
            singleListener.closeVetoChanged(this);
        }
    }
}

