/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.eclipse.gui.widgets;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.SWTEventListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TypedListener;

@Deprecated
public class DatePicker
extends Composite {
    private Calendar _calendar;
    private SimpleDateFormat _monthYearFormat;
    private final Label monthLabel;
    private final DatePanel datePanel;
    private final boolean allowWeekends;

    private boolean allowWeekends() {
        return this.allowWeekends;
    }

    public DatePicker(Composite parent, int style, boolean allowWeekends) {
        this(parent, style, null, allowWeekends);
    }

    public DatePicker(Composite parent, int style, Locale locale, boolean allowWeekends) {
        super(parent, style);
        this.allowWeekends = allowWeekends;
        if (locale != null) {
            this._calendar = new GregorianCalendar(locale);
            this._monthYearFormat = new SimpleDateFormat("MMMM, yyyy", locale);
        } else {
            this._calendar = new GregorianCalendar();
            this._monthYearFormat = new SimpleDateFormat("MMMM, yyyy");
        }
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 5;
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.marginWidth = 1;
        gridLayout.marginHeight = 1;
        this.setBackground(Display.getCurrent().getSystemColor(2));
        this.setLayout((Layout)gridLayout);
        Button prevYear = new Button((Composite)this, 0);
        GridData gridData = new GridData(32);
        gridData.widthHint = 20;
        gridData.heightHint = 20;
        prevYear.setLayoutData((Object)gridData);
        prevYear.setImage(this.getImage("prev_year.gif"));
        prevYear.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DatePicker.this._calendar.add(1, -1);
                if (!DatePicker.this.allowWeekends()) {
                    if (DatePicker.this._calendar.get(7) == 1) {
                        DatePicker.this._calendar.add(5, -2);
                    } else if (DatePicker.this._calendar.get(7) == 7) {
                        DatePicker.this._calendar.add(5, -1);
                    }
                }
                DatePicker.this.updateDate();
            }
        });
        Button prevMonth = new Button((Composite)this, 0);
        gridData = new GridData(32);
        gridData.widthHint = 20;
        gridData.heightHint = 20;
        prevMonth.setLayoutData((Object)gridData);
        prevMonth.setImage(this.getImage("prev_month.gif"));
        prevMonth.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DatePicker.this._calendar.add(2, -1);
                if (!DatePicker.this.allowWeekends()) {
                    if (DatePicker.this._calendar.get(7) == 1) {
                        DatePicker.this._calendar.add(5, -2);
                    } else if (DatePicker.this._calendar.get(7) == 7) {
                        DatePicker.this._calendar.add(5, -1);
                    }
                }
                DatePicker.this.updateDate();
            }
        });
        this.monthLabel = new Label((Composite)this, 0x1000000);
        gridData = new GridData(772);
        gridData.heightHint = prevYear.computeSize((int)20, (int)20).y;
        this.monthLabel.setLayoutData((Object)gridData);
        Button nextMonth = new Button((Composite)this, 0);
        gridData = new GridData(128);
        gridData.widthHint = 20;
        gridData.heightHint = 20;
        nextMonth.setLayoutData((Object)gridData);
        nextMonth.setImage(this.getImage("next_month.gif"));
        nextMonth.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DatePicker.this._calendar.add(2, 1);
                if (!DatePicker.this.allowWeekends()) {
                    if (DatePicker.this._calendar.get(7) == 7) {
                        DatePicker.this._calendar.add(5, 2);
                    } else if (DatePicker.this._calendar.get(7) == 1) {
                        DatePicker.this._calendar.add(5, 1);
                    }
                }
                DatePicker.this.updateDate();
            }
        });
        Button nextYear = new Button((Composite)this, 0);
        gridData = new GridData(128);
        gridData.widthHint = 20;
        gridData.heightHint = 20;
        nextYear.setLayoutData((Object)gridData);
        nextYear.setImage(this.getImage("next_year.gif"));
        nextYear.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DatePicker.this._calendar.add(1, 1);
                if (!DatePicker.this.allowWeekends()) {
                    if (DatePicker.this._calendar.get(7) == 7) {
                        DatePicker.this._calendar.add(5, 2);
                    } else if (DatePicker.this._calendar.get(7) == 1) {
                        DatePicker.this._calendar.add(5, 1);
                    }
                }
                DatePicker.this.updateDate();
            }
        });
        this.datePanel = new DatePanel(this, 0);
        gridData = new GridData(128);
        gridData.horizontalSpan = 5;
        this.datePanel.setLayoutData(gridData);
        this.panelChanged();
    }

    private Image getImage(String imageFile) {
        ImageData iData = new ImageData(((Object)((Object)this)).getClass().getResourceAsStream(imageFile));
        ImageData iMask = iData.getTransparencyMask();
        return new Image(null, iData, iMask);
    }

    private void updateDate() {
        this.datePanel.updateCalender();
        this.datePanel.redraw();
        this.panelChanged();
    }

    private void panelChanged() {
        this.monthLabel.setText(this._monthYearFormat.format(this._calendar.getTime()));
    }

    private void dateSelected(boolean good) {
        Event event = new Event();
        event.doit = good;
        this.notifyListeners(13, event);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        TypedListener typedListener = new TypedListener((SWTEventListener)listener);
        this.addListener(13, (Listener)typedListener);
        this.addListener(14, (Listener)typedListener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        this.removeListener(13, (SWTEventListener)listener);
        this.removeListener(14, (SWTEventListener)listener);
    }

    public Date getDate() {
        return this._calendar.getTime();
    }

    public void setDate(Date date) {
        if (!this.allowWeekends) {
            Calendar dummyCalendar = (Calendar)this._calendar.clone();
            dummyCalendar.setTime(date);
            if (dummyCalendar.get(7) == 7 || dummyCalendar.get(7) == 1) {
                return;
            }
        }
        this._calendar.setTime(date);
        this.updateDate();
    }

    private class DatePanel
    extends Canvas {
        private final Display _display;
        private Calendar _panelCalendar;
        private final int _colSize;
        private final int _rowSize;
        private int _maxDaysOfWeek;
        private int _maxDaysOfMonth;

        public DatePanel(Composite parent, int style) {
            super(parent, style | 0x40000 | 0x100000);
            this._display = Display.getCurrent();
            GC gc = new GC((Drawable)this);
            Point p = gc.stringExtent("Q");
            gc.dispose();
            this._panelCalendar = (Calendar)DatePicker.this._calendar.clone();
            this._colSize = p.x * 3;
            this._rowSize = (int)((double)p.y * 1.2);
            this._maxDaysOfWeek = this._panelCalendar.getActualMaximum(7);
            this._maxDaysOfMonth = this._panelCalendar.getActualMaximum(5);
            this.addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent event) {
                    DatePanel.this.onPaint(event);
                }
            });
            this.addControlListener((ControlListener)new ControlAdapter(){

                public void controlResized(ControlEvent e) {
                    DatePanel.this.redraw();
                }
            });
            this.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyPressed(KeyEvent e) {
                    DatePanel.this.onKeyDown(e);
                }
            });
            this.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDown(MouseEvent e) {
                    DatePanel.this.onMouseDown(e);
                }
            });
        }

        protected void updateCalender() {
            this._panelCalendar = (Calendar)DatePicker.this._calendar.clone();
            this._maxDaysOfWeek = this._panelCalendar.getActualMaximum(7);
            this._maxDaysOfMonth = this._panelCalendar.getActualMaximum(5);
        }

        private void onMouseDown(MouseEvent e) {
            int day = this.getDayFromPoint(e.x, e.y);
            if (day > 0 && (DatePicker.this.allowWeekends || !this.isWeekendDay(day))) {
                DatePicker.this._calendar.set(5, day);
                this.redraw();
                DatePicker.this.dateSelected(true);
            }
        }

        private boolean isWeekendDay(int day) {
            Calendar dummyCalendar = (Calendar)DatePicker.this._calendar.clone();
            dummyCalendar.set(5, day);
            return dummyCalendar.get(7) == 7 || dummyCalendar.get(7) == 1;
        }

        private int getDayFromPoint(int x, int y) {
            int i = 1;
            while (i <= DatePicker.this._calendar.getActualMaximum(5)) {
                Point p = this.getDayPoint(i);
                Rectangle r = new Rectangle(p.x, p.y, this._colSize, this._rowSize);
                if (r.contains(x, y)) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        private Point getDayPoint(int day) {
            this._panelCalendar.setTime(DatePicker.this._calendar.getTime());
            this._panelCalendar.set(5, 1);
            int first_day_of_week = this._panelCalendar.get(7) - 1;
            this._panelCalendar.set(5, day);
            int day_of_week = this._panelCalendar.get(7);
            int x = (day_of_week - 1) * this._colSize + this._colSize / 4;
            int y = (1 + (first_day_of_week + day - 1) / this._maxDaysOfWeek) * this._rowSize;
            return new Point(x, y);
        }

        private void onPaint(PaintEvent event) {
            Rectangle rect = this.getClientArea();
            GC gc0 = event.gc;
            Image image = new Image((Device)this._display, rect.width, rect.height);
            GC gc = new GC((Drawable)image);
            gc.setBackground(this._display.getSystemColor(22));
            gc.fillRectangle(rect);
            int x = 0;
            int y = 0;
            String[] dayNames = DatePicker.this._monthYearFormat.getDateFormatSymbols().getWeekdays();
            int i = 1;
            while (i < dayNames.length) {
                gc.drawText(dayNames[i].substring(0, 2), x + this._colSize / 4, 1);
                x += this._colSize;
                ++i;
            }
            gc.setForeground(this._display.getSystemColor(2));
            gc.drawLine(0, 0, rect.width, 0);
            gc.drawLine(0, (y += this._rowSize) - 1, rect.width, y - 1);
            this._panelCalendar.setTime(DatePicker.this._calendar.getTime());
            int day = 1;
            while (day <= this._maxDaysOfMonth) {
                this._panelCalendar.set(5, day);
                Point p = this.getDayPoint(day);
                if (day == DatePicker.this._calendar.get(5)) {
                    gc.setForeground(this._display.getSystemColor(27));
                    gc.setBackground(this._display.getSystemColor(26));
                } else {
                    gc.setBackground(this._display.getSystemColor(22));
                    gc.setForeground(this._display.getSystemColor(2));
                }
                gc.drawText("" + day, p.x, p.y);
                ++day;
            }
            gc0.drawImage(image, 0, 0);
            gc.dispose();
            image.dispose();
        }

        private void onKeyDown(KeyEvent e) {
            if (e.character == '\u001b') {
                DatePicker.this.dateSelected(false);
                return;
            }
            if (e.character == ' ' || e.character == '\r') {
                DatePicker.this.dateSelected(true);
                return;
            }
            Date oldDate = DatePicker.this._calendar.getTime();
            if (e.keyCode == 0x1000003) {
                DatePicker.this._calendar.add(5, -1);
                if (!DatePicker.this.allowWeekends && DatePicker.this._calendar.get(7) == 1) {
                    DatePicker.this._calendar.add(5, -2);
                }
            } else if (e.keyCode == 0x1000004) {
                DatePicker.this._calendar.add(5, 1);
                if (!DatePicker.this.allowWeekends && DatePicker.this._calendar.get(7) == 7) {
                    DatePicker.this._calendar.add(5, 2);
                }
            } else if (e.keyCode == 0x1000001) {
                DatePicker.this._calendar.add(5, -this._maxDaysOfWeek);
            } else if (e.keyCode == 0x1000002) {
                DatePicker.this._calendar.add(5, this._maxDaysOfWeek);
            } else if (e.keyCode == 0x1000005) {
                DatePicker.this._calendar.add(2, -1);
                if (!DatePicker.this.allowWeekends) {
                    if (DatePicker.this._calendar.get(7) == 1) {
                        DatePicker.this._calendar.add(5, -2);
                    } else if (DatePicker.this._calendar.get(7) == 7) {
                        DatePicker.this._calendar.add(5, -1);
                    }
                }
            } else if (e.keyCode == 0x1000006) {
                DatePicker.this._calendar.add(2, 1);
                if (!DatePicker.this.allowWeekends) {
                    if (DatePicker.this._calendar.get(7) == 7) {
                        DatePicker.this._calendar.add(5, 2);
                    } else if (DatePicker.this._calendar.get(7) == 1) {
                        DatePicker.this._calendar.add(5, 1);
                    }
                }
            }
            if (!DatePicker.this._calendar.getTime().equals(oldDate)) {
                this.redraw();
                DatePicker.this.panelChanged();
            }
        }

        public Point computeSize(int wHint, int hHint, boolean changed) {
            return new Point(this._colSize * this._maxDaysOfWeek, this._rowSize * 7);
        }
    }
}

