/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.eclipse.gui;

import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Display;

public class ImageInCanvasPainter
implements PaintListener {
    private final Canvas canvas;
    private Image image;
    private final boolean frameOnNoImage;
    private final boolean paintInCentre;

    public ImageInCanvasPainter(Canvas canvas, boolean frameOnNoImage, boolean paintInCentre) {
        this.canvas = canvas;
        this.frameOnNoImage = frameOnNoImage;
        this.paintInCentre = paintInCentre;
    }

    public void setImage(Image image) {
        this.image = image;
    }

    public void paintControl(PaintEvent e) {
        int canvasHeight;
        GC gc = e.gc;
        Rectangle canvasBounds = this.canvas.getBounds();
        int canvasWidth = canvasBounds.width;
        if (canvasWidth > 1) {
            --canvasWidth;
        }
        if ((canvasHeight = canvasBounds.height) > 1) {
            --canvasHeight;
        }
        if (this.image != null && !this.image.isDisposed()) {
            float divisor;
            float divisorWidth = 1.0f;
            float divisorHeight = 1.0f;
            Rectangle rec = this.image.getBounds();
            int width = rec.width;
            int height = rec.height;
            if (width > canvasWidth) {
                divisorWidth = (float)width / (float)canvasWidth;
            }
            if (height > canvasHeight) {
                divisorHeight = (float)height / (float)canvasHeight;
            }
            if ((divisor = Math.max(divisorHeight, divisorWidth)) > 0.0f) {
                int newWidth = Math.round((float)width / divisor);
                int newHeight = Math.round((float)height / divisor);
                if (newWidth > 2 && newHeight > 2) {
                    if (this.paintInCentre) {
                        gc.drawImage(this.image, 0, 0, width, height, (canvasWidth - newWidth) / 2, (canvasHeight - newHeight) / 2, newWidth, newHeight);
                    } else {
                        gc.drawImage(this.image, 0, 0, width, height, 0, 0, newWidth, newHeight);
                    }
                }
            }
        } else if (this.frameOnNoImage) {
            gc.setForeground(Display.getDefault().getSystemColor(16));
            gc.drawRectangle(0, 0, canvasWidth, canvasHeight);
            gc.drawLine(0, 0, canvasWidth, canvasHeight);
            gc.drawLine(canvasWidth, 0, 0, canvasHeight);
        }
    }
}

