/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.eclipse.graphics.image;

import com.arcway.lib.geometry.Point;
import com.arcway.lib.graphics.image.EXCorruptImageFileContent;
import com.arcway.lib.graphics.image.EXImageDataTypeNotSupported;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.resource.JvmExternalResourceInteractionException;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.swt.widgets.Display;

public class PNGResolutionFetcher {
    private static final ILogger LOGGER = Logger.getLogger(PNGResolutionFetcher.class);

    /*
     * Unable to fully structure code
     */
    public static Point fetchResolutionInPixelsPerMeter(InputStream pngStream) throws EXImageDataTypeNotSupported, JvmExternalResourceInteractionException, EXCorruptImageFileContent {
        pixelsPerMeter = null;
        try {
            try {
                signature = new byte[8];
                pngStream.read(signature);
                if ((signature[0] & 255) != 137) {
                    throw new EXImageDataTypeNotSupported();
                }
                if ((signature[1] & 255) != 80) {
                    throw new EXImageDataTypeNotSupported();
                }
                if ((signature[2] & 255) != 78) {
                    throw new EXImageDataTypeNotSupported();
                }
                if ((signature[3] & 255) != 71) {
                    throw new EXImageDataTypeNotSupported();
                }
                if ((signature[4] & 255) != 13) {
                    throw new EXImageDataTypeNotSupported();
                }
                if ((signature[5] & 255) != 10) {
                    throw new EXImageDataTypeNotSupported();
                }
                if ((signature[6] & 255) != 26) {
                    throw new EXImageDataTypeNotSupported();
                }
                if ((signature[7] & 255) != 10) {
                    throw new EXImageDataTypeNotSupported();
                }
            }
            catch (Exception e) {
                throw new EXImageDataTypeNotSupported((Throwable)e);
            }
            endOfSearch = false;
            type = new byte[4];
            dummy = new byte[4096];
            while (!endOfSearch) {
                length = PNGResolutionFetcher.readInt(pngStream);
                pngStream.read(type);
                if (PNGResolutionFetcher.isIEND(type)) {
                    endOfSearch = true;
                    continue;
                }
                if (PNGResolutionFetcher.isIDAT(type)) {
                    endOfSearch = true;
                    continue;
                }
                if (!PNGResolutionFetcher.isPHYS(type)) ** GOTO lbl63
                pixelsPerUnitX = PNGResolutionFetcher.readInt(pngStream);
                if (pixelsPerUnitX <= 0) {
                    throw new EXCorruptImageFileContent();
                }
                pixelsPerUnitY = PNGResolutionFetcher.readInt(pngStream);
                if (pixelsPerUnitY <= 0) {
                    throw new EXCorruptImageFileContent();
                }
                format = pngStream.read();
                if (format == -1) {
                    throw new EOFException();
                }
                if (format == 1) {
                    unitsPerMeter = 1.0;
                    pixelsPerMeter = new Point((double)pixelsPerUnitX * unitsPerMeter, (double)pixelsPerUnitY * unitsPerMeter);
                } else {
                    dpiX = Display.getDefault().getDPI().x;
                    pixelsPerMeterX = dpiX * 39.37007874015748;
                    pixelsPerMeterY = pixelsPerMeterX * (double)pixelsPerUnitY / (double)pixelsPerUnitX;
                    pixelsPerMeter = new Point(pixelsPerMeterX, pixelsPerMeterY);
                }
                endOfSearch = true;
                continue;
lbl-1000:
                // 1 sources

                {
                    read = pngStream.read(dummy, 0, Math.min(length, dummy.length));
                    if (read != length) {
                        throw new EOFException();
                    }
                    length -= read;
lbl63:
                    // 2 sources

                    ** while (length > 0)
                }
lbl64:
                // 1 sources

                PNGResolutionFetcher.readInt(pngStream);
            }
        }
        catch (IOException e) {
            try {
                pngStream.close();
            }
            catch (IOException e1) {
                PNGResolutionFetcher.LOGGER.error("IOException in exception handling", (Throwable)e1);
            }
            throw new JvmExternalResourceInteractionException((Throwable)e);
        }
        try {
            pngStream.close();
        }
        catch (IOException e) {
            throw new JvmExternalResourceInteractionException((Throwable)e);
        }
        return pixelsPerMeter;
    }

    private static boolean isIEND(byte[] type) {
        if ((type[0] & 0xFF) != 73) {
            return false;
        }
        if ((type[1] & 0xFF) != 69) {
            return false;
        }
        if ((type[2] & 0xFF) != 78) {
            return false;
        }
        return (type[3] & 0xFF) == 68;
    }

    private static boolean isIDAT(byte[] type) {
        if ((type[0] & 0xFF) != 73) {
            return false;
        }
        if ((type[1] & 0xFF) != 68) {
            return false;
        }
        if ((type[2] & 0xFF) != 65) {
            return false;
        }
        return (type[3] & 0xFF) == 84;
    }

    private static boolean isPHYS(byte[] type) {
        if ((type[0] & 0xFF) != 112) {
            return false;
        }
        if ((type[1] & 0xFF) != 72) {
            return false;
        }
        if ((type[2] & 0xFF) != 89) {
            return false;
        }
        return (type[3] & 0xFF) == 115;
    }

    private static int readInt(InputStream stream) throws IOException {
        byte[] buf = new byte[4];
        int read = stream.read(buf);
        if (read != 4) {
            throw new EOFException();
        }
        return (buf[0] & 0xFF) << 24 | (buf[1] & 0xFF) << 16 | (buf[2] & 0xFF) << 8 | buf[3] & 0xFF;
    }

    private PNGResolutionFetcher() {
    }
}

