/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.eclipse.graphics;

import com.arcway.lib.eclipse.graphics.SWTDefaultRendererManager;
import com.arcway.lib.eclipse.graphics.SWTImageData;
import com.arcway.lib.eclipse.graphics.SWTRenderer;
import com.arcway.lib.eclipse.graphics.devicedrivers.DeviceDriverSWTGC;
import com.arcway.lib.eclipse.graphics.devicedrivers.ISWTOffscreenBitmapBackdoor;
import com.arcway.lib.geometry.Dimension;
import com.arcway.lib.geometry.Rectangle;
import com.arcway.lib.geometry.TurnedRectangle;
import com.arcway.lib.graphics.EXNoMoreHandles;
import com.arcway.lib.graphics.IRenderer;
import com.arcway.lib.graphics.devicedrivers.IDeviceDriverOffscreenBitmap;
import com.arcway.lib.graphics.image.EXImageTooBig;
import com.arcway.lib.graphics.image.IImageData;
import com.arcway.lib.graphics.image.IOffscreenBitmap;
import com.arcway.lib.java.Assert;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;

public class SWTOffscreenBitmap
implements IOffscreenBitmap,
ISWTOffscreenBitmapBackdoor {
    private static final com.arcway.lib.graphics.Color TRANSPARENT_BACKGROUND = new com.arcway.lib.graphics.Color(251, 246, 250);
    private static final PaletteData DEPTH_32_PALETTE_DATA = new PaletteData(255, 65280, 0xFF0000);
    private static final int DEPTH32_TRANSPARENT_PIXEL;
    private static final PaletteData DEPTH_24_PALETTE_DATA;
    private final SWTRenderer swtRenderer;
    private final Image wrappedSWTImage;
    private final boolean wasCreatedInRAM;
    private final boolean isLossyImage;
    private byte[] optionalPngOrJpgFileData = null;

    static {
        int rgbPixelValue = DEPTH_32_PALETTE_DATA.getPixel(new RGB(255, 255, 255));
        int alpha = 0;
        int alphaPixelValue = alpha << 24 & 0xFF000000;
        DEPTH32_TRANSPARENT_PIXEL = rgbPixelValue | alphaPixelValue;
        DEPTH_24_PALETTE_DATA = new PaletteData(255, 65280, 0xFF0000);
    }

    public static Image createSWTImage(Device device, int widthInPixels, int heightInPixels, com.arcway.lib.graphics.Color backgroundColor) throws EXImageTooBig, EXNoMoreHandles {
        return SWTOffscreenBitmap.createSWTImage_original(device, widthInPixels, heightInPixels, backgroundColor);
    }

    private static Image createSWTImage_original(Device device, int widthInPixels, int heightInPixels, com.arcway.lib.graphics.Color backgroundColor) throws EXImageTooBig, EXNoMoreHandles {
        ImageData templateImageData;
        Image testImage;
        try {
            testImage = new Image(null, widthInPixels, heightInPixels);
        }
        catch (OutOfMemoryError e) {
            throw new EXImageTooBig();
        }
        catch (SWTError e) {
            throw new EXNoMoreHandles((Throwable)e);
        }
        catch (SWTException e) {
            throw new EXImageTooBig();
        }
        Color swtBackgroundColor = backgroundColor.transparent ? new Color(null, SWTOffscreenBitmap.TRANSPARENT_BACKGROUND.r, SWTOffscreenBitmap.TRANSPARENT_BACKGROUND.g, SWTOffscreenBitmap.TRANSPARENT_BACKGROUND.b) : new Color(null, backgroundColor.r, backgroundColor.g, backgroundColor.b);
        GC gc = new GC((Drawable)testImage);
        gc.setBackground(swtBackgroundColor);
        gc.fillRectangle(0, 0, testImage.getBounds().width, testImage.getBounds().height);
        gc.dispose();
        swtBackgroundColor.dispose();
        try {
            templateImageData = SWTOffscreenBitmap.createSWTImageData(testImage);
        }
        finally {
            testImage.dispose();
        }
        if (backgroundColor.transparent) {
            int backgroundPixel;
            templateImageData.transparentPixel = backgroundPixel = templateImageData.getPixel(0, 0);
        }
        Image image = SWTOffscreenBitmap.createSWTImage(device, templateImageData);
        return image;
    }

    public static Image createSWTImage_new(Device device, int widthInPixels, int heightInPixels, com.arcway.lib.graphics.Color backgroundColor) throws EXImageTooBig, EXNoMoreHandles {
        int pixelValue;
        ImageData templateImageData = SWTOffscreenBitmap.createDepth32ImageData(widthInPixels, heightInPixels);
        if (backgroundColor.transparent) {
            pixelValue = DEPTH32_TRANSPARENT_PIXEL;
        } else {
            RGB rgb = new RGB(backgroundColor.r, backgroundColor.g, backgroundColor.b);
            int alpha = 255;
            pixelValue = SWTOffscreenBitmap.getDepth32Pixel(rgb, alpha);
        }
        templateImageData.setPixel(0, 0, pixelValue);
        templateImageData = templateImageData.scaledTo(widthInPixels, heightInPixels);
        Image image = SWTOffscreenBitmap.createSWTImage(device, templateImageData);
        return image;
    }

    public static ImageData createSWTImageData(Image image) throws EXImageTooBig {
        ImageData imageData;
        try {
            imageData = image.getImageData();
        }
        catch (OutOfMemoryError e) {
            throw new EXImageTooBig();
        }
        catch (SWTException e) {
            throw new EXImageTooBig();
        }
        return imageData;
    }

    private static Image createSWTImage(Device device, ImageData imageData) throws EXImageTooBig, EXNoMoreHandles {
        Image image;
        try {
            image = new Image(device, imageData);
        }
        catch (OutOfMemoryError e) {
            throw new EXImageTooBig();
        }
        catch (SWTError e) {
            throw new EXNoMoreHandles((Throwable)e);
        }
        catch (SWTException e) {
            throw new EXImageTooBig();
        }
        return image;
    }

    public static Image createRerenderedImage(Image swtImage, boolean isLossyImage, byte[] optionalPngOrJpgFileData) throws EXImageTooBig, EXNoMoreHandles {
        SWTOffscreenBitmap originalImage = new SWTOffscreenBitmap(swtImage, isLossyImage, optionalPngOrJpgFileData);
        int w = originalImage.getWidthInPixels();
        int h = originalImage.getHeightInPixels();
        SWTRenderer renderer = originalImage.swtRenderer;
        SWTOffscreenBitmap rerenderedImage = renderer.createSWTOffscreenBitmap(w, h, com.arcway.lib.graphics.Color.TRANSPARENT, isLossyImage);
        IDeviceDriverOffscreenBitmap deviceDriver = rerenderedImage.createDeviceDriver();
        deviceDriver.drawImage((IOffscreenBitmap)originalImage, 0, 0, w, h, new TurnedRectangle(new Rectangle(0.0, 0.0, new Dimension((double)w, (double)h))), 255);
        deviceDriver.dispose(optionalPngOrJpgFileData);
        return rerenderedImage.getWrappedSWTImage();
    }

    public static Image createRerenderedImage_new(Image swtImage) throws EXImageTooBig, EXNoMoreHandles {
        ImageData sourceImageData = swtImage.getImageData();
        ImageData unbuggyImageData = SWTOffscreenBitmap.ensure24BitWithTransparentColorImageData(sourceImageData);
        Image unbuggyImage = SWTOffscreenBitmap.createSWTImage(swtImage.getDevice(), unbuggyImageData);
        return unbuggyImage;
    }

    public static Image create24BitWithAlphaDataImage(Image swtImage) throws EXImageTooBig, EXNoMoreHandles {
        ImageData sourceImageData = swtImage.getImageData();
        ImageData unbuggyImageData = SWTOffscreenBitmap.ensure24BitWithAlphaDataImageData(sourceImageData);
        Image unbuggyImage = SWTOffscreenBitmap.createSWTImage(swtImage.getDevice(), unbuggyImageData);
        return unbuggyImage;
    }

    public static Image create24BitWithTransparentColorImage(Image swtImage) throws EXImageTooBig, EXNoMoreHandles {
        ImageData sourceImageData = swtImage.getImageData();
        ImageData unbuggyImageData = SWTOffscreenBitmap.ensure24BitWithTransparentColorImageData(sourceImageData);
        Image unbuggyImage = SWTOffscreenBitmap.createSWTImage(swtImage.getDevice(), unbuggyImageData);
        return unbuggyImage;
    }

    private static ImageData ensure32BitImageData(ImageData sourceImageData) {
        ImageData unbuggyImageData;
        int sourceTransparencyType = sourceImageData.getTransparencyType();
        int sourceGlobalAlpha = sourceImageData.alpha;
        if (sourceImageData.depth == 32 && sourceTransparencyType == 0 && sourceGlobalAlpha == -1) {
            unbuggyImageData = sourceImageData;
        } else {
            int width = sourceImageData.width;
            int height = sourceImageData.height;
            unbuggyImageData = SWTOffscreenBitmap.createDepth32ImageData(width, height);
            SWTOffscreenBitmap.blit(sourceImageData, unbuggyImageData);
        }
        return unbuggyImageData;
    }

    private static ImageData ensure24BitWithAlphaDataImageData(ImageData sourceImageData) {
        ImageData unbuggyImageData;
        int sourceTransparencyType = sourceImageData.getTransparencyType();
        int sourceGlobalAlpha = sourceImageData.alpha;
        if (sourceImageData.depth == 24 && sourceTransparencyType == 1 && sourceGlobalAlpha == -1) {
            unbuggyImageData = sourceImageData;
        } else {
            int width = sourceImageData.width;
            int height = sourceImageData.height;
            unbuggyImageData = SWTOffscreenBitmap.createDepth24WithAlphaDataImageData(width, height);
            SWTOffscreenBitmap.blit(sourceImageData, unbuggyImageData);
        }
        return unbuggyImageData;
    }

    private static ImageData ensure24BitWithTransparentColorImageData(ImageData sourceImageData) {
        ImageData unbuggyImageData;
        int sourceTransparencyType = sourceImageData.getTransparencyType();
        int sourceGlobalAlpha = sourceImageData.alpha;
        if (sourceImageData.depth == 24 && sourceTransparencyType == 4 && sourceGlobalAlpha == -1) {
            unbuggyImageData = sourceImageData;
        } else {
            int width = sourceImageData.width;
            int height = sourceImageData.height;
            unbuggyImageData = SWTOffscreenBitmap.createDepth24WithTransparentColorImageData(width, height);
            SWTOffscreenBitmap.blit(sourceImageData, unbuggyImageData);
        }
        return unbuggyImageData;
    }

    private static void blit(ImageData sourceImageData, ImageData targetImageData) {
        int width = sourceImageData.width;
        int height = sourceImageData.height;
        PaletteData sourcePaletteData = sourceImageData.palette;
        int sourceTransparencyType = sourceImageData.getTransparencyType();
        int sourceGlobalAlpha = sourceImageData.alpha;
        int sourceDepth = sourceImageData.depth;
        ImageData sourceTransparencyMask = sourceTransparencyType == 2 ? sourceImageData.getTransparencyMask() : null;
        PaletteData targetPaletteData = targetImageData.palette;
        int targetDepth = targetImageData.depth;
        int targetTransparencyType = targetImageData.getTransparencyType();
        int y = 0;
        while (y < height) {
            int x = 0;
            while (x < width) {
                int sourceMaskPixel;
                int sourcePixel = sourceImageData.getPixel(x, y);
                RGB rgb = sourcePaletteData.getRGB(sourcePixel);
                int alpha = sourceTransparencyType == 2 ? (sourceTransparencyMask != null ? ((sourceMaskPixel = sourceTransparencyMask.getPixel(x, y)) == 0 ? 0 : 255) : 255) : (sourceTransparencyType == 4 ? (sourcePixel == sourceImageData.transparentPixel ? 0 : 255) : (sourceTransparencyType == 1 ? sourceImageData.getAlpha(x, y) : (sourceGlobalAlpha >= 0 ? sourceGlobalAlpha : (sourceDepth == 32 ? SWTOffscreenBitmap.getDepth32Alpha(sourcePixel) : 255))));
                int targetPixel = targetPaletteData.getPixel(rgb);
                if (targetTransparencyType == 2) {
                    throw new UnsupportedOperationException();
                }
                if (targetTransparencyType == 4) {
                    if (alpha == 0) {
                        targetPixel = targetImageData.transparentPixel;
                    }
                } else if (targetTransparencyType == 1) {
                    targetImageData.setAlpha(x, y, alpha);
                } else {
                    if (sourceGlobalAlpha >= 0) {
                        throw new UnsupportedOperationException();
                    }
                    if (targetDepth == 32) {
                        int alphaPixelValue = alpha << 24 & 0xFF000000;
                        targetPixel |= alphaPixelValue;
                    }
                }
                targetImageData.setPixel(x, y, targetPixel);
                ++x;
            }
            ++y;
        }
    }

    private static ImageData createDepth32ImageData(int width, int height) {
        ImageData imageData = new ImageData(width, height, 32, DEPTH_32_PALETTE_DATA);
        return imageData;
    }

    private static int getDepth32Pixel(RGB rgb, int alpha) {
        int rgbPixelValue = DEPTH_32_PALETTE_DATA.getPixel(rgb);
        int alphaPixelValue = alpha << 24 & 0xFF000000;
        int unbuggyPixelValue = rgbPixelValue | alphaPixelValue;
        return unbuggyPixelValue;
    }

    private static int getDepth32Alpha(int pixel) {
        int alpha = pixel >> 24 & 0xFF;
        return alpha;
    }

    private static ImageData createDepth24WithAlphaDataImageData(int width, int height) {
        ImageData imageData = new ImageData(width, height, 24, DEPTH_24_PALETTE_DATA);
        imageData.alphaData = new byte[width * height];
        return imageData;
    }

    private static ImageData createDepth24WithTransparentColorImageData(int width, int height) {
        ImageData imageData = new ImageData(width, height, 24, DEPTH_24_PALETTE_DATA);
        imageData.transparentPixel = DEPTH_24_PALETTE_DATA.getPixel(new RGB(SWTOffscreenBitmap.TRANSPARENT_BACKGROUND.r, SWTOffscreenBitmap.TRANSPARENT_BACKGROUND.g, SWTOffscreenBitmap.TRANSPARENT_BACKGROUND.b));
        return imageData;
    }

    SWTOffscreenBitmap(SWTRenderer swtRenderer, int widthInPixels, int heightInPixels, com.arcway.lib.graphics.Color backgroundColor, boolean isLossyImage) throws EXImageTooBig, EXNoMoreHandles {
        Assert.checkArgumentBeeingNotNull((Object)swtRenderer);
        Assert.checkArgument((widthInPixels > 0 ? 1 : 0) != 0);
        Assert.checkArgument((heightInPixels > 0 ? 1 : 0) != 0);
        this.swtRenderer = swtRenderer;
        this.wrappedSWTImage = SWTOffscreenBitmap.createSWTImage(swtRenderer.getWrappedSWTDevice(), widthInPixels, heightInPixels, backgroundColor);
        this.isLossyImage = isLossyImage;
        this.wasCreatedInRAM = true;
    }

    public SWTOffscreenBitmap(SWTRenderer swtRenderer, SWTImageData imageData) throws EXImageTooBig, EXNoMoreHandles {
        Assert.checkArgumentBeeingNotNull((Object)swtRenderer);
        Assert.checkArgumentBeeingNotNull((Object)imageData);
        this.swtRenderer = swtRenderer;
        this.isLossyImage = imageData.isLossyImage();
        this.optionalPngOrJpgFileData = imageData.getOptionalPngOrJpgFileData();
        Image wrappedSWTImageTmp = SWTOffscreenBitmap.createSWTImage(swtRenderer.getWrappedSWTDevice(), imageData.getWrappedSWTImageData());
        try {
            Image rerenderedImage = SWTOffscreenBitmap.createRerenderedImage(wrappedSWTImageTmp, this.isLossyImage, this.optionalPngOrJpgFileData);
            wrappedSWTImageTmp.dispose();
            wrappedSWTImageTmp = rerenderedImage;
        }
        catch (EXImageTooBig eXImageTooBig) {
        }
        catch (EXNoMoreHandles eXNoMoreHandles) {
            // empty catch block
        }
        this.wrappedSWTImage = wrappedSWTImageTmp;
        this.wasCreatedInRAM = true;
    }

    public SWTOffscreenBitmap(Image image, boolean isLossyImage, byte[] optionalPngOrJpgFileData) {
        Assert.checkArgumentBeeingNotNull((Object)image);
        SWTRenderer defaultRenderer = SWTDefaultRendererManager.getDefaultSWTRendererOfCurrentThread();
        this.swtRenderer = defaultRenderer.getWrappedSWTDevice() == image.getDevice() ? defaultRenderer : new SWTRenderer(image.getDevice());
        this.wrappedSWTImage = image;
        this.isLossyImage = isLossyImage;
        this.optionalPngOrJpgFileData = optionalPngOrJpgFileData;
        this.wasCreatedInRAM = false;
    }

    public IRenderer getRenderer() {
        return this.swtRenderer;
    }

    public IDeviceDriverOffscreenBitmap createDeviceDriver() {
        this.optionalPngOrJpgFileData = null;
        DeviceDriverSWTGC deviceDriverSWTGC = new DeviceDriverSWTGC(this.swtRenderer.getWrappedSWTDevice(), (Drawable)this.wrappedSWTImage, true, this);
        return deviceDriverSWTGC;
    }

    public void dispose() {
        this.wrappedSWTImage.dispose();
    }

    public int getWidthInPixels() {
        return this.wrappedSWTImage.getBounds().width;
    }

    public int getHeightInPixels() {
        return this.wrappedSWTImage.getBounds().height;
    }

    public boolean isLossyImage() {
        return this.isLossyImage;
    }

    public IImageData getSnapshot() throws EXImageTooBig {
        ImageData imageData;
        Image imageToSnapShot;
        if (this.wasCreatedInRAM) {
            imageToSnapShot = this.wrappedSWTImage;
        } else {
            ImageData possiblyFlippedSnapShot = SWTOffscreenBitmap.createSWTImageData(this.wrappedSWTImage);
            try {
                imageToSnapShot = SWTOffscreenBitmap.createSWTImage(this.swtRenderer.getWrappedSWTDevice(), possiblyFlippedSnapShot);
            }
            catch (EXNoMoreHandles e) {
                throw new EXImageTooBig();
            }
        }
        try {
            imageData = SWTOffscreenBitmap.createSWTImageData(imageToSnapShot);
        }
        finally {
            if (!this.wasCreatedInRAM) {
                imageToSnapShot.dispose();
            }
        }
        return new SWTImageData(imageData, this.isLossyImage, this.optionalPngOrJpgFileData);
    }

    public Image getWrappedSWTImage() {
        return this.wrappedSWTImage;
    }

    @Override
    public void setOptionalPngOrJpgFileData(byte[] optionalPngOrJpgFileData) {
        this.optionalPngOrJpgFileData = optionalPngOrJpgFileData;
    }

    public byte[] getOptionalPngOrJpgFileData() {
        return this.optionalPngOrJpgFileData;
    }

    public boolean isDisposed() {
        return this.wrappedSWTImage.isDisposed();
    }
}

