/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.eclipse.graphics;

import com.arcway.lib.geometry.Rectangle;
import com.arcway.lib.graphics.EXNoMoreHandles;
import com.arcway.lib.graphics.text.EXFontSizeTooSmall;
import com.arcway.lib.graphics.text.IFont;
import com.arcway.lib.graphics.text.TextStyle;
import com.arcway.lib.java.To;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Display;

public class SWTFont
implements IFont {
    private static final double SWT_HALF_SIZE_RATION = 0.6809815950920245;
    private static final double SWT_ITALIC_RATION_APPROXIMATION = 0.15853658536585366;
    private static final int SWT_INITIAL_TEXT_SIZE = 50;
    public static final int RECOMMENDED_MAX_NUMBER_OF_CHARACTERS_FOR_TEXT_EXTEND_CALCULATIONS = 655;
    private static final ThreadLocal<SWTFontCache> fontCacheThreadLocal = new ThreadLocal<SWTFontCache>(){

        @Override
        protected SWTFontCache initialValue() {
            return new SWTFontCache();
        }
    };
    private final TextStyle textStyle;
    private final FontSingleton fontSingleton;
    private final double textLineHeight;

    public static SWTFontCache getFontCacheOfCurrentThread() {
        return fontCacheThreadLocal.get();
    }

    public SWTFont(TextStyle textStyle) throws EXNoMoreHandles {
        this.textStyle = textStyle;
        SWTFontCache fontCache = SWTFont.getFontCacheOfCurrentThread();
        this.fontSingleton = fontCache.getFontSingleton(textStyle);
        this.fontSingleton.allocate(this);
        int calculatedTextSize = SWTFont.getSWTTextLineHeight(this.fontSingleton.getGC(), this.fontSingleton.getFont());
        this.textLineHeight = calculatedTextSize == 0 ? 1.0000000000000001E-7 : To.toDouble((int)calculatedTextSize);
    }

    public void dispose() {
        this.fontSingleton.release(this);
    }

    public TextStyle getTextStyle() {
        return this.textStyle;
    }

    public double getTextTop() {
        return SWTFont.getTextTop(this.fontSingleton.getGC(), this.fontSingleton.getFont()) / this.textLineHeight;
    }

    public double getTextAscent() {
        return SWTFont.getTextAscent(this.fontSingleton.getGC(), this.fontSingleton.getFont()) / this.textLineHeight;
    }

    public double getTextHalf() {
        return SWTFont.getTextHalf(this.fontSingleton.getGC(), this.fontSingleton.getFont()) / this.textLineHeight;
    }

    public double getTextDescent() {
        return SWTFont.getTextDescent(this.fontSingleton.getGC(), this.fontSingleton.getFont()) / this.textLineHeight;
    }

    public double getLeftOffset() {
        return SWTFont.getLeftOffset(this.fontSingleton.getGC(), this.fontSingleton.getFont()) / this.textLineHeight;
    }

    public double getRightOffset() {
        return SWTFont.getRightOffset(this.fontSingleton.getGC(), this.fontSingleton.getFont()) / this.textLineHeight;
    }

    public double getTextLength(String text) {
        return SWTFont.getTextLength(this.fontSingleton.getGC(), this.fontSingleton.getFont(), text) / this.textLineHeight;
    }

    public Rectangle getTextExtend(String text) {
        return SWTFont.getTextExtend(this.fontSingleton.getGC(), this.fontSingleton.getFont(), text).scale(1.0 / this.textLineHeight);
    }

    private static int getSWTTextLineHeight(GC gc, Font font) {
        int swtHHeight = SWTFont.getSWTTextAscent(gc, font) + SWTFont.getSWTTextLeading(gc, font) + SWTFont.getSWTTextDescent(gc, font);
        return swtHHeight;
    }

    public static double getTextTop(GC gc, Font font) {
        return SWTFont.getSWTTextAscent(gc, font) + SWTFont.getSWTTextLeading(gc, font);
    }

    public static double getTextAscent(GC gc, Font font) {
        return SWTFont.getSWTTextAscent(gc, font);
    }

    public static double getTextHalf(GC gc, Font font) {
        return SWTFont.getTextAscent(gc, font) * 0.6809815950920245;
    }

    public static double getTextDescent(GC gc, Font font) {
        return -SWTFont.getSWTTextDescent(gc, font);
    }

    public static double getLeftOffset(GC gc, Font font) {
        return SWTFont.getSWTTextLeftOffsetApproximation(gc, font);
    }

    public static double getRightOffset(GC gc, Font font) {
        return SWTFont.getSWTTextORightOffsetApproximation(gc, font);
    }

    public static double getTextLength(GC gc, Font font, String text) {
        return SWTFont.getSWTStringWidth(gc, font, text);
    }

    public static Rectangle getTextExtend(GC gc, Font font, String text) {
        double left = -SWTFont.getLeftOffset(gc, font);
        double upper = -SWTFont.getTextTop(gc, font);
        double right = SWTFont.getTextLength(gc, font, text) + SWTFont.getRightOffset(gc, font);
        double lower = -SWTFont.getTextDescent(gc, font);
        return new Rectangle(left, upper, right, lower);
    }

    private static int getSWTTextLeading(GC gc, Font font) {
        Font oldFont = gc.getFont();
        gc.setFont(font);
        int value = gc.getFontMetrics().getLeading();
        gc.setFont(oldFont);
        return value;
    }

    private static int getSWTTextAscent(GC gc, Font font) {
        Font oldFont = gc.getFont();
        gc.setFont(font);
        int value = gc.getFontMetrics().getAscent();
        gc.setFont(oldFont);
        return value;
    }

    private static int getSWTTextDescent(GC gc, Font font) {
        Font oldFont = gc.getFont();
        gc.setFont(font);
        int value = gc.getFontMetrics().getDescent();
        gc.setFont(oldFont);
        return value;
    }

    private static int getSWTStringWidth(GC gc, Font font, String text) {
        Font oldFont = gc.getFont();
        gc.setFont(font);
        int value = gc.stringExtent((String)text).x;
        gc.setFont(oldFont);
        return value;
    }

    private static double getSWTTextLeftOffsetApproximation(GC gc, Font font) {
        double offsetSum = SWTFont.getSWTTextOffsetSumApproximation(gc, font);
        int textLineHeight = SWTFont.getSWTTextLineHeight(gc, font);
        double leftOffset = textLineHeight == 0 ? 0.0 : offsetSum * (double)SWTFont.getSWTTextDescent(gc, font) / To.toDouble((int)textLineHeight);
        return leftOffset;
    }

    private static double getSWTTextORightOffsetApproximation(GC gc, Font font) {
        double offsetSum = SWTFont.getSWTTextOffsetSumApproximation(gc, font);
        int textLineHeight = SWTFont.getSWTTextLineHeight(gc, font);
        double rightOffset = textLineHeight == 0 ? 0.0 : offsetSum * (double)SWTFont.getSWTTextAscent(gc, font) / To.toDouble((int)textLineHeight);
        return rightOffset;
    }

    private static double getSWTTextOffsetSumApproximation(GC gc, Font font) {
        double offsetSum = SWTFont.isItalic(font) ? To.toDouble((int)SWTFont.getSWTTextLineHeight(gc, font)) * 0.15853658536585366 : 0.0;
        return offsetSum;
    }

    public static Font createSWTFont(Device device, GC gc, double textLineHeightInPixel, TextStyle textStyle) throws EXNoMoreHandles, EXFontSizeTooSmall {
        Font font;
        String fontName = textStyle.getFontName();
        int swtFontStyle = SWTFont.calculateSWTFontStyle(textStyle);
        int pointsSWT = SWTFont.findSWTPointsForTextLineHeight(device, gc, textLineHeightInPixel, textStyle);
        try {
            font = new Font(device, fontName, pointsSWT, swtFontStyle);
        }
        catch (SWTError e) {
            throw new EXNoMoreHandles((Throwable)e);
        }
        return font;
    }

    private static int findSWTPointsForTextLineHeight(Device device, GC gc, double wishedTextLineHeightInPixel, TextStyle textStyle) throws EXNoMoreHandles, EXFontSizeTooSmall {
        int textLineHeigtInSWTPoints;
        int wishedTextLineHeightInPointsPostscript;
        int lowerCursorInSWTPoints = wishedTextLineHeightInPointsPostscript = Math.max(1, (int)Math.round(SWTFont.transformPixelToPointsPostscript(device, wishedTextLineHeightInPixel) * 0.8075987144168962));
        int lowerCursorInPixels = SWTFont.getSWTTextLineHeightInPixels(device, gc, lowerCursorInSWTPoints, textStyle);
        int upperCursorInSWTPoints = lowerCursorInSWTPoints;
        int upperCursorInPixels = lowerCursorInPixels;
        while (true) {
            if (Math.abs(To.toDouble((int)lowerCursorInPixels) - wishedTextLineHeightInPixel) <= 0.5) {
                textLineHeigtInSWTPoints = lowerCursorInSWTPoints;
                break;
            }
            if (Math.abs(To.toDouble((int)upperCursorInPixels) - wishedTextLineHeightInPixel) <= 0.5) {
                textLineHeigtInSWTPoints = upperCursorInSWTPoints;
                break;
            }
            if ((double)upperCursorInPixels < wishedTextLineHeightInPixel) {
                lowerCursorInSWTPoints = upperCursorInSWTPoints;
                lowerCursorInPixels = upperCursorInPixels;
                upperCursorInSWTPoints = Math.max(upperCursorInSWTPoints + 1, (int)Math.round(To.toDouble((int)upperCursorInSWTPoints) * wishedTextLineHeightInPixel / To.toDouble((int)upperCursorInPixels)) + 1);
                upperCursorInPixels = SWTFont.getSWTTextLineHeightInPixels(device, gc, upperCursorInSWTPoints, textStyle);
                continue;
            }
            if ((double)lowerCursorInPixels > wishedTextLineHeightInPixel) {
                if (lowerCursorInSWTPoints == 1) {
                    throw new EXFontSizeTooSmall();
                }
                upperCursorInSWTPoints = lowerCursorInSWTPoints;
                upperCursorInPixels = lowerCursorInPixels;
                lowerCursorInSWTPoints = Math.max(1, Math.min(lowerCursorInSWTPoints - 1, (int)Math.round(To.toDouble((int)lowerCursorInSWTPoints) * wishedTextLineHeightInPixel / To.toDouble((int)lowerCursorInPixels)) - 1));
                lowerCursorInPixels = SWTFont.getSWTTextLineHeightInPixels(device, gc, lowerCursorInSWTPoints, textStyle);
                continue;
            }
            if (upperCursorInSWTPoints - lowerCursorInSWTPoints <= 1) {
                if (Math.abs(To.toDouble((int)lowerCursorInPixels) - wishedTextLineHeightInPixel) < Math.abs(To.toDouble((int)upperCursorInPixels) - wishedTextLineHeightInPixel)) {
                    textLineHeigtInSWTPoints = lowerCursorInSWTPoints;
                    break;
                }
                textLineHeigtInSWTPoints = upperCursorInSWTPoints;
                break;
            }
            int averageInSWTPoints = Math.max(lowerCursorInSWTPoints + 1, Math.min(upperCursorInSWTPoints - 1, (int)Math.round(To.toDouble((int)(lowerCursorInSWTPoints + upperCursorInSWTPoints)) / 2.0)));
            int averageInPixels = SWTFont.getSWTTextLineHeightInPixels(device, gc, averageInSWTPoints, textStyle);
            if (To.toDouble((int)averageInPixels) < wishedTextLineHeightInPixel) {
                lowerCursorInSWTPoints = averageInSWTPoints;
                lowerCursorInPixels = averageInPixels;
                continue;
            }
            upperCursorInSWTPoints = averageInSWTPoints;
            upperCursorInPixels = averageInPixels;
        }
        return textLineHeigtInSWTPoints;
    }

    private static int getSWTTextLineHeightInPixels(Device device, GC gc, int textLineHeightInSWTPoints, TextStyle textStyle) throws EXNoMoreHandles {
        Font testFont = SWTFont.createSWTFont(device, textLineHeightInSWTPoints, textStyle);
        int swtTextTextHeightInPixels = SWTFont.getSWTTextLineHeight(gc, testFont);
        testFont.dispose();
        return swtTextTextHeightInPixels;
    }

    private static Font createSWTFont(Device device, int pointsSWT, TextStyle textStyle) throws EXNoMoreHandles {
        Font font;
        String fontName = textStyle.getFontName();
        int swtFontStyle = SWTFont.calculateSWTFontStyle(textStyle);
        try {
            font = new Font(device, fontName, pointsSWT, swtFontStyle);
        }
        catch (SWTError e) {
            throw new EXNoMoreHandles((Throwable)e);
        }
        return font;
    }

    private static double transformPixelToPointsPostscript(Device device, double pixel) {
        double dpiY = To.toDouble((int)device.getDPI().y);
        double inch = pixel / dpiY;
        double pointsPostscript = inch * 72.0;
        return pointsPostscript;
    }

    private static int calculateSWTFontStyle(TextStyle textStyle) {
        boolean bold = textStyle.isBold();
        boolean italic = textStyle.isItalic();
        int style = 0;
        if (bold) {
            style |= 1;
        }
        if (italic) {
            style |= 2;
        }
        return style;
    }

    private static boolean isItalic(Font font) {
        return (font.getFontData()[0].getStyle() & 2) != 0;
    }

    private static class FontSingleton {
        private final SWTFontCache fontCache;
        private final SWTTextStyle swtTextStyle;
        private final Font font;
        private final GC gc;
        private final Set<SWTFont> references = new HashSet<SWTFont>();

        public FontSingleton(SWTFontCache fontCache, Display display, GC gc, SWTTextStyle swtTextStyle) throws EXNoMoreHandles {
            this.fontCache = fontCache;
            this.swtTextStyle = swtTextStyle;
            this.font = swtTextStyle.createSWTFont(display);
            this.gc = gc;
        }

        public boolean isDisposed() {
            return this.font.isDisposed();
        }

        public Font allocate(SWTFont swtFont) {
            this.references.add(swtFont);
            return this.font;
        }

        public void release(SWTFont swtFont) {
            this.references.remove(swtFont);
            if (this.references.size() == 0) {
                this.free();
            }
        }

        private void free() {
            this.fontCache.free(this.swtTextStyle);
            this.font.dispose();
        }

        public Font getFont() {
            return this.font;
        }

        public GC getGC() {
            return this.gc;
        }

        public SWTTextStyle getSWTTextStyle() {
            return this.swtTextStyle;
        }
    }

    private static class SWTFontCache {
        private final Map<SWTTextStyle, FontSingleton> swtTextStyleToFontSingleton = new HashMap<SWTTextStyle, FontSingleton>();
        private Display display;
        private GC gc;

        public FontSingleton getFontSingleton(TextStyle textStyle) throws EXNoMoreHandles {
            SWTTextStyle swtTextStyle = new SWTTextStyle(textStyle);
            FontSingleton fontSingleton = this.swtTextStyleToFontSingleton.get(swtTextStyle);
            if (fontSingleton != null && fontSingleton.isDisposed()) {
                this.swtTextStyleToFontSingleton.remove(swtTextStyle);
                fontSingleton = null;
            }
            if (fontSingleton == null) {
                this.updateDisplayAndGC();
                fontSingleton = new FontSingleton(this, this.display, this.gc, swtTextStyle);
                this.swtTextStyleToFontSingleton.put(swtTextStyle, fontSingleton);
            }
            return fontSingleton;
        }

        private void updateDisplayAndGC() throws EXNoMoreHandles {
            if (this.gc != null && this.gc.isDisposed()) {
                this.swtTextStyleToFontSingleton.clear();
                this.gc = null;
            }
            if (this.gc == null) {
                this.display = Display.getCurrent();
                if (this.display == null) {
                    try {
                        this.display = new Display();
                    }
                    catch (SWTError e) {
                        throw new EXNoMoreHandles((Throwable)e);
                    }
                }
                try {
                    this.gc = new GC((Drawable)this.display);
                }
                catch (SWTError e) {
                    throw new EXNoMoreHandles((Throwable)e);
                }
            }
        }

        public void free(SWTTextStyle swtTextStyle) {
            this.swtTextStyleToFontSingleton.remove(swtTextStyle);
        }
    }

    private static class SWTTextStyle {
        private final TextStyle textStyle;
        private final String fontName;
        private final int swtFontStyle;

        public SWTTextStyle(TextStyle textStyle) {
            this.textStyle = textStyle;
            this.fontName = textStyle.getFontName();
            this.swtFontStyle = SWTFont.calculateSWTFontStyle(textStyle);
        }

        public Font createSWTFont(Display display) throws EXNoMoreHandles {
            Font font = SWTFont.createSWTFont((Device)display, 50, this.textStyle);
            return font;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o == null) {
                return false;
            }
            if (!(o instanceof SWTTextStyle)) {
                return false;
            }
            SWTTextStyle style = (SWTTextStyle)o;
            return this.fontName.equals(style.fontName) && this.swtFontStyle == style.swtFontStyle;
        }

        public int hashCode() {
            return this.fontName.hashCode() ^ new Integer(this.swtFontStyle).hashCode();
        }
    }
}

