/*
 * Decompiled with CFR 0.152.
 */
package au.com.swz.swttocom.swt;

import au.com.swz.swttocom.swt.AbstractResourcePackage;
import au.com.swz.swttocom.swt.IManagedResourcePackageUser;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;

public class ResourceManager {
    private static final ILogger LOGGER = Logger.getLogger(ResourceManager.class);
    private static final float existentResourcesCompactGarbageThreshold = 0.75f;
    private static final int existentResourcesInitialCapacity = 200;
    private ArrayList<ResourcePackageRegistration> existentResources = new ArrayList(200);
    private ReferenceQueue<IManagedResourcePackageUser> garbageResources = new ReferenceQueue();
    private long resourceDisposalsSinceLastCompact = 0L;
    private long totalResourceAllocations = 0L;
    private long totalResourceDisposals = 0L;
    private int totalSweeps = 0;
    private int totalCompacts = 0;
    private boolean isDisposed = false;

    public synchronized void registerResourcePackage(IManagedResourcePackageUser resourcePackageUser, AbstractResourcePackage resourcePackage) {
        assert (!this.isDisposed);
        this.sweep();
        this.compact();
        ResourcePackageRegistration resourcePackageRegistration = new ResourcePackageRegistration(resourcePackageUser, this.garbageResources, resourcePackage);
        this.existentResources.add(resourcePackageRegistration);
        if (this.totalResourceAllocations != Long.MAX_VALUE) {
            ++this.totalResourceAllocations;
        }
    }

    public synchronized void shutdown() {
        assert (!this.isDisposed);
        long shutdownStartMillis = System.currentTimeMillis();
        this.sweep();
        int numAliveResourcesAtShutdown = 0;
        HashMap<String, Integer> aliveResourcesAtShutdownPerType = new HashMap<String, Integer>();
        int i = this.existentResources.size() - 1;
        while (i >= 0) {
            ResourcePackageRegistration resourcePackageRegistration = this.existentResources.get(i);
            AbstractResourcePackage resourcePackage = resourcePackageRegistration.getResourcePackage();
            if (resourcePackage != null) {
                String referentTypeName = ((IManagedResourcePackageUser)resourcePackageRegistration.get()).getClass().getName();
                boolean bl = this.disposeRegisteredResourcePackage(resourcePackageRegistration);
                if (bl) {
                    ++numAliveResourcesAtShutdown;
                    Integer numberOfAliveResourcesOfSameType = (Integer)aliveResourcesAtShutdownPerType.get(referentTypeName);
                    numberOfAliveResourcesOfSameType = numberOfAliveResourcesOfSameType != null ? Integer.valueOf(numberOfAliveResourcesOfSameType + 1) : Integer.valueOf(1);
                    aliveResourcesAtShutdownPerType.put(referentTypeName, numberOfAliveResourcesOfSameType);
                }
            }
            --i;
        }
        this.isDisposed = true;
        long shutdownMillis = System.currentTimeMillis() - shutdownStartMillis;
        StringBuilder message = new StringBuilder();
        message.append("COM ResouceManager statistics:").append("  totalResourceAllocations=" + this.totalResourceAllocations).append(", totalResourceDisposals=" + this.totalResourceDisposals).append(", numAliveResourcesAtShutdown=" + numAliveResourcesAtShutdown).append(", shutdownMillis=" + shutdownMillis).append(", totalSweeps=" + this.totalSweeps).append(", totalCompacts=" + this.totalCompacts);
        message.append(", numAliveresourcesPerType=");
        ArrayList entryList = new ArrayList(aliveResourcesAtShutdownPerType.entrySet());
        Collections.sort(entryList, new Comparator<Map.Entry<String, Integer>>(){

            @Override
            public int compare(Map.Entry<String, Integer> paramT1, Map.Entry<String, Integer> paramT2) {
                return paramT2.getValue() - paramT1.getValue();
            }
        });
        for (Map.Entry entry : entryList) {
            message.append(' ').append((String)entry.getKey()).append(':').append(entry.getValue());
        }
        LOGGER.debug(message.toString());
    }

    private void sweep() {
        boolean sweeped = false;
        ResourcePackageRegistration garbageResourceRegistration = (ResourcePackageRegistration)this.garbageResources.poll();
        while (garbageResourceRegistration != null) {
            this.disposeRegisteredResourcePackage(garbageResourceRegistration);
            sweeped = true;
            garbageResourceRegistration = (ResourcePackageRegistration)this.garbageResources.poll();
        }
        if (sweeped && this.totalSweeps != Integer.MAX_VALUE) {
            ++this.totalSweeps;
        }
    }

    private boolean disposeRegisteredResourcePackage(ResourcePackageRegistration garbageResourceRegistration) {
        AbstractResourcePackage resourcePackage = garbageResourceRegistration.getResourcePackage();
        assert (resourcePackage != null);
        boolean wasAlive = false;
        if (!resourcePackage.isDisposed()) {
            wasAlive = true;
            resourcePackage.dispose();
        }
        garbageResourceRegistration.clearResourcePackageReference();
        garbageResourceRegistration.clear();
        ++this.resourceDisposalsSinceLastCompact;
        if (this.totalResourceDisposals != Long.MAX_VALUE) {
            ++this.totalResourceDisposals;
        }
        return wasAlive;
    }

    private void compact() {
        int existentResources_size = this.existentResources.size();
        if (existentResources_size >= 200 && (float)this.resourceDisposalsSinceLastCompact > 0.75f * (float)existentResources_size) {
            ArrayList<ResourcePackageRegistration> survivorRegistrations = new ArrayList<ResourcePackageRegistration>(existentResources_size * 2);
            for (ResourcePackageRegistration registration : this.existentResources) {
                if (registration.getResourcePackage() == null) continue;
                survivorRegistrations.add(registration);
            }
            this.existentResources = survivorRegistrations;
            this.resourceDisposalsSinceLastCompact = 0L;
            if (this.totalCompacts != Integer.MAX_VALUE) {
                ++this.totalCompacts;
            }
        }
    }

    private static class ResourcePackageRegistration
    extends WeakReference<IManagedResourcePackageUser> {
        private AbstractResourcePackage resourcePackage;

        public ResourcePackageRegistration(IManagedResourcePackageUser resourcePackageUser, ReferenceQueue<? super IManagedResourcePackageUser> q, AbstractResourcePackage resourcePackage) {
            super(resourcePackageUser, q);
            assert (resourcePackage != null);
            this.resourcePackage = resourcePackage;
        }

        public AbstractResourcePackage getResourcePackage() {
            return this.resourcePackage;
        }

        public void clearResourcePackageReference() {
            this.resourcePackage = null;
        }
    }
}

