/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.eclipse.gef.draw2d.printing;

import com.arcway.lib.eclipse.gef.draw2d.IFigureProvider;
import com.arcway.lib.eclipse.gef.draw2d.printing.PrintFigureOperation;
import org.eclipse.gef.ui.actions.WorkbenchPartAction;
import org.eclipse.swt.printing.PrintDialog;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.ActionFactory;

public class PrintAction
extends WorkbenchPartAction {
    private final IFigureProvider figureProvider;

    public PrintAction(IWorkbenchPart part, IFigureProvider figureProvider) {
        super(part);
        this.figureProvider = figureProvider;
        ActionFactory.IWorkbenchAction printAction = ActionFactory.PRINT.create(part.getSite().getWorkbenchWindow());
        this.setText(printAction.getText());
        this.setToolTipText(printAction.getToolTipText());
        this.setId(printAction.getId());
        this.setImageDescriptor(printAction.getImageDescriptor());
        this.setDisabledImageDescriptor(printAction.getDisabledImageDescriptor());
        this.setHoverImageDescriptor(printAction.getHoverImageDescriptor());
        this.setDescription(printAction.getDescription());
        printAction.dispose();
        this.setLazyEnablementCalculation(false);
    }

    protected void init() {
        super.init();
    }

    public boolean isEnabled() {
        boolean printerAvailable;
        PrinterData[] printers = Printer.getPrinterList();
        boolean bl = printerAvailable = printers != null && printers.length > 0;
        return printerAvailable && super.isEnabled();
    }

    protected boolean calculateEnabled() {
        return false;
    }

    public void run() {
        PrintDialog dialog = new PrintDialog(this.getWorkbenchPart().getSite().getShell(), 0);
        PrinterData data = dialog.open();
        if (data != null) {
            Printer printer = new Printer(data);
            try {
                PrintFigureOperation op = new PrintFigureOperation(printer, this.figureProvider.getCurrentFigure());
                op.setPrintMode(2);
                op.run(this.getWorkbenchPart().getTitle());
            }
            finally {
                printer.dispose();
            }
        }
    }
}

