/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.frontend.eclipse.interFace.repositoryproviders;

import com.arcway.frontend.eclipse.interFace.plugin.extensions.RepositoryProviderExtensionPoint;
import com.arcway.frontend.eclipse.interFace.repositoryproviders.IRepositoryProvider;
import com.arcway.lib.java.collections.ICollection_;
import com.arcway.lib.java.collections.IIterator_;
import com.arcway.repository.interFace.dataaccess.IRepositoryInterfaceRO;

public class EclipseFrontendRepositoryReference {
    private final String repositoryTypeID;
    private final String repositoryID;

    public EclipseFrontendRepositoryReference(IRepositoryInterfaceRO repositoryInterface) throws EXRepositoryHasNoRepositoryProvider {
        String foundRepositoryID = null;
        String foundRepositoryTypeID = null;
        ICollection_<IRepositoryProvider> repositoryProviders = RepositoryProviderExtensionPoint.getInstance().getRepositoryProviders();
        IIterator_ i = repositoryProviders.iterator();
        while (foundRepositoryID == null && i.hasNext()) {
            IRepositoryProvider repositoryProvider = (IRepositoryProvider)i.next();
            foundRepositoryID = repositoryProvider.getRepositoryID(repositoryInterface);
            if (foundRepositoryID == null) continue;
            foundRepositoryTypeID = repositoryProvider.getRepositoryTypeID();
        }
        if (foundRepositoryID == null) {
            throw new EXRepositoryHasNoRepositoryProvider();
        }
        this.repositoryTypeID = foundRepositoryTypeID;
        this.repositoryID = foundRepositoryID;
    }

    public EclipseFrontendRepositoryReference(String repositoryTypeID, String repositoryID) {
        this.repositoryTypeID = repositoryTypeID;
        this.repositoryID = repositoryID;
    }

    public static IRepositoryInterfaceRO findRepositoryInterface(EclipseFrontendRepositoryReference repositoryReference) {
        IRepositoryInterfaceRO foundRepositoryInterface = null;
        ICollection_<IRepositoryProvider> repositoryProviders = RepositoryProviderExtensionPoint.getInstance().getRepositoryProviders();
        IIterator_ i = repositoryProviders.iterator();
        while (foundRepositoryInterface == null && i.hasNext()) {
            IRepositoryProvider repositoryProvider = (IRepositoryProvider)i.next();
            if (!repositoryProvider.getRepositoryTypeID().equals(repositoryReference.getRepositoryTypeID())) continue;
            foundRepositoryInterface = repositoryProvider.getRepositoryInterface(repositoryReference.getRepositoryID());
        }
        return foundRepositoryInterface;
    }

    public String getRepositoryTypeID() {
        return this.repositoryTypeID;
    }

    public String getRepositoryID() {
        return this.repositoryID;
    }

    public class EXRepositoryHasNoRepositoryProvider
    extends Exception {
    }
}

