/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.frontend.definition.lib.interFace.declaration.label;

import com.arcway.frontend.definition.lib.interFace.declaration.label.Condition;
import com.arcway.frontend.definition.lib.interFace.declaration.label.ExpirationHelper;
import com.arcway.frontend.definition.lib.interFace.declaration.label.LabelCreationContext;
import com.arcway.frontend.definition.lib.interFace.declaration.label.Text;
import com.arcway.lib.java.Assert;
import java.util.Date;

public class TextIf
implements Text {
    private final Condition ifCondition;
    private final Text thenText;
    private final Text elseText;

    public TextIf(Condition ifCondition, Text thenText, Text elseText) {
        Assert.checkArgumentBeeingNotNull((Object)ifCondition);
        Assert.checkArgumentBeeingNotNull((Object)thenText);
        Assert.checkArgumentBeeingNotNull((Object)elseText);
        this.ifCondition = ifCondition;
        this.thenText = thenText;
        this.elseText = elseText;
    }

    @Override
    public String getText(LabelCreationContext context) {
        String text = this.ifCondition.isTrue(context) ? this.thenText.getText(context) : this.elseText.getText(context);
        return text;
    }

    @Override
    public Date expires(LabelCreationContext labelCreationContext) {
        Date valueExpirationDate = this.ifCondition.isTrue(labelCreationContext) ? this.thenText.expires(labelCreationContext) : this.elseText.expires(labelCreationContext);
        return ExpirationHelper.getEarliestDate(new Date[]{this.ifCondition.expires(labelCreationContext), valueExpirationDate});
    }
}

