/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.ppm1.ppm1migrator.messages;

import com.arcway.cockpit.frame.client.project.migration.access_both.version0.modules.EOAbstractModuleData_V0;
import com.arcway.cockpit.frame.shared.IPermissionOperand;
import com.arcway.cockpit.ppm1.ppm1migrator.messages.EOTask;
import com.arcway.lib.stringtools.StringUtil;
import de.plans.lib.xml.encoding.EXEncoderException;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.lib.xml.encoding.XMLContext;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;

public final class EOPMProject
extends EOAbstractModuleData_V0
implements IPermissionOperand {
    public static String XML_NAME = "pmm.pmproject";
    private static final String ATTR_TAG_SOURCE_UID = "sourceuid";
    private static final String ATTR_TAG_NAME = "name";
    private static final String ATTR_TAG_START = "start";
    private static final String ATTR_TAG_FINISH = "finish";
    private static final String ATTR_TAG_DURATION = "duration";
    private static final String ATTR_TAG_WORK = "work";
    private static final String ATTR_TAG_WORK_DONE = "workdone";
    private static final String ATTR_TAG_EXTERNAL_UID = "externalUID";
    private static final String ATTR_TAG_DESCRIPTION = "description";
    private static final String ATTR_TAG_HOURS_PER_DAY = "hoursPerDay";
    private static final String ATTR_TAG_ORIGINAL_WORK = "originalwork";
    private static final String ATTR_TAG_UID = "uid";
    private static final String ATTR_TAG_PROJECT_UID = "projectuid";
    private String sourceUid;
    private String name;
    private Timestamp start;
    private Timestamp finish;
    private int duration = 0;
    private long work = 0L;
    private long workDone = 0L;
    private String externalUID;
    private String description;
    private int hoursPerDay = 8;
    private long originalWork = 0L;
    private final List tasks = new ArrayList();

    public EOPMProject() {
        super(XML_NAME);
    }

    public EOPMProject(XMLContext xmlContext) {
        super(XML_NAME, xmlContext);
    }

    public EOPMProject(EOPMProject pmProject) {
        super(XML_NAME);
        assert (pmProject != null) : "pmproject to copy is null";
        this.setUid(pmProject.getUID());
        this.setProjectUID(pmProject.getProjectUID());
        this.setSourceUID(pmProject.getSourceUID());
        this.setExternalUID(pmProject.getExternalUID());
        this.setDuration(pmProject.getDuration());
        this.setStart(pmProject.getStart());
        this.setFinish(pmProject.getFinish());
        this.setWork(pmProject.getWork());
        this.setWorkDone(pmProject.getWorkDone());
        this.setName(pmProject.getName());
        this.setDescription(pmProject.getDescription());
        this.setHoursPerDay(pmProject.getHoursPerDay());
        int i = 0;
        while (i < pmProject.getTasksCount()) {
            this.addTask(pmProject.getTask(i));
            ++i;
        }
    }

    protected void appendAttributesToXML(EncodableObjectBase.WriteContext outp) throws EXEncoderException {
        super.appendAttributesToXML(outp);
        this.appendAttrToXML(outp, ATTR_TAG_SOURCE_UID, this.sourceUid);
        this.appendAttrToXML(outp, ATTR_TAG_NAME, this.name);
        this.appendAttrToXML(outp, ATTR_TAG_DESCRIPTION, this.description);
        this.appendAttrToXML(outp, ATTR_TAG_EXTERNAL_UID, this.externalUID);
        this.appendAttrToXML(outp, ATTR_TAG_HOURS_PER_DAY, this.hoursPerDay);
    }

    protected boolean setAttributeFromXML(String name, String value) {
        if (super.setAttributeFromXML(name, value)) {
            return true;
        }
        if (name.equals(ATTR_TAG_UID)) {
            super.setUid(value);
            return true;
        }
        if (name.equals(ATTR_TAG_PROJECT_UID)) {
            this.setProjectUID(value);
            return true;
        }
        if (name.equals(ATTR_TAG_SOURCE_UID)) {
            this.sourceUid = value;
            return true;
        }
        if (name.equals(ATTR_TAG_NAME)) {
            this.name = value;
            return true;
        }
        if (name.equals(ATTR_TAG_DESCRIPTION)) {
            this.description = value;
            return true;
        }
        if (name.equals(ATTR_TAG_EXTERNAL_UID)) {
            this.externalUID = value;
            return true;
        }
        if (name.equals(ATTR_TAG_HOURS_PER_DAY)) {
            this.hoursPerDay = Integer.parseInt(value);
            return true;
        }
        return false;
    }

    protected boolean hasChildren() {
        return false;
    }

    protected void writeChildrenToXML(EncodableObjectBase.WriteContext outp, int depth) {
    }

    protected boolean addChildFromXML(EncodableObjectBase newChild) {
        return false;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        EOPMProject pmProject = (EOPMProject)((Object)obj);
        return this.getProjectUID().equals(pmProject.getProjectUID()) && this.getUID().equals(pmProject.getUID());
    }

    public int hashCode() {
        return (String.valueOf(this.getProjectUID()) + this.getUID()).hashCode();
    }

    public int getTasksCount() {
        return this.tasks.size();
    }

    public EOTask getTask(int index) {
        return (EOTask)((Object)this.tasks.get(index));
    }

    public void addTask(EOTask task) {
        assert (task != null) : "task is null";
        this.tasks.add(task);
    }

    public void removeTask(EOTask task) {
        this.tasks.remove((Object)task);
    }

    public void removeTask(int index) {
        this.tasks.remove(index);
    }

    public void removeAllTasks() {
        this.tasks.clear();
    }

    public Object[] getChildTasksArray() {
        return this.tasks.toArray();
    }

    public String getSourceUID() {
        return this.sourceUid;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public int getDuration() {
        return this.duration;
    }

    public Timestamp getFinish() {
        return this.finish;
    }

    public Timestamp getStart() {
        return this.start;
    }

    public long getWork() {
        return this.work;
    }

    public long getWorkDone() {
        return this.workDone;
    }

    public String getExternalUID() {
        return this.externalUID;
    }

    public int getHoursPerDay() {
        return this.hoursPerDay;
    }

    public long getOriginalWork() {
        return this.originalWork;
    }

    public void setSourceUID(String uid) {
        assert (uid != null) : "source uid is null";
        this.sourceUid = uid;
    }

    public void setName(String string) {
        assert (string != null) : "name is null";
        this.name = string;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setDuration(int duration) {
        assert (duration >= 0) : "duration < 0";
        this.duration = duration;
    }

    public void setFinish(Timestamp finish) {
        this.finish = finish;
    }

    public void setStart(Timestamp start) {
        this.start = start;
    }

    public void setWork(long work) {
        this.work = work;
    }

    public void setWorkDone(long workDone) {
        this.workDone = workDone;
    }

    public void setExternalUID(String externalUID) {
        this.externalUID = externalUID;
    }

    public void setHoursPerDay(int hoursPerDay) {
        this.hoursPerDay = hoursPerDay;
    }

    public void setOriginalWork(long originalWork) {
        this.originalWork = originalWork;
    }

    public String getPermissionOperandDisplayName() {
        return this.getName();
    }

    public String getPermissionOperandType() {
        return "treeElement";
    }

    public String getPermissionOperandUID() {
        return this.getUID();
    }

    public static final boolean haveEqualAttributes(EOPMProject p1, EOPMProject p2) {
        boolean equal = StringUtil.equals((String)p1.getName(), (String)p2.getName()) && StringUtil.equals((String)p1.getProjectUID(), (String)p2.getProjectUID()) && StringUtil.equals((String)p1.getSourceUID(), (String)p2.getSourceUID());
        return equal;
    }

    public String getTypeID() {
        return "com.arcway.msp.projectPlan";
    }
}

