/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.ppm1.ppm1migrator;

import com.arcway.cockpit.frame.client.project.migration.MigrationFailedException;
import com.arcway.cockpit.frame.client.project.migration.access_both.version0.EOLinkLog_V0;
import com.arcway.cockpit.frame.client.project.migration.access_both.version0.EOLink_V0;
import com.arcway.cockpit.frame.client.project.migration.access_both.version0.EOModuleData_V0;
import com.arcway.cockpit.frame.client.project.migration.access_both.version0.EOProject_V0;
import com.arcway.cockpit.frame.client.project.migration.access_both.version0.EOStakeholder_V0;
import com.arcway.cockpit.frame.client.project.migration.access_both.version0.EOVersionedModuleData_V0;
import com.arcway.cockpit.frame.client.project.migration.access_both.version0.V0_EOFactory;
import com.arcway.cockpit.frame.client.project.migration.access_both.version0.modules.EOModuleDataContainer_V0;
import com.arcway.cockpit.frame.client.project.migration.access_both.version0.modules.EOSourceFileInfo_V0;
import com.arcway.cockpit.frame.client.project.migration.access_both.version0.modules.V0_EOFactory_ForModules;
import com.arcway.cockpit.frame.client.project.migration.access_dumps.version0.HistoricProjectDumpView_0_;
import com.arcway.cockpit.ppm1.ppm1migrator.Converter;
import com.arcway.cockpit.ppm1.ppm1migrator.PPM1MigratorCore;
import com.arcway.cockpit.ppm1.ppm1migrator.messages.EODataContainer;
import com.arcway.cockpit.ppm1.ppm1migrator.messages.EODataContainerOld;
import com.arcway.cockpit.ppm1.ppm1migrator.messages.EOPMProject;
import com.arcway.cockpit.ppm1.ppm1migrator.messages.EOTask;
import com.arcway.cockpit.ppm1.ppm1migrator.messages.EOWorkItem;
import com.arcway.cockpit.ppm1.ppm1migrator.messages.MessageDataFactory;
import com.arcway.lib.codec.EXDecoderException;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import de.plans.lib.xml.encoding.EOList;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.lib.xml.encoding.IEncodableObjectFactory;
import de.plans.lib.xml.encoding.MessageDataFactoryForBasicEOs;
import de.plans.lib.xml.encoding.MessageDataFactoryForUnknownEOs;
import de.plans.lib.xml.encoding.MultiplexEncodableObjectFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class PPM1Migrator_ForDumps {
    private static final ILogger logger = Logger.getLogger(PPM1Migrator_ForDumps.class);
    private static final String MODULE_ID_PPM1 = "PMM";
    private static final String DATAFILE_NAME_PPM1 = "pmm.xml";
    private static final String STAKEHOLDERS_DELIMITER = ";";

    public static void migrateData(EOProject_V0 project, HistoricProjectDumpView_0_ historicViewOnDumpFile) throws MigrationFailedException {
        try {
            EOModuleData_V0 newTask;
            String pmProjectUid;
            String projectUID = project.getProjectUID();
            String defaultCreatorModifier = "";
            long defaultCreationModificationDate = System.currentTimeMillis();
            ArrayList<EOModuleData_V0> newSourcefileInfos = new ArrayList<EOModuleData_V0>();
            ArrayList<EOModuleData_V0> newProjectPlans = new ArrayList<EOModuleData_V0>();
            ArrayList<EOModuleData_V0> newTasks = new ArrayList<EOModuleData_V0>();
            ArrayList<EOModuleData_V0> newWorkItems = new ArrayList<EOModuleData_V0>();
            ArrayList newWICategories = new ArrayList();
            ArrayList<EOVersionedModuleData_V0> newSourcefileInfoLogs = new ArrayList<EOVersionedModuleData_V0>();
            ArrayList<EOVersionedModuleData_V0> newProjectPlanLogs = new ArrayList<EOVersionedModuleData_V0>();
            ArrayList<EOVersionedModuleData_V0> newTasksLogs = new ArrayList<EOVersionedModuleData_V0>();
            ArrayList<EOVersionedModuleData_V0> newWorkItemLogs = new ArrayList<EOVersionedModuleData_V0>();
            ArrayList newWICategoryLogs = new ArrayList();
            ArrayList<EOLink_V0> newLinks = new ArrayList<EOLink_V0>();
            HashMap<String, EOModuleData_V0> sourcefileMap = new HashMap<String, EOModuleData_V0>();
            HashMap<String, EOModuleData_V0> projectPlanMap = new HashMap<String, EOModuleData_V0>();
            HashMap<String, EOModuleData_V0> taskMap = new HashMap<String, EOModuleData_V0>();
            HashMap<String, EOModuleData_V0> workItemMap = new HashMap<String, EOModuleData_V0>();
            HashMap categoryNameMap = new HashMap();
            HashMap<String, Integer> idMap = new HashMap<String, Integer>();
            EncodableObjectBase dataContainer_oldFormat = historicViewOnDumpFile.readDataFile(project, DATAFILE_NAME_PPM1, MODULE_ID_PPM1, (IEncodableObjectFactory)new MultiplexEncodableObjectFactory(new IEncodableObjectFactory[]{MessageDataFactory.getInstance(), V0_EOFactory_ForModules.getDefault(), MessageDataFactoryForBasicEOs.getDefault()}), false);
            if (!(dataContainer_oldFormat instanceof EODataContainerOld)) {
                if (dataContainer_oldFormat != null) {
                    throw new MigrationFailedException("PPM1 data container has unexpected format.");
                }
                return;
            }
            EODataContainerOld oldContainer = (EODataContainerOld)dataContainer_oldFormat;
            EODataContainer dataContainer = new EODataContainer();
            dataContainer.setProjectUID(oldContainer.getProjectUID());
            dataContainer.setPMProjectList(new EOList(Arrays.asList(oldContainer.getPmProjectsArray())));
            dataContainer.setTaskList(new EOList(Arrays.asList(oldContainer.getTasksArray())));
            dataContainer.setSourceInformationList(new EOList(Arrays.asList(oldContainer.getSourceFileInfoArray())));
            EOList workItems = oldContainer.getWorkItemList();
            Converter converter = new Converter();
            dataContainer.setWorkItemList(converter.convertFromEnvelopes((List)workItems));
            EOList oldSourceFileInfos = dataContainer.getSourceInformationList();
            for (EOSourceFileInfo_V0 oldSourceFileInfo : oldSourceFileInfos) {
                EOModuleData_V0 newSourceFileInfo = PPM1MigratorCore.migrateSourceFileInfoRecord(oldSourceFileInfo, projectUID, defaultCreatorModifier, defaultCreationModificationDate);
                newSourcefileInfos.add(newSourceFileInfo);
                sourcefileMap.put(oldSourceFileInfo.getUID(), newSourceFileInfo);
                newSourcefileInfoLogs.add(new EOVersionedModuleData_V0(newSourceFileInfo));
            }
            List oldProjectPlans = dataContainer.getPMProjectList();
            for (EOPMProject oldProjectPlan : oldProjectPlans) {
                EOModuleData_V0 newProjectPlan = PPM1MigratorCore.migrateProjectPlanRecord(oldProjectPlan, projectUID, defaultCreatorModifier, defaultCreationModificationDate);
                newProjectPlans.add(newProjectPlan);
                projectPlanMap.put(oldProjectPlan.getUID(), newProjectPlan);
                String oldSourcefileUID = oldProjectPlan.getSourceUID();
                if (oldSourcefileUID != null) {
                    EOModuleData_V0 newTargetSourcefile = (EOModuleData_V0)sourcefileMap.get(oldSourcefileUID);
                    if (newTargetSourcefile != null) {
                        newLinks.add(new EOLink_V0(projectUID, newTargetSourcefile.getUid(), newProjectPlan.getUid(), "com.arcway.cockpit.projectplanningmodule2", "ProjectSourceFile"));
                    } else {
                        logger.warn("Inconsistent project planning data: The project plan with the name \"" + (oldProjectPlan.getName() == null ? "" : oldProjectPlan.getName()) + "\" referred to a non existing source file");
                    }
                }
                newProjectPlanLogs.add(new EOVersionedModuleData_V0(newProjectPlan));
            }
            List oldTasks = dataContainer.getTaskList();
            for (EOTask oldTask : oldTasks) {
                pmProjectUid = oldTask.getPMProjectUid();
                if (pmProjectUid != null && projectPlanMap.get(pmProjectUid) != null) {
                    newTask = PPM1MigratorCore.migrateTaskRecord(oldTask, projectUID, defaultCreatorModifier, defaultCreationModificationDate);
                    newTasks.add(newTask);
                    taskMap.put(oldTask.getUID(), newTask);
                    newTasksLogs.add(new EOVersionedModuleData_V0(newTask));
                    continue;
                }
                logger.warn("Inconsistent project planning data: The task with the name \"" + (oldTask.getName() == null ? "" : oldTask.getName()) + "\" referred to a non existing project plan. - did not import this task ");
            }
            for (EOTask oldTask : oldTasks) {
                pmProjectUid = oldTask.getPMProjectUid();
                if (pmProjectUid == null || projectPlanMap.get(pmProjectUid) == null) continue;
                newTask = (EOModuleData_V0)taskMap.get(oldTask.getUID());
                String newPlanUID = ((EOModuleData_V0)projectPlanMap.get(pmProjectUid)).getUid();
                Integer id = (Integer)idMap.get(newPlanUID);
                if (id == null) {
                    id = new Integer(0);
                }
                int newID = id + 1;
                newTask.addAttribute("ppm.task.ID", Integer.toString(newID));
                idMap.put(newPlanUID, new Integer(newID));
                String oldParentTaskUID = oldTask.getParentUid();
                if (oldParentTaskUID == null || taskMap.get(oldParentTaskUID) == null) {
                    newLinks.add(new EOLink_V0(projectUID, ((EOModuleData_V0)projectPlanMap.get(oldTask.getPMProjectUid())).getUid(), newTask.getUid(), "com.arcway.cockpit.projectplanningmodule2", "TaskProjectPlan"));
                    if (oldParentTaskUID == null) continue;
                    logger.warn("Inconsistent project planning data: The task with the name \"" + (oldTask.getName() == null ? "" : oldTask.getName()) + "\" referred to a non existing parent task." + " - converted task to a \"root\" task of the same project plan");
                    continue;
                }
                newLinks.add(new EOLink_V0(projectUID, ((EOModuleData_V0)taskMap.get(oldParentTaskUID)).getUid(), newTask.getUid(), "com.arcway.cockpit.projectplanningmodule2", "TaskTask"));
            }
            Map<String, EOStakeholder_V0> stakeholderMap = PPM1Migrator_ForDumps.extractStakeholderNames((List<EOStakeholder_V0>)historicViewOnDumpFile.readStakeholders(project));
            EOList oldWorkItems = dataContainer.getWorkItemList();
            for (EOWorkItem oldWorkItem : oldWorkItems) {
                String linkedTaskUID;
                EOModuleData_V0 newWorkItem = PPM1MigratorCore.migrateWorkItemRecord(oldWorkItem, projectUID, defaultCreatorModifier, defaultCreationModificationDate, stakeholderMap);
                newWorkItems.add(newWorkItem);
                workItemMap.put(oldWorkItem.getUID(), newWorkItem);
                EOModuleData_V0 workItemCategory = PPM1MigratorCore.updateCategoryListAndReturnCategoryEO(newWICategories, newWICategoryLogs, categoryNameMap, oldWorkItem, projectUID, defaultCreatorModifier, defaultCreationModificationDate);
                String targetUEUid = oldWorkItem.getUniqueElementUID();
                if (targetUEUid != null) {
                    newLinks.add(new EOLink_V0(projectUID, targetUEUid, newWorkItem.getUid(), "com.arcway.cockpit.projectplanningmodule2", "WorkItemUniqueElement"));
                }
                if ((linkedTaskUID = oldWorkItem.getTaskUID()) != null) {
                    EOModuleData_V0 newTargetTask = (EOModuleData_V0)taskMap.get(linkedTaskUID);
                    if (newTargetTask != null) {
                        newLinks.add(new EOLink_V0(projectUID, newTargetTask.getUid(), newWorkItem.getUid(), "com.arcway.cockpit.projectplanningmodule2", "WorkItemTask"));
                    } else {
                        logger.warn("Inconsistent project planning data: The work item with the name \"" + (oldWorkItem.getName() == null ? "" : oldWorkItem.getName()) + "\" refferred to a non existing task. ");
                    }
                }
                EOLinkLog_V0 workItemCategoryLinkLog = null;
                if (workItemCategory != null) {
                    newLinks.add(new EOLink_V0(projectUID, workItemCategory.getUid(), newWorkItem.getUid(), "com.arcway.cockpit.projectplanningmodule2", "WorkItemCategory"));
                    workItemCategoryLinkLog = new EOLinkLog_V0(projectUID, workItemCategory.getUid(), workItemCategory.getModCount(), newWorkItem.getUid(), newWorkItem.getModCount(), "com.arcway.cockpit.projectplanningmodule2", "WorkItemCategory");
                }
                StringTokenizer names = new StringTokenizer(oldWorkItem.getResourceNames(), STAKEHOLDERS_DELIMITER);
                EOStakeholder_V0 personInCharge = null;
                while (names.hasMoreTokens() && personInCharge == null) {
                    String name = names.nextToken().trim();
                    personInCharge = stakeholderMap.get(name);
                }
                if (personInCharge != null) {
                    newLinks.add(new EOLink_V0(projectUID, personInCharge.getUID(), newWorkItem.getUid(), "com.arcway.cockpit.projectplanningmodule2", "WorkItemStakeholder"));
                }
                EOVersionedModuleData_V0 newWorkItemLog = new EOVersionedModuleData_V0(newWorkItem);
                if (workItemCategoryLinkLog != null) {
                    newWorkItemLog.addOutLink(workItemCategoryLinkLog);
                }
                newWorkItemLogs.add(newWorkItemLog);
            }
            EOList moduleData = (EOList)historicViewOnDumpFile.readDataFile(project, "cmm_data.xml", "cmm", (IEncodableObjectFactory)new MultiplexEncodableObjectFactory(new IEncodableObjectFactory[]{V0_EOFactory_ForModules.getDefault(), V0_EOFactory.getDefault(), MessageDataFactoryForBasicEOs.getDefault(), MessageDataFactoryForUnknownEOs.getDefault()}));
            EOModuleDataContainer_V0 sourceFileContainer = new EOModuleDataContainer_V0();
            sourceFileContainer.setDataTypeUID("ppm2.sourceFile");
            sourceFileContainer.setModuleDataItems(new EOList(newSourcefileInfos));
            moduleData.add((EncodableObjectBase)sourceFileContainer);
            EOModuleDataContainer_V0 projectPlanContainer = new EOModuleDataContainer_V0();
            projectPlanContainer.setDataTypeUID("ppm2.projectplan");
            projectPlanContainer.setModuleDataItems(new EOList(newProjectPlans));
            moduleData.add((EncodableObjectBase)projectPlanContainer);
            EOModuleDataContainer_V0 taskContainer = new EOModuleDataContainer_V0();
            taskContainer.setDataTypeUID("ppm2.task");
            taskContainer.setModuleDataItems(new EOList(newTasks));
            moduleData.add((EncodableObjectBase)taskContainer);
            EOModuleDataContainer_V0 workItemContainer = new EOModuleDataContainer_V0();
            workItemContainer.setDataTypeUID("ppm2.workitem");
            workItemContainer.setModuleDataItems(new EOList(newWorkItems));
            moduleData.add((EncodableObjectBase)workItemContainer);
            EOModuleDataContainer_V0 workItemCategoryContainer = new EOModuleDataContainer_V0();
            workItemCategoryContainer.setDataTypeUID("ppm2.workitemcategory");
            workItemCategoryContainer.setModuleDataItems(new EOList(newWICategories));
            moduleData.add((EncodableObjectBase)workItemCategoryContainer);
            boolean success = historicViewOnDumpFile.writeDataFile(project, "cmm_data.xml", "cmm", (EncodableObjectBase)moduleData);
            if (!success) {
                throw new MigrationFailedException("Can't write back migrated ppm data.");
            }
            EOList moduleDataLogs = (EOList)historicViewOnDumpFile.readDataFile(project, "cmm_data_log.xml", "cmm", (IEncodableObjectFactory)new MultiplexEncodableObjectFactory(new IEncodableObjectFactory[]{V0_EOFactory_ForModules.getDefault(), V0_EOFactory.getDefault(), MessageDataFactoryForBasicEOs.getDefault(), MessageDataFactoryForUnknownEOs.getDefault()}));
            EOModuleDataContainer_V0 sourceFileLogContainer = new EOModuleDataContainer_V0();
            sourceFileLogContainer.setDataTypeUID("ppm2.sourceFile");
            sourceFileLogContainer.setModuleDataItems(new EOList(newSourcefileInfoLogs));
            moduleDataLogs.add((EncodableObjectBase)sourceFileLogContainer);
            EOModuleDataContainer_V0 projectPlanLogContainer = new EOModuleDataContainer_V0();
            projectPlanLogContainer.setDataTypeUID("ppm2.projectplan");
            projectPlanLogContainer.setModuleDataItems(new EOList(newProjectPlanLogs));
            moduleDataLogs.add((EncodableObjectBase)projectPlanLogContainer);
            EOModuleDataContainer_V0 taskLogContainer = new EOModuleDataContainer_V0();
            taskLogContainer.setDataTypeUID("ppm2.task");
            taskLogContainer.setModuleDataItems(new EOList(newTasksLogs));
            moduleDataLogs.add((EncodableObjectBase)taskLogContainer);
            EOModuleDataContainer_V0 workItemLogContainer = new EOModuleDataContainer_V0();
            workItemLogContainer.setDataTypeUID("ppm2.workitem");
            workItemLogContainer.setModuleDataItems(new EOList(newWorkItemLogs));
            moduleDataLogs.add((EncodableObjectBase)workItemLogContainer);
            EOModuleDataContainer_V0 workItemLogCategoryContainer = new EOModuleDataContainer_V0();
            workItemLogCategoryContainer.setDataTypeUID("ppm2.workitemcategory");
            workItemLogCategoryContainer.setModuleDataItems(new EOList(newWICategoryLogs));
            moduleDataLogs.add((EncodableObjectBase)workItemLogCategoryContainer);
            success = historicViewOnDumpFile.writeDataFile(project, "cmm_data_log.xml", "cmm", (EncodableObjectBase)moduleDataLogs);
            if (!success) {
                throw new MigrationFailedException("Can't write back migrated ppm data logs.");
            }
            historicViewOnDumpFile.deleteDataDirectory(project, MODULE_ID_PPM1);
        }
        catch (EXDecoderException e) {
            throw new MigrationFailedException((Throwable)e);
        }
    }

    private static Map<String, EOStakeholder_V0> extractStakeholderNames(List<EOStakeholder_V0> stakeholders) {
        HashMap<String, EOStakeholder_V0> map = new HashMap<String, EOStakeholder_V0>(stakeholders.size() * 2);
        for (EOStakeholder_V0 stakeholder : stakeholders) {
            map.put(stakeholder.getStakeholderName(), stakeholder);
        }
        return map;
    }
}

