/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.planimporter.ole.excel.graphreader;

import com.arcway.cockpit.planimporter.exceptions.EXFileImportException;
import com.arcway.cockpit.planimporter.exceptions.EXFileNotFormattedCorrectly;
import com.arcway.lib.eclipse.adapter.excel.ExcelImportExportException;
import com.arcway.lib.eclipse.adapter.excel.imports.ColumnDescription;
import com.arcway.lib.eclipse.adapter.excel.imports.GenericExcelListImporter;
import com.arcway.lib.eclipse.adapter.excel.imports.ImportedSheet;
import com.arcway.lib.eclipse.adapter.excel.imports.ImportedSheetType;
import com.arcway.lib.java.Assert;
import com.arcway.planagent.planimporterexporter.graphs.Graph;
import com.arcway.planagent.planimporterexporter.graphs.Node;
import de.plans.lib.util.gui.IProgressDisplay;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;

public class ExcelGraphReader {
    private static final List<String> EXCEL_COLUMN_ID = Arrays.asList("Type", "Typ", "ID");
    private static final List<String> EXCEL_COLUMN_NAME = Arrays.asList("Name");
    private static final List<String> EXCEL_COLUMN_DESCRIPTION = Arrays.asList("Description", "Beschreibung");
    private final GenericExcelListImporter excelListImporter;
    private final List<ImportedSheet> importedSheets = new ArrayList<ImportedSheet>();
    private File file;
    private IProgressDisplay progressDisplay;
    private int workReported = 0;

    public ExcelGraphReader() {
        this.excelListImporter = new GenericExcelListImporter("Cockpit Plan Importer");
    }

    public static List<String> getSupportedExcelExtensions() {
        return GenericExcelListImporter.getSupportedExcelExtensions();
    }

    public Collection<Graph> getGraphs(File f, IProgressDisplay display, String progressDisplayDescription) throws EXFileImportException, EXFileNotFormattedCorrectly {
        Assert.checkArgumentBeeingNotNull((Object)f);
        Assert.checkArgumentBeeingNotNull((Object)display);
        this.file = f;
        this.progressDisplay = display;
        ArrayList<List<String>> mandatoryColumnNames = new ArrayList<List<String>>();
        mandatoryColumnNames.add(EXCEL_COLUMN_ID);
        mandatoryColumnNames.add(EXCEL_COLUMN_NAME);
        ArrayList<Graph> graphCollection = new ArrayList<Graph>();
        this.readFile();
        Collection<String> sheetNames = this.getSheetNames(mandatoryColumnNames);
        if (sheetNames.size() > 0) {
            this.progressDisplay.beginQuantifiedTask(progressDisplayDescription, sheetNames.size(), false);
        }
        for (String sheetName : sheetNames) {
            List<List<String>> nodeDescriptions = this.getNodeDescriptions(sheetName);
            ArrayList<Node> graphNodes = new ArrayList<Node>();
            int decriptionColNr = -1;
            String column2Title = this.getColumnTitle(sheetName, 2);
            if (column2Title != null) {
                for (String columnName : EXCEL_COLUMN_DESCRIPTION) {
                    if (!columnName.equals(column2Title)) continue;
                    decriptionColNr = 2;
                    break;
                }
            }
            for (List<String> nodeDescription : nodeDescriptions) {
                String description = decriptionColNr != -1 && nodeDescription.size() > decriptionColNr ? nodeDescription.get(decriptionColNr) : "";
                Node node = new Node(nodeDescription.get(1), description, nodeDescription.get(0));
                int i = 2;
                while (i < nodeDescription.size()) {
                    if (i != decriptionColNr) {
                        String attributeName = this.getColumnTitle(sheetName, i);
                        String attributeValue = nodeDescription.get(i);
                        if (attributeName != null) {
                            node.setCustomAttribute(attributeName, attributeValue);
                        }
                    }
                    ++i;
                }
                graphNodes.add(node);
            }
            Graph graph = new Graph(sheetName, null, graphNodes);
            graphCollection.add(graph);
            this.progressDisplay.reportQuantifiedProgress(this.workReported++, sheetName);
        }
        return graphCollection;
    }

    private void readFile() throws EXFileImportException {
        try {
            this.excelListImporter.setExcelFile(this.file.getAbsolutePath(), null, Locale.getDefault(), this.progressDisplay);
        }
        catch (ExcelImportExportException e) {
            throw new EXFileImportException(this.file.getAbsolutePath(), (Throwable)e);
        }
    }

    private Collection<String> getSheetNames(List<List<String>> columnNames) throws EXFileNotFormattedCorrectly {
        ArrayList<String> graphNames = new ArrayList<String>();
        List sheetTypes = this.excelListImporter.getSheetTypes();
        for (ImportedSheetType sheetType : sheetTypes) {
            List columnDescriptions = sheetType.getColumnDescriptions();
            int i = 0;
            for (List<String> column : columnNames) {
                boolean columnNamesEqual;
                if (i < columnDescriptions.size()) {
                    columnNamesEqual = false;
                    for (String columnName : column) {
                        columnNamesEqual |= columnName.equals(((ColumnDescription)columnDescriptions.get(i)).getColumnName());
                    }
                } else {
                    columnNamesEqual = false;
                }
                ++i;
                if (columnNamesEqual) continue;
                throw new EXFileNotFormattedCorrectly(this.file.getAbsolutePath());
            }
            this.importedSheets.addAll(sheetType.getImportedSheets());
        }
        for (ImportedSheet sheet : this.importedSheets) {
            String sheetName = sheet.getSheetName();
            graphNames.add(sheetName);
        }
        return graphNames;
    }

    private List<List<String>> getNodeDescriptions(String sheetName) {
        for (ImportedSheet importedSheet : this.importedSheets) {
            if (!importedSheet.getSheetName().equals(sheetName)) continue;
            return importedSheet.getItems();
        }
        return null;
    }

    private String getColumnTitle(String sheetName, int columnIndex) {
        for (ImportedSheetType sheetType : this.excelListImporter.getSheetTypes()) {
            for (ImportedSheet sheet : sheetType.getImportedSheets()) {
                if (!sheetName.equals(sheet.getSheetName())) continue;
                List columnDescriptions = sheetType.getColumnDescriptions();
                if (columnIndex >= columnDescriptions.size()) {
                    return null;
                }
                ColumnDescription columnDescription = (ColumnDescription)columnDescriptions.get(columnIndex);
                if (columnDescription == null) {
                    return null;
                }
                return columnDescription.getColumnName();
            }
        }
        return null;
    }
}

