/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.modulelib2.client.platformadapter.interFace;

import com.arcway.cockpit.frame.client.project.modules.IModuleDataTypeDescriptionForFrame;
import com.arcway.cockpit.modulelib2.client.messages.IDataTypesHelper;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import com.arcway.cockpit.modulelib2.client.messages.IUIDataTypesHelper;
import com.arcway.cockpit.modulelib2.client.messages.description.IModuleDataTypeDescription;
import com.arcway.cockpit.modulelib2.client.messages.description.ModuleDataTypeDescriptionForFrame;
import com.arcway.cockpit.modulelib2.client.platformadapter.IPropertyDeclarations;
import com.arcway.cockpit.modulelib2.client.platformadapter.ModuleDataTypeSubsetDefinition_NoSubdivision;
import com.arcway.cockpit.modulelib2.client.platformadapter.helper.RepositoryIDCreator;
import com.arcway.cockpit.modulelib2.client.platformadapter.interFace.IModuleDataTypeDescriptionForPlatformAdapter;
import com.arcway.cockpit.modulelib2.client.platformadapter.interFace.IModuleDataTypeSubsetDefinition;
import com.arcway.cockpit.modulelib2.shared.messages.ILinkTypeHelper_Shared;
import com.arcway.frontend.definition.lib.interFace.declaration.label.Icon;
import com.arcway.frontend.definition.lib.interFace.declaration.label.Text;
import com.arcway.lib.ui.editor.specification.sequential.Sequence;
import com.arcway.repository.clientadapter.interFace.ISequenceManager;
import de.plans.lib.resources.IIconResource;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;

public class ModuleDataTypeDescriptionForPlatformAdapter
implements IModuleDataTypeDescriptionForPlatformAdapter {
    private final String typeID;
    private final IModuleDataTypeDescription typeDescription;
    private final Collection<IModuleDataTypeSubsetDefinition> subsetDefinitions;
    private final ISequenceManager specialSequenceManager;
    private final IDataTypesHelper dataTypesHelper;
    private final ILinkTypeHelper_Shared linkTypeHelper;
    private final IUIDataTypesHelper uiDataTypesHelper;

    public ModuleDataTypeDescriptionForPlatformAdapter(String typeID, IDataTypesHelper dataTypesHelper, IUIDataTypesHelper uiDataTypesHelper, ILinkTypeHelper_Shared linkTypeHelper) {
        this.typeID = typeID;
        this.dataTypesHelper = dataTypesHelper;
        this.linkTypeHelper = linkTypeHelper;
        this.uiDataTypesHelper = uiDataTypesHelper;
        this.typeDescription = dataTypesHelper.getTypeDescription(typeID);
        this.subsetDefinitions = Collections.singleton(new ModuleDataTypeSubsetDefinition_NoSubdivision(this.typeDescription, dataTypesHelper));
        this.specialSequenceManager = null;
    }

    public ModuleDataTypeDescriptionForPlatformAdapter(IModuleDataTypeDescription typeDescription, IDataTypesHelper dataTypesHelper, IUIDataTypesHelper uiDataTypesHelper, ILinkTypeHelper_Shared linkTypeHelper) {
        this.typeID = typeDescription.getTypeID();
        this.dataTypesHelper = dataTypesHelper;
        this.uiDataTypesHelper = uiDataTypesHelper;
        this.linkTypeHelper = linkTypeHelper;
        this.typeDescription = typeDescription;
        this.subsetDefinitions = Collections.singleton(new ModuleDataTypeSubsetDefinition_NoSubdivision(typeDescription, dataTypesHelper));
        this.specialSequenceManager = null;
    }

    public ModuleDataTypeDescriptionForPlatformAdapter(String typeID, ISequenceManager specialSequenceManager, IDataTypesHelper dataTypesHelper, IUIDataTypesHelper uiDataTypesHelper, ILinkTypeHelper_Shared linkTypeHelper) {
        this.typeID = typeID;
        this.dataTypesHelper = dataTypesHelper;
        this.uiDataTypesHelper = uiDataTypesHelper;
        this.linkTypeHelper = linkTypeHelper;
        this.typeDescription = dataTypesHelper.getTypeDescription(typeID);
        this.subsetDefinitions = Collections.singleton(new ModuleDataTypeSubsetDefinition_NoSubdivision(this.typeDescription, dataTypesHelper));
        this.specialSequenceManager = specialSequenceManager;
    }

    public ModuleDataTypeDescriptionForPlatformAdapter(String typeID, Collection<IModuleDataTypeSubsetDefinition> subsetDefinitions, IDataTypesHelper dataTypesHelper, IUIDataTypesHelper uiDataTypesHelper, ILinkTypeHelper_Shared linkTypeHelper) {
        assert (subsetDefinitions != null && subsetDefinitions.size() >= 2);
        this.typeID = typeID;
        this.dataTypesHelper = dataTypesHelper;
        this.uiDataTypesHelper = uiDataTypesHelper;
        this.linkTypeHelper = linkTypeHelper;
        this.typeDescription = dataTypesHelper.getTypeDescription(typeID);
        this.subsetDefinitions = subsetDefinitions;
        this.specialSequenceManager = null;
    }

    public ModuleDataTypeDescriptionForPlatformAdapter(String typeID, Collection<IModuleDataTypeSubsetDefinition> subsetDefinitions, ISequenceManager specialSequenceManager, IDataTypesHelper dataTypesHelper, IUIDataTypesHelper uiDataTypesHelper, ILinkTypeHelper_Shared linkTypeHelper) {
        assert (subsetDefinitions != null && subsetDefinitions.size() >= 2);
        this.typeID = typeID;
        this.dataTypesHelper = dataTypesHelper;
        this.uiDataTypesHelper = uiDataTypesHelper;
        this.linkTypeHelper = linkTypeHelper;
        this.typeDescription = dataTypesHelper.getTypeDescription(typeID);
        this.subsetDefinitions = subsetDefinitions;
        this.specialSequenceManager = specialSequenceManager;
    }

    @Override
    public IModuleData createInstance(String objectUID) {
        IModuleData newInstance = this.typeDescription.getNewInstance();
        newInstance.setUid(objectUID);
        return newInstance;
    }

    @Override
    public String getHierarchyLinkTypeForParentType(String parentTypeID) {
        return this.linkTypeHelper.getHierarchyLinkTypeID(parentTypeID, this.typeID);
    }

    @Override
    public boolean isHierarchyType() {
        return this.dataTypesHelper.getDocumentationDataTypes().contains(this.typeID);
    }

    @Override
    public boolean hasSpecialNaturalOrderDataType() {
        return this.typeDescription.getDataTypeForNaturalOrdering() != null && !this.typeID.equals(this.typeDescription.getDataTypeForNaturalOrdering().getCockpitDataTypeID());
    }

    @Override
    public boolean hasSpecialSequenceManager() {
        return this.specialSequenceManager != null;
    }

    @Override
    public ISequenceManager getSpecialSequenceManager() {
        return this.specialSequenceManager;
    }

    @Override
    public boolean hasSubsetDefinitions() {
        return this.subsetDefinitions.size() >= 2;
    }

    @Override
    public Collection<IModuleDataTypeSubsetDefinition> getSubsetDefinitions() {
        return this.subsetDefinitions;
    }

    @Override
    public boolean allSubsetsHaveSameParentTypes() {
        Collection<String> parentTypes = this.subsetDefinitions.iterator().next().getPossibleParentTypeIDs();
        for (IModuleDataTypeSubsetDefinition subsetDefinition : this.subsetDefinitions) {
            if (parentTypes.equals(subsetDefinition.getPossibleParentTypeIDs())) continue;
            return false;
        }
        return true;
    }

    @Override
    public Collection<String> getAttributeIDs() {
        return this.typeDescription.getAttributeIDs();
    }

    @Override
    public String getIDAttribute() {
        return this.typeDescription.getIDAttribute();
    }

    @Override
    public String getNameAttribute() {
        return this.typeDescription.getNameAttribute();
    }

    @Override
    public List<String> getChildrenIDFormatAttributeIDs() {
        return this.typeDescription.getChildrenIDFormatAttributeIDs();
    }

    @Override
    public String getChildCockpitTypeForIDFormatAttribute(String childrenIDFormatAttributeID) {
        return this.typeDescription.getChildCockpitTypeForIDFormatAttribute(childrenIDFormatAttributeID);
    }

    @Override
    public Collection<String> getLinkedModuleDataAttributeIDs() {
        return this.typeDescription.getLinkedModuleDataAttributeIDs();
    }

    @Override
    public boolean isLinkedModuleDataAttribute(String attributeID) {
        return this.typeDescription.isLinkedModuleDataAttribute(attributeID);
    }

    @Override
    public Collection<String> getLinkedFrameDataAttributeIDs() {
        return this.typeDescription.getLinkedFrameDataAttributeIDs();
    }

    @Override
    public boolean isLinkedFrameDataAttribute(String attributeID) {
        return this.typeDescription.isLinkedFrameDataAttribute(attributeID);
    }

    @Override
    public String getLinkTypeIDForLinkedModuleDataAttribute(String attributeID) {
        return this.typeDescription.getLinkTypeIDForLinkedModuleDataAttribute(attributeID);
    }

    @Override
    public String getModuleDataTypeIDForLinkedModuleDataAttribute(String attributeID) {
        return this.typeDescription.getModuleDataTypeIDForLinkedModuleDataAttribute(attributeID);
    }

    @Override
    public String getFrameDataTypeIDForLinkedFrameDataAttribute(String attributeID) {
        return this.typeDescription.getFrameDataTypeIDForLinkedFrameDataAttribute(attributeID);
    }

    @Override
    public String getLinkTypeIDForLinkedFrameDataAttribute(String attributeID) {
        return this.typeDescription.getLinkTypeIDForLinkedFrameDataAttribute(attributeID);
    }

    @Override
    public Collection<String> getSimpleAttributeIDs() {
        return this.typeDescription.getSimpleAttributeIDs();
    }

    @Override
    public boolean isSimpleAttribute(String attributeID) {
        return this.typeDescription.isSimpleAttribute(attributeID);
    }

    @Override
    public Collection<String> getCalculatedAttributeIDs() {
        return this.typeDescription.getCalculatedAttributeIDs();
    }

    @Override
    public boolean isCalculatedAttribute(String attributeID) {
        return this.typeDescription.isCalculatedAttribute(attributeID);
    }

    @Override
    public Collection<String> getPersistentAttributeIDs() {
        return this.typeDescription.getPersistentAttributeIDs();
    }

    @Override
    public String getAttributeName(String attributeID) {
        return this.typeDescription.getAttributeName(attributeID);
    }

    @Override
    public String getAttributeName(String attributeID, Locale locale) {
        return this.typeDescription.getAttributeName(attributeID, locale);
    }

    @Override
    public boolean isMandatoryAttribute(String attributeID) {
        return this.typeDescription.isMandatoryAttribute(attributeID);
    }

    @Override
    public String getTypeID() {
        return this.typeDescription.getTypeID();
    }

    @Override
    public IIconResource getTypeIcon() {
        return this.typeDescription.getTypeIcon();
    }

    @Override
    public String getTypeName(Locale locale) {
        return this.typeDescription.getTypeName(locale);
    }

    @Override
    public Collection<String> getStatuses() {
        return this.typeDescription.getStatuses();
    }

    @Override
    public Icon getStatusDependantIconSpecification(IPropertyDeclarations propertyDeclarations) {
        return this.typeDescription.getStatusDependantIconSpecification(propertyDeclarations);
    }

    @Override
    public Text getStatusDependantLabelSpecification(RepositoryIDCreator repositoryIDCreator) {
        return this.typeDescription.getStatusDependantLabelSpecification(repositoryIDCreator);
    }

    @Override
    @Deprecated
    public IModuleData getNewInstance() {
        return this.typeDescription.getNewInstance();
    }

    @Override
    @Deprecated
    public IModuleData getDummyInstance() {
        return this.typeDescription.getDummyInstance();
    }

    @Override
    public ModuleDataTypeDescriptionForFrame getModuleDataTypeDescriptionForFrame() {
        return this.typeDescription.getModuleDataTypeDescriptionForFrame();
    }

    @Override
    public String getDefaultIDPrefix(Locale locale) {
        return this.typeDescription.getDefaultIDPrefix(locale);
    }

    @Override
    @Deprecated
    public IModuleDataTypeDescriptionForFrame getDataTypeForNaturalOrdering() {
        return this.typeDescription.getDataTypeForNaturalOrdering();
    }

    @Override
    @Deprecated
    public Comparator<? extends IModuleData> getNaturalOrderComparator() {
        return this.typeDescription.getNaturalOrderComparator();
    }

    @Override
    @Deprecated
    public int getNaturalOrderPriority() {
        return this.typeDescription.getNaturalOrderPriority();
    }

    @Override
    @Deprecated
    public boolean isNaturalOrderUserDetermined() {
        return this.typeDescription.isNaturalOrderUserDetermined();
    }

    @Override
    public boolean isSupportingCategories() {
        return this.typeDescription.isSupportingCategories();
    }

    @Override
    public boolean isCreatableGenerically() {
        return this.typeDescription.isCreatableGenerically();
    }

    @Override
    public boolean isModifiableGenerically() {
        return this.typeDescription.isModifiableGenerically();
    }

    @Override
    public boolean isDeletableGenerically() {
        return this.typeDescription.isDeletableGenerically();
    }

    @Override
    public File getEditorLayoutSpecificationFile() {
        return this.uiDataTypesHelper.getEditorLayoutSpecificationFile(this.typeDescription.getTypeID());
    }

    @Override
    public Sequence getSequentialLayoutSpecification(Locale contentLocale) {
        return this.uiDataTypesHelper.getSequentialLayoutSpecification(this.typeDescription.getTypeID(), contentLocale);
    }

    @Override
    public String getHistoryRecordMode() {
        return this.typeDescription.getHistoryRecordMode();
    }
}

