/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.modulelib2.client.messages.description;

import com.arcway.cockpit.modulelib2.client.Messages;
import com.arcway.cockpit.modulelib2.client.ModuleLabelProvider;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import com.arcway.cockpit.modulelib2.client.messages.description.IModuleDataTypeDescription;
import com.arcway.cockpit.modulelib2.client.platformadapter.IPropertyDeclarations;
import com.arcway.cockpit.modulelib2.client.platformadapter.helper.RepositoryIDCreator;
import com.arcway.frontend.definition.lib.interFace.declaration.label.Icon;
import com.arcway.frontend.definition.lib.interFace.declaration.label.IconObjectType;
import com.arcway.frontend.definition.lib.interFace.declaration.label.Text;
import com.arcway.frontend.definition.lib.interFace.declaration.label.TextObjectTypeName;
import de.plans.lib.localisation.ILabelProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public abstract class AbstractModuleDataTypeDescription
implements IModuleDataTypeDescription {
    private static final Map<String, IModuleData> map_typeID_dummyInstance = new HashMap<String, IModuleData>();
    private final Set<String> SIMPLE_ATTRIBUTES = new HashSet<String>();
    private final Set<String> LINKEDMODULEDATA_ATTRIBUTES = new HashSet<String>();
    private final Set<String> LINKEDFRAMEDATA_ATTRIBUTES = new HashSet<String>();
    private final Set<String> CALCULATED_ATTRIBUTES = new HashSet<String>();
    private final Set<String> MANDATORY_ATTRIBUTES = new HashSet<String>();
    private final Map<String, ILabelProvider> MAP_ATTRIBUTEID_LABELPROVIDER = new HashMap<String, ILabelProvider>();
    private final Map<String, String> MAP_LINKEDMODULEDATAATTRIBUTEID_LINKTYPEID = new HashMap<String, String>();
    private final Map<String, String> MAP_LINKEDMODULEDATAATTRIBUTEID_MODULEDATATYPEID = new HashMap<String, String>();
    private final Map<String, String> MAP_LINKEDFRAMEDATAATTRIBUTEID_LINKTYPEID = new HashMap<String, String>();
    private final Map<String, String> MAP_LINKEDFRAMEDATAATTRIBUTEID_FRAMEDATATYPEID = new HashMap<String, String>();

    public AbstractModuleDataTypeDescription() {
        this.addSimpleAttribute("abstractmoduledata_creationDate", new ModuleLabelProvider("AbstractModuleData.CDATE_NAME", Messages.class), true);
        this.addSimpleAttribute("abstractmoduledata_creator", new ModuleLabelProvider("AbstractModuleData.CREATOR_NAME", Messages.class), true);
        this.addSimpleAttribute("abstractmoduledata_modificationDate", new ModuleLabelProvider("AbstractModuleData.MDATE_NAME", Messages.class), true);
        this.addSimpleAttribute("abstractmoduledata_modifier", new ModuleLabelProvider("AbstractModuleData.MODIFIER_NAME", Messages.class), true);
    }

    @Override
    public final Collection<String> getAttributeIDs() {
        Collection<String> allAttributes = this.getPersistentAttributeIDs();
        allAttributes.addAll(this.CALCULATED_ATTRIBUTES);
        return allAttributes;
    }

    @Override
    public final Collection<String> getSimpleAttributeIDs() {
        return new ArrayList<String>(this.SIMPLE_ATTRIBUTES);
    }

    @Override
    public boolean isSimpleAttribute(String attributeID) {
        return this.SIMPLE_ATTRIBUTES.contains(attributeID);
    }

    @Override
    public final Collection<String> getLinkedModuleDataAttributeIDs() {
        return new ArrayList<String>(this.LINKEDMODULEDATA_ATTRIBUTES);
    }

    @Override
    public boolean isLinkedModuleDataAttribute(String attributeID) {
        return this.LINKEDMODULEDATA_ATTRIBUTES.contains(attributeID);
    }

    @Override
    public final Collection<String> getLinkedFrameDataAttributeIDs() {
        return new ArrayList<String>(this.LINKEDFRAMEDATA_ATTRIBUTES);
    }

    @Override
    public boolean isLinkedFrameDataAttribute(String attributeID) {
        return this.LINKEDFRAMEDATA_ATTRIBUTES.contains(attributeID);
    }

    @Override
    public final Collection<String> getCalculatedAttributeIDs() {
        return new ArrayList<String>(this.CALCULATED_ATTRIBUTES);
    }

    @Override
    public boolean isCalculatedAttribute(String attributeID) {
        return this.CALCULATED_ATTRIBUTES.contains(attributeID);
    }

    @Override
    public final Collection<String> getPersistentAttributeIDs() {
        HashSet<String> persistentAttributes = new HashSet<String>();
        persistentAttributes.addAll(this.SIMPLE_ATTRIBUTES);
        persistentAttributes.addAll(this.LINKEDMODULEDATA_ATTRIBUTES);
        persistentAttributes.addAll(this.LINKEDFRAMEDATA_ATTRIBUTES);
        return persistentAttributes;
    }

    @Override
    public final String getLinkTypeIDForLinkedModuleDataAttribute(String attributeID) {
        return this.MAP_LINKEDMODULEDATAATTRIBUTEID_LINKTYPEID.get(attributeID);
    }

    @Override
    public final String getModuleDataTypeIDForLinkedModuleDataAttribute(String attributeID) {
        return this.MAP_LINKEDMODULEDATAATTRIBUTEID_MODULEDATATYPEID.get(attributeID);
    }

    @Override
    public final String getLinkTypeIDForLinkedFrameDataAttribute(String attributeID) {
        return this.MAP_LINKEDFRAMEDATAATTRIBUTEID_LINKTYPEID.get(attributeID);
    }

    @Override
    public final String getFrameDataTypeIDForLinkedFrameDataAttribute(String attributeID) {
        return this.MAP_LINKEDFRAMEDATAATTRIBUTEID_FRAMEDATATYPEID.get(attributeID);
    }

    @Override
    public final String getAttributeName(String attributeID) {
        return this.getAttributeName(attributeID, Locale.getDefault());
    }

    @Override
    public final String getAttributeName(String attributeID, Locale locale) {
        ILabelProvider labelProvider = this.MAP_ATTRIBUTEID_LABELPROVIDER.get(attributeID);
        return labelProvider.getLabel(locale);
    }

    @Override
    public final boolean isMandatoryAttribute(String attributeID) {
        return this.MANDATORY_ATTRIBUTES.contains(attributeID);
    }

    protected final void addSimpleAttribute(String id, ILabelProvider labelProvider) {
        this.addSimpleAttribute(id, labelProvider, false);
    }

    protected final void addSimpleAttribute(String id, ILabelProvider labelProvider, boolean mandatory) {
        this.SIMPLE_ATTRIBUTES.add(id);
        this.MAP_ATTRIBUTEID_LABELPROVIDER.put(id, labelProvider);
        if (mandatory) {
            this.MANDATORY_ATTRIBUTES.add(id);
        }
    }

    protected final void addLinkedModuleDataAttribute(String id, ILabelProvider labelProvider, String linkTypeID, String dataTypeID) {
        this.addLinkedModuleDataAttribute(id, labelProvider, linkTypeID, dataTypeID, false);
    }

    protected final void addCalculatedAttribute(String id, ILabelProvider labelProvider) {
        this.CALCULATED_ATTRIBUTES.add(id);
        this.MAP_ATTRIBUTEID_LABELPROVIDER.put(id, labelProvider);
    }

    protected final void addLinkedModuleDataAttribute(String id, ILabelProvider labelProvider, String linkTypeID, String dataTypeID, boolean mandatory) {
        this.LINKEDMODULEDATA_ATTRIBUTES.add(id);
        this.MAP_ATTRIBUTEID_LABELPROVIDER.put(id, labelProvider);
        this.MAP_LINKEDMODULEDATAATTRIBUTEID_LINKTYPEID.put(id, linkTypeID);
        this.MAP_LINKEDMODULEDATAATTRIBUTEID_MODULEDATATYPEID.put(id, dataTypeID);
        if (mandatory) {
            this.MANDATORY_ATTRIBUTES.add(id);
        }
    }

    protected final void addLinkedFrameDataAttribute(String id, ILabelProvider labelProvider, String linkTypeID, String frameDataTypeID) {
        this.LINKEDFRAMEDATA_ATTRIBUTES.add(id);
        this.MAP_ATTRIBUTEID_LABELPROVIDER.put(id, labelProvider);
        this.MAP_LINKEDFRAMEDATAATTRIBUTEID_LINKTYPEID.put(id, linkTypeID);
        this.MAP_LINKEDFRAMEDATAATTRIBUTEID_FRAMEDATATYPEID.put(id, frameDataTypeID);
    }

    @Override
    public String getDefaultIDPrefix(Locale locale) {
        return null;
    }

    @Override
    public List<String> getChildrenIDFormatAttributeIDs() {
        return Collections.emptyList();
    }

    @Override
    public String getChildCockpitTypeForIDFormatAttribute(String childrenIDFormatAttributeID) {
        return null;
    }

    @Override
    public Collection<String> getStatuses() {
        return Collections.singleton("MD_STATUS_DEFAULT");
    }

    @Override
    public Icon getStatusDependantIconSpecification(IPropertyDeclarations propertyDeclarations) {
        return new IconObjectType();
    }

    @Override
    public Text getStatusDependantLabelSpecification(RepositoryIDCreator repositoryIDCreator) {
        return new TextObjectTypeName();
    }

    @Override
    public boolean isNaturalOrderUserDetermined() {
        return true;
    }

    @Override
    public int getNaturalOrderPriority() {
        return 0;
    }

    @Override
    public Comparator<? extends IModuleData> getNaturalOrderComparator() {
        return null;
    }

    @Override
    public boolean isSupportingCategories() {
        return true;
    }

    @Override
    public String getHistoryRecordMode() {
        return "off";
    }

    @Override
    public IModuleData getDummyInstance() {
        String typeID = this.getTypeID();
        IModuleData dummyInstance = map_typeID_dummyInstance.get(typeID);
        if (dummyInstance == null && !map_typeID_dummyInstance.containsKey(typeID)) {
            dummyInstance = this.getNewInstance();
            map_typeID_dummyInstance.put(typeID, dummyInstance);
        }
        return dummyInstance;
    }
}

