/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.modulelib2.client.messages.attributes;

import com.arcway.cockpit.modulelib2.client.messages.attributes.IModuleDataAttribute;
import com.arcway.cockpit.modulelib2.client.messages.attributes.IModuleDataAttributeText;
import com.arcway.lib.java.SetterSuccess;
import de.plans.lib.util.valueranges.ILong;
import de.plans.lib.util.valueranges.IValueRangeHelperText;
import de.plans.lib.util.valueranges.ValueRangeHelperDuration;
import java.util.Locale;

public class ModuleDataAttributeDuration
implements IModuleDataAttributeText,
ILong {
    private long durationInMilliSecs;
    private final ValueRangeHelperDuration valueRangeHelper;

    public ModuleDataAttributeDuration() {
        this(0L, 0L);
    }

    public ModuleDataAttributeDuration(long duration) {
        this(0L, duration >= 0L ? duration : 0L);
    }

    public ModuleDataAttributeDuration(ModuleDataAttributeDuration duration) {
        this(duration.getValue());
    }

    private ModuleDataAttributeDuration(long start, long end) {
        this.durationInMilliSecs = start <= end ? end - start : 0L;
        this.valueRangeHelper = new ValueRangeHelperDuration(3, (ILong)this);
    }

    @Override
    public String getDisplayStringRepresentation() {
        return this.getDisplayRepresentationWithUnit();
    }

    @Override
    public String getDisplayStringRepresentation(Locale locale) {
        return this.getDisplayStringRepresentation();
    }

    public String getDisplayRepresentationWithUnit() {
        return this.valueRangeHelper.getDisplayFormatWithUnit();
    }

    public String getDisplayStringRepresentationWithoutUnit() {
        return this.valueRangeHelper.getDisplayFormat();
    }

    @Override
    public SetterSuccess setValueViaDisplayStringRepresentation(String displayRepresentation) {
        return this.valueRangeHelper.setPersistentValue(displayRepresentation);
    }

    @Override
    public String getUniqueStringRepresentation() {
        return String.valueOf(this.durationInMilliSecs);
    }

    @Override
    public boolean setValueViaUniqueStringRepresentation(String uniqueStringRepresentation) {
        long oldValue = this.durationInMilliSecs;
        try {
            this.durationInMilliSecs = Long.parseLong(uniqueStringRepresentation);
        }
        catch (NumberFormatException e) {
            this.durationInMilliSecs = 0L;
        }
        return oldValue != this.durationInMilliSecs;
    }

    @Override
    public IModuleDataAttribute copy() {
        ModuleDataAttributeDuration copiedItem = new ModuleDataAttributeDuration(this.durationInMilliSecs);
        copiedItem.setUnit(this.getUnit());
        copiedItem.setHoursPerDay(this.getHoursPerDay());
        return copiedItem;
    }

    public Long getValue() {
        return new Long(this.durationInMilliSecs);
    }

    public void setValue(Long newValue) {
        this.durationInMilliSecs = newValue != null ? newValue : 0L;
    }

    public void setValue(long newValue) {
        this.setValue(new Long(newValue));
    }

    public int getUnit() {
        return this.valueRangeHelper.getUnit();
    }

    public void setUnit(int unit) {
        this.valueRangeHelper.setUnit(unit);
    }

    public void setHoursPerDay(int hoursPerDay) {
        this.valueRangeHelper.setConversionFactors(0, 0, hoursPerDay);
    }

    public int getHoursPerDay() {
        return this.valueRangeHelper.getHoursPerDay();
    }

    public ModuleDataAttributeDuration addDuration(ModuleDataAttributeDuration durationToAdd) {
        ModuleDataAttributeDuration newDuration = new ModuleDataAttributeDuration(this.getValue() + durationToAdd.getValue());
        newDuration.setUnit(this.getUnit());
        return newDuration;
    }

    public ModuleDataAttributeDuration subtractDuration(ModuleDataAttributeDuration durationToSubtract) {
        ModuleDataAttributeDuration newDuration = new ModuleDataAttributeDuration(Math.max(this.getValue() - durationToSubtract.getValue(), 0L));
        newDuration.setUnit(this.getUnit());
        return newDuration;
    }

    public boolean isShorterThan(ModuleDataAttributeDuration durationToCompare) {
        return this.getValue() - durationToCompare.getValue() < 0L;
    }

    public boolean isLongerThan(ModuleDataAttributeDuration durationToCompare) {
        return this.getValue() - durationToCompare.getValue() > 0L;
    }

    @Override
    public IValueRangeHelperText getValueRangeHelper() {
        return new ValueRangeHelperDuration(this.valueRangeHelper.getUnit(), (ILong)this);
    }
}

