/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.modulelib2.client.gui.editor.specification.structure;

import com.arcway.cockpit.modulelib2.client.gui.editor.specification.AbstractEditorSpecificationPart;
import com.arcway.cockpit.modulelib2.client.gui.editor.specification.IEditorSpecificationPart;
import com.arcway.cockpit.modulelib2.client.gui.editor.specification.structure.EditorParameters;
import com.arcway.cockpit.modulelib2.client.gui.editor.specification.structure.Page;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Editor
extends AbstractEditorSpecificationPart {
    private final Map<String, Page> pageMap = new HashMap<String, Page>();
    private final EditorParameters editorParameters;
    private final String objectTypeID;
    private final String editorTypeID;

    public Editor(List<Page> pageList, EditorParameters editorParameters, String objectTypeID, String editorTypeID) {
        int pageListCounter = 1;
        for (Page part : pageList) {
            part.setIndex(pageListCounter);
            String partID = part.getID();
            this.pageMap.put(partID, part);
            ++pageListCounter;
        }
        this.editorParameters = editorParameters;
        this.objectTypeID = objectTypeID;
        this.editorTypeID = editorTypeID;
    }

    public List<Page> getPageList() {
        ArrayList<Page> list = new ArrayList<Page>(this.pageMap.values());
        Editor.sortSpecificationPartList(list);
        return list;
    }

    public Page getPage(String id) {
        return this.pageMap.get(id);
    }

    public Page getPage(int index) {
        return this.getPageList().get(index);
    }

    public EditorParameters getEditorParameters() {
        return this.editorParameters;
    }

    public String getObjectTypeID() {
        return this.objectTypeID;
    }

    public String getEditorTypeID() {
        return this.editorTypeID;
    }

    @Override
    public String getID() {
        return this.objectTypeID;
    }

    public List<IEditorSpecificationPart> getChildren() {
        ArrayList<IEditorSpecificationPart> children = new ArrayList<IEditorSpecificationPart>();
        children.addAll(this.pageMap.values());
        children.add(this.editorParameters);
        return children;
    }

    @Override
    public String getTypeID() {
        return "Editor";
    }
}

