/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.modulelib2.client.gui.dnd;

import com.arcway.cockpit.frame.client.global.license.IClientFunctionLicenseType2;
import com.arcway.cockpit.frame.client.lib.dataviews.dnd.DragSource;
import com.arcway.cockpit.frame.client.lib.dataviews.dnd.DropTarget;
import com.arcway.cockpit.frame.client.lib.dataviews.util.IActiveProjectProvider;
import com.arcway.cockpit.frame.client.lib.dataviews.util.IModuleProjectSwitchListener;
import com.arcway.cockpit.frame.client.lib.dataviews.util.IProjectAgentProvider;
import com.arcway.cockpit.modulelib2.client.Messages;
import com.arcway.cockpit.modulelib2.client.core.IModelControllerProvider;
import com.arcway.cockpit.modulelib2.client.core.project.IModelController;
import com.arcway.cockpit.modulelib2.client.gui.AbstractCopyManager;
import com.arcway.cockpit.modulelib2.client.gui.dnd.AbstractMoveDragNDropSupport;
import com.arcway.cockpit.modulelib2.client.gui.dnd.ICopyDragNDropExecuter;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import com.arcway.cockpit.modulelib2.client.messages.transfer.CopiedModuleDataTransferAgent;
import com.arcway.lib.UUIDGenerator;
import com.arcway.lib.eclipse.transfer.dnd.DropTargetParameters;
import com.arcway.lib.eclipse.transfer.dnd.IDragHandler;
import com.arcway.lib.eclipse.transfer.dnd.IDropHandler;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public abstract class AbstractCopyDragNDropSupport
implements ICopyDragNDropExecuter,
IModuleProjectSwitchListener,
IActiveProjectProvider {
    private static final ILogger logger = Logger.getLogger(AbstractMoveDragNDropSupport.class);
    private static final String TRANSFER_TYPE_BASE = "DnD-Copy_";
    private final String transferType;
    private final Transfer transfer;
    protected IModelController modelController;
    private final AbstractCopyManager copyManager;
    private static ModuleDataCopyTransferContent transferData = null;

    public AbstractCopyDragNDropSupport(IModelController modelController, AbstractCopyManager copyManager, String copyDnDSupportTypeID) {
        this.modelController = modelController;
        this.copyManager = copyManager;
        this.transferType = TRANSFER_TYPE_BASE + copyDnDSupportTypeID;
        this.transfer = CopiedModuleDataTransferAgent.getInstance(this.transferType);
    }

    public DragSource getDragSource() {
        return new DragSource(this.getDragOperations(), this.getTransfers(), this.getDragHandler(), this.getRequiredLicenseType(), this.getProjectManager(), (IActiveProjectProvider)this);
    }

    public DropTarget getDropTarget() {
        return new DropTarget(this.getDropOperations(), this.getTransfers(), this.getDropHandler(), this.getRequiredLicenseType(), this.getProjectManager(), (IActiveProjectProvider)this);
    }

    private int getDragOperations() {
        return 1;
    }

    private int getDropOperations() {
        return 1;
    }

    private Set<Transfer> getTransfers() {
        return Collections.singleton(this.transfer);
    }

    private IDragHandler getDragHandler() {
        IDragHandler dragHandler = new IDragHandler(){

            public boolean isDragPossible(DragSourceEvent event, ISelectionProvider selectionProvider) {
                transferData = null;
                ISelection selection = selectionProvider.getSelection();
                if (!(selection instanceof IStructuredSelection)) {
                    return false;
                }
                List selectedItems = ((IStructuredSelection)selection).toList();
                String virtualParentDataType = AbstractCopyDragNDropSupport.this.checkSourceData(selectedItems);
                if (virtualParentDataType == null) {
                    return false;
                }
                transferData = new ModuleDataCopyTransferContent(selectedItems, virtualParentDataType, AbstractCopyDragNDropSupport.this.modelController.getProjectUID());
                return true;
            }

            public Object getDragData(DragSourceEvent event, ISelectionProvider selectionProvider) {
                if (transferData != null) {
                    return AbstractCopyDragNDropSupport.this.copyManager.getCopy(transferData.moduleData, AbstractCopyDragNDropSupport.this.modelController);
                }
                logger.error("Copy drag handler was asked for drag data though it had indicated that dragging is not possible.");
                return AbstractCopyDragNDropSupport.this.copyManager.getCopy(Collections.emptySet(), AbstractCopyDragNDropSupport.this.modelController);
            }

            public void finishDrag(DragSourceEvent event, ISelectionProvider selectionProvider) {
                transferData = null;
            }
        };
        return dragHandler;
    }

    private IDropHandler getDropHandler() {
        IDropHandler dropHandler = new IDropHandler(){

            public boolean isDropPossible(DropTargetEvent event, int location, Control targetControl, DropTargetParameters parametersToChoose) {
                if (event.item == null || event.item.getData() != null && event.item.getData() instanceof IModuleData) {
                    TransferData dataType = AbstractCopyDragNDropSupport.this.extractRequiredDatatype(event.dataTypes);
                    if (dataType == null) {
                        return false;
                    }
                    parametersToChoose.requestedTransferType = dataType;
                    int operation = AbstractCopyDragNDropSupport.this.extractRequiredOperation(event.detail);
                    if (operation == 0) {
                        return false;
                    }
                    parametersToChoose.requestedOperation = operation;
                    if (location != 3 && (location != 4 || event.item != null)) {
                        return false;
                    }
                    if (transferData != null && transferData.projectUID != null && transferData.projectUID.equals(AbstractCopyDragNDropSupport.this.modelController.getProjectUID())) {
                        IModuleData targetData = null;
                        if (event.item != null) {
                            targetData = (IModuleData)event.item.getData();
                        }
                        if (!AbstractCopyDragNDropSupport.this.checkTarget(transferData.moduleData, targetData, transferData.virtualParentDataType)) {
                            return false;
                        }
                    }
                    parametersToChoose.requestedFeedbackTypes = 25;
                    return true;
                }
                return false;
            }

            public boolean performDrop(DropTargetEvent event, int location, Control targetControl) {
                Object transferContentObject = event.data;
                if (transferContentObject != null) {
                    String virtualParentDataType;
                    Collection<IModuleData> itemsToCopy;
                    IModuleData target;
                    IModuleData iModuleData = target = event.item != null ? (IModuleData)event.item.getData() : null;
                    if ((transferData == null || transferData.projectUID == null || transferData.projectUID.equals(AbstractCopyDragNDropSupport.this.modelController.getProjectUID())) && !AbstractCopyDragNDropSupport.this.checkTarget(itemsToCopy = AbstractCopyDragNDropSupport.this.copyManager.getRootItemsOfCopy(transferContentObject), target, virtualParentDataType = AbstractCopyDragNDropSupport.this.copyManager.getVirtualParentDataType(transferContentObject))) {
                        return false;
                    }
                    Collection result = AbstractCopyDragNDropSupport.this.doCopy(transferContentObject, target, targetControl.getShell());
                    return !result.isEmpty();
                }
                return false;
            }
        };
        return dropHandler;
    }

    private int extractRequiredOperation(int requestedOperation) {
        if (requestedOperation == 16) {
            return 0;
        }
        if ((requestedOperation & 1) != 0) {
            return 1;
        }
        return 0;
    }

    private TransferData extractRequiredDatatype(TransferData[] dataTypes) {
        TransferData[] transferDataArray = dataTypes;
        int n = dataTypes.length;
        int n2 = 0;
        while (n2 < n) {
            TransferData dataType = transferDataArray[n2];
            if (this.transfer.isSupportedType(dataType)) {
                return dataType;
            }
            ++n2;
        }
        return null;
    }

    private String checkSourceData(Collection sourceData) {
        for (Object sourceItem : sourceData) {
            if (!(sourceItem instanceof IModuleData)) {
                return null;
            }
            IModuleData moduleData = (IModuleData)sourceItem;
            if (this.isCopyable(moduleData)) continue;
            return null;
        }
        String virtualParentDataType = this.copyManager.getVirtualParentDataType(sourceData);
        return virtualParentDataType;
    }

    private boolean checkTarget(Collection sourceData, IModuleData target, String virtualParentDataType) {
        String parentTypeID = target != null ? target.getTypeID() : "hierarchyroot";
        if (!this.copyManager.isValidParentType(parentTypeID, virtualParentDataType)) {
            return false;
        }
        return this.isCopyPossible(sourceData, target, false);
    }

    @Override
    public Collection doCopy(Collection sourceItems, IModuleData target, Shell shell) {
        return this.doCopy(this.copyManager.getCopy(sourceItems, this.modelController), target, shell);
    }

    private Collection doCopy(Object copiedData, IModuleData target, Shell shell) {
        if (!this.getDragSource().licenseAvailable()) {
            MessageDialog.openWarning((Shell)shell, (String)Messages.getString("CopyPaste.NoLicense.Title"), (String)Messages.getString("CopyPaste.NoLicense.Message"));
            return Collections.EMPTY_LIST;
        }
        if (!this.getDropTarget().licenseAvailable()) {
            MessageDialog.openWarning((Shell)shell, (String)Messages.getString("CopyPaste.NoLicense.Title"), (String)Messages.getString("CopyPaste.NoLicense.Message"));
            return Collections.EMPTY_LIST;
        }
        String virtualParentTypeOfItemsToCopy = this.copyManager.getVirtualParentDataType(copiedData);
        if (!this.copyManager.doCheckPermissions(virtualParentTypeOfItemsToCopy, target, this.modelController, shell) || !this.copyManager.doAcquireLocks(target, this.modelController, shell, null)) {
            return Collections.EMPTY_LIST;
        }
        Collection<IModuleData> copies = this.copyManager.paste(copiedData, target, this.modelController, shell);
        if (copies == null) {
            MessageDialog.openWarning((Shell)shell, (String)Messages.getString("CopyPaste.CopyNotPossible.Title"), (String)Messages.getString("CopyPaste.CopyNotPossible.Message"));
            return Collections.EMPTY_LIST;
        }
        return copies;
    }

    @Override
    public boolean isCopyPossible(Collection items, IModuleData newParent, boolean checkParentDataType) {
        String virtualParentDataType;
        if (!this.getDragSource().licenseAvailable()) {
            return false;
        }
        if (!this.getDropTarget().licenseAvailable()) {
            return false;
        }
        if (checkParentDataType && ((virtualParentDataType = this.checkSourceData(items)) == null || newParent != null && !this.copyManager.isValidParentType(newParent.getTypeID(), virtualParentDataType) || newParent == null && !this.copyManager.isValidParentType("hierarchyroot", virtualParentDataType))) {
            return false;
        }
        for (Object item : items) {
            if (!(item instanceof IModuleData)) {
                return false;
            }
            if (this.isCopyable((IModuleData)item, newParent)) continue;
            return false;
        }
        return true;
    }

    protected abstract String getHierarchyLinkType(String var1, String var2);

    protected boolean isCopyable(IModuleData item) {
        assert (item != null);
        return true;
    }

    protected boolean isCopyable(IModuleData item, IModuleData newParent) {
        assert (item != null);
        assert (newParent == null || newParent.getProjectUID() != null);
        return true;
    }

    protected abstract IProjectAgentProvider getProjectManager();

    protected abstract IModelControllerProvider getModelControllerProvider();

    protected IClientFunctionLicenseType2 getRequiredLicenseType() {
        return null;
    }

    public void projectSwitched(String projectUID) {
        this.modelController = this.getModelControllerProvider().getModelController(projectUID);
    }

    public String getActiveProject() {
        return this.modelController != null ? this.modelController.getProjectUID() : null;
    }

    private class ModuleDataCopyTransferContent {
        public String uid;
        public String projectUID;
        public Collection moduleData;
        public String virtualParentDataType;

        public ModuleDataCopyTransferContent(Collection data, String virtualParentDataType, String projectUID) {
            this.moduleData = data;
            this.virtualParentDataType = virtualParentDataType;
            this.projectUID = projectUID;
            this.uid = UUIDGenerator.getUniqueID();
        }
    }
}

