/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.modulelib2.client.gui.compare;

import com.arcway.cockpit.modulelib2.client.core.project.IModelController;
import com.arcway.cockpit.modulelib2.client.gui.dataview.jfaceviewer.tree.standard.StandardTreeDataViewSorter;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.compare.IModificationDate;
import org.eclipse.compare.IStreamContentAccessor;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.structuremergeviewer.IStructureComparator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.swt.graphics.Image;

public class ModuleDataRevision
implements ITypedElement,
IModificationDate,
IStreamContentAccessor,
IStructureComparator {
    private static final String CONTENTTYPE_ID_MODULEDATA = "com.arcway.cockpit.moduledata";
    private final IModuleData itemRevision;
    private final IModelController modelController;

    public ModuleDataRevision(IModuleData itemRevision, IModelController modelController) {
        this.modelController = modelController;
        this.itemRevision = itemRevision;
    }

    public Image getImage() {
        return this.itemRevision.getTypeDescription().getTypeIcon().getImage();
    }

    public String getName() {
        return this.itemRevision.getDisplayRepresentation(this.modelController.getProjectLanguage());
    }

    public String getType() {
        return CONTENTTYPE_ID_MODULEDATA;
    }

    public long getModificationDate() {
        return this.itemRevision.getModificationTime().getValue();
    }

    public byte[] getContent() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.itemRevision.getProjectUID());
        buffer.append("\n");
        buffer.append(this.itemRevision.getUID());
        buffer.append("\n");
        buffer.append(Integer.toString(this.itemRevision.getModificationCount()));
        buffer.append("\n");
        buffer.append(this.itemRevision.getModificationTime().getValue());
        return buffer.toString().getBytes();
    }

    public InputStream getContents() throws CoreException {
        return new ByteArrayInputStream(this.getContent());
    }

    public Object[] getChildren() {
        if (this.itemRevision.getTypeDescription().getHistoryRecordMode().equals("complete")) {
            Collection<IModuleData> children = this.modelController.getChildren(this.itemRevision);
            ArrayList<ModuleDataRevision> childRevisions = new ArrayList<ModuleDataRevision>(children.size());
            for (IModuleData child : children) {
                childRevisions.add(new ModuleDataRevision(child, this.modelController));
            }
            Object[] childRevisionsArray = childRevisions.toArray();
            StandardTreeDataViewSorter.getSorterForNaturalOrder(this.modelController).sort(null, childRevisionsArray);
            return childRevisionsArray;
        }
        return new Object[0];
    }

    public IModuleData getRevisionItem() {
        return this.itemRevision;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ModuleDataRevision) {
            return this.itemRevision.equals(((ModuleDataRevision)obj).itemRevision);
        }
        return false;
    }

    public int hashCode() {
        return this.itemRevision.hashCode();
    }
}

