/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.modulelib2.client.gui.compare;

import com.arcway.cockpit.client.base.interfaces.frame.gui.DetailsElement;
import com.arcway.cockpit.frame.client.global.ExtensionMgr;
import com.arcway.cockpit.frame.client.global.gui.views.details.DetailsViewResources;
import com.arcway.cockpit.frame.client.global.gui.views.details.provider.IDetailsProvider;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.cockpit.modulelib2.client.Messages;
import com.arcway.cockpit.modulelib2.client.gui.compare.ModuleDataRevision;
import com.arcway.cockpit.modulelib2.client.gui.compare.patch.ContentMergeViewer;
import com.arcway.cockpit.modulelib2.client.gui.detailsviewprovider.ModuleDetailsProvider;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import com.arcway.lib.java.locale.resourcebundles.ArcwayStandardResourceBundleLoader;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;

public class ModuleDataCompareViewer
extends ContentMergeViewer {
    private static final String BUNDLE_NAME = "com.arcway.cockpit.modulelib2.client.gui.compare.ModuleDataMergeViewerResources";
    private IWorkbenchPartSite site;
    private Composite baseComposite;
    private final Composite[] compareComposites = new Composite[2];
    private final ModuleDetailsProvider[] compareDetailsProviders = new ModuleDetailsProvider[2];
    private final Control[] compareControls = new Control[2];
    private final ModuleDataRevision[] compareContents = new ModuleDataRevision[2];
    private DetailsViewResources resources;

    public ModuleDataCompareViewer(Composite parent, int styles, CompareConfiguration mp) {
        super(styles, ArcwayStandardResourceBundleLoader.getBundle((String)BUNDLE_NAME, (Locale)Locale.getDefault(), ModuleDataCompareViewer.class), mp);
        this.buildControl(parent);
    }

    @Override
    protected void createControls(Composite composite) {
        this.baseComposite = composite;
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        this.compareComposites[0] = new Composite(this.baseComposite, 0);
        this.compareComposites[0].setLayout((Layout)gridLayout);
        this.compareComposites[1] = new Composite(this.baseComposite, 0);
        this.compareComposites[1].setLayout((Layout)gridLayout);
        IWorkbenchPart part = this.getCompareConfiguration().getContainer().getWorkbenchPart();
        this.site = part != null ? part.getSite() : null;
        this.resources = new DetailsViewResources(this.baseComposite.getDisplay(), this.baseComposite.getFont().getFontData()[0].getName());
        this.compareComposites[0].addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (ModuleDataCompareViewer.this.compareDetailsProviders[0] != null) {
                    ModuleDataCompareViewer.this.compareDetailsProviders[0].stopShowingElement();
                }
                if (ModuleDataCompareViewer.this.compareDetailsProviders[1] != null) {
                    ModuleDataCompareViewer.this.compareDetailsProviders[1].stopShowingElement();
                }
                ModuleDataCompareViewer.this.resources.dispose();
            }
        });
    }

    @Override
    protected void handleResizeAncestor(int x, int y, int width, int height) {
    }

    @Override
    protected void handleResizeLeftRight(int x, int y, int leftWidth, int centerWidth, int rightWidth, int height) {
        this.compareComposites[0].setBounds(x, y, leftWidth, height);
        this.compareComposites[1].setBounds(x + leftWidth + centerWidth, y, rightWidth, height);
    }

    @Override
    protected void updateContent(Object ancestor, Object p_left, Object p_right) {
        boolean isNewControl_Left = this.updateContent(0, p_left);
        boolean isNewControl_Right = this.updateContent(1, p_right);
        this.calculateDiffs();
        if (isNewControl_Left || isNewControl_Right) {
            this.baseComposite.layout(true, true);
            this.baseComposite.redraw();
        }
    }

    private boolean updateContent(int sideIndex, Object newContentObject) {
        if (this.compareDetailsProviders[sideIndex] != null) {
            this.compareDetailsProviders[sideIndex].stopShowingElement();
        }
        boolean isNewControl = false;
        if (newContentObject != null) {
            if (newContentObject instanceof ModuleDataRevision) {
                boolean canBeDisplayedInCompareDetailsProvider = false;
                String oldContentDataTypeID = this.compareContents[sideIndex] == null ? null : this.compareContents[sideIndex].getRevisionItem().getTypeID();
                ModuleDataRevision newContent = (ModuleDataRevision)newContentObject;
                IModuleData newContentItem = newContent.getRevisionItem();
                String newContentDataTypeID = newContentItem.getTypeID();
                if (this.compareDetailsProviders[sideIndex] != null && oldContentDataTypeID != null && newContentDataTypeID.equals(oldContentDataTypeID)) {
                    canBeDisplayedInCompareDetailsProvider = true;
                } else {
                    ModuleDetailsProvider detailsProviderForType = this.createNewDetailsProvider(newContentDataTypeID);
                    if (detailsProviderForType != null) {
                        this.compareDetailsProviders[sideIndex] = detailsProviderForType;
                        if (this.compareControls[sideIndex] != null) {
                            this.compareControls[sideIndex].dispose();
                        }
                        Control detailsControl = detailsProviderForType.createPartControl(this.compareComposites[sideIndex], this.site, null, this.resources);
                        detailsControl.setLayoutData((Object)new GridData(4, 4, true, true));
                        this.compareControls[sideIndex] = detailsControl;
                        isNewControl = true;
                        canBeDisplayedInCompareDetailsProvider = true;
                    } else {
                        this.showMessageInsteadOfCompareDetailsWidget(sideIndex, Messages.getString("ModuleDataCompareView.ObjectCanNotBeDisplayed"));
                        isNewControl = true;
                    }
                }
                if (canBeDisplayedInCompareDetailsProvider) {
                    this.compareDetailsProviders[sideIndex].showElement((ICockpitProjectData)newContentItem);
                    this.compareContents[sideIndex] = newContent;
                }
            } else {
                this.showMessageInsteadOfCompareDetailsWidget(sideIndex, Messages.getString("ModuleDataCompareView.ObjectCanNotBeDisplayed"));
                isNewControl = true;
            }
        } else {
            this.showMessageInsteadOfCompareDetailsWidget(sideIndex, Messages.getString("ModuleDataCompareView.ObjectDoesNotExistInThisRevision"));
            isNewControl = true;
        }
        return isNewControl;
    }

    private void showMessageInsteadOfCompareDetailsWidget(int sideIndex, String message) {
        if (this.compareControls[sideIndex] != null) {
            this.compareControls[sideIndex].dispose();
        }
        this.compareDetailsProviders[sideIndex] = null;
        this.compareContents[sideIndex] = null;
        StyledText label = new StyledText(this.compareComposites[sideIndex], 64);
        label.setText(message);
        label.setBackground(this.baseComposite.getDisplay().getSystemColor(22));
        GridData gridData = new GridData(4, 4, true, true);
        gridData.horizontalIndent = 10;
        gridData.verticalIndent = 10;
        label.setLayoutData((Object)gridData);
        this.compareControls[sideIndex] = label;
    }

    private ModuleDetailsProvider createNewDetailsProvider(String dataTypeID) {
        IDetailsProvider detailsProvider = ExtensionMgr.getDetailProvider((String)dataTypeID);
        if (detailsProvider != null && detailsProvider instanceof ModuleDetailsProvider) {
            ModuleDetailsProvider moduleDetailsProvider = (ModuleDetailsProvider)detailsProvider;
            moduleDetailsProvider.setIsForHistoryViewer(true);
            return moduleDetailsProvider;
        }
        return null;
    }

    private void calculateDiffs() {
        LinkedList<DetailsElement> leftDetailsElements = new LinkedList<DetailsElement>();
        if (this.compareDetailsProviders[0] != null) {
            leftDetailsElements.addAll(this.compareDetailsProviders[0].getCurrentDetailsElementsForComparison());
        }
        LinkedList<DetailsElement> rightDetailsElements = new LinkedList<DetailsElement>();
        if (this.compareDetailsProviders[1] != null) {
            rightDetailsElements.addAll(this.compareDetailsProviders[1].getCurrentDetailsElementsForComparison());
        }
        for (DetailsElement leftElement : leftDetailsElements) {
            DetailsElement rightElement = this.findDetailsElement(leftElement.getId(), rightDetailsElements);
            if (rightElement != null) {
                if (leftElement.showsEqualValues(rightElement)) {
                    leftElement.setHighlighted(false);
                    rightElement.setHighlighted(false);
                } else {
                    leftElement.setHighlighted(true);
                    rightElement.setHighlighted(true);
                }
                rightDetailsElements.remove(rightElement);
                continue;
            }
            leftElement.setHighlighted(this.compareDetailsProviders[1] != null);
        }
        for (DetailsElement rightElement : rightDetailsElements) {
            rightElement.setHighlighted(this.compareDetailsProviders[0] != null);
        }
    }

    private DetailsElement findDetailsElement(String id, List<DetailsElement> detailsElements) {
        if (id != null) {
            for (DetailsElement element : detailsElements) {
                if (!id.equals(element.getId())) continue;
                return element;
            }
            return null;
        }
        return null;
    }

    @Override
    protected void copy(boolean leftToRight) {
    }

    @Override
    protected byte[] getContents(boolean p_left) {
        return null;
    }
}

