/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.modulelib2.client.gui;

import com.arcway.cockpit.frame.client.global.gui.views.linkview.ILinkContentProvider;
import com.arcway.cockpit.frame.client.global.gui.views.linkview.IModuleLinkLabelProvider;
import com.arcway.cockpit.frame.client.lib.dataviews.view.AbstractDataView;
import com.arcway.cockpit.modulelib2.client.gui.IUserInterface;
import com.arcway.cockpit.modulelib2.client.gui.ViewID;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;

public abstract class AbstractModuleUserInterface
implements IUserInterface {
    private final IWorkbenchWindow window;
    private ILinkContentProvider linkContentProvider;
    private IModuleLinkLabelProvider linkLabelProvider;
    private static final ILogger logger = Logger.getLogger(AbstractModuleUserInterface.class);

    public AbstractModuleUserInterface(IWorkbenchWindow window) {
        assert (window != null) : "window must not be null";
        this.window = window;
    }

    public IWorkbenchWindow getWorkbenchWindow() {
        return this.window;
    }

    public final ILinkContentProvider getLinkContentProvider() {
        if (this.linkContentProvider == null) {
            this.linkContentProvider = this.createLinkContentProvider();
        }
        return this.linkContentProvider;
    }

    public final IModuleLinkLabelProvider getLinkLabelProvider() {
        if (this.linkLabelProvider == null) {
            this.linkLabelProvider = this.createLinkLabelProvider();
        }
        return this.linkLabelProvider;
    }

    protected abstract ILinkContentProvider createLinkContentProvider();

    protected abstract IModuleLinkLabelProvider createLinkLabelProvider();

    @Override
    public final AbstractDataView[] getDataViews(boolean restore) {
        ArrayList<AbstractDataView> dataViews;
        ViewID[] dataViewIDs = this.getDataViewIDs();
        if (dataViewIDs != null) {
            dataViews = new ArrayList(dataViewIDs.length);
            ViewID[] viewIDArray = dataViewIDs;
            int n = dataViewIDs.length;
            int n2 = 0;
            while (n2 < n) {
                IViewReference[] views;
                ViewID dataViewID = viewIDArray[n2];
                String primaryID = dataViewID.getPrimaryID();
                String secondaryID = dataViewID.getSecondaryID();
                IViewReference[] iViewReferenceArray = views = this.getAllViewsOfWorkbenchWindow();
                int n3 = views.length;
                int n4 = 0;
                while (n4 < n3) {
                    IViewReference viewReference = iViewReferenceArray[n4];
                    if (primaryID.equals(viewReference.getId()) && (secondaryID == null || secondaryID.equals(viewReference.getSecondaryId()))) {
                        try {
                            IViewPart view = viewReference.getView(restore);
                            if (view == null) break;
                            dataViews.add((AbstractDataView)view);
                            break;
                        }
                        catch (ClassCastException e) {
                            logger.warn("View ID is not the id of a data view: Primary ID: " + primaryID + " / Secondary ID: " + secondaryID, (Throwable)e);
                        }
                    }
                    ++n4;
                }
                ++n2;
            }
        } else {
            dataViews = new ArrayList<AbstractDataView>(0);
        }
        return dataViews.toArray(new AbstractDataView[dataViews.size()]);
    }

    private IViewReference[] getAllViewsOfWorkbenchWindow() {
        IWorkbenchPage[] pages;
        HashSet<IViewReference> views = new HashSet<IViewReference>();
        IWorkbenchPage[] iWorkbenchPageArray = pages = this.window.getPages();
        int n = pages.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchPage page = iWorkbenchPageArray[n2];
            views.addAll(Arrays.asList(page.getViewReferences()));
            ++n2;
        }
        return views.toArray(new IViewReference[views.size()]);
    }

    protected abstract ViewID[] getDataViewIDs();
}

