/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.modulelib2.client.dataexchange.adapter.exporter;

import com.arcway.cockpit.cockpitlib.client.filter.gui.IFilterItem;
import com.arcway.cockpit.frame.client.global.Icons;
import com.arcway.cockpit.modulelib2.client.Messages;
import com.arcway.cockpit.modulelib2.client.core.project.IModelController;
import com.arcway.cockpit.modulelib2.client.dataexchange.adapter.AbstractExportAndImportWizardBase;
import com.arcway.cockpit.modulelib2.client.dataexchange.adapter.ExportOrImportResult;
import com.arcway.cockpit.modulelib2.client.dataexchange.adapter.IExportOrImportWizardContribution;
import com.arcway.cockpit.modulelib2.client.dataexchange.adapter.exporter.FilterPage;
import com.arcway.cockpit.modulelib2.client.dataexchange.adapter.exporter.IExporterManager;
import de.plans.lib.util.gui.IProgressDisplay;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizardPage;

public class ExportWizard
extends AbstractExportAndImportWizardBase {
    private final IModelController modelController;
    private final IExporterManager exporterManager;
    private final String exporterID;
    private FilterPage filterPage;
    private final Collection<IFilterItem> fixAttributeFilterItems;
    private final Collection<String> customPropertyFilterDataTypes;

    public ExportWizard(String exporterID, IExportOrImportWizardContribution exportWizardContribution, String configurationKey, IExporterManager exporterManager, IModelController modelController, Collection<IFilterItem> fixAttributeFilterItems, Collection<String> customPropertyFilterDataTypes) {
        super(exporterID, exportWizardContribution, configurationKey, modelController);
        this.modelController = modelController;
        this.exporterManager = exporterManager;
        this.exporterID = exporterID;
        this.fixAttributeFilterItems = fixAttributeFilterItems;
        this.customPropertyFilterDataTypes = customPropertyFilterDataTypes;
    }

    @Override
    protected String getTitle() {
        return Messages.getString("ExportWizard.WindowTitle");
    }

    @Override
    protected ImageDescriptor getImage() {
        return Icons.getImageDescriptorForBigExportLogo();
    }

    @Override
    protected List<IWizardPage> getPagesForBeginning() {
        return Collections.emptyList();
    }

    @Override
    protected List<IWizardPage> getPagesForEnd() {
        this.filterPage = new FilterPage(this.modelController, this.fixAttributeFilterItems, this.customPropertyFilterDataTypes);
        return Collections.singletonList(this.filterPage);
    }

    @Override
    protected ExportOrImportResult doExportOrImport(String projectUID, List<?> parameters, IProgressDisplay progressDisplay) {
        return this.exporterManager.export(this.modelController.getProjectUID(), this.exporterID, parameters, this.filterPage.getFilterItems(), progressDisplay, this.getShell());
    }

    @Override
    protected String getExportOrImportFailedMessageDialogueTitle() {
        return Messages.getString("ExportWizard.MissingExporterMessage_Title");
    }

    @Override
    protected String getExportOrImportFailedMessageDialogueDefaultText() {
        return Messages.getString("ExportWizard.MissingExporterMessage_Text");
    }

    @Override
    protected String getExportOrImportSucceededMessageDialogueTitle() {
        return Messages.getString("ExportWizard.ExportSuccessful_Title");
    }

    @Override
    protected String getExportOrImportSucceededMessageDialogueDefaultText() {
        return Messages.getString("ExportWizard.ExportSuccessful_Text");
    }
}

