/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.modulelib2.client.core.project;

import com.arcway.cockpit.frame.client.project.modules.IModuleProjectAgent;
import com.arcway.cockpit.frame.client.project.settings.ProjectSettingsCoDecForData;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import com.arcway.cockpit.modulelib2.client.platformadapter.helper.RepositoryIDCreator;
import com.arcway.frontend.definition.lib.implementation.type.manager.FrontendTypeManager;
import com.arcway.frontend.definition.lib.interFace.label.IExpiringFrontendLabel;
import com.arcway.frontend.definition.lib.interFace.type.manager.IFrontendTypeManager;
import com.arcway.lib.codec.data.IDataType;
import com.arcway.lib.java.Assert;
import com.arcway.lib.java.ObjectWrapper;
import com.arcway.lib.java.SetterSuccess;
import com.arcway.lib.java.locale.PresentationContext;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.memento.IArcwayMemento;
import com.arcway.repository.interFace.data.RepositoryReferences;
import com.arcway.repository.interFace.data.RepositorySamples;
import com.arcway.repository.interFace.data.attributeset.IRepositoryAttributeSet;
import com.arcway.repository.interFace.data.attributeset.IRepositoryPropertySetSample;
import com.arcway.repository.interFace.data.object.DTRepositoryObjectReference;
import com.arcway.repository.interFace.data.object.IRepositoryIterator_IRepositoryObject;
import com.arcway.repository.interFace.data.object.IRepositoryObject;
import com.arcway.repository.interFace.data.object.IRepositoryObjectReference;
import com.arcway.repository.interFace.data.object.IRepositoryObjectSample;
import com.arcway.repository.interFace.data.relation.ICrossLinkRepositoryRelation;
import com.arcway.repository.interFace.data.relation.ICrossLinkRepositoryRelationsReference;
import com.arcway.repository.interFace.data.relation.ICrossLinkRepositoryRelationsReferenceWithOnlyOneContribution;
import com.arcway.repository.interFace.data.relation.IRepositoryIterator_ICrossLinkRepositoryRelation;
import com.arcway.repository.interFace.data.relationcontribution.ICrossLinkRepositoryRelationContribution;
import com.arcway.repository.interFace.dataaccess.EXNotReproducibleSnapshot;
import com.arcway.repository.interFace.dataaccess.IRepositoryInterfaceRO;
import com.arcway.repository.interFace.dataaccess.IRepositorySnapshotRO;
import com.arcway.repository.interFace.dataaccess.IWithCurrentSnapshotProcessor;
import com.arcway.repository.interFace.dataaccess.RepositoryInterfaces;
import com.arcway.repository.interFace.declaration.type.object.IRepositoryObjectTypeID;
import com.arcway.repository.interFace.declaration.type.relation.IRepositoryRelationTypeID;
import com.arcway.repository.interFace.declaration.type.relationcontribution.IRepositoryRelationContributionRoleID;
import com.arcway.repository.interFace.implementation.workspace.IRepositoryWorkspaceRO;
import com.arcway.repository.interFace.implementation.workspace.IRepositoryWorkspaceRW;
import com.arcway.repository.interFace.registration.type.IRepositoryTypeManagerRO;
import com.arcway.repository.interFace.registration.type.object.IRepositoryObjectType;
import com.arcway.repository.interFace.registration.type.relationcontribution.ICrossLinkRepositoryRelationContributionType;
import com.arcway.repository.interFace.transactions.IRepositoryTransaction;
import com.arcway.repository.interFace.transactions.IRepositoryTransactionManager;
import com.arcway.repository.interFace.transactions.exceptions.EXMissingCrossLinkTarget;
import com.arcway.repository.lib.high.declaration.type.relation.RepositoryRelationTypeID;
import com.arcway.repository.lib.high.implementation.access.CrossLinkRepositoryRelationsReference;
import com.arcway.repository.lib.high.implementation.access.RepositoryObjectReference;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.Locale;
import java.util.TimeZone;

public class ModulePlatformAccess {
    private static final ILogger logger = Logger.getLogger(ModulePlatformAccess.class);
    IModuleProjectAgent projectAgent;
    RepositoryIDCreator repositoryIDCreator;

    public ModulePlatformAccess(String moduleID) {
        this.repositoryIDCreator = new RepositoryIDCreator(RepositoryIDCreator.getCoreTypeID(moduleID), "declaration_module_coremodule");
    }

    public void construct(IModuleProjectAgent projectAgent_) {
        this.projectAgent = projectAgent_;
    }

    public IRepositoryObjectReference getFrameDataItem(String cockpitTypeID, String uid) {
        return this.getFrameDataItem(cockpitTypeID, this.projectAgent.getRepositoryObjectID(uid));
    }

    private IRepositoryObjectReference getFrameDataItem(String cockpitTypeID, final IRepositoryPropertySetSample repositoryUID) {
        IRepositoryInterfaceRO repositoryInterface = this.projectAgent.getRepositoryInterface();
        IRepositoryObjectTypeID objectTypeID = RepositoryIDCreator.getRepositoryObjectTypeIDForFrameCockpitTypeID(cockpitTypeID);
        final IRepositoryObjectType objectType = repositoryInterface.getTypeManager().getObjectType(objectTypeID);
        final ObjectWrapper objectRef = new ObjectWrapper(null);
        try {
            RepositoryInterfaces.doWithCurrentSnapshot((IRepositoryInterfaceRO)repositoryInterface, (IWithCurrentSnapshotProcessor)new IWithCurrentSnapshotProcessor(){

                public void doWithCurrentSnapshot(IRepositorySnapshotRO snapshot) throws EXNotReproducibleSnapshot {
                    IRepositoryObject object = snapshot.findRepositoryObject(objectType, repositoryUID);
                    if (object != null) {
                        objectRef.setWrappedObject((Object)new RepositoryObjectReference(object));
                    }
                }
            });
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        return (IRepositoryObjectReference)objectRef.getWrappedObject();
    }

    public IRepositoryObjectReference getFrameDataItem(IArcwayMemento key) {
        try {
            return (IRepositoryObjectReference)ProjectSettingsCoDecForData.decodeFromMemento((IArcwayMemento)key, (IDataType)DTRepositoryObjectReference.getInstance((IRepositoryTypeManagerRO)this.projectAgent.getRepositoryInterface().getTypeManager()));
        }
        catch (Exception e) {
            logger.info("Frame data item could not be restored from Memento.", (Throwable)e);
            return null;
        }
    }

    public boolean itemExists(String cockpitTypeID, String uid) {
        return this.getFrameDataItem(cockpitTypeID, uid) != null;
    }

    public boolean itemExists(String cockpitTypeID, IRepositoryObjectReference object) {
        IRepositoryObjectReference foundObject = this.getFrameDataItem(cockpitTypeID, object.getObjectID());
        return foundObject != null;
    }

    public void storeKeyForFrameDataItem(IRepositoryObjectReference object, IArcwayMemento memento) {
        ProjectSettingsCoDecForData.encodeIntoMemento((Object)object, (IDataType)DTRepositoryObjectReference.getInstance((IRepositoryTypeManagerRO)this.projectAgent.getRepositoryInterface().getTypeManager()), (IArcwayMemento)memento);
    }

    public Collection<IRepositoryObjectReference> getAllFrameDataItems(String cockpitTypeID) {
        IRepositoryInterfaceRO repositoryInterface = this.projectAgent.getRepositoryInterface();
        IRepositoryObjectTypeID objectTypeID = RepositoryIDCreator.getRepositoryObjectTypeIDForFrameCockpitTypeID(cockpitTypeID);
        final IRepositoryObjectType objectType = repositoryInterface.getTypeManager().getObjectType(objectTypeID);
        final LinkedList<IRepositoryObjectReference> allObjects = new LinkedList<IRepositoryObjectReference>();
        try {
            RepositoryInterfaces.doWithCurrentSnapshot((IRepositoryInterfaceRO)repositoryInterface, (IWithCurrentSnapshotProcessor)new IWithCurrentSnapshotProcessor(){

                public void doWithCurrentSnapshot(IRepositorySnapshotRO snapshot) throws EXNotReproducibleSnapshot {
                    allObjects.clear();
                    IRepositoryIterator_IRepositoryObject allObjectsIterator = snapshot.findAllObjectOfType(objectType);
                    while (allObjectsIterator.hasNext()) {
                        allObjects.add(new RepositoryObjectReference(allObjectsIterator.nextIRepositoryObject()));
                    }
                }
            });
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        return allObjects;
    }

    public IRepositoryObjectReference getLinkedFrameDataItem(IModuleData item, String attributeID) {
        IRepositoryInterfaceRO repositoryInterface = this.projectAgent.getRepositoryInterface();
        String cockpitLinkTypeID = item.getTypeDescription().getLinkTypeIDForLinkedFrameDataAttribute(attributeID);
        RepositoryRelationTypeID relationTypeID = this.repositoryIDCreator.createRelationTypeID(cockpitLinkTypeID);
        IRepositoryRelationContributionRoleID relationContributionRoleID_item = this.repositoryIDCreator.createRelationContributionRoleID(cockpitLinkTypeID, "object");
        IRepositoryRelationContributionRoleID relationContributionRoleID_attribute = this.repositoryIDCreator.createRelationContributionRoleID(cockpitLinkTypeID, "attribute");
        IRepositoryPropertySetSample repositoryObjectID = this.projectAgent.getRepositoryObjectID(item.getUID());
        ObjectWrapper objectRef = new ObjectWrapper(null);
        try {
            RepositoryInterfaces.doWithCurrentSnapshot((IRepositoryInterfaceRO)repositoryInterface, (IWithCurrentSnapshotProcessor)new IWithCurrentSnapshotProcessor((IRepositoryRelationTypeID)relationTypeID, relationContributionRoleID_item, repositoryObjectID, relationContributionRoleID_attribute, objectRef){
                private final /* synthetic */ IRepositoryRelationTypeID val$relationTypeID;
                private final /* synthetic */ IRepositoryRelationContributionRoleID val$relationContributionRoleID_item;
                private final /* synthetic */ IRepositoryPropertySetSample val$repositoryObjectID;
                private final /* synthetic */ IRepositoryRelationContributionRoleID val$relationContributionRoleID_attribute;
                private final /* synthetic */ ObjectWrapper val$objectRef;
                {
                    this.val$relationTypeID = iRepositoryRelationTypeID;
                    this.val$relationContributionRoleID_item = iRepositoryRelationContributionRoleID;
                    this.val$repositoryObjectID = iRepositoryPropertySetSample;
                    this.val$relationContributionRoleID_attribute = iRepositoryRelationContributionRoleID2;
                    this.val$objectRef = objectWrapper;
                }

                public void doWithCurrentSnapshot(IRepositorySnapshotRO snapshot) throws EXNotReproducibleSnapshot {
                    ICrossLinkRepositoryRelationsReferenceWithOnlyOneContribution relationsReference = CrossLinkRepositoryRelationsReference.createWithOnlyOneContribution((IRepositoryRelationTypeID)this.val$relationTypeID, (IRepositoryRelationContributionRoleID)this.val$relationContributionRoleID_item, (IRepositoryPropertySetSample)this.val$repositoryObjectID);
                    try {
                        IRepositoryIterator_ICrossLinkRepositoryRelation relations = RepositoryReferences.getAllRelationsFromReference((ICrossLinkRepositoryRelationsReference)relationsReference, (IRepositorySnapshotRO)snapshot);
                        if (relations.hasNext()) {
                            ICrossLinkRepositoryRelation relation = relations.nextIRepositoryRelation();
                            relations.abortIteration();
                            ICrossLinkRepositoryRelationContributionType relationContributionType = relation.getRelationType().getRelationContributionType(this.val$relationContributionRoleID_attribute);
                            ICrossLinkRepositoryRelationContribution relationContribution = relation.getRelationContribution(relationContributionType);
                            IRepositoryObject object = relationContribution.getAttributeSet().getObject();
                            this.val$objectRef.setWrappedObject((Object)new RepositoryObjectReference(object));
                        } else {
                            this.val$objectRef.setWrappedObject(null);
                        }
                    }
                    catch (EXMissingCrossLinkTarget ex) {
                        this.val$objectRef.setWrappedObject(null);
                    }
                }
            });
        }
        catch (IllegalStateException isE) {
            objectRef.setWrappedObject(null);
        }
        return (IRepositoryObjectReference)objectRef.getWrappedObject();
    }

    public IExpiringFrontendLabel getLabelOfLinkedFrameDataItem(IModuleData item, String attributeID) {
        return this.getLabelOfLinkedFrameDataItem(item, attributeID, Locale.getDefault());
    }

    public IExpiringFrontendLabel getLabelOfLinkedFrameDataItem(IModuleData item, String attributeID, Locale locale) {
        IRepositoryObjectReference objectRef = this.getLinkedFrameDataItem(item, attributeID);
        if (objectRef != null) {
            return this.getLabelForPlatformObject(objectRef, locale);
        }
        return null;
    }

    public String getFullyQualifiedLabelOfLinkedFrameDataItem(IModuleData item, String attributeID, Locale locale) {
        IRepositoryObjectReference objectRef = this.getLinkedFrameDataItem(item, attributeID);
        if (objectRef != null) {
            return this.getFullyQualifiedLabelForPlatformObject(objectRef, locale);
        }
        return null;
    }

    public IExpiringFrontendLabel getLabelForPlatformObject(IRepositoryObjectReference object) {
        PresentationContext presentationContext = PresentationContext.getVirtualMachineUserLocaleForNow();
        return this.getLabelForPlatformObject(object, presentationContext);
    }

    public IExpiringFrontendLabel getLabelForPlatformObject(IRepositoryObjectReference object, Locale locale) {
        PresentationContext presentationContext = new PresentationContext(locale, new Date(), TimeZone.getDefault());
        return this.getLabelForPlatformObject(object, presentationContext);
    }

    public String getFullyQualifiedLabelForPlatformObject(IRepositoryObjectReference object, Locale locale) {
        PresentationContext presentationContext = new PresentationContext(locale, new Date(), TimeZone.getDefault());
        return this.getFullyQualifiedLabelForPlatformObject(object, presentationContext);
    }

    public IExpiringFrontendLabel getLabelForPlatformObject(final IRepositoryObjectReference object, final PresentationContext presentationContext) {
        IRepositoryInterfaceRO repositoryInterface = this.projectAgent.getRepositoryInterface();
        final IFrontendTypeManager frontendTypeManager = FrontendTypeManager.getFrontendTypeManager((IRepositoryTypeManagerRO)repositoryInterface.getTypeManager());
        final ObjectWrapper label = new ObjectWrapper(null);
        final IRepositoryObjectType objectType = repositoryInterface.getTypeManager().findObjectType(object.getObjectTypeID());
        if (objectType != null) {
            try {
                RepositoryInterfaces.doWithCurrentSnapshot((IRepositoryInterfaceRO)repositoryInterface, (IWithCurrentSnapshotProcessor)new IWithCurrentSnapshotProcessor(){

                    public void doWithCurrentSnapshot(IRepositorySnapshotRO snapshot) throws EXNotReproducibleSnapshot {
                        IRepositoryObject repositoryObject = snapshot.findRepositoryObject(objectType, object.getObjectID());
                        if (repositoryObject != null) {
                            label.setWrappedObject((Object)frontendTypeManager.getLabelForObject(repositoryObject, presentationContext));
                        }
                    }
                });
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        return (IExpiringFrontendLabel)label.getWrappedObject();
    }

    public String getFullyQualifiedLabelForPlatformObject(final IRepositoryObjectReference object, final PresentationContext presentationContext) {
        IRepositoryInterfaceRO repositoryInterface = this.projectAgent.getRepositoryInterface();
        final ObjectWrapper label = new ObjectWrapper(null);
        final IRepositoryObjectType objectType = repositoryInterface.getTypeManager().findObjectType(object.getObjectTypeID());
        if (objectType != null) {
            try {
                RepositoryInterfaces.doWithCurrentSnapshot((IRepositoryInterfaceRO)repositoryInterface, (IWithCurrentSnapshotProcessor)new IWithCurrentSnapshotProcessor(){

                    public void doWithCurrentSnapshot(IRepositorySnapshotRO snapshot) throws EXNotReproducibleSnapshot {
                        IRepositoryObject repositoryObject = snapshot.findRepositoryObject(objectType, object.getObjectID());
                        if (repositoryObject != null) {
                            label.setWrappedObject((Object)ModulePlatformAccess.this.getFullyQualifiedLabelForRepositoryObject(repositoryObject, presentationContext));
                        }
                    }
                });
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        return (String)label.getWrappedObject();
    }

    private String getFullyQualifiedLabelForRepositoryObject(IRepositoryObject repositoryObject, PresentationContext presentationContext) throws EXNotReproducibleSnapshot {
        String labelTextForObject = ModulePlatformAccess.getLabelTextForObject(repositoryObject, presentationContext);
        IRepositoryAttributeSet parentAttributeSet = repositoryObject.getParentAttributeSet();
        if (parentAttributeSet != null && !ModulePlatformAccess.isChildOfRoot(repositoryObject, presentationContext)) {
            IRepositoryObject parentObject = parentAttributeSet.getObject();
            labelTextForObject = String.valueOf(this.getFullyQualifiedLabelForRepositoryObject(parentObject, presentationContext)) + "/" + labelTextForObject;
        }
        return labelTextForObject;
    }

    private static boolean isChildOfRoot(IRepositoryObject repositoryObject, PresentationContext presentationContext) throws EXNotReproducibleSnapshot {
        IRepositoryAttributeSet parentAttributeSet = repositoryObject.getParentAttributeSet();
        if (parentAttributeSet == null) {
            return true;
        }
        IRepositoryObject parentObject = parentAttributeSet.getObject();
        IRepositoryAttributeSet parentsParentAttributeSet = parentObject.getParentAttributeSet();
        return parentsParentAttributeSet == null;
    }

    private static String getLabelTextForObject(IRepositoryObject repositoryObject, PresentationContext presentationContext) {
        IRepositoryTypeManagerRO typeManager = repositoryObject.getTypeManager();
        IFrontendTypeManager frontendTypeManager = FrontendTypeManager.getFrontendTypeManager((IRepositoryTypeManagerRO)typeManager);
        IExpiringFrontendLabel labelForObject = frontendTypeManager.getLabelForObject(repositoryObject, presentationContext);
        String labelTextForObject = labelForObject.getText();
        if (labelTextForObject == null) {
            labelTextForObject = "";
        }
        return labelTextForObject;
    }

    public SetterSuccess changeLinkToFrameItem(IModuleData item, String attributeID, IRepositoryObjectReference newLinkedItem) {
        IRepositoryInterfaceRO repositoryInterface = this.projectAgent.getRepositoryInterface();
        boolean isLinkToBeCreated = newLinkedItem != null;
        String cockpitLinkTypeID = item.getTypeDescription().getLinkTypeIDForLinkedFrameDataAttribute(attributeID);
        RepositoryRelationTypeID relationTypeID = this.repositoryIDCreator.createRelationTypeID(cockpitLinkTypeID);
        IRepositoryRelationContributionRoleID relationContributionRoleID_item = this.repositoryIDCreator.createRelationContributionRoleID(cockpitLinkTypeID, "object");
        IRepositoryRelationContributionRoleID relationContributionRoleID_attribute = this.repositoryIDCreator.createRelationContributionRoleID(cockpitLinkTypeID, "attribute");
        IRepositoryPropertySetSample repositoryObjectID_item = this.projectAgent.getRepositoryObjectID(item.getUID());
        IRepositoryPropertySetSample repositoryObjectID_attribute = newLinkedItem != null ? newLinkedItem.getObjectID() : null;
        ObjectWrapper result = new ObjectWrapper(null);
        try {
            RepositoryInterfaces.doWithCurrentSnapshot((IRepositoryInterfaceRO)repositoryInterface, (IWithCurrentSnapshotProcessor)new IWithCurrentSnapshotProcessor((IRepositoryRelationTypeID)relationTypeID, relationContributionRoleID_item, repositoryObjectID_item, isLinkToBeCreated, relationContributionRoleID_attribute, repositoryObjectID_attribute, repositoryInterface, newLinkedItem, result){
                private final /* synthetic */ IRepositoryRelationTypeID val$relationTypeID;
                private final /* synthetic */ IRepositoryRelationContributionRoleID val$relationContributionRoleID_item;
                private final /* synthetic */ IRepositoryPropertySetSample val$repositoryObjectID_item;
                private final /* synthetic */ boolean val$isLinkToBeCreated;
                private final /* synthetic */ IRepositoryRelationContributionRoleID val$relationContributionRoleID_attribute;
                private final /* synthetic */ IRepositoryPropertySetSample val$repositoryObjectID_attribute;
                private final /* synthetic */ IRepositoryInterfaceRO val$repositoryInterface;
                private final /* synthetic */ IRepositoryObjectReference val$newLinkedItem;
                private final /* synthetic */ ObjectWrapper val$result;
                {
                    this.val$relationTypeID = iRepositoryRelationTypeID;
                    this.val$relationContributionRoleID_item = iRepositoryRelationContributionRoleID;
                    this.val$repositoryObjectID_item = iRepositoryPropertySetSample;
                    this.val$isLinkToBeCreated = bl;
                    this.val$relationContributionRoleID_attribute = iRepositoryRelationContributionRoleID2;
                    this.val$repositoryObjectID_attribute = iRepositoryPropertySetSample2;
                    this.val$repositoryInterface = iRepositoryInterfaceRO;
                    this.val$newLinkedItem = iRepositoryObjectReference;
                    this.val$result = objectWrapper;
                }

                /*
                 * Exception decompiling
                 */
                public void doWithCurrentSnapshot(IRepositorySnapshotRO snapshot) throws EXNotReproducibleSnapshot {
                    /*
                     * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                     * 
                     * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                     *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                     *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                     *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                     *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                     *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                     *     at org.benf.cfr.reader.Main.main(Main.java:54)
                     */
                    throw new IllegalStateException("Decompilation failed");
                }
            });
        }
        catch (IllegalStateException isE) {
            result.setWrappedObject((Object)SetterSuccess.NEW_VALUE_COULD_NOT_BE_APPLIED);
        }
        return (SetterSuccess)result.getWrappedObject();
    }

    private static IRepositoryTransactionManager getTransactionManager(IRepositoryInterfaceRO repositoryInterface) {
        IRepositoryWorkspaceRO workspace = repositoryInterface.getWorkspace();
        Assert.checkOperationSupport((boolean)(workspace instanceof IRepositoryWorkspaceRW));
        IRepositoryWorkspaceRW workspaceRW = (IRepositoryWorkspaceRW)workspace;
        return workspaceRW.getTransactionManager();
    }

    private static IRepositoryTransaction openTransaction(IRepositoryInterfaceRO repositoryInterface, IRepositorySnapshotRO snapshot) throws EXNotReproducibleSnapshot {
        IRepositoryObjectSample snapshotInformation = snapshot.getSnapshotInformation();
        IRepositoryTypeManagerRO typeManager = snapshot.getTypeManager();
        return ModulePlatformAccess.getTransactionManager(repositoryInterface).openTransaction(RepositorySamples.getSnapshotID((IRepositoryObjectSample)snapshotInformation, (IRepositoryTypeManagerRO)typeManager));
    }

    static /* synthetic */ IRepositoryTransaction access$1(IRepositoryInterfaceRO iRepositoryInterfaceRO, IRepositorySnapshotRO iRepositorySnapshotRO) throws EXNotReproducibleSnapshot {
        return ModulePlatformAccess.openTransaction(iRepositoryInterfaceRO, iRepositorySnapshotRO);
    }
}

