/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.modulelib2.client.core.project;

import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.core.links.ILinkModificationListener;
import com.arcway.cockpit.frame.client.project.core.links.linkableobjects.ILOLinkAccessFacade;
import com.arcway.cockpit.frame.client.project.core.links.linkeddataaccess.ILinkedDataAccessFacade;
import com.arcway.cockpit.frame.client.project.core.links.linktypes.ILinkType;
import com.arcway.cockpit.frame.client.project.core.links.linktypes.ILinkTypeLinkAccessFacade;
import com.arcway.cockpit.frame.client.project.core.locking.ILockManager;
import com.arcway.cockpit.frame.client.project.core.locking.LockResult;
import com.arcway.cockpit.frame.client.project.modules.IModuleLinkManager;
import com.arcway.cockpit.frame.client.project.modules.IModuleLockManager;
import com.arcway.cockpit.frame.shared.message.EOLink;
import com.arcway.cockpit.frame.shared.message.EOLinkLog;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.cockpit.modulelib2.client.core.project.AbstractDataMgr;
import com.arcway.cockpit.modulelib2.client.core.project.LockAccess;
import com.arcway.cockpit.modulelib2.client.messages.ILinkTypeHelper;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import com.arcway.lib.java.collectionmaps.ISetMapWithFixReturnSetsRO;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;

public class LinkMgr {
    private static final ILogger logger = Logger.getLogger(LinkMgr.class);
    private IFrameProjectAgent projectAgent;
    private IModuleLinkManager manager;
    private String moduleID;
    private AbstractDataMgr dataMgr;
    private final Map<String, ILinkTypeLinkAccessFacade> mapLinkTypeID_linkAccessFacade = new HashMap<String, ILinkTypeLinkAccessFacade>();
    private final Map<String, ILOLinkAccessFacade> mapDataTypeID_LOLinkAccessFacade = new HashMap<String, ILOLinkAccessFacade>();

    public void construct(IFrameProjectAgent projectAgent_, IModuleLinkManager mgr, String mID, AbstractDataMgr dataMngr) {
        assert (mgr != null) : "mgr must not be null";
        assert (mID != null) : "mID must not be null";
        assert (dataMngr != null) : "dataMgr must not be null";
        this.projectAgent = projectAgent_;
        this.manager = mgr;
        this.moduleID = mID;
        this.dataMgr = dataMngr;
    }

    public LockAccess acquireLocksForLinkData(String linkableObjectUID, String moduleDataUID, String linkTypeID) {
        IModuleLockManager lockMgr = this.projectAgent.getModuleLockManager();
        ILinkTypeLinkAccessFacade linkTypeLinkAccessFacade = this.mapLinkTypeID_linkAccessFacade.get(linkTypeID);
        LockResult lockResult = linkTypeLinkAccessFacade.acquireLocksForLinkData(linkableObjectUID, moduleDataUID);
        LockAccess lockAccess = new LockAccess((ILockManager)lockMgr, lockResult);
        return lockAccess;
    }

    public IStatus createLink(String linkableObjectUID, String moduleDataItemUID, String linkTypeID) {
        return this.mapLinkTypeID_linkAccessFacade.get(linkTypeID).createLink(moduleDataItemUID, linkableObjectUID);
    }

    public IStatus addVersionedLink(EOLinkLog link) {
        return this.mapLinkTypeID_linkAccessFacade.get(link.getLinkTypeID()).addVersionedLink(link);
    }

    public void removeVersionedLink(EOLinkLog link) {
        this.mapLinkTypeID_linkAccessFacade.get(link.getLinkTypeID()).removeVersionedLink(link);
    }

    public Set<? extends EOLink> getLinksForLinkableObject(IModuleData item, String linkTypeID) {
        ILinkTypeLinkAccessFacade linkFacade = this.mapLinkTypeID_linkAccessFacade.get(linkTypeID);
        String itemUID = item.getUID();
        int modCount = item.getModificationCount();
        if (item.isHistoricItem()) {
            return linkFacade.getVersionedLinksForLinkableObject(itemUID, modCount);
        }
        return linkFacade.getLinksForLinkableObject(itemUID);
    }

    public Collection getModuleData(String linkableObjectUID, int modCount, String linkTypeID) {
        return this.mapLinkTypeID_linkAccessFacade.get(linkTypeID).getVersionedModuleData(linkableObjectUID, modCount);
    }

    public Collection<IModuleData> getAllModuleData(String linkTypeID) {
        HashSet<IModuleData> moduleData = new HashSet<IModuleData>();
        String dataTypeUID = this.dataMgr.getLinkTypesHelper().getLinkSourceDataTypeIDForLinkType(linkTypeID);
        ILinkTypeLinkAccessFacade linkFacade = this.mapLinkTypeID_linkAccessFacade.get(linkTypeID);
        for (EOLink link : linkFacade.getAllLinks()) {
            moduleData.add((IModuleData)this.dataMgr.getItem(dataTypeUID, link.getModuleDataUID()));
        }
        return moduleData;
    }

    public Collection<EOLink> createLinks(Collection<? extends IModuleData> linkableObjects, IModuleData moduleDataItem, String linkTypeID) {
        return this.mapLinkTypeID_linkAccessFacade.get(linkTypeID).createLinks(moduleDataItem.getUID(), this.extractModuleDataUIDs(linkableObjects));
    }

    public Collection<EOLink> createLinks(String linkableObjectUID, Collection<? extends IModuleData> moduleData, String linkTypeID) {
        return this.mapLinkTypeID_linkAccessFacade.get(linkTypeID).createLinks(this.extractModuleDataUIDs(moduleData), linkableObjectUID);
    }

    private Collection<String> extractModuleDataUIDs(Collection<? extends IModuleData> moduleData) {
        assert (moduleData != null);
        ArrayList<String> moduleDataUIDs = new ArrayList<String>(moduleData.size());
        for (IModuleData iModuleData : moduleData) {
            moduleDataUIDs.add(iModuleData.getUID());
        }
        return moduleDataUIDs;
    }

    public IStatus deleteLink(String linkableObjectUID, String moduleDataItemUID, String linkTypeID) {
        return this.mapLinkTypeID_linkAccessFacade.get(linkTypeID).deleteLink(moduleDataItemUID, linkableObjectUID);
    }

    public Collection getLinkableObjects(IModuleData moduleDataItem, String linkTypeID) {
        ILinkTypeLinkAccessFacade linkFacade = this.mapLinkTypeID_linkAccessFacade.get(linkTypeID);
        if (moduleDataItem.isHistoricItem()) {
            return linkFacade.getVersionedLinkableObjects(moduleDataItem.getUID(), moduleDataItem.getModificationCount());
        }
        return linkFacade.getLinkableObjects(moduleDataItem.getUID());
    }

    public Collection<? extends ICockpitProjectData> getLinkableObjects(String moduleDataUID, String linkTypeID) {
        ILinkTypeLinkAccessFacade linkFacade = this.mapLinkTypeID_linkAccessFacade.get(linkTypeID);
        return linkFacade.getLinkableObjects(moduleDataUID);
    }

    public boolean linkExists(String projectUID, String linkableObjectUID, IModuleData moduleDataItem, String linkTypeID) {
        return this.mapLinkTypeID_linkAccessFacade.get(linkTypeID).linkExists(new EOLink(projectUID, linkableObjectUID, moduleDataItem.getUID(), this.moduleID, linkTypeID));
    }

    public Collection getModuleData(String linkableObjectUID, String linkTypeID, String planUID) {
        assert (linkableObjectUID != null) : "linkableObjectUID must not be null";
        assert (linkTypeID != null) : "linkTypeID must not be null";
        assert (planUID != null) : "planUID must not be null";
        return this.mapLinkTypeID_linkAccessFacade.get(linkTypeID).getModuleData(linkableObjectUID);
    }

    public Set<EOLink> getLinksForLinkableObject(String linkableObjectUID, String linkTypeID) {
        assert (linkableObjectUID != null) : "linkableObjectUID must not be null";
        assert (linkTypeID != null) : "linkTypeID must not be null";
        return this.mapLinkTypeID_linkAccessFacade.get(linkTypeID).getLinksForLinkableObject(linkableObjectUID);
    }

    public Set<? extends EOLink> getLinksForModuleDataItem(IModuleData data, String linkTypeID) {
        assert (data != null) : "data must not be null";
        assert (linkTypeID != null) : "linkTypeID must not be null";
        if (data.isHistoricItem()) {
            return this.mapLinkTypeID_linkAccessFacade.get(linkTypeID).getVersionedLinksForModuleDataItem(data.getUID(), data.getModificationCount());
        }
        return this.mapLinkTypeID_linkAccessFacade.get(linkTypeID).getLinksForModuleDataItem(data.getUID());
    }

    public IModuleData getModuleData(EOLink link) {
        return (IModuleData)this.mapLinkTypeID_linkAccessFacade.get(link.getLinkTypeID()).getModuleDataItem(link);
    }

    public ICockpitProjectData getLinkableObject(EOLink link) {
        return this.mapLinkTypeID_linkAccessFacade.get(link.getLinkTypeID()).getLinkableObject(link);
    }

    public Collection<? extends IModuleData> getModuleData(String linkableObjectUID, String linkTypeID) {
        String dataTypeUID;
        assert (linkableObjectUID != null) : "linkableObjectUID must not be null";
        assert (linkTypeID != null) : "linkTypeID must not be null";
        ILinkTypeLinkAccessFacade linkFacade = this.mapLinkTypeID_linkAccessFacade.get(linkTypeID);
        Set links = linkFacade.getLinksForLinkableObject(linkableObjectUID);
        ArrayList<IModuleData> elements = new ArrayList<IModuleData>(links.size());
        if (!links.isEmpty() && (dataTypeUID = this.dataMgr.getLinkTypesHelper().getLinkSourceDataTypeIDForLinkType(linkTypeID)) != null) {
            for (EOLink link : links) {
                IModuleData moduleData = (IModuleData)this.dataMgr.getItem(dataTypeUID, link.getModuleDataUID());
                if (moduleData != null) {
                    elements.add(moduleData);
                    continue;
                }
                logger.warn("Link without module data: " + link);
            }
        }
        return elements;
    }

    public void linkedItemDeleted(IModuleData item) {
        assert (item != null) : "item must not be null";
        this.manager.linkedItemDeleted(item.getTypeID(), (ICockpitProjectData)item);
    }

    public boolean linkableObjectProviderIDExists(String linkableObjectProviderID) {
        assert (linkableObjectProviderID != null) : "linkableObjectProviderID must not be null";
        return this.mapDataTypeID_LOLinkAccessFacade.keySet().contains(linkableObjectProviderID);
    }

    public void addModificationListenerForLinkType(String linkType, ILinkModificationListener listener) {
        this.manager.addLinkModificationListenerForLinkType(listener, linkType);
    }

    public void registerLinkedDataAccessFacade(IModuleLinkManager linkManager, Collection<? extends ILinkedDataAccessFacade> linkedDataAccessFacades, boolean retrieveLOLinkAccessFacades) {
        for (ILinkedDataAccessFacade iLinkedDataAccessFacade : linkedDataAccessFacades) {
            linkManager.registerLinkedDataAccessFacade(iLinkedDataAccessFacade);
            ILOLinkAccessFacade linkAccessFacade = linkManager.getLinkableObjectLinkAccessFacade(iLinkedDataAccessFacade.getDataTypeID());
            this.mapDataTypeID_LOLinkAccessFacade.put(iLinkedDataAccessFacade.getDataTypeID(), linkAccessFacade);
        }
    }

    public void registerLinkTypes(IModuleLinkManager linkManager, Collection<? extends ILinkType> linkTypes) {
        assert (linkManager != null) : "linkManager must not be null";
        assert (linkTypes != null) : "linkTypes must not be null";
        for (ILinkType iLinkType : linkTypes) {
            ILinkTypeLinkAccessFacade linkFacade = linkManager.registerLinkType(iLinkType);
            this.mapLinkTypeID_linkAccessFacade.put(iLinkType.getUID(), linkFacade);
        }
    }

    public String getModuleID() {
        return this.moduleID;
    }

    public Collection<? extends IModuleData> getModuleData(IModuleData linkableObject, String linkTypeID) {
        String itemUID = linkableObject.getUID();
        int modCount = linkableObject.getModificationCount();
        if (linkableObject.isHistoricItem()) {
            return this.getModuleData(itemUID, modCount, linkTypeID);
        }
        return this.getModuleData(itemUID, linkTypeID);
    }

    public ISetMapWithFixReturnSetsRO<String, EOLink> getLinksForLinkType(String linkTypeID) {
        return this.mapLinkTypeID_linkAccessFacade.get(linkTypeID).getAllLinksMappedByLinkableObjectID();
    }

    public Collection<EOLink> addLinks(Collection<EOLink> links, String linkType) {
        return this.mapLinkTypeID_linkAccessFacade.get(linkType).addLinks(links);
    }

    public Collection<EOLink> deleteLinks(Collection<? extends IModuleData> linkableObjects, IModuleData moduleDataItem, String linkType) {
        return this.mapLinkTypeID_linkAccessFacade.get(linkType).deleteLinks(this.extractModuleDataUIDs(linkableObjects), moduleDataItem.getUID());
    }

    public Collection<EOLink> deleteLinks(String linkableObjectUID, Collection<? extends IModuleData> moduleData, String linkType) {
        return this.mapLinkTypeID_linkAccessFacade.get(linkType).deleteLinks(linkableObjectUID, this.extractModuleDataUIDs(moduleData));
    }

    public IStatus deleteLink(EOLink link) {
        return this.mapLinkTypeID_linkAccessFacade.get(link.getLinkTypeID()).deleteLink(link);
    }

    public ILinkTypeHelper getLinkTypeHelper() {
        return this.dataMgr.getLinkTypesHelper();
    }
}

