/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.genericmodule.client.messages;

import com.arcway.cockpit.genericmodule.client.GenericModulePlugin;
import com.arcway.cockpit.genericmodule.client.core.ClientDataFactory_TypesHelper;
import com.arcway.cockpit.genericmodule.client.core.GMLinkTypeHelper_Shared;
import com.arcway.cockpit.genericmodule.client.core.ModuleIdentification;
import com.arcway.cockpit.genericmodule.client.infrastructure.resources.Messages;
import com.arcway.cockpit.genericmodule.client.infrastructure.resources.ResourceManager;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.SpecificationProvider;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.Attribute;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.CMRelationParticipant;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.CrossModuleRelationType;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.EnumerationAttribute;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.IDAttribute;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.LinkedFrameDataAttribute;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.LinkedModuleDataAttribute;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.MDRelationParticipant;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.ModelElementLinkType;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.ModuleDataRelationType;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.ModuleSpecification;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.ObjectType;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.RelationType;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.SimpleAttribute;
import com.arcway.cockpit.genericmodule.client.messages.GMDataTypesHelper;
import com.arcway.cockpit.modulelib2.client.messages.IUIDataTypesHelper;
import com.arcway.cockpit.modulelib2.client.messages.description.IModuleDataTypeDescription;
import com.arcway.cockpit.modulelib2.client.platformadapter.PlatformAdaptorConstants;
import com.arcway.cockpit.modulelib2.client.platformadapter.helper.RepositoryIDCreator;
import com.arcway.cockpit.modulelib2.client.util.LabelProvider;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.ui.editor.ObjectTypeCategoryLabels;
import com.arcway.lib.ui.editor.WidgetTypeID;
import com.arcway.lib.ui.editor.datatype.IWidgetTypeID;
import com.arcway.lib.ui.editor.layoutspecification.CustomPropertySpecification;
import com.arcway.lib.ui.editor.layoutspecification.IWidgetSpecification;
import com.arcway.lib.ui.editor.layoutspecification.WidgetSpecification;
import com.arcway.lib.ui.editor.parameters.MultipleChoiceWidgetParameters;
import com.arcway.lib.ui.editor.parameters.WidgetParameters;
import com.arcway.lib.ui.editor.parameters.importdialog.PageWidgetParameters;
import com.arcway.lib.ui.editor.specification.sequential.EntrySpecification;
import com.arcway.lib.ui.editor.specification.sequential.PageSpecification;
import com.arcway.lib.ui.editor.specification.sequential.Sequence;
import com.arcway.repository.cockpit.interFace.declaration.frame.infolink.CRTIDsInfoLink;
import com.arcway.repository.interFace.declaration.type.property.IRepositoryPropertyTypeID;
import com.arcway.repository.interFace.declaration.type.relation.IRepositoryRelationTypeID;
import com.arcway.repository.interFace.declaration.type.relationcontribution.IRepositoryRelationContributionRoleID;
import com.arcway.repository.lib.high.declaration.type.object.RepositoryObjectTypeID;
import com.arcway.repository.lib.high.declaration.type.relation.RepositoryRelationTypeID;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.eclipse.core.runtime.FileLocator;

public class GMUIDataTypesHelper
implements IUIDataTypesHelper {
    private static final ILogger logger = Logger.getLogger(GMUIDataTypesHelper.class);
    private static final Map<String, IUIDataTypesHelper> singletons = new HashMap<String, IUIDataTypesHelper>();
    private final String moduleID;

    public static IUIDataTypesHelper getDefault(String moduleID) {
        IUIDataTypesHelper singleton = singletons.get(moduleID);
        if (singleton == null) {
            singleton = new GMUIDataTypesHelper(moduleID);
            singletons.put(moduleID, singleton);
        }
        return singleton;
    }

    private GMUIDataTypesHelper(String moduleID) {
        this.moduleID = moduleID;
    }

    public boolean isToBeShownInDataView(String dataTypeID) {
        return true;
    }

    public File getEditorLayoutSpecificationFile(String typeID) {
        URL editorLayoutSpecURL = ResourceManager.getDefault().getResourceURL(this.moduleID, String.valueOf(GenericModulePlugin.getDefault().getSpecPath()) + "/" + "EditorLayoutSpec.xml");
        if (editorLayoutSpecURL != null) {
            try {
                URL editorLayoutSpecAsFileURL = FileLocator.toFileURL((URL)editorLayoutSpecURL);
                File file = new File(editorLayoutSpecAsFileURL.getPath());
                return file;
            }
            catch (IOException ioE) {
                logger.error("Couldn't load editor layout spec for module '" + this.moduleID + "'.", (Throwable)ioE);
                return null;
            }
        }
        logger.error("Editor layout spec for module '" + this.moduleID + "' does not exist.");
        return null;
    }

    public Sequence getSequentialLayoutSpecification(String cockpitTypeID, Locale contentLocale) {
        ModuleSpecification moduleSpecification = SpecificationProvider.getDefault().getModuleSpecification(this.moduleID);
        ObjectType objectTypeSpecification = moduleSpecification.getModuleDataSpecification().getObjectType(ClientDataFactory_TypesHelper.getShortTypeID(cockpitTypeID));
        IModuleDataTypeDescription dataTypeDescription = GMDataTypesHelper.getDefault(this.moduleID).getTypeDescription(cockpitTypeID);
        GMLinkTypeHelper_Shared linkTypeHelper = GMLinkTypeHelper_Shared.getDefault(this.moduleID);
        String platformModuleID = ModuleIdentification.getModuleIDForPlatform(this.moduleID);
        RepositoryIDCreator repositoryIDCreator = new RepositoryIDCreator(platformModuleID, "declaration_module_coremodule");
        ArrayList<PageSpecification> pageSpecifications = new ArrayList<PageSpecification>(2);
        ArrayList<EntrySpecification> propertyEntrySpecifications = new ArrayList<EntrySpecification>();
        if (dataTypeDescription.isSupportingCategories()) {
            EntrySpecification categoryEntrySpecification = GMUIDataTypesHelper.getEntrySpecificationForObjectTypeCategory();
            propertyEntrySpecifications.add(categoryEntrySpecification);
            EntrySpecification horizontalSeparatorEntrySpecification = GMUIDataTypesHelper.getEntrySpecificationForDecoratorWidget((IWidgetTypeID)WidgetTypeID.HORIZONTAL_SEPARATOR);
            propertyEntrySpecifications.add(horizontalSeparatorEntrySpecification);
        }
        for (Attribute attribute : objectTypeSpecification.getAttributeList()) {
            Object entrySpecification;
            String attributeID;
            if (attribute instanceof SimpleAttribute) {
                SimpleAttribute simpleAttribute = (SimpleAttribute)attribute;
                attributeID = simpleAttribute.getAttributeID();
                WidgetTypeID widgetType = GMUIDataTypesHelper.getDefaultWidgetTypeForAttributeDataType(simpleAttribute.getAttributeDataType());
                if (widgetType == null) continue;
                EntrySpecification entrySpecification2 = GMUIDataTypesHelper.getEntrySpecificationForProperty(dataTypeDescription, cockpitTypeID, attributeID, (IWidgetTypeID)widgetType, repositoryIDCreator, contentLocale);
                propertyEntrySpecifications.add(entrySpecification2);
                continue;
            }
            if (attribute instanceof IDAttribute) {
                IDAttribute idAttribute = (IDAttribute)attribute;
                attributeID = idAttribute.getAttributeID();
                entrySpecification = GMUIDataTypesHelper.getEntrySpecificationForProperty(dataTypeDescription, cockpitTypeID, attributeID, (IWidgetTypeID)WidgetTypeID.FREESTRING, repositoryIDCreator, contentLocale);
                propertyEntrySpecifications.add((EntrySpecification)entrySpecification);
                continue;
            }
            if (attribute instanceof EnumerationAttribute) {
                EnumerationAttribute enumAttribute = (EnumerationAttribute)attribute;
                attributeID = enumAttribute.getAttributeID();
                entrySpecification = GMUIDataTypesHelper.getEntrySpecificationForProperty(dataTypeDescription, cockpitTypeID, attributeID, (IWidgetTypeID)WidgetTypeID.SINGLECHOICE, repositoryIDCreator, contentLocale);
                propertyEntrySpecifications.add((EntrySpecification)entrySpecification);
                continue;
            }
            if (attribute instanceof LinkedModuleDataAttribute) {
                LinkedModuleDataAttribute linkedModuleDataAttribute = (LinkedModuleDataAttribute)attribute;
                attributeID = linkedModuleDataAttribute.getAttributeID();
                entrySpecification = GMUIDataTypesHelper.getEntrySpecificationForLinkedAttribute(dataTypeDescription, objectTypeSpecification, attributeID, "object", contentLocale, linkTypeHelper, repositoryIDCreator);
                propertyEntrySpecifications.add((EntrySpecification)entrySpecification);
                continue;
            }
            if (!(attribute instanceof LinkedFrameDataAttribute)) continue;
            LinkedFrameDataAttribute linkedFrameDataAttribute = (LinkedFrameDataAttribute)attribute;
            attributeID = linkedFrameDataAttribute.getAttributeID();
            entrySpecification = GMUIDataTypesHelper.getEntrySpecificationForLinkedAttribute(dataTypeDescription, objectTypeSpecification, attributeID, "object", contentLocale, linkTypeHelper, repositoryIDCreator);
            propertyEntrySpecifications.add((EntrySpecification)entrySpecification);
        }
        WidgetParameters widgetParams = new WidgetParameters(com.arcway.repository.clientadapter.implementation.adapter.Messages.getString((String)"ImportDialogueLayout.CockpitData.CustomProperties.Label"), com.arcway.repository.clientadapter.implementation.adapter.Messages.getString((String)"ImportDialogueLayout.CockpitData.CustomProperties.Tooltip"), true);
        CustomPropertySpecification widgetSpec = new CustomPropertySpecification(widgetParams);
        EntrySpecification entrySpec = new EntrySpecification((IWidgetSpecification)widgetSpec, true);
        propertyEntrySpecifications.add(entrySpec);
        PageWidgetParameters propertyPageParams = new PageWidgetParameters(com.arcway.repository.clientadapter.implementation.adapter.Messages.getString((String)"ImportDialogueLayout.CockpitData.Properties.Label"), com.arcway.repository.clientadapter.implementation.adapter.Messages.getString((String)"ImportDialogueLayout.CockpitData.Properties.Tooltip"), true, 0);
        PageSpecification propertyPageSpec = new PageSpecification(propertyEntrySpecifications, (WidgetParameters)propertyPageParams);
        pageSpecifications.add(propertyPageSpec);
        ArrayList<EntrySpecification> relationEntrySpecifications = new ArrayList<EntrySpecification>();
        for (RelationType relationType : moduleSpecification.getModuleDataSpecification().getRelationTypeList()) {
            if (relationType instanceof ModuleDataRelationType) {
                ModuleDataRelationType moduleDataRelationType = (ModuleDataRelationType)relationType;
                int participantIndex = 0;
                for (MDRelationParticipant mdRelationParticipant : moduleDataRelationType.getMDRelationParticipantList()) {
                    if (mdRelationParticipant.getObjectTypeIDOfParticipant().equals(objectTypeSpecification.getObjectTypeID())) {
                        String roleName = GMUIDataTypesHelper.getOtherRoleName(moduleDataRelationType, mdRelationParticipant, contentLocale);
                        String linkTypeID = linkTypeHelper.getRelationLinkTypeID(moduleDataRelationType.getRelationTypeID());
                        String roleIDSegment = participantIndex == 0 ? "moduledata" : "linkableobject";
                        EntrySpecification entrySpecification = GMUIDataTypesHelper.getEntrySpecificationForRelation(linkTypeID, roleIDSegment, roleName, repositoryIDCreator);
                        relationEntrySpecifications.add(entrySpecification);
                    }
                    ++participantIndex;
                }
                continue;
            }
            if (relationType instanceof ModelElementLinkType) {
                ModelElementLinkType modelElementLinkType = (ModelElementLinkType)relationType;
                if (!modelElementLinkType.getLinkedObjectTypeID().equals(objectTypeSpecification.getObjectTypeID())) continue;
                String roleName = Messages.getString("GMUIDataTypesHelper.SequentialLayoutSpecification.ModelElementslabel");
                String linkTypeID = linkTypeHelper.getModelElementLinkTypeID(modelElementLinkType.getLinkedObjectTypeID());
                RepositoryRelationTypeID relationTypeID = repositoryIDCreator.createRelationTypeID(CRTIDsInfoLink.RELATION_TYPE_ID, linkTypeID);
                EntrySpecification entrySpecification = GMUIDataTypesHelper.getEntrySpecificationForRelation((IRepositoryRelationTypeID)relationTypeID, (IRepositoryRelationContributionRoleID)CRTIDsInfoLink.RELATION_CONTRIBUTION_ROLE_ID_MODULEDATA, roleName);
                relationEntrySpecifications.add(entrySpecification);
                continue;
            }
            if (!(relationType instanceof CrossModuleRelationType)) continue;
            CrossModuleRelationType crossModuleRelationType = (CrossModuleRelationType)relationType;
            GMUIDataTypesHelper.addEntrySpecificationsForCrossModuleRelationType(crossModuleRelationType, objectTypeSpecification.getObjectTypeID(), null, linkTypeHelper, contentLocale, relationEntrySpecifications);
        }
        for (ModuleSpecification externalModuleSpecification : SpecificationProvider.getDefault().getModuleSpecifications().values()) {
            if (externalModuleSpecification.getModuleID().equals(this.moduleID)) continue;
            for (CrossModuleRelationType crossModuleRelationType : externalModuleSpecification.getModuleDataSpecification().getRelationTypeListOfType(CrossModuleRelationType.class)) {
                GMUIDataTypesHelper.addEntrySpecificationsForCrossModuleRelationType(crossModuleRelationType, objectTypeSpecification.getObjectTypeID(), this.moduleID, GMLinkTypeHelper_Shared.getDefault(externalModuleSpecification), contentLocale, relationEntrySpecifications);
            }
        }
        if (!relationEntrySpecifications.isEmpty()) {
            PageWidgetParameters relationPageParams = new PageWidgetParameters(com.arcway.repository.clientadapter.implementation.adapter.Messages.getString((String)"ImportDialogueLayout.CockpitData.LinkedElements.Label"), com.arcway.repository.clientadapter.implementation.adapter.Messages.getString((String)"ImportDialogueLayout.CockpitData.LinkedElements.Tooltip"), true, 1);
            PageSpecification relationPageSpec = new PageSpecification(relationEntrySpecifications, (WidgetParameters)relationPageParams);
            pageSpecifications.add(relationPageSpec);
        }
        Sequence sequence = new Sequence(pageSpecifications, null);
        return sequence;
    }

    private static void addEntrySpecificationsForCrossModuleRelationType(CrossModuleRelationType crossModuleRelationType, String relatedObjectTypeID, String ownModuleID, GMLinkTypeHelper_Shared linkTypeHelper, Locale contentLocale, List<EntrySpecification> relationEntrySpecifications) {
        int participantIndex = 0;
        for (CMRelationParticipant cmRelationParticipant : crossModuleRelationType.getCMRelationParticipantList()) {
            if (cmRelationParticipant.getParticipantType().equals("all-module-data") || cmRelationParticipant.getParticipantType().equals(ownModuleID == null ? "module-internal" : "other-module") && cmRelationParticipant.getIDOfParticipant().equals(relatedObjectTypeID) && (ownModuleID == null || cmRelationParticipant.getParticipantModule().equals(ownModuleID))) {
                String roleName = GMUIDataTypesHelper.getOtherRoleName(crossModuleRelationType, cmRelationParticipant, contentLocale);
                String linkTypeID = linkTypeHelper.getCrossModuleLinkTypeID(crossModuleRelationType.getRelationTypeID());
                RepositoryIDCreator cmlRepositoryIDCreator = new RepositoryIDCreator("crossmodulelinks", linkTypeID);
                RepositoryRelationTypeID relationTypeID = cmlRepositoryIDCreator.createRelationTypeID(PlatformAdaptorConstants.RELATION_TYPE_ID_ABSTRACTCROSSMODULEDATALINK, linkTypeID);
                IRepositoryRelationContributionRoleID roleID = participantIndex == 0 ? PlatformAdaptorConstants.RELATION_CONTRIBUTION_ROLE_CROSSMODULELINK_REFERRING_ITEM : PlatformAdaptorConstants.RELATION_CONTRIBUTION_ROLE_CROSSMODULELINK_REFERRED_ITEM;
                EntrySpecification entrySpecification = GMUIDataTypesHelper.getEntrySpecificationForRelation((IRepositoryRelationTypeID)relationTypeID, roleID, roleName);
                relationEntrySpecifications.add(entrySpecification);
            }
            ++participantIndex;
        }
    }

    private static String getOtherRoleName(CrossModuleRelationType relationType, CMRelationParticipant cmRelationParticipant, Locale contentLocale) {
        for (CMRelationParticipant otherCmRelationParticipant : relationType.getCMRelationParticipantList()) {
            if (otherCmRelationParticipant.getIDOfParticipant().equals(cmRelationParticipant.getIDOfParticipant())) continue;
            return new LabelProvider(otherCmRelationParticipant.getParticipantRoleName()).getLabel(contentLocale);
        }
        assert (false);
        return "Role name not found";
    }

    private static String getOtherRoleName(ModuleDataRelationType relationType, MDRelationParticipant mdRelationParticipant, Locale contentLocale) {
        for (MDRelationParticipant otherMDRelationParticipant : relationType.getMDRelationParticipantList()) {
            if (otherMDRelationParticipant.getIndex() == mdRelationParticipant.getIndex()) continue;
            return new LabelProvider(otherMDRelationParticipant.getParticipantRoleName()).getLabel(contentLocale);
        }
        assert (false);
        return "Role name not found";
    }

    private static EntrySpecification getEntrySpecificationForObjectTypeCategory() {
        WidgetParameters widgetParams = new WidgetParameters(ObjectTypeCategoryLabels.LABEL_CATEGORY, ObjectTypeCategoryLabels.LABEL_CATEGORY, true);
        WidgetSpecification widgetSpec = new WidgetSpecification(true, Collections.emptySet(), Collections.emptyMap(), (IWidgetTypeID)WidgetTypeID.SINGLECHOICE, widgetParams);
        EntrySpecification entrySpec = new EntrySpecification((IWidgetSpecification)widgetSpec, true);
        return entrySpec;
    }

    private static EntrySpecification getEntrySpecificationForDecoratorWidget(IWidgetTypeID widgetTypeID) {
        WidgetParameters widgetParams = new WidgetParameters(null, null, false);
        WidgetSpecification widgetSpec = new WidgetSpecification(false, Collections.emptySet(), Collections.emptyMap(), widgetTypeID, widgetParams);
        EntrySpecification entrySpec = new EntrySpecification((IWidgetSpecification)widgetSpec, true);
        return entrySpec;
    }

    private static EntrySpecification getEntrySpecificationForAttribute(IModuleDataTypeDescription dataTypeDescription, String attributeID, Collection<String> propertyTypeIDs, Map<String, String> relationTypeID2roleID, IWidgetTypeID widgetType, Locale contentLocale) {
        String attributeName = dataTypeDescription.getAttributeName(attributeID, contentLocale);
        WidgetParameters widgetParams = new WidgetParameters(attributeName, attributeName, true);
        WidgetSpecification widgetSpec = new WidgetSpecification(false, propertyTypeIDs, relationTypeID2roleID, widgetType, widgetParams);
        EntrySpecification entrySpec = new EntrySpecification((IWidgetSpecification)widgetSpec, true);
        return entrySpec;
    }

    private static EntrySpecification getEntrySpecificationForProperty(IModuleDataTypeDescription dataTypeDescription, String cockpitTypeID, String attributeID, IWidgetTypeID widgetType, RepositoryIDCreator repositoryIDCreator, Locale contentLocale) {
        ArrayList<String> propertyTypeIds = new ArrayList<String>();
        RepositoryObjectTypeID repositoryObjectTypeID = repositoryIDCreator.createObjectTypeIDForRealType(cockpitTypeID);
        IRepositoryPropertyTypeID repositoryPropertyTypeID = repositoryIDCreator.createPropertyTypeIDForAttribute(repositoryObjectTypeID, attributeID);
        propertyTypeIds.add(repositoryPropertyTypeID.toCanonicalString());
        return GMUIDataTypesHelper.getEntrySpecificationForAttribute(dataTypeDescription, attributeID, propertyTypeIds, Collections.emptyMap(), widgetType, contentLocale);
    }

    private static EntrySpecification getEntrySpecificationForLinkedAttribute(IModuleDataTypeDescription dataTypeDescription, ObjectType objectTypeSpecification, String attributeID, String roleIDSegment, Locale contentLocale, GMLinkTypeHelper_Shared linkTypeHelper, RepositoryIDCreator repositoryIDCreator) {
        HashMap<String, String> relationTypeID2roleID = new HashMap<String, String>();
        String linkTypeID = linkTypeHelper.getAttributeLinkTypeID_forShortTypeID(objectTypeSpecification.getObjectTypeID(), attributeID);
        RepositoryRelationTypeID relationTypeID = repositoryIDCreator.createRelationTypeID(linkTypeID);
        IRepositoryRelationContributionRoleID roleID = repositoryIDCreator.createRelationContributionRoleID(linkTypeID, roleIDSegment);
        relationTypeID2roleID.put(relationTypeID.toCanonicalString(), roleID.toCanonicalString());
        return GMUIDataTypesHelper.getEntrySpecificationForAttribute(dataTypeDescription, attributeID, Collections.emptySet(), relationTypeID2roleID, (IWidgetTypeID)WidgetTypeID.SINGLECHOICE, contentLocale);
    }

    private static WidgetTypeID getDefaultWidgetTypeForAttributeDataType(String attributeDataType) {
        if (attributeDataType.equals("datatype_mda_string_single")) {
            return WidgetTypeID.FREESTRING;
        }
        if (attributeDataType.equals("datatype_mda_string_multi")) {
            return WidgetTypeID.FREETEXT;
        }
        if (attributeDataType.equals("datatype_mda_integer")) {
            return WidgetTypeID.FREESTRING;
        }
        if (attributeDataType.equals("datatype_mda_long")) {
            return WidgetTypeID.FREESTRING;
        }
        if (attributeDataType.equals("datatype_mda_user")) {
            return WidgetTypeID.FREESTRING;
        }
        if (attributeDataType.equals("datatype_mda_timestamp_dateandtime")) {
            return WidgetTypeID.CALENDAR;
        }
        if (attributeDataType.equals("datatype_mda_timestamp_dateonly")) {
            return WidgetTypeID.CALENDAR;
        }
        if (attributeDataType.equals("datatype_mda_duration_minutes")) {
            return WidgetTypeID.FREESTRING;
        }
        if (attributeDataType.equals("datatype_mda_duration_hours")) {
            return WidgetTypeID.FREESTRING;
        }
        if (attributeDataType.equals("datatype_mda_duration_workingdays")) {
            return WidgetTypeID.FREESTRING;
        }
        if (attributeDataType.equals("datatype_mda_path")) {
            return WidgetTypeID.FREESTRING;
        }
        if (attributeDataType.equals("datatype_mda_boolean")) {
            return WidgetTypeID.BOOLEAN;
        }
        return null;
    }

    private static EntrySpecification getEntrySpecificationForRelation(String linkTypeID, String roleIDSegment, String label, RepositoryIDCreator repositoryIDCreator) {
        RepositoryRelationTypeID relationTypeID = repositoryIDCreator.createRelationTypeID(linkTypeID);
        IRepositoryRelationContributionRoleID roleID = repositoryIDCreator.createRelationContributionRoleID(linkTypeID, roleIDSegment);
        return GMUIDataTypesHelper.getEntrySpecificationForRelation((IRepositoryRelationTypeID)relationTypeID, roleID, label);
    }

    private static EntrySpecification getEntrySpecificationForRelation(IRepositoryRelationTypeID relationTypeID, IRepositoryRelationContributionRoleID roleID, String label) {
        MultipleChoiceWidgetParameters widgetParams = new MultipleChoiceWidgetParameters(label, label, true, 0, 1, true, true);
        HashMap<String, String> relationTypeID2roleID = new HashMap<String, String>();
        relationTypeID2roleID.put(relationTypeID.toCanonicalString(), roleID.toCanonicalString());
        WidgetSpecification widgetSpecification = new WidgetSpecification(false, Collections.emptySet(), relationTypeID2roleID, (IWidgetTypeID)WidgetTypeID.MULTIPLECHOICE, (WidgetParameters)widgetParams);
        EntrySpecification entrySpecification = new EntrySpecification((IWidgetSpecification)widgetSpecification, false);
        return entrySpecification;
    }
}

