/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.genericmodule.client.messages;

import com.arcway.cockpit.genericmodule.client.core.ClientDataFactory_TypesHelper;
import com.arcway.cockpit.genericmodule.client.core.GMLinkTypeHelper_Shared;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.SpecificationProvider;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.CMRelationParticipant;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.CrossModuleRelationType;
import com.arcway.cockpit.modulelib2.client.core.crossmodulelinks.CrossModuleLinkManager;
import com.arcway.cockpit.modulelib2.client.core.crossmodulelinks.ICrossModuleLinkType;
import com.arcway.cockpit.modulelib2.client.util.LabelProvider;
import de.plans.lib.localisation.ILabelProvider;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;

public class CrossModuleLinkType
implements ICrossModuleLinkType,
IExecutableExtension {
    private String moduleID;
    private CrossModuleRelationType crossModuleRelationType;

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.moduleID = SpecificationProvider.getDefault().getModuleID(data);
        this.crossModuleRelationType = (CrossModuleRelationType)SpecificationProvider.getDefault().getModuleSpecificationPart(data);
    }

    public String getId() {
        return GMLinkTypeHelper_Shared.getDefault(this.moduleID).getCrossModuleLinkTypeID(this.crossModuleRelationType.getID());
    }

    public ILabelProvider getName() {
        return new LabelProvider(this.crossModuleRelationType.getRelationTypeName());
    }

    public ILabelProvider getModuleDataContributionName() {
        CMRelationParticipant moduleDataParticipant = this.crossModuleRelationType.getCMRelationParticipant(0);
        return new LabelProvider(moduleDataParticipant.getParticipantRoleName());
    }

    public Collection<String> getAllowedTypesForModuleDataContribution() {
        CMRelationParticipant moduleDataParticipant = this.crossModuleRelationType.getCMRelationParticipant(0);
        return this.retrieveAllowedTypes(moduleDataParticipant);
    }

    public String getModuleDataCardinality() {
        CMRelationParticipant moduleDataParticipant = this.crossModuleRelationType.getCMRelationParticipant(0);
        return this.translateCardinality(moduleDataParticipant.getCardinality());
    }

    public ILabelProvider getLinkableObjectContributionName() {
        CMRelationParticipant linkableObjectParticipant = this.crossModuleRelationType.getCMRelationParticipant(1);
        return new LabelProvider(linkableObjectParticipant.getParticipantRoleName());
    }

    public Collection<String> getAllowedTypesForLinkableObjectContribution() {
        CMRelationParticipant linkableObjectParticipant = this.crossModuleRelationType.getCMRelationParticipant(1);
        return this.retrieveAllowedTypes(linkableObjectParticipant);
    }

    public String getLinkableObjectCardinality() {
        CMRelationParticipant linkableObjectParticipant = this.crossModuleRelationType.getCMRelationParticipant(1);
        return this.translateCardinality(linkableObjectParticipant.getCardinality());
    }

    private Collection<String> retrieveAllowedTypes(CMRelationParticipant participant) {
        Set<String> allowedModuleDataTypes = null;
        if (participant.getParticipantType().equals("all-module-data")) {
            allowedModuleDataTypes = CrossModuleLinkManager.ALLOW_ALL_MODULEDATA_TYPES;
        } else if (participant.getParticipantType().equals("module-internal")) {
            allowedModuleDataTypes = Collections.singleton(ClientDataFactory_TypesHelper.getDataTypeID(this.moduleID, participant.getIDOfParticipant()));
        } else if (participant.getParticipantType().equals("other-module")) {
            allowedModuleDataTypes = Collections.singleton(ClientDataFactory_TypesHelper.getDataTypeID(participant.getParticipantModule(), participant.getIDOfParticipant()));
        } else if (participant.getParticipantType().equals("old-module")) {
            allowedModuleDataTypes = Collections.singleton(participant.getIDOfParticipant());
        }
        return allowedModuleDataTypes;
    }

    private String translateCardinality(String cardinality) {
        if (cardinality == null) {
            return "unlimited";
        }
        if (cardinality.equals("none-or-one")) {
            return "none-or-one";
        }
        if (cardinality.equals("unlimited")) {
            return "unlimited";
        }
        return null;
    }
}

