/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.genericmodule.client.infrastructure.specification.serialisation;

import com.arcway.cockpit.genericmodule.client.infrastructure.specification.IModuleSpecificationPart;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.IModuleSpecificationPartXMLFactory;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.IModuleSpecificationPartXMLFactoryParent;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.serialisation.CrossModuleRelationTypeXMLFactory;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.serialisation.ModelElementLinkTypeXMLFactory;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.serialisation.ModuleDataRelationTypeXMLFactory;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.serialisation.ObjectTypeXMLFactory;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.serialisation.RequiredModuleXMLFactory;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.CrossModuleRelationType;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.ModelElementLinkType;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.ModuleDataRelationType;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.ModuleDataSpecification;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.ObjectType;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.RelationType;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.RequiredModule;
import com.arcway.lib.codec.xml.EXXMLDecodingFailed;
import com.arcway.lib.codec.xml.IXMLElementWO;
import com.arcway.lib.codec.xml.IXMLItemRO;
import com.arcway.lib.codec.xml.XMLAttribute;
import com.arcway.lib.codec.xml.XMLElementName;
import com.arcway.lib.codec.xml.XMLProcessingInstruction;
import com.arcway.lib.java.collections.ArrayList_;
import com.arcway.lib.java.collections.IList_;
import java.util.ArrayList;
import java.util.List;

public class ModuleDataSpecificationXMLFactory
implements IModuleSpecificationPartXMLFactory {
    private ModuleDataSpecification specPart;
    private IModuleSpecificationPartXMLFactoryParent parentFactory;
    private List<RequiredModule> requiredModuleList;
    private List<ObjectType> objectTypeList;
    private List<RelationType> relationTypeList;

    public ModuleDataSpecificationXMLFactory(ModuleDataSpecification part) {
        this.specPart = part;
    }

    public ModuleDataSpecificationXMLFactory(IList_<XMLAttribute> xmlAttributes_, IModuleSpecificationPartXMLFactoryParent parentFactory_) {
        assert (xmlAttributes_ != null);
        this.parentFactory = parentFactory_;
        this.requiredModuleList = new ArrayList<RequiredModule>();
        this.objectTypeList = new ArrayList<ObjectType>();
        this.relationTypeList = new ArrayList<RelationType>();
    }

    public XMLElementName getElementName() {
        return new XMLElementName(null, "ModuleDataSpecification");
    }

    public IList_<XMLAttribute> getAttributes() {
        ArrayList_ xmlAttributes_ = new ArrayList_();
        return xmlAttributes_;
    }

    public IList_<IXMLItemRO> getChildItems() {
        ArrayList_ children = new ArrayList_();
        for (RequiredModule requiredModule : this.specPart.getRequiredModuleList()) {
            children.add((Object)new RequiredModuleXMLFactory(requiredModule));
        }
        for (ObjectType objectType : this.specPart.getObjectTypeList()) {
            children.add((Object)new ObjectTypeXMLFactory(objectType));
        }
        for (RelationType relationType : this.specPart.getRelationTypeList()) {
            if (relationType instanceof ModuleDataRelationType) {
                children.add((Object)new ModuleDataRelationTypeXMLFactory((ModuleDataRelationType)relationType));
            }
            if (relationType instanceof ModelElementLinkType) {
                children.add((Object)new ModelElementLinkTypeXMLFactory((ModelElementLinkType)relationType));
            }
            if (!(relationType instanceof CrossModuleRelationType)) continue;
            children.add((Object)new CrossModuleRelationTypeXMLFactory((CrossModuleRelationType)relationType));
        }
        return children;
    }

    public IXMLElementWO createChildElement(XMLElementName elementName, IList_<XMLAttribute> xmlAttributes_) throws EXXMLDecodingFailed {
        if (elementName.getElementName().equals("RequiredModule")) {
            return new RequiredModuleXMLFactory(xmlAttributes_, this);
        }
        if (elementName.getElementName().equals("ObjectType")) {
            return new ObjectTypeXMLFactory(xmlAttributes_, this);
        }
        if (elementName.getElementName().equals("ModuleDataRelationType")) {
            return new ModuleDataRelationTypeXMLFactory(xmlAttributes_, this);
        }
        if (elementName.getElementName().equals("ModelElementLinkType")) {
            return new ModelElementLinkTypeXMLFactory(xmlAttributes_, this);
        }
        if (elementName.getElementName().equals("CrossModuleRelationType")) {
            return new CrossModuleRelationTypeXMLFactory(xmlAttributes_, this);
        }
        throw new EXXMLDecodingFailed();
    }

    public void characters(String characters) throws EXXMLDecodingFailed {
    }

    public void endElement() throws EXXMLDecodingFailed {
        ModuleDataSpecification deserialisedPart = new ModuleDataSpecification(this.requiredModuleList, this.objectTypeList, this.relationTypeList);
        this.parentFactory.addChildPart("ModuleDataSpecification", deserialisedPart);
    }

    @Override
    public void addChildPart(String partType, IModuleSpecificationPart part) {
        if (partType.equals("RequiredModule")) {
            this.requiredModuleList.add((RequiredModule)part);
        }
        if (partType.equals("ObjectType")) {
            this.objectTypeList.add((ObjectType)part);
        }
        if (partType.equals("ModuleDataRelationType") || partType.equals("ModelElementLinkType") || partType.equals("CrossModuleRelationType")) {
            this.relationTypeList.add((RelationType)part);
        }
    }

    public void processingInstruction(XMLProcessingInstruction processingInstruction) throws EXXMLDecodingFailed {
    }
}

