/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.genericmodule.client.infrastructure.resources;

import com.arcway.cockpit.genericmodule.client.infrastructure.resources.ResourceManager;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import de.plans.lib.resources.IIconResource;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;

public class IconResource
implements IIconResource {
    private static final ILogger logger = Logger.getLogger(IconResource.class);
    private final String moduleID;
    private final String imageFileName;

    public IconResource(String moduleID, String imageFileName) {
        this.moduleID = moduleID;
        this.imageFileName = imageFileName;
    }

    public String getName() {
        return this.imageFileName;
    }

    public ImageDescriptor getImageDescriptor() {
        return ResourceManager.getDefault().getImageDescriptor(this.moduleID, this.imageFileName);
    }

    public Image getImage() {
        return ResourceManager.getDefault().getImage(this.moduleID, this.imageFileName);
    }

    public InputStream getInputStream() {
        try {
            return ResourceManager.getDefault().getImageURL(this.moduleID, this.imageFileName).openStream();
        }
        catch (IOException ioE) {
            logger.warn("Could not open input stream for image: " + this.moduleID + " -> " + this.imageFileName, (Throwable)ioE);
            return null;
        }
    }
}

