/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.genericmodule.client.gui.menu.handlers;

import com.arcway.cockpit.genericmodule.client.GenericModulePlugin;
import com.arcway.cockpit.genericmodule.client.gui.dataview.DataView;
import com.arcway.cockpit.genericmodule.client.gui.menu.actions.ActionNewRootItem;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.SpecificationProvider;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.ModuleSpecification;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.ObjectType;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.ParentType;
import com.arcway.cockpit.modulelib2.client.core.project.IModelController;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;

public class CHFileNewRootItem
extends AbstractHandler
implements IExecutableExtension {
    private String moduleID;
    private ObjectType objectType;

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.moduleID = SpecificationProvider.getDefault().getModuleID(data);
        ParentType parentType = (ParentType)SpecificationProvider.getDefault().getModuleSpecificationPart(data);
        ModuleSpecification specification = SpecificationProvider.getDefault().getModuleSpecification(this.moduleID);
        this.objectType = SpecificationProvider.getObjectTypeForParentType(specification, parentType);
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchPart activePart = HandlerUtil.getActivePart((ExecutionEvent)event);
        IModelController modelController = null;
        if (activePart instanceof DataView) {
            String projectUID = ((DataView)activePart).getCurrentlyAssociatedProject();
            modelController = GenericModulePlugin.getDefault().getProjectManager(this.moduleID).getModelController(projectUID);
        }
        if (modelController != null) {
            ActionNewRootItem action = new ActionNewRootItem(modelController, this.moduleID, this.objectType);
            action.run();
        }
        return null;
    }
}

