/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.genericmodule.client.gui.dataview;

import com.arcway.cockpit.frame.client.project.core.uniqueelements.IUniqueElement;
import com.arcway.cockpit.genericmodule.client.GenericModulePlugin;
import com.arcway.cockpit.genericmodule.client.core.ClientDataFactory_TypesHelper;
import com.arcway.cockpit.genericmodule.client.core.GMLinkTypeHelper_Shared;
import com.arcway.cockpit.genericmodule.client.infrastructure.resources.Messages;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.AttributeColumnContent;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.Column;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.ColumnContent;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.MDRelationColumnContent;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.MELinkColumnContent;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.TableTreeDataView;
import com.arcway.cockpit.genericmodule.client.messages.GenericModuleData;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.cockpit.modulelib2.client.core.project.IModelController;
import com.arcway.cockpit.modulelib2.client.gui.dataview.jfaceviewer.tree.standard.IModuleFixColumnProvider;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import com.arcway.cockpit.modulelib2.client.messages.attributes.IModuleDataAttribute;
import com.arcway.cockpit.modulelib2.client.messages.attributes.ModuleDataAttributeDiscrete;
import com.arcway.frontend.definition.lib.interFace.label.IExpiringFrontendLabel;
import com.arcway.lib.stringtools.StringUtil;
import de.plans.lib.resources.IIconResource;
import java.util.Collection;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;

public class DataViewLabelProvider
implements IModuleFixColumnProvider {
    private final String moduleID;
    private final TableTreeDataView dataViewSpec;

    public DataViewLabelProvider(String moduleID, TableTreeDataView dataViewSpec) {
        this.moduleID = moduleID;
        this.dataViewSpec = dataViewSpec;
    }

    public Image getColumnImage(IModuleData element, String columnID) {
        if (element instanceof GenericModuleData) {
            MELinkColumnContent meLinkColumnContent;
            GenericModuleData item = (GenericModuleData)element;
            String cockpitTypeID = item.getTypeID();
            String shortTypeID = ClientDataFactory_TypesHelper.getShortTypeID(cockpitTypeID);
            Column columnSpec = (Column)this.dataViewSpec.getColumnProvider(columnID);
            if (columnSpec == (Column)this.dataViewSpec.getColumnProviderList().get(0)) {
                return item.getStatusDependentIcon().getImage();
            }
            ColumnContent columnContent = columnSpec.getColumnContent(shortTypeID);
            if (columnContent instanceof AttributeColumnContent) {
                IIconResource attributeIcon;
                IModuleDataAttribute attribute;
                String attributeID = ((AttributeColumnContent)columnContent).getAttributeID();
                ImageDescriptor imageDescriptor = null;
                boolean isEnumerationAttribute = false;
                if (item.getTypeDescription().isSimpleAttribute(attributeID) && (attribute = item.getAttribute(attributeID)) instanceof ModuleDataAttributeDiscrete) {
                    imageDescriptor = ((ModuleDataAttributeDiscrete)attribute).getDisplayImageDescriptor();
                    isEnumerationAttribute = true;
                }
                if (!isEnumerationAttribute && (attributeIcon = item.getAttributeIcon(attributeID)) != null) {
                    imageDescriptor = attributeIcon.getImageDescriptor();
                }
                if (imageDescriptor != null) {
                    return GenericModulePlugin.getDefault().getImageDescriptorRegistry().get(imageDescriptor);
                }
                return null;
            }
            if (columnContent instanceof MELinkColumnContent && (meLinkColumnContent = (MELinkColumnContent)columnContent).getMELinkPresentationType().equals("link-icon")) {
                IModelController modelController = GenericModulePlugin.getDefault().getProjectManager(this.moduleID).getModelController(item.getProjectUID());
                Collection<ICockpitProjectData> linkedItems = DataViewLabelProvider.getLinkedModelElements(item, cockpitTypeID, modelController);
                if (!linkedItems.isEmpty()) {
                    return GenericModulePlugin.getDefault().getImageDescriptorRegistry().get(GenericModulePlugin.getDefault().getImageDescriptor_("link.gif"));
                }
                return null;
            }
        }
        return null;
    }

    public String getColumnText(IModuleData element, String columnID) {
        String text = "";
        if (element instanceof GenericModuleData) {
            MELinkColumnContent meLinkColumnContent;
            GenericModuleData item = (GenericModuleData)element;
            String cockpitTypeID = item.getTypeID();
            String shortTypeID = ClientDataFactory_TypesHelper.getShortTypeID(cockpitTypeID);
            Column columnSpec = (Column)this.dataViewSpec.getColumnProvider(columnID);
            ColumnContent columnContent = columnSpec.getColumnContent(shortTypeID);
            IModelController modelController = GenericModulePlugin.getDefault().getProjectManager(this.moduleID).getModelController(item.getProjectUID());
            if (columnContent instanceof AttributeColumnContent) {
                IExpiringFrontendLabel label;
                String attributeID = ((AttributeColumnContent)columnContent).getAttributeID();
                if (item.getTypeDescription().isSimpleAttribute(attributeID) || item.getTypeDescription().isCalculatedAttribute(attributeID)) {
                    IModuleDataAttribute attribute = item.getAttribute(attributeID);
                    text = attribute.getDisplayStringRepresentation(modelController.getProjectLanguage());
                } else if (item.getTypeDescription().isLinkedModuleDataAttribute(attributeID)) {
                    Collection moduleDataCollection = modelController.getLinkableObjects((IModuleData)item, item.getTypeDescription().getLinkTypeIDForLinkedModuleDataAttribute(attributeID));
                    if (moduleDataCollection.size() == 1) {
                        IModuleData moduleData = (IModuleData)moduleDataCollection.iterator().next();
                        text = moduleData.getDisplayRepresentation();
                    } else assert (moduleDataCollection.isEmpty());
                } else if (item.getTypeDescription().isLinkedFrameDataAttribute(attributeID) && (label = modelController.getPlatformAccessAgent().getLabelOfLinkedFrameDataItem((IModuleData)item, attributeID)) != null && label.getText() != null) {
                    text = label.getText();
                }
            } else if (columnContent instanceof MDRelationColumnContent) {
                String linkTypeID = GMLinkTypeHelper_Shared.getDefault(item.getGenericModuleID()).getRelationLinkTypeID(((MDRelationColumnContent)columnContent).getModuleDataRelationTypeID());
                Collection linkedItems = ((MDRelationColumnContent)columnContent).getDirection().equals("referred-items") ? modelController.getLinkableObjects((IModuleData)item, linkTypeID) : modelController.getModuleData((IModuleData)item, linkTypeID);
                String attributeID = ((MDRelationColumnContent)columnContent).getAttributeID();
                StringBuilder textBuilder = new StringBuilder();
                boolean first = true;
                for (ICockpitProjectData linkedItem : linkedItems) {
                    if (first) {
                        first = false;
                    } else {
                        textBuilder.append(", ");
                    }
                    textBuilder.append(((IModuleData)linkedItem).getAttribute(attributeID).getDisplayStringRepresentation(modelController.getProjectLanguage()));
                }
                text = textBuilder.toString();
            } else if (columnContent instanceof MELinkColumnContent && !(meLinkColumnContent = (MELinkColumnContent)columnContent).getMELinkPresentationType().equals("link-icon")) {
                Collection<ICockpitProjectData> linkedItems = DataViewLabelProvider.getLinkedModelElements(item, cockpitTypeID, modelController);
                if (meLinkColumnContent.getMELinkPresentationType().equals("link-yesno")) {
                    text = !linkedItems.isEmpty() ? Messages.getString("DataViewLabelProvider.MELinkColumnContent.IsLinkedToModelElements") : Messages.getString("DataViewLabelProvider.MELinkColumnContent.IsNotLinkedToModelElements");
                } else if (meLinkColumnContent.getMELinkPresentationType().equals("link-number")) {
                    text = Integer.toString(linkedItems.size());
                } else if (meLinkColumnContent.getMELinkPresentationType().equals("link-list")) {
                    StringBuilder textBuilder = new StringBuilder();
                    boolean first = true;
                    for (ICockpitProjectData linkedItem : linkedItems) {
                        if (first) {
                            first = false;
                        } else {
                            textBuilder.append(", ");
                        }
                        textBuilder.append(((IUniqueElement)linkedItem).getElementName());
                    }
                    text = textBuilder.toString();
                }
            }
        }
        text = StringUtil.removeNewlines((String)text);
        return text;
    }

    private static final Collection<ICockpitProjectData> getLinkedModelElements(GenericModuleData item, String cockpitTypeID, IModelController modelController) {
        String linkTypeID = GMLinkTypeHelper_Shared.getDefault(item.getGenericModuleID()).getModelElementLinkTypeID(cockpitTypeID);
        return modelController.getLinkableObjects((IModuleData)item, linkTypeID);
    }
}

