/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.genericmodule.client.gui.actions;

import com.arcway.cockpit.client.base.interfaces.frame.propertychanges.IPropertyChanges;
import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.global.gui.ProjectSelectionAnalyser;
import com.arcway.cockpit.frame.client.global.license.IClientFunctionLicenseType2;
import com.arcway.cockpit.genericmodule.client.GenericModulePlugin;
import com.arcway.cockpit.genericmodule.client.core.licensetypes.ClientFunctionLicenseTypeGMModifyItems;
import com.arcway.cockpit.genericmodule.client.core.permissions.PermissionManager;
import com.arcway.cockpit.genericmodule.client.gui.actions.GenericModuleActionDelegate;
import com.arcway.cockpit.genericmodule.client.infrastructure.resources.Messages;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.SpecificationProvider;
import com.arcway.cockpit.genericmodule.client.messages.GenericModuleData;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.cockpit.modulelib2.client.core.project.IModelController;
import com.arcway.cockpit.modulelib2.client.core.project.LockAccess;
import com.arcway.cockpit.modulelib2.client.core.project.ModuleLockManager;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import com.arcway.lib.java.collections.CollectionUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;

public class ActionDelegateDelete
extends GenericModuleActionDelegate
implements IExecutableExtension {
    private String moduleID;
    private ArrayList<GenericModuleData> currentSelection = null;
    private IModelController modelCtrl = null;
    private boolean enable = false;
    private final Runnable deletionRunnable = new Runnable(){

        @Override
        public void run() {
            ActionDelegateDelete.this.deleteItems(new HashSet(ActionDelegateDelete.this.currentSelection));
        }
    };

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.moduleID = SpecificationProvider.getDefault().getModuleID(data);
    }

    public void setInitializationData(String moduleID) {
        this.moduleID = moduleID;
    }

    public void run(IAction action) {
        assert (action != null);
        assert (this.currentSelection != null);
        assert (this.modelCtrl != null) : "modelCtrl must not be null";
        this.modelCtrl.executeTransaction(this.deletionRunnable);
    }

    private void deleteItems(Set<GenericModuleData> items) {
        assert (this.modelCtrl != null);
        PermissionManager permissionMgr = (PermissionManager)this.modelCtrl.getPermissionMgr();
        boolean hasPermission = permissionMgr.mayDelete(items);
        if (!hasPermission) {
            permissionMgr.showNoPermissionMsg(this.getIssuingShell());
            return;
        }
        ModuleLockManager lockMgr = (ModuleLockManager)this.modelCtrl.getLockMgr();
        ArrayList<LockAccess> aquiredLocks = new ArrayList<LockAccess>();
        for (GenericModuleData item : items) {
            LockAccess lock = lockMgr.acquireRemoveLock((ICockpitProjectData)item);
            if (!lock.hasLock()) {
                this.releaseLocks(aquiredLocks);
                return;
            }
            aquiredLocks.add(lock);
        }
        ArrayList subItemsToBeDeleted = new ArrayList();
        for (GenericModuleData toDelete : items) {
            subItemsToBeDeleted.addAll(CollectionUtils.getTypedCollection((Collection)this.modelCtrl.getAllDescendants((IModuleData)toDelete), GenericModuleData.class));
        }
        items.addAll(subItemsToBeDeleted);
        MessageDialog messageDialog = new MessageDialog(this.getIssuingShell(), Messages.getString("ActionDelegateDelete.Confirmation.Title"), null, Messages.getString("ActionDelegateDelete.Confirmation.Message"), 4, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
        if (messageDialog.open() == 0) {
            this.modelCtrl.deleteItems(items);
        } else {
            this.releaseLocks(aquiredLocks);
        }
    }

    private void releaseLocks(Collection<LockAccess> aquiredLocks) {
        for (LockAccess currentLock : aquiredLocks) {
            currentLock.releaseLocks();
        }
    }

    public boolean determineEnabledStatus(ISelection selection) {
        IStructuredSelection selectionContent;
        String projectUid;
        this.enable = false;
        if (selection != null && selection instanceof IStructuredSelection && (projectUid = ProjectSelectionAnalyser.extractProjectUID((ISelection)(selectionContent = (IStructuredSelection)selection))) != null) {
            if (!ProjectMgr.getProjectMgr().getProjectAgent(projectUid).isOpened()) {
                if (this.currentSelection != null) {
                    this.currentSelection.clear();
                }
            } else {
                this.modelCtrl = GenericModulePlugin.getDefault().getProjectManager(this.moduleID).getModelController(projectUid);
                if (this.modelCtrl != null) {
                    PermissionManager permissionManager = (PermissionManager)this.modelCtrl.getPermissionMgr();
                    this.currentSelection = new ArrayList();
                    for (Object nextSelectionElement : selectionContent.toList()) {
                        if (nextSelectionElement instanceof GenericModuleData) {
                            GenericModuleData item = (GenericModuleData)((Object)nextSelectionElement);
                            if (permissionManager.mayDelete(item)) {
                                this.currentSelection.add(item);
                                continue;
                            }
                            this.currentSelection.clear();
                            break;
                        }
                        this.currentSelection.clear();
                        break;
                    }
                    if (this.currentSelection.size() > 0) {
                        this.enable = true;
                    }
                }
            }
        }
        return this.enable;
    }

    protected boolean determineEnabledStatus(String newProjectUID) {
        this.modelCtrl = GenericModulePlugin.getDefault().getProjectManager(this.moduleID).getModelController(newProjectUID);
        return this.enable;
    }

    protected <T> boolean determineEnabledStatus(IPropertyChanges<T> changes, Class<T> clazz) {
        if (this.currentSelection != null) {
            this.currentSelection.removeAll(changes.getDeletedElements());
        }
        return this.enable;
    }

    @Override
    protected String getModuleID() {
        return this.moduleID;
    }

    protected IClientFunctionLicenseType2 getRequiredLicenseType() {
        return ClientFunctionLicenseTypeGMModifyItems.getInstance(this.moduleID);
    }
}

