/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.genericmodule.client.gui;

import com.arcway.cockpit.client.base.interfaces.frame.gui.DetailsElement;
import com.arcway.cockpit.cockpitlib.client.filter.AbstractBooleanValueFilter;
import com.arcway.cockpit.cockpitlib.client.filter.AbstractDateValuesFilter;
import com.arcway.cockpit.cockpitlib.client.filter.AbstractDiscreteValueFilter;
import com.arcway.cockpit.cockpitlib.client.filter.AbstractDurationFilter;
import com.arcway.cockpit.cockpitlib.client.filter.AbstractIntegerFilter;
import com.arcway.cockpit.cockpitlib.client.filter.AbstractTextValuesFilter;
import com.arcway.cockpit.cockpitlib.client.filter.gui.BooleanFilterItem;
import com.arcway.cockpit.cockpitlib.client.filter.gui.DateFilterItem;
import com.arcway.cockpit.cockpitlib.client.filter.gui.DiscreteValueListFilterItem;
import com.arcway.cockpit.cockpitlib.client.filter.gui.DurationFilterItem;
import com.arcway.cockpit.cockpitlib.client.filter.gui.IFilterItem;
import com.arcway.cockpit.cockpitlib.client.filter.gui.IntegerFilterItem;
import com.arcway.cockpit.frame.client.global.gui.views.details.DetailsView;
import com.arcway.cockpit.frame.client.global.gui.views.details.element.DetailsElementList;
import com.arcway.cockpit.frame.client.global.gui.views.details.element.DetailsElementMulti;
import com.arcway.cockpit.frame.client.global.gui.views.details.element.DetailsElementSingle;
import com.arcway.cockpit.frame.client.global.gui.views.details.element.ListEntryParameter;
import com.arcway.cockpit.frame.client.global.gui.views.details.value.DetailsValueList;
import com.arcway.cockpit.frame.client.global.gui.views.details.value.DetailsValueMulti;
import com.arcway.cockpit.frame.client.global.gui.views.details.value.DetailsValueSingle;
import com.arcway.cockpit.frame.client.lib.dataviews.util.IModuleProjectSwitchListenerManager;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.filters.ObjectTypeCategoryFilter;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.filters.ObjectTypeCategoryTableListFilterItem;
import com.arcway.cockpit.genericmodule.client.GenericModulePlugin;
import com.arcway.cockpit.genericmodule.client.core.ClientDataFactory_TypesHelper;
import com.arcway.cockpit.genericmodule.client.core.GMLinkTypeHelper_Shared;
import com.arcway.cockpit.genericmodule.client.infrastructure.SpecificationConstantsHelper;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.Attribute;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.CalculatedAttribute;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.EnumerationAttribute;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.IDAttribute;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.LinkedFrameDataAttribute;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.LinkedModuleDataAttribute;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.ObjectType;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.SimpleAttribute;
import com.arcway.cockpit.genericmodule.client.messages.GenericModuleData;
import com.arcway.cockpit.genericmodule.client.messages.description.GenericModuleDataTypeDescription;
import com.arcway.cockpit.modulelib2.client.core.IModelControllerProvider;
import com.arcway.cockpit.modulelib2.client.core.project.IModelController;
import com.arcway.cockpit.modulelib2.client.gui.filters.AbstractStringValueFilter;
import com.arcway.cockpit.modulelib2.client.gui.filters.LinkedFrameDataTableListFilterItem;
import com.arcway.cockpit.modulelib2.client.gui.filters.ModuleDataTableListFilterItem;
import com.arcway.cockpit.modulelib2.client.gui.filters.StringValueFilterItem;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import com.arcway.cockpit.modulelib2.client.messages.attributes.IModuleDataAttribute;
import com.arcway.cockpit.modulelib2.client.messages.attributes.ModuleDataAttributeBoolean;
import com.arcway.cockpit.modulelib2.client.messages.attributes.ModuleDataAttributeDiscrete;
import com.arcway.cockpit.modulelib2.client.messages.attributes.ModuleDataAttributeDuration;
import com.arcway.cockpit.modulelib2.client.messages.attributes.ModuleDataAttributeInteger;
import com.arcway.cockpit.modulelib2.client.messages.attributes.ModuleDataAttributeLong;
import com.arcway.cockpit.modulelib2.client.messages.attributes.ModuleDataAttributePath;
import com.arcway.cockpit.modulelib2.client.messages.attributes.ModuleDataAttributeString;
import com.arcway.cockpit.modulelib2.client.messages.attributes.ModuleDataAttributeTimestamp;
import com.arcway.cockpit.modulelib2.client.messages.attributes.ModuleDataAttributeUser;
import com.arcway.cockpit.modulelib2.client.platformadapter.helper.RepositoryIDCreator;
import com.arcway.cockpit.modulelib2.client.util.LabelProvider;
import com.arcway.frontend.definition.lib.interFace.declaration.label.Condition;
import com.arcway.frontend.definition.lib.interFace.declaration.label.ConditionAnd;
import com.arcway.frontend.definition.lib.interFace.declaration.label.ConditionOr;
import com.arcway.frontend.definition.lib.interFace.declaration.label.ConditionValuesAreEqual;
import com.arcway.frontend.definition.lib.interFace.declaration.label.Text;
import com.arcway.frontend.definition.lib.interFace.declaration.label.TextConcatenation;
import com.arcway.frontend.definition.lib.interFace.declaration.label.TextConstant;
import com.arcway.frontend.definition.lib.interFace.declaration.label.TextIf;
import com.arcway.frontend.definition.lib.interFace.declaration.label.TextObjectTypeName;
import com.arcway.frontend.definition.lib.interFace.declaration.label.TextPropertyValue;
import com.arcway.frontend.definition.lib.interFace.declaration.label.Value;
import com.arcway.frontend.definition.lib.interFace.declaration.label.ValueConstantForProperty;
import com.arcway.frontend.definition.lib.interFace.declaration.label.ValuePropertyValue;
import com.arcway.frontend.definition.lib.interFace.label.IExpiringFrontendLabel;
import com.arcway.lib.eclipse.file.UrlLauncher;
import com.arcway.lib.ui.editor.ObjectTypeCategoryLabels;
import com.arcway.repository.interFace.data.data.IRepositoryData;
import com.arcway.repository.interFace.declaration.type.property.IRepositoryPropertyTypeID;
import com.arcway.repository.lib.high.declaration.type.object.RepositoryObjectTypeID;
import com.arcway.repository.lib.high.registration.data.lib.RDTDisplayName;
import de.plans.lib.util.LongComparator;
import de.plans.lib.util.valueranges.DiscreteValue;
import de.plans.lib.util.valueranges.IString;
import de.plans.lib.util.valueranges.IValueRangeHelperText;
import de.plans.lib.util.valueranges.ValueRangeHelperString;
import java.io.File;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import org.eclipse.core.runtime.Path;
import org.eclipse.ui.IWorkbenchPage;

public class AttributeUIHelper {
    public static DetailsElement getDetailsElement(String id, String attributeDataType, String attributeName, IModuleDataAttribute attribute, final DetailsView containingDetailsView) {
        if (attributeDataType.equals("datatype_meta_enumeration")) {
            return new DetailsElementSingle(id, attributeName, new DetailsValueSingle(((ModuleDataAttributeDiscrete)attribute).getDisplayStringRepresentation()));
        }
        if (attributeDataType.equals("datatype_mda_string_single")) {
            return new DetailsElementSingle(id, attributeName, new DetailsValueSingle(((ModuleDataAttributeString)attribute).getDisplayStringRepresentation()));
        }
        if (attributeDataType.equals("datatype_mda_string_multi")) {
            return new DetailsElementMulti(id, attributeName, new DetailsValueMulti(((ModuleDataAttributeString)attribute).getDisplayStringRepresentation()), true);
        }
        if (attributeDataType.equals("datatype_mda_integer")) {
            return new DetailsElementSingle(id, attributeName, new DetailsValueSingle(((ModuleDataAttributeInteger)attribute).getDisplayStringRepresentation()));
        }
        if (attributeDataType.equals("datatype_mda_long")) {
            return new DetailsElementSingle(id, attributeName, new DetailsValueSingle(((ModuleDataAttributeLong)attribute).getDisplayStringRepresentation()));
        }
        if (attributeDataType.equals("datatype_mda_user")) {
            return new DetailsElementSingle(id, attributeName, new DetailsValueSingle(((ModuleDataAttributeUser)attribute).getDisplayStringRepresentation()));
        }
        if (attributeDataType.equals("datatype_mda_timestamp_dateandtime")) {
            return new DetailsElementSingle(id, attributeName, new DetailsValueSingle(((ModuleDataAttributeTimestamp)attribute).getDisplayStringRepresentation()));
        }
        if (attributeDataType.equals("datatype_mda_timestamp_dateonly")) {
            return new DetailsElementSingle(id, attributeName, new DetailsValueSingle(((ModuleDataAttributeTimestamp)attribute).getDisplayStringRepresentation()));
        }
        if (attributeDataType.equals("datatype_mda_duration_minutes")) {
            return new DetailsElementSingle(id, attributeName, new DetailsValueSingle(((ModuleDataAttributeDuration)attribute).getDisplayStringRepresentation()));
        }
        if (attributeDataType.equals("datatype_mda_duration_hours")) {
            return new DetailsElementSingle(id, attributeName, new DetailsValueSingle(((ModuleDataAttributeDuration)attribute).getDisplayStringRepresentation()));
        }
        if (attributeDataType.equals("datatype_mda_duration_workingdays")) {
            return new DetailsElementSingle(id, attributeName, new DetailsValueSingle(((ModuleDataAttributeDuration)attribute).getDisplayStringRepresentation()));
        }
        if (attributeDataType.equals("datatype_mda_path")) {
            DetailsValueList detailsValuePath = new DetailsValueList();
            final String url = ((ModuleDataAttributePath)attribute).getDisplayStringRepresentation();
            detailsValuePath.addListElement(url, null, new ListEntryParameter(new Runnable(){

                @Override
                public void run() {
                    Path location = new Path(url);
                    UrlLauncher.launchFile_noEx((File)location.toFile(), (IWorkbenchPage)containingDetailsView.getViewSite().getPage());
                }
            }, null, null));
            return new DetailsElementList(id, attributeName, detailsValuePath);
        }
        if (attributeDataType.equals("datatype_mda_boolean")) {
            return new DetailsElementSingle(id, attributeName, new DetailsValueSingle(((ModuleDataAttributeBoolean)attribute).getDisplayStringRepresentation()));
        }
        assert (false);
        return null;
    }

    public static DetailsElement getLinkedModuleDataAttributeDetailsElement(String id, String attributeName, IModuleData moduleData) {
        if (moduleData != null) {
            return new DetailsElementSingle(id, attributeName, new DetailsValueSingle(moduleData.getDisplayRepresentation()));
        }
        return new DetailsElementSingle(id, attributeName, new DetailsValueSingle(""));
    }

    public static DetailsElement getLinkedFrameDataAttributeDetailsElement(String id, String attributeName, String label) {
        if (label != null) {
            return new DetailsElementSingle(id, attributeName, new DetailsValueSingle(label));
        }
        return new DetailsElementSingle(id, attributeName, new DetailsValueSingle(""));
    }

    public static Comparator<Object> getComparator(String attributeDataType) {
        if (attributeDataType.equals("datatype_meta_enumeration")) {
            return new Comparator<Object>(){

                @Override
                public int compare(Object o1, Object o2) {
                    return ((ModuleDataAttributeDiscrete)o1).getValue() - ((ModuleDataAttributeDiscrete)o2).getValue();
                }
            };
        }
        if (attributeDataType.equals("datatype_meta_linkedmoduledata")) {
            return new Comparator<Object>(){

                @Override
                public int compare(Object o1, Object o2) {
                    if (o1 == null && o2 == null) {
                        return 0;
                    }
                    if (o1 == null) {
                        return 1;
                    }
                    if (o2 == null) {
                        return -1;
                    }
                    return ((IModuleData)o1).getDisplayRepresentation().compareToIgnoreCase(((IModuleData)o2).getDisplayRepresentation());
                }
            };
        }
        if (attributeDataType.equals("datatype_virtual_linkedframedata")) {
            return new Comparator<Object>(){

                @Override
                public int compare(Object o1, Object o2) {
                    if (o1 == null && o2 == null) {
                        return 0;
                    }
                    if (o1 == null) {
                        return 1;
                    }
                    if (o2 == null) {
                        return -1;
                    }
                    return ((String)o1).compareToIgnoreCase((String)o2);
                }
            };
        }
        if (attributeDataType.equals("datatype_mda_string_single")) {
            return new Comparator<Object>(){

                @Override
                public int compare(Object o1, Object o2) {
                    return ((ModuleDataAttributeString)o1).getDisplayStringRepresentation().compareToIgnoreCase(((ModuleDataAttributeString)o2).getDisplayStringRepresentation());
                }
            };
        }
        if (attributeDataType.equals("datatype_mda_string_multi")) {
            return new Comparator<Object>(){

                @Override
                public int compare(Object o1, Object o2) {
                    return ((ModuleDataAttributeString)o1).getDisplayStringRepresentation().compareToIgnoreCase(((ModuleDataAttributeString)o2).getDisplayStringRepresentation());
                }
            };
        }
        if (attributeDataType.equals("datatype_mda_integer")) {
            return new Comparator<Object>(){

                @Override
                public int compare(Object o1, Object o2) {
                    return ((ModuleDataAttributeInteger)o1).getValue() - ((ModuleDataAttributeInteger)o2).getValue();
                }
            };
        }
        if (attributeDataType.equals("datatype_mda_long")) {
            return new Comparator<Object>(){

                @Override
                public int compare(Object o1, Object o2) {
                    long value2;
                    long value1 = ((ModuleDataAttributeLong)o1).getValue();
                    return value1 < (value2 = ((ModuleDataAttributeLong)o2).getValue().longValue()) ? -1 : (value1 > value2 ? 1 : 0);
                }
            };
        }
        if (attributeDataType.equals("datatype_mda_user")) {
            return new Comparator<Object>(){

                @Override
                public int compare(Object o1, Object o2) {
                    return ((ModuleDataAttributeUser)o1).getDisplayStringRepresentation().compareToIgnoreCase(((ModuleDataAttributeUser)o2).getDisplayStringRepresentation());
                }
            };
        }
        if (attributeDataType.equals("datatype_mda_timestamp_dateandtime") || attributeDataType.equals("datatype_mda_timestamp_dateonly")) {
            return new Comparator<Object>(){

                @Override
                public int compare(Object o1, Object o2) {
                    ModuleDataAttributeTimestamp value1 = (ModuleDataAttributeTimestamp)o1;
                    ModuleDataAttributeTimestamp value2 = (ModuleDataAttributeTimestamp)o2;
                    return LongComparator.getDefault().compare((Object)value1, (Object)value2);
                }
            };
        }
        if (attributeDataType.equals("datatype_mda_duration_minutes")) {
            return new Comparator<Object>(){

                @Override
                public int compare(Object o1, Object o2) {
                    long value1 = ((ModuleDataAttributeDuration)o1).getValue();
                    long value2 = ((ModuleDataAttributeDuration)o2).getValue();
                    return (value1 -= value1 % 60000L) < (value2 -= value2 % 60000L) ? -1 : (value1 > value2 ? 1 : 0);
                }
            };
        }
        if (attributeDataType.equals("datatype_mda_duration_hours")) {
            return new Comparator<Object>(){

                @Override
                public int compare(Object o1, Object o2) {
                    long value1 = ((ModuleDataAttributeDuration)o1).getValue();
                    long value2 = ((ModuleDataAttributeDuration)o2).getValue();
                    return (value1 -= value1 % 3600000L) < (value2 -= value2 % 3600000L) ? -1 : (value1 > value2 ? 1 : 0);
                }
            };
        }
        if (attributeDataType.equals("datatype_mda_duration_workingdays")) {
            return new Comparator<Object>(){

                @Override
                public int compare(Object o1, Object o2) {
                    long value1 = ((ModuleDataAttributeDuration)o1).getValue();
                    long value2 = ((ModuleDataAttributeDuration)o2).getValue();
                    return (value1 -= value1 % 28800000L) < (value2 -= value2 % 28800000L) ? -1 : (value1 > value2 ? 1 : 0);
                }
            };
        }
        if (attributeDataType.equals("datatype_mda_path")) {
            return new Comparator<Object>(){

                @Override
                public int compare(Object o1, Object o2) {
                    return ((ModuleDataAttributePath)o1).getDisplayStringRepresentation().compareToIgnoreCase(((ModuleDataAttributePath)o2).getDisplayStringRepresentation());
                }
            };
        }
        if (attributeDataType.equals("datatype_mda_boolean")) {
            return new Comparator<Object>(){

                @Override
                public int compare(Object o1, Object o2) {
                    boolean value1 = ((ModuleDataAttributeBoolean)o1).getValue();
                    boolean value2 = ((ModuleDataAttributeBoolean)o2).getValue();
                    return !value1 && value2 ? -1 : (value1 && !value2 ? 1 : 0);
                }
            };
        }
        assert (false);
        return null;
    }

    public static IFilterItem getFilterItem(String attributeDataType, String moduleID, ObjectType objectType, final String attributeID) {
        Attribute attribute = objectType.getAttribute(attributeID);
        String attributeNameRaw = attribute instanceof IDAttribute ? ((IDAttribute)attribute).getAttributeName() : (attribute instanceof SimpleAttribute ? ((SimpleAttribute)attribute).getAttributeName() : ((CalculatedAttribute)attribute).getAttributeName());
        String filterName = String.valueOf(new LabelProvider(objectType.getObjectTypeName()).getLabel(Locale.getDefault())) + ": " + new LabelProvider(attributeNameRaw).getLabel(Locale.getDefault());
        final String objectsCockpitTypeID = ClientDataFactory_TypesHelper.getDataTypeID(moduleID, objectType.getObjectTypeID());
        final String filterID = String.valueOf(objectsCockpitTypeID) + "." + attributeID;
        if (attributeDataType.equals("datatype_mda_string_single") || attributeDataType.equals("datatype_mda_string_multi") || attributeDataType.equals("datatype_mda_user") || attributeDataType.equals("datatype_mda_path")) {
            return new StringValueFilterItem(filterName, new AbstractStringValueFilter(){

                protected IString getStringAttribute(Object element) {
                    return (IString)((GenericModuleData)((Object)element)).getAttribute(attributeID);
                }

                protected IValueRangeHelperText getValueRangeHelper() {
                    return new ValueRangeHelperString(this.filterString);
                }

                public String getFilterID() {
                    return filterID;
                }

                protected boolean isValidObjectType(Object element) {
                    return element instanceof GenericModuleData && ((GenericModuleData)((Object)element)).getTypeID().equals(objectsCockpitTypeID);
                }
            });
        }
        if (attributeDataType.equals("datatype_mda_boolean")) {
            return new BooleanFilterItem(filterName, new AbstractBooleanValueFilter(){

                protected boolean getBooleanAttribute(Object element) {
                    return ((ModuleDataAttributeBoolean)((GenericModuleData)((Object)element)).getAttribute(attributeID)).getValue();
                }

                public String getFilterID() {
                    return filterID;
                }

                protected boolean isValidObjectType(Object element) {
                    return element instanceof GenericModuleData && ((GenericModuleData)((Object)element)).getTypeID().equals(objectsCockpitTypeID);
                }
            });
        }
        if (attributeDataType.equals("datatype_mda_timestamp_dateandtime") || attributeDataType.equals("datatype_mda_timestamp_dateonly")) {
            return new DateFilterItem(filterName, new AbstractDateValuesFilter(){

                protected Timestamp getDateAttribute(Object element) {
                    return ((ModuleDataAttributeTimestamp)((GenericModuleData)((Object)element)).getAttribute(attributeID)).getValueAsTimeStamp();
                }

                public String getFilterID() {
                    return filterID;
                }

                protected boolean isValidObjectType(Object element) {
                    return element instanceof GenericModuleData && ((GenericModuleData)((Object)element)).getTypeID().equals(objectsCockpitTypeID);
                }
            });
        }
        if (attributeDataType.equals("datatype_mda_duration_minutes")) {
            return new DurationFilterItem(filterName, new AbstractDurationFilter(){

                protected long getDurationAttribute(Object objectToFilter) {
                    return ((ModuleDataAttributeDuration)((GenericModuleData)((Object)objectToFilter)).getAttribute(attributeID)).getValue();
                }

                public String getFilterID() {
                    return filterID;
                }

                protected boolean isValidObjectType(Object element) {
                    return element instanceof GenericModuleData && ((GenericModuleData)((Object)element)).getTypeID().equals(objectsCockpitTypeID);
                }
            }, 2);
        }
        if (attributeDataType.equals("datatype_mda_duration_hours")) {
            return new DurationFilterItem(filterName, new AbstractDurationFilter(){

                protected long getDurationAttribute(Object objectToFilter) {
                    return ((ModuleDataAttributeDuration)((GenericModuleData)((Object)objectToFilter)).getAttribute(attributeID)).getValue();
                }

                public String getFilterID() {
                    return filterID;
                }

                protected boolean isValidObjectType(Object element) {
                    return element instanceof GenericModuleData && ((GenericModuleData)((Object)element)).getTypeID().equals(objectsCockpitTypeID);
                }
            }, 1);
        }
        if (attributeDataType.equals("datatype_mda_duration_workingdays")) {
            return new DurationFilterItem(filterName, new AbstractDurationFilter(){

                protected long getDurationAttribute(Object objectToFilter) {
                    return ((ModuleDataAttributeDuration)((GenericModuleData)((Object)objectToFilter)).getAttribute(attributeID)).getValue();
                }

                public String getFilterID() {
                    return filterID;
                }

                protected boolean isValidObjectType(Object element) {
                    return element instanceof GenericModuleData && ((GenericModuleData)((Object)element)).getTypeID().equals(objectsCockpitTypeID);
                }
            }, 3);
        }
        if (attributeDataType.equals("datatype_mda_integer")) {
            return new IntegerFilterItem(filterName, new AbstractIntegerFilter(){

                protected long getIntegerAttribute(Object objectToFilter) {
                    return ((ModuleDataAttributeInteger)((GenericModuleData)((Object)objectToFilter)).getAttribute(attributeID)).getValue();
                }

                public String getFilterID() {
                    return filterID;
                }

                protected boolean isValidObjectType(Object element) {
                    return element instanceof GenericModuleData && ((GenericModuleData)((Object)element)).getTypeID().equals(objectsCockpitTypeID);
                }
            });
        }
        if (attributeDataType.equals("datatype_mda_long")) {
            return new IntegerFilterItem(filterName, new AbstractIntegerFilter(){

                protected long getIntegerAttribute(Object objectToFilter) {
                    return ((ModuleDataAttributeLong)((GenericModuleData)((Object)objectToFilter)).getAttribute(attributeID)).getValue();
                }

                public String getFilterID() {
                    return filterID;
                }

                protected boolean isValidObjectType(Object element) {
                    return element instanceof GenericModuleData && ((GenericModuleData)((Object)element)).getTypeID().equals(objectsCockpitTypeID);
                }
            });
        }
        assert (false);
        return null;
    }

    public static IFilterItem getEnumerationAttributeFilterItem(String moduleID, ObjectType objectType, final String attributeID, List<DiscreteValue> possibleValues) {
        String filterName = String.valueOf(new LabelProvider(objectType.getObjectTypeName()).getLabel(Locale.getDefault())) + ": " + new LabelProvider(((EnumerationAttribute)objectType.getAttribute(attributeID)).getAttributeName()).getLabel(Locale.getDefault());
        final String objectsCockpitTypeID = ClientDataFactory_TypesHelper.getDataTypeID(moduleID, objectType.getObjectTypeID());
        final String filterID = String.valueOf(objectsCockpitTypeID) + "." + attributeID;
        return new DiscreteValueListFilterItem(filterName, possibleValues, new AbstractDiscreteValueFilter(){

            protected int getDiscreteIndex(Object objectToFilter) {
                return ((ModuleDataAttributeDiscrete)((GenericModuleData)((Object)objectToFilter)).getAttribute(attributeID)).getValue();
            }

            public String getFilterID() {
                return filterID;
            }

            protected boolean isValidObjectType(Object element) {
                return element instanceof GenericModuleData && ((GenericModuleData)((Object)element)).getTypeID().equals(objectsCockpitTypeID);
            }

            public boolean isFilterProperty(Object element, String property) {
                return property.equals(attributeID);
            }
        });
    }

    public static IFilterItem getLinkedModuleDataAttributeFilterItem(final String moduleID, ObjectType objectType, final String attributeID, int operationalMode, IModelController modelController, IModuleProjectSwitchListenerManager projectSwitchListenerManager) {
        LinkedModuleDataAttribute attribute = (LinkedModuleDataAttribute)objectType.getAttribute(attributeID);
        String filterName = String.valueOf(new LabelProvider(objectType.getObjectTypeName()).getLabel(Locale.getDefault())) + ": " + new LabelProvider(attribute.getAttributeName()).getLabel(Locale.getDefault());
        final String objectsCockpitTypeID = ClientDataFactory_TypesHelper.getDataTypeID(moduleID, objectType.getObjectTypeID());
        final String filterID = String.valueOf(objectsCockpitTypeID) + "." + attributeID;
        final String attributeLinkTypeID = GMLinkTypeHelper_Shared.getDefault(moduleID).getAttributeLinkTypeID(objectsCockpitTypeID, attributeID);
        String linkedObjectTypeID = ClientDataFactory_TypesHelper.getDataTypeID(moduleID, attribute.getObjectTypeID());
        AbstractTextValuesFilter filter = new AbstractTextValuesFilter(true){

            protected String getStringAttribute(Object element) {
                GenericModuleData objectToFilter = (GenericModuleData)((Object)element);
                IModelController modelController_ = GenericModulePlugin.getDefault().getProjectManager(moduleID).getModelController(objectToFilter.getProjectUID());
                Collection linkableObjects = modelController_.getLinkableObjects((IModuleData)objectToFilter, attributeLinkTypeID);
                if (linkableObjects.size() == 1) {
                    GenericModuleData linkedAttribute = (GenericModuleData)((Object)linkableObjects.iterator().next());
                    return linkedAttribute.getDisplayRepresentation();
                }
                return null;
            }

            public String getFilterID() {
                return filterID;
            }

            protected boolean isValidObjectType(Object element) {
                return element instanceof GenericModuleData && ((GenericModuleData)((Object)element)).getTypeID().equals(objectsCockpitTypeID);
            }

            public boolean isFilterProperty(Object element, String property) {
                return property.equals(attributeID);
            }
        };
        ModuleDataTableListFilterItem filterItem = operationalMode == 1 ? new ModuleDataTableListFilterItem(filterName, linkedObjectTypeID, modelController, filter) : new ModuleDataTableListFilterItem(filterName, linkedObjectTypeID, projectSwitchListenerManager, (IModelControllerProvider)GenericModulePlugin.getDefault().getProjectManager(moduleID), filter);
        filterItem.setComparator(AttributeUIHelper.getComparator("datatype_meta_linkedmoduledata"));
        return filterItem;
    }

    public static IFilterItem getLinkedFrameDataAttributeFilterItem(final String moduleID, ObjectType objectType, final String attributeID, int operationalMode, IModelController modelController, IModuleProjectSwitchListenerManager projectSwitchListenerManager) {
        LinkedFrameDataAttribute attribute = (LinkedFrameDataAttribute)objectType.getAttribute(attributeID);
        String filterName = String.valueOf(new LabelProvider(objectType.getObjectTypeName()).getLabel(Locale.getDefault())) + ": " + new LabelProvider(attribute.getAttributeName()).getLabel(Locale.getDefault());
        final String objectsCockpitTypeID = ClientDataFactory_TypesHelper.getDataTypeID(moduleID, objectType.getObjectTypeID());
        String attributesCockpitTypeID = SpecificationConstantsHelper.getCockpitDataTypeIDForLinkedFrameObjectType(attribute.getFrameObjectTypeID());
        final String filterID = String.valueOf(objectsCockpitTypeID) + "." + attributeID;
        AbstractTextValuesFilter filter = new AbstractTextValuesFilter(true){

            protected String getStringAttribute(Object element) {
                GenericModuleData objectToFilter = (GenericModuleData)((Object)element);
                IModelController modelController_ = GenericModulePlugin.getDefault().getProjectManager(moduleID).getModelController(objectToFilter.getProjectUID());
                IExpiringFrontendLabel label = modelController_.getPlatformAccessAgent().getLabelOfLinkedFrameDataItem((IModuleData)objectToFilter, attributeID);
                return label != null && label.getText() != null ? label.getText() : "";
            }

            public String getFilterID() {
                return filterID;
            }

            protected boolean isValidObjectType(Object element) {
                return element instanceof GenericModuleData && ((GenericModuleData)((Object)element)).getTypeID().equals(objectsCockpitTypeID);
            }

            public boolean isFilterProperty(Object element, String property) {
                return property.equals(attributeID);
            }
        };
        LinkedFrameDataTableListFilterItem filterItem = operationalMode == 1 ? new LinkedFrameDataTableListFilterItem(filterName, attributesCockpitTypeID, modelController, filter) : new LinkedFrameDataTableListFilterItem(filterName, attributesCockpitTypeID, projectSwitchListenerManager, (IModelControllerProvider)GenericModulePlugin.getDefault().getProjectManager(moduleID), filter);
        filterItem.setComparator(AttributeUIHelper.getComparator("datatype_virtual_linkedframedata"));
        return filterItem;
    }

    public static IFilterItem getObjectTypeCategoryFilterItem(String moduleID, ObjectType objectType, int operationalMode, IModelController modelController, IModuleProjectSwitchListenerManager projectSwitchListenerManager) {
        String filterName = String.valueOf(new LabelProvider(objectType.getObjectTypeName()).getLabel(Locale.getDefault())) + ": " + ObjectTypeCategoryLabels.LABEL_CATEGORY;
        String objectsCockpitTypeID = ClientDataFactory_TypesHelper.getDataTypeID(moduleID, objectType.getObjectTypeID());
        ObjectTypeCategoryFilter filter = new ObjectTypeCategoryFilter(objectsCockpitTypeID);
        ObjectTypeCategoryTableListFilterItem filterItem = operationalMode == 1 ? new ObjectTypeCategoryTableListFilterItem(filterName, objectsCockpitTypeID, modelController.getProjectAgent(), (AbstractTextValuesFilter)filter) : new ObjectTypeCategoryTableListFilterItem(filterName, objectsCockpitTypeID, projectSwitchListenerManager, (AbstractTextValuesFilter)filter);
        return filterItem;
    }

    public static int getExportFormatHint(String moduleID, ObjectType objectType, String attributeID) {
        IModuleData instance = GenericModuleDataTypeDescription.getTypeDescription(moduleID, objectType).getDummyInstance();
        IModuleDataAttribute attribute = instance.getAttribute(attributeID);
        if (attribute instanceof ModuleDataAttributeString && ((ModuleDataAttributeString)attribute).getType() == 2) {
            return 1;
        }
        if (attribute instanceof ModuleDataAttributeInteger || attribute instanceof ModuleDataAttributeLong) {
            return 2;
        }
        if (attribute instanceof ModuleDataAttributeTimestamp) {
            return 4;
        }
        return 0;
    }

    public static Text getPlatformLabelSpecificationForCalculatedAttribute(String moduleID, String objectTypeID, CalculatedAttribute attribute, RepositoryIDCreator repositoryIDCreator) {
        if (attribute.getCalculationTypeID().equals("string-constant")) {
            return AttributeUIHelper.getPlatformLabelSpecificationForCalculatedAttribute_Constant(attribute);
        }
        if (attribute.getCalculationTypeID().equals("string-objecttypename")) {
            return AttributeUIHelper.getPlatformLabelSpecificationForCalculatedAttribute_ObjectTypeName();
        }
        if (attribute.getCalculationTypeID().equals("string-concatenation-dash")) {
            return AttributeUIHelper.getPlatformLabelSpecificationForCalculatedAttribute_Concatenation(moduleID, objectTypeID, attribute, " - ", repositoryIDCreator);
        }
        if (attribute.getCalculationTypeID().equals("string-concatenation-space")) {
            return AttributeUIHelper.getPlatformLabelSpecificationForCalculatedAttribute_Concatenation(moduleID, objectTypeID, attribute, " ", repositoryIDCreator);
        }
        if (attribute.getCalculationTypeID().equals("string-concatenation-version")) {
            return AttributeUIHelper.getPlatformLabelSpecificationForCalculatedAttribute_ConcatenationVersion(moduleID, objectTypeID, attribute, repositoryIDCreator);
        }
        if (attribute.getCalculationTypeID().equals("string-concatenation-immediate")) {
            return AttributeUIHelper.getPlatformLabelSpecificationForCalculatedAttribute_Concatenation(moduleID, objectTypeID, attribute, "", repositoryIDCreator);
        }
        return null;
    }

    private static Text getPlatformLabelSpecificationForCalculatedAttribute_Concatenation(String moduleID, String objectTypeID, CalculatedAttribute attribute, String separator, RepositoryIDCreator repositoryIDCreator) {
        String dataTypeID = ClientDataFactory_TypesHelper.getDataTypeID(moduleID, objectTypeID);
        RepositoryObjectTypeID repositoryObjectTypeID = repositoryIDCreator.createObjectTypeIDForRealType(dataTypeID);
        String paramAttributeID1 = attribute.getParameter1();
        IRepositoryPropertyTypeID paramPlatformPropertyID1 = repositoryIDCreator.createPropertyTypeIDForAttribute(repositoryObjectTypeID, paramAttributeID1);
        String paramAttributeID2 = attribute.getParameter2();
        IRepositoryPropertyTypeID paramPlatformPropertyID2 = repositoryIDCreator.createPropertyTypeIDForAttribute(repositoryObjectTypeID, paramAttributeID2);
        return new TextConcatenation(new Text[]{new TextPropertyValue(paramPlatformPropertyID1), new TextConstant(separator), new TextPropertyValue(paramPlatformPropertyID2)});
    }

    private static Text getPlatformLabelSpecificationForCalculatedAttribute_ConcatenationVersion(String moduleID, String objectTypeID, CalculatedAttribute attribute, RepositoryIDCreator repositoryIDCreator) {
        String dataTypeID = ClientDataFactory_TypesHelper.getDataTypeID(moduleID, objectTypeID);
        RepositoryObjectTypeID repositoryObjectTypeID = repositoryIDCreator.createObjectTypeIDForRealType(dataTypeID);
        TextConstant separator = new TextConstant(".");
        TextConstant padderMajor = new TextConstant("0");
        TextConstant padderMinor = new TextConstant(".0");
        IRepositoryData dataForEmptyString = RDTDisplayName.getInstance().createData("");
        IRepositoryData dataForNullString = RDTDisplayName.getInstance().createData(null);
        String paramAttributeID3 = attribute.getParameter3();
        IRepositoryPropertyTypeID paramPlatformPropertyID3 = repositoryIDCreator.createPropertyTypeIDForAttribute(repositoryObjectTypeID, paramAttributeID3);
        ValuePropertyValue value3 = new ValuePropertyValue(paramPlatformPropertyID3);
        ValueConstantForProperty noText3 = new ValueConstantForProperty(paramPlatformPropertyID3, dataForNullString);
        ValueConstantForProperty emptyText3 = new ValueConstantForProperty(paramPlatformPropertyID3, dataForEmptyString);
        ConditionOr segment3IsAbsent = new ConditionOr(new Condition[]{new ConditionValuesAreEqual((Value)value3, (Value)noText3), new ConditionValuesAreEqual((Value)value3, (Value)emptyText3)});
        TextIf segment3 = new TextIf((Condition)segment3IsAbsent, (Text)TextConstant.NO_TEXT, (Text)new TextConcatenation(new Text[]{separator, new TextPropertyValue(paramPlatformPropertyID3)}));
        String paramAttributeID2 = attribute.getParameter2();
        IRepositoryPropertyTypeID paramPlatformPropertyID2 = repositoryIDCreator.createPropertyTypeIDForAttribute(repositoryObjectTypeID, paramAttributeID2);
        ValuePropertyValue value2 = new ValuePropertyValue(paramPlatformPropertyID2);
        ValueConstantForProperty noText2 = new ValueConstantForProperty(paramPlatformPropertyID2, dataForNullString);
        ValueConstantForProperty emptyText2 = new ValueConstantForProperty(paramPlatformPropertyID2, dataForEmptyString);
        ConditionOr segment2IsAbsent = new ConditionOr(new Condition[]{new ConditionValuesAreEqual((Value)value2, (Value)noText2), new ConditionValuesAreEqual((Value)value2, (Value)emptyText2)});
        ConditionAnd segments2And3AreAbsent = new ConditionAnd(new Condition[]{segment2IsAbsent, segment3IsAbsent});
        TextIf segment2And3 = new TextIf((Condition)segments2And3AreAbsent, (Text)TextConstant.NO_TEXT, (Text)new TextIf((Condition)segment2IsAbsent, (Text)new TextConcatenation(new Text[]{padderMinor, segment3}), (Text)new TextConcatenation(new Text[]{separator, new TextPropertyValue(paramPlatformPropertyID2), segment3})));
        String paramAttributeID1 = attribute.getParameter1();
        IRepositoryPropertyTypeID paramPlatformPropertyID1 = repositoryIDCreator.createPropertyTypeIDForAttribute(repositoryObjectTypeID, paramAttributeID1);
        ValuePropertyValue value1 = new ValuePropertyValue(paramPlatformPropertyID1);
        ValueConstantForProperty noText1 = new ValueConstantForProperty(paramPlatformPropertyID1, dataForNullString);
        ValueConstantForProperty emptyText1 = new ValueConstantForProperty(paramPlatformPropertyID1, dataForEmptyString);
        ConditionOr segment1IsAbsent = new ConditionOr(new Condition[]{new ConditionValuesAreEqual((Value)value1, (Value)noText1), new ConditionValuesAreEqual((Value)value1, (Value)emptyText1)});
        ConditionAnd segments1And2And3AreAbsent = new ConditionAnd(new Condition[]{segment1IsAbsent, segments2And3AreAbsent});
        TextIf segment1And2And3 = new TextIf((Condition)segments1And2And3AreAbsent, (Text)TextConstant.NO_TEXT, (Text)new TextIf((Condition)segment1IsAbsent, (Text)new TextConcatenation(new Text[]{padderMajor, segment2And3}), (Text)new TextConcatenation(new Text[]{new TextPropertyValue(paramPlatformPropertyID1), segment2And3})));
        return segment1And2And3;
    }

    private static Text getPlatformLabelSpecificationForCalculatedAttribute_Constant(CalculatedAttribute attribute) {
        String constant = attribute.getParameter1();
        return new TextConstant(constant);
    }

    private static Text getPlatformLabelSpecificationForCalculatedAttribute_ObjectTypeName() {
        return new TextObjectTypeName();
    }
}

