/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.framestandaloneserverproxywithcommit;

import com.arcway.cockpit.frame.client.global.FramePlugin;
import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.global.license.IClientFunctionLicenseType;
import com.arcway.cockpit.frame.client.global.license.licensetypes.ClientFunctionLicenseTypeProjectsLoad;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.core.files.FileID;
import com.arcway.cockpit.frame.client.project.core.serverproxy.IFrameServerProxy;
import com.arcway.cockpit.frame.client.project.core.serverproxy.ServerDataContainer;
import com.arcway.cockpit.frame.client.project.datainterchange.ProjectFileAccess;
import com.arcway.cockpit.frame.client.project.datainterchange.ProjectFileFormatVersionIncompatibleException;
import com.arcway.cockpit.frame.client.project.offlinemode.exceptions.EXOfflineDataNotAvailable;
import com.arcway.cockpit.frame.client.project.offlinemode.exceptions.EXOfflineMode;
import com.arcway.cockpit.frame.shared.message.EOCockpitProjectData;
import com.arcway.cockpit.frame.shared.message.EOCommit;
import com.arcway.cockpit.frame.shared.message.EOFrameDataModification;
import com.arcway.cockpit.frame.shared.message.EOGenericCockpitDatabaseData;
import com.arcway.cockpit.frame.shared.message.EOLock;
import com.arcway.cockpit.frame.shared.message.genericframedata.EOFrameData;
import com.arcway.cockpit.frame.shared.serverexceptions.EXPendingAsynchronousUpdates;
import com.arcway.cockpit.framestandaloneserverproxywithcommit.DummyUser;
import com.arcway.cockpit.framestandaloneserverproxywithcommit.Messages;
import com.arcway.lib.UUIDGenerator;
import com.arcway.lib.eclipse.gui.dialogs.FileChooserDialog;
import com.arcway.lib.io.DataCopyHelper;
import com.arcway.lib.io.FileHelper;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.memento.IArcwayMemento;
import com.arcway.lib.resource.JvmExternalResourceInteractionException;
import com.arcway.repository.cockpitadapter.EOCommitCountAndCommitInformation;
import com.arcway.repository.cockpitadapter.EOCommitInformation;
import com.arcway.repository.cockpitadapter.EOUserInformation;
import com.arcway.repository.cockpitadapter.locks.EOPlatformLock;
import de.plans.lib.eclipse.JFaceProgressMonitorToProgressDisplayAdapter;
import de.plans.lib.util.INotificationBusListener;
import de.plans.lib.util.Zip;
import de.plans.lib.util.gui.IProgressDisplay;
import de.plans.lib.xml.encoding.EOList;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.psc.client.communication.ExPrematureEndOfTransfer;
import de.plans.psc.client.communication.LoginCanceledException;
import de.plans.psc.client.communication.ServerConnection;
import de.plans.psc.client.communication.ServerNotAvailableException;
import de.plans.psc.client.communication.UnknownServerException;
import de.plans.psc.shared.message.EOClientRequest;
import de.plans.psc.shared.message.EOException;
import de.plans.psc.shared.message.EOGroup;
import de.plans.psc.shared.message.EOPermission;
import de.plans.psc.shared.message.EOServerResponse;
import de.plans.psc.shared.message.EOUser;
import de.plans.psc.shared.message.EOUserAndGroupAndPermissions;
import de.plans.psc.shared.message.IPermissionOwner;
import de.plans.psc.shared.serverexceptions.EXServerException;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;

public class FrameServerProxy
implements IFrameServerProxy {
    private static final ILogger logger = Logger.getLogger(FrameServerProxy.class);
    private static final String KEY_LAST_LOAD_FILE = "lastLoadFile";
    private File exportFile;
    private IFrameProjectAgent projectAgent;
    private File cacheDirectory;
    private File userSelectedFileForCommit;

    public static File getCacheDirectory(File projectRoot) {
        File cacheDirectory = new File(projectRoot, "server-cache");
        if (cacheDirectory.exists() && !cacheDirectory.isDirectory()) {
            cacheDirectory.delete();
        }
        cacheDirectory.mkdir();
        return cacheDirectory;
    }

    public static File getExportFile(File cacheDirectory, String projectUID) {
        String fileName = projectUID;
        fileName = String.valueOf(fileName) + "." + FramePlugin.getFileExtensionForProjectData();
        return new File(cacheDirectory, fileName);
    }

    public void construct(IFrameProjectAgent newProjectAgent) {
        this.projectAgent = newProjectAgent;
        this.cacheDirectory = FrameServerProxy.getCacheDirectory(newProjectAgent.getProjectRoot());
        this.exportFile = FrameServerProxy.getExportFile(newProjectAgent.getProjectRoot(), newProjectAgent.getUID());
    }

    public List<EOPermission> getAllPermissions() {
        return Collections.emptyList();
    }

    public boolean concurrentWorkPossible() {
        return false;
    }

    public boolean isCommitable() {
        return true;
    }

    public Collection<IPermissionOwner> getAllPermissionOwners() {
        return Collections.emptyList();
    }

    public Collection<EOGroup> getAllServerGroups() {
        return Collections.emptyList();
    }

    public Collection<EOUser> getAllServerUsers() {
        return Collections.emptyList();
    }

    public void downloadFile(FileID fileID, File file) throws ServerNotAvailableException, EXServerException, LoginCanceledException, UnknownServerException, ExPrematureEndOfTransfer {
        File serverFile = this.getFile(fileID);
        if (serverFile == null) {
            throw new EXServerException("standalone version", "download file", "The requested file " + fileID + " was not found!");
        }
        try {
            DataCopyHelper.copyFile((File)serverFile, (File)file);
        }
        catch (JvmExternalResourceInteractionException e) {
            throw new EXServerException("standalone version", "download file", e.getMessage());
        }
    }

    public boolean fileExistsOnServer(FileID fileID) throws ServerNotAvailableException, EXServerException, LoginCanceledException, UnknownServerException {
        File serverFile = this.getFile(fileID);
        return serverFile != null;
    }

    public void releaseLocks(Collection<EOLock> locksToBeReleased) {
    }

    public List<EOLock> getForeignLocks(Collection<EOLock> clientLocksNeededByServer, boolean considerCommitVersion) throws ServerNotAvailableException, LoginCanceledException, EXServerException, UnknownServerException {
        return Collections.emptyList();
    }

    public boolean prepareCommit(boolean useDefaultDestination, Shell parentShell) {
        this.projectAgent.saveAllEditors(parentShell, Messages.getString("FrameServerProxy.PrepareCommit.CloseEditors"), false, false, true);
        this.userSelectedFileForCommit = null;
        if (!useDefaultDestination) {
            this.userSelectedFileForCommit = FrameServerProxy.getUserFile(this.projectAgent, false, parentShell);
            if (this.userSelectedFileForCommit != null && this.userSelectedFileForCommit.exists()) {
                return MessageDialog.openQuestion((Shell)parentShell, (String)Messages.getString("FrameServerProxy.file_exists"), (String)Messages.getString("FrameServerProxy.file_will_be_overwritten"));
            }
            return this.userSelectedFileForCommit != null;
        }
        return true;
    }

    public void prepareCommit(File fileForCommit) {
        this.userSelectedFileForCommit = fileForCommit;
    }

    public EOCommit commitProject(EOCommit projectModifications, Shell parentShell) {
        Throwable exception = null;
        ProgressMonitorDialog pmd = new ProgressMonitorDialog(parentShell);
        IRunnableWithProgress rwp = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    FrameServerProxy.this.projectAgent.getFrameExportDataProvider().exportData(FrameServerProxy.this.exportFile, (IProgressDisplay)new JFaceProgressMonitorToProgressDisplayAdapter(monitor));
                }
                catch (IOException e) {
                    throw new InvocationTargetException(e);
                }
                catch (JvmExternalResourceInteractionException jeriE) {
                    throw new InvocationTargetException(jeriE.getCause() != null ? jeriE.getCause() : jeriE);
                }
            }
        };
        try {
            EOList<EOFrameDataModification<? extends EOGenericCockpitDatabaseData>> newModuleChanges;
            pmd.setOpenOnRun(true);
            pmd.run(false, false, rwp);
            EOList moduleChanges = projectModifications.getCreatedOrModifiedModuleDataChanges();
            if (moduleChanges != null) {
                newModuleChanges = FrameServerProxy.replaceRequestByResponse((EOList<EOFrameDataModification<? extends EOGenericCockpitDatabaseData>>)moduleChanges);
                projectModifications.setCreatedOrModifiedModuleDataChanges(newModuleChanges);
            }
            if ((moduleChanges = projectModifications.getDeletedModuleDataChanges()) != null) {
                newModuleChanges = FrameServerProxy.replaceRequestByResponse((EOList<EOFrameDataModification<? extends EOGenericCockpitDatabaseData>>)moduleChanges);
                projectModifications.setDeletedModuleDataChanges(newModuleChanges);
            }
            if (this.userSelectedFileForCommit != null) {
                if (this.userSelectedFileForCommit.exists() && !this.userSelectedFileForCommit.isDirectory()) {
                    FileHelper.deleteExistingFileOrDirectory((File)this.userSelectedFileForCommit);
                }
                DataCopyHelper.copyFile((File)this.exportFile, (File)this.userSelectedFileForCommit);
            }
            FileHelper.deleteContentOfDirectory((File)this.cacheDirectory);
            Zip.unzipFile((String)this.exportFile.getAbsolutePath(), (String)this.cacheDirectory.getAbsolutePath());
        }
        catch (InvocationTargetException e) {
            exception = e;
            logger.error("Error while committing data.", (Throwable)e);
        }
        catch (InterruptedException e) {
            exception = e;
            logger.error("Error while committing data.", (Throwable)e);
        }
        catch (JvmExternalResourceInteractionException e) {
            exception = e;
            logger.error("Error while committing data.", (Throwable)e);
        }
        catch (IOException e) {
            exception = e;
            logger.error("Error while committing data.", (Throwable)e);
        }
        if (exception != null) {
            String description = Messages.getString("FrameServerProxy.ErrorWhileCommittingData");
            EXServerException serverException = new EXServerException("SeriousErrorException", "Exception", description, (Exception)exception);
            EOException exceptionAsEOException = serverException.convertToEOException();
            projectModifications.setException(exceptionAsEOException);
        }
        return projectModifications;
    }

    private static EOList<EOFrameDataModification<? extends EOGenericCockpitDatabaseData>> replaceRequestByResponse(EOList<EOFrameDataModification<? extends EOGenericCockpitDatabaseData>> moduleChanges) {
        for (EOFrameDataModification mc : moduleChanges) {
            for (EOGenericCockpitDatabaseData createdModuleDataItem : mc.getCreatedData()) {
                createdModuleDataItem.setIsHistoricItem(false);
            }
            for (EOGenericCockpitDatabaseData modifiedModuleDataItem : mc.getModifiedData()) {
                modifiedModuleDataItem.setIsHistoricItem(false);
            }
        }
        return moduleChanges;
    }

    public List<String> uploadFiles(List<File> files) throws ServerNotAvailableException, EXServerException, LoginCanceledException, UnknownServerException, ExPrematureEndOfTransfer {
        ArrayList<String> transferIDs = new ArrayList<String>(files.size());
        int i = 0;
        while (i < files.size()) {
            transferIDs.add(UUIDGenerator.getUniqueID());
            ++i;
        }
        return transferIDs;
    }

    public EOUser getCurrentUser() {
        return DummyUser.getSingleUser();
    }

    public EOUserAndGroupAndPermissions getUserData(boolean forceLogin) throws ServerNotAvailableException, EXServerException, LoginCanceledException {
        EOUserAndGroupAndPermissions ugp = new EOUserAndGroupAndPermissions();
        ugp.setUser(DummyUser.getSingleUser());
        return ugp;
    }

    public void updatePermissions(Collection<EOPermission> permissionsToAdd, Collection<EOPermission> permissionsToRemove) throws ServerNotAvailableException, EXServerException, LoginCanceledException, UnknownServerException {
    }

    public List<Collection<EOLock>> atomicCheckAndSetLocks(Collection<EOLock> locksToBeChecked, Collection<EOLock> clientLocksNeededByServer, Collection<EOLock> locksToBeSet) throws ServerNotAvailableException, LoginCanceledException, EXServerException, UnknownServerException {
        ArrayList<Collection<EOLock>> list = new ArrayList<Collection<EOLock>>();
        EOList failedChecks = new EOList();
        EOList setLocks = new EOList(locksToBeSet);
        list.add((Collection<EOLock>)failedChecks);
        list.add((Collection<EOLock>)setLocks);
        return list;
    }

    public EOClientRequest subscribeListenerOnClientBusAndGetRequestToRegisterOnServer(INotificationBusListener listener, String notificationtype) {
        return null;
    }

    public void subscribeListenerOnServer(INotificationBusListener listener, String notificationtype) throws ServerNotAvailableException, EXServerException, LoginCanceledException, UnknownServerException {
    }

    public void unsubscribeListenerOnServer(INotificationBusListener listener, String notificationType) throws ServerNotAvailableException, EXServerException, LoginCanceledException, UnknownServerException {
    }

    public EOServerResponse sendRequest(String reqGroup, String reqSubID, EncodableObjectBase reqParam) throws ServerNotAvailableException, LoginCanceledException, EXServerException, UnknownServerException, EXOfflineMode {
        return null;
    }

    private static File getUserFile(IFrameProjectAgent projectAgent, boolean forLoad, Shell shell) {
        File userFile;
        File lastFile;
        FileChooserDialog dialog = null;
        String[] fileExtensions = new String[]{"*." + FramePlugin.getFileExtensionForProjectData()};
        IArcwayMemento ls = projectAgent.getFrameLocalSettings();
        String lastFileName = ls.getString(KEY_LAST_LOAD_FILE);
        if (lastFileName != null && (lastFile = new File(lastFileName)).getParentFile() != null && lastFile.getParentFile().exists() && (!forLoad || lastFile.exists())) {
            dialog = new FileChooserDialog(fileExtensions, lastFile.getParentFile(), true, shell);
            dialog.setStartFileName(lastFile.getName());
        }
        if (dialog == null) {
            dialog = new FileChooserDialog(fileExtensions, shell);
        }
        if ((userFile = forLoad ? dialog.openForLoad() : dialog.openForSave()) != null) {
            ls.putString(KEY_LAST_LOAD_FILE, userFile.toString());
        }
        return userFile;
    }

    public boolean supportsVersioning() {
        return false;
    }

    public EOFrameData getVersion(String itemUID, String typeID, int modCount, String requestGroupID) {
        throw new UnsupportedOperationException();
    }

    public List<EOCockpitProjectData> getAllVersions(String itemUID, String typeID, String requestGroupID) {
        throw new UnsupportedOperationException();
    }

    public String getAvailabilityState() {
        if (!this.projectAgent.getServerLicenseManager().isLicenseOperationAllowed((IClientFunctionLicenseType)ClientFunctionLicenseTypeProjectsLoad.getInstance())) {
            return Messages.getString("FrameServerProxy.license_expired");
        }
        return null;
    }

    public void refreshProject() throws ServerNotAvailableException, EXServerException, LoginCanceledException, UnknownServerException {
    }

    public EOList<EOPlatformLock> allocateLocks(Collection<EOPlatformLock> locksToCheck, Collection<EOPlatformLock> locksToRelease, Collection<EOPlatformLock> locksToAllocate) throws ServerNotAvailableException, EXServerException, LoginCanceledException, UnknownServerException {
        return null;
    }

    public ServerDataContainer fetchServerDataContainer(Collection<EOLock> allLocksCurrentlyAllocatedOnServer) throws EXServerException, UnknownServerException, LoginCanceledException, ServerNotAvailableException, EXOfflineDataNotAvailable, EXPendingAsynchronousUpdates {
        return null;
    }

    public ServerDataContainer setupAfterDataManagersAreCreated() throws EXServerException, UnknownServerException, LoginCanceledException, ServerNotAvailableException, EXOfflineDataNotAvailable {
        return this.createServerDataContainer();
    }

    private ServerDataContainer createServerDataContainer() {
        String serverID = this.projectAgent.getServerID();
        ServerConnection serverConnection = ProjectMgr.getProjectMgr().getServerConnectionByServerID(serverID);
        EOUserInformation currentUserInformation = new EOUserInformation(serverConnection.getDirectoryType(), serverConnection.getDirectoryNameOrURL(), serverConnection.getDistinguishedName(), serverConnection.getLoginID(), serverConnection.getRealName());
        List workspaceInformations = Collections.emptyList();
        EOList commitInformations = new EOList();
        commitInformations.add((EncodableObjectBase)new EOCommitCountAndCommitInformation(1, new EOCommitInformation("1", new Date(0L), currentUserInformation, "")));
        Map workspaceUID_locks = Collections.emptyMap();
        List lockLog = Collections.emptyList();
        EOList<EOList<? extends EncodableObjectBase>> mainData = this.loadImport();
        ServerDataContainer serverDataContainer = mainData != null ? new ServerDataContainer(this.projectAgent, commitInformations, workspaceInformations, workspaceUID_locks, lockLog, mainData) : null;
        return serverDataContainer;
    }

    private File getFile(FileID fileID) {
        String fileName;
        File file;
        File dir = new File(this.cacheDirectory, "files");
        if (dir.exists() && (file = new File(dir, fileName = fileID.getFileUID())).exists()) {
            return file;
        }
        return null;
    }

    private EOList<EOList<? extends EncodableObjectBase>> loadImport() {
        EOList mainData = null;
        if (this.exportFile != null) {
            try {
                if (this.exportFile.exists()) {
                    ProjectFileAccess preparedLoadFile = new ProjectFileAccess(this.exportFile, 2, null);
                    mainData = preparedLoadFile.getMainData();
                    FileHelper.copyDirectoryContent((File)preparedLoadFile.getRootDirectoryOfUnzippedProjectFile(), (File)this.cacheDirectory);
                    preparedLoadFile.dispose();
                }
            }
            catch (JvmExternalResourceInteractionException e) {
                logger.error("could not load file", (Throwable)e);
            }
            catch (ProjectFileAccess.ProjectFileAccessException e) {
                logger.error("could not load file", (Throwable)e);
            }
            catch (ProjectFileFormatVersionIncompatibleException e) {
                logger.error("could not load file", (Throwable)e);
            }
        }
        return mainData;
    }
}

