/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.shared.message;

import com.arcway.cockpit.frame.shared.message.EOLock;
import com.arcway.lib.java.Assert;
import de.plans.lib.xml.encoding.EOEncodableObject;
import de.plans.lib.xml.encoding.EXEncoderException;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.lib.xml.encoding.XMLContext;
import java.util.Collection;

public class EOCommitVersionUpdate
extends EOEncodableObject {
    public static final String XML_TAG = "commitVersionUpdate";
    private static final String XML_ATTRIBUTE_PROJECTUID = "projectuid";
    private static final String XML_ATTRIBUTE_COMMITUID = "commituid";
    private String projectUID;
    private String commitUID;
    private Collection<EOLock> clientLocks;

    public EOCommitVersionUpdate(String projectUID, String commitUID, Collection<EOLock> clientLocks) {
        super(XML_TAG);
        Assert.checkArgumentBeeingNotNull((Object)projectUID);
        Assert.checkArgumentBeeingNotNull((Object)commitUID);
        Assert.checkArgumentBeeingNotNull(clientLocks);
        this.commitUID = commitUID;
        this.projectUID = projectUID;
        this.clientLocks = clientLocks;
    }

    public EOCommitVersionUpdate(XMLContext xmlContext) {
        super(XML_TAG, xmlContext);
    }

    protected void appendAttributesToXML(EncodableObjectBase.WriteContext writeContext) throws EXEncoderException {
        super.appendAttrToXML(writeContext, XML_ATTRIBUTE_PROJECTUID, this.projectUID);
        super.appendAttrToXML(writeContext, XML_ATTRIBUTE_COMMITUID, this.commitUID);
    }

    protected boolean hasChildren() {
        return true;
    }

    protected boolean setAttributeFromXML(String name, String value) {
        boolean success;
        if (name.equals(XML_ATTRIBUTE_COMMITUID)) {
            this.commitUID = value;
            success = true;
        } else if (name.equals(XML_ATTRIBUTE_PROJECTUID)) {
            this.projectUID = value;
            success = true;
        } else {
            success = false;
        }
        return success;
    }

    protected void writeChildrenToXML(EncodableObjectBase.WriteContext writeContext, int depth) throws EXEncoderException {
        for (EOLock eoLock : this.clientLocks) {
            eoLock.writeXMLBody(writeContext, depth);
        }
    }

    protected boolean addChildFromXML(EncodableObjectBase newChild) {
        boolean success;
        if (newChild instanceof EOLock) {
            EOLock eoLock = (EOLock)newChild;
            this.clientLocks.add(eoLock);
            success = true;
        } else {
            success = false;
        }
        return success;
    }

    public Collection<EOLock> getClientLocks() {
        return this.clientLocks;
    }

    public String getCommitUID() {
        return this.commitUID;
    }

    public String getProjectUID() {
        return this.projectUID;
    }
}

