/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.repository.clientadapter.implementation.manager;

import com.arcway.frontend.definition.lib.interFace.declaration.FrontendAttributeSetTypeDeclaration;
import com.arcway.frontend.definition.lib.interFace.declaration.FrontendRelationContributionTypeDeclaration;
import com.arcway.frontend.definition.lib.interFace.declaration.label.FrontendLabel;
import com.arcway.lib.resource.IStreamResource;
import com.arcway.repository.clientadapter.implementation.adapter.PlatformAdapterCrossLinkRelationTypeDeclaration;
import com.arcway.repository.clientadapter.implementation.manager.Messages;
import com.arcway.repository.clientadapter.implementation.manager.PlatformAdapterModuleManager;
import com.arcway.repository.clientadapter.interFace.CardinalityType;
import com.arcway.repository.clientadapter.interFace.ILinkManagerAdapter;
import com.arcway.repository.clientadapter.interFace.IObjectTypeDeclaration;
import com.arcway.repository.clientadapter.interFace.IRelationContributionType;
import com.arcway.repository.clientadapter.interFace.IRelationTypeDeclaration;
import com.arcway.repository.interFace.declaration.type.attributeset.IRepositoryAttributeSetTypeID;
import com.arcway.repository.interFace.declaration.type.relationcontribution.IRepositoryRelationContributionRoleID;
import java.util.Locale;

class FERelationContributionDeclaration
extends FrontendRelationContributionTypeDeclaration {
    private final FrontendAttributeSetTypeDeclaration optionalAttributeSetTypeDeclaration;

    public FERelationContributionDeclaration(PlatformAdapterModuleManager platformAdapterModuleManager, IRelationTypeDeclaration relationTypeDeclaration, IRelationContributionType relationContributionType, Locale projectLanguage) {
        super(relationContributionType.getRepositoryRelationContributionRoleID(), platformAdapterModuleManager.createFrontendDeclaration(relationContributionType.getLabels(), projectLanguage));
        assert (relationTypeDeclaration != null);
        this.optionalAttributeSetTypeDeclaration = null;
    }

    public FERelationContributionDeclaration(PlatformAdapterModuleManager platformAdapterModuleManager, ILinkManagerAdapter linkManagerAdapter, IRelationContributionType relationContributionType, Locale projectLanguage) {
        super(relationContributionType.getRepositoryRelationContributionRoleID(), platformAdapterModuleManager.createFrontendDeclaration(relationContributionType.getLabels(), projectLanguage));
        if (relationContributionType.getCardinality() != CardinalityType.C0_1_AS_PROPERTY && relationContributionType.getCardinality() != CardinalityType.C1_1_AS_PROPERTY) {
            FrontendLabel attributeSetLabel;
            IRepositoryAttributeSetTypeID attributeSetTypeID = PlatformAdapterCrossLinkRelationTypeDeclaration.createAttributeSetTypeID(relationContributionType, linkManagerAdapter.getRepositoryRelationTypeID());
            if (linkManagerAdapter.getRelationContributionTypes().length == 2) {
                IRelationContributionType getRelationContributionType1 = linkManagerAdapter.getRelationContributionTypes()[0];
                IRelationContributionType getRelationContributionType2 = linkManagerAdapter.getRelationContributionTypes()[1];
                IRepositoryRelationContributionRoleID roleID1 = getRelationContributionType1.getRepositoryRelationContributionRoleID();
                IRepositoryRelationContributionRoleID thisRoleID = relationContributionType.getRepositoryRelationContributionRoleID();
                IRelationContributionType otherRelationContributionType = IRepositoryRelationContributionRoleID.IS_EQUAL_RELATION_CONTRIBUTION_ROLE_ID_HASHER.isEqual((Object)thisRoleID, (Object)roleID1) ? getRelationContributionType2 : getRelationContributionType1;
                IObjectTypeDeclaration objectTypeDeclaration = platformAdapterModuleManager.findObjectTypeDeclaration(otherRelationContributionType.getRelatedObjectTypeID());
                FrontendLabel objectTypeLabel = platformAdapterModuleManager.getInheritedObjectTypeLabel(objectTypeDeclaration, projectLanguage);
                FrontendLabel relationTypeLabel = platformAdapterModuleManager.getInheritedRelationTypeLabel(linkManagerAdapter, projectLanguage);
                FrontendLabel relationContributionTypeLabel = platformAdapterModuleManager.getInheritedRelationContributionTypeLabel(linkManagerAdapter, otherRelationContributionType.getRepositoryRelationContributionRoleID(), projectLanguage);
                String objectTypeText = objectTypeLabel.getText();
                String relationTypeText = relationTypeLabel.getText();
                String relationContributionTypeText = relationContributionTypeLabel.getText();
                String label = objectTypeText;
                if (relationTypeText != null && relationContributionTypeText != null) {
                    label = String.valueOf(label) + Messages.getString("RelationRolePart1", projectLanguage) + relationContributionTypeText + Messages.getString("RelationRolePart2", projectLanguage) + relationTypeText + Messages.getString("RelationRolePart3", projectLanguage);
                } else if (relationTypeText != null) {
                    label = String.valueOf(label) + Messages.getString("RelationRolePart4", projectLanguage) + relationTypeText + Messages.getString("RelationRolePart3", projectLanguage);
                } else if (relationContributionTypeText != null) {
                    label = String.valueOf(label) + Messages.getString("RelationRolePart1", projectLanguage) + relationContributionTypeText + Messages.getString("RelationRolePart3", projectLanguage);
                }
                IStreamResource icon16x16 = relationContributionTypeLabel.getIcon16x16();
                if (icon16x16 == null) {
                    icon16x16 = objectTypeLabel.getIcon16x16();
                }
                if (icon16x16 == null) {
                    icon16x16 = relationTypeLabel.getIcon16x16();
                }
                attributeSetLabel = new FrontendLabel(label, icon16x16);
            } else {
                FrontendLabel relationTypeLabel = platformAdapterModuleManager.getInheritedRelationTypeLabel(linkManagerAdapter, projectLanguage);
                FrontendLabel relationContributionTypeLabel = platformAdapterModuleManager.getInheritedRelationContributionTypeLabel(linkManagerAdapter, relationContributionType.getRepositoryRelationContributionRoleID(), projectLanguage);
                String relationTypeText = relationTypeLabel.getText();
                String relationContributionTypeText = relationContributionTypeLabel.getText();
                String label = relationTypeText != null && relationContributionTypeText != null ? String.valueOf(Messages.getString("RelationRolePart5", projectLanguage)) + relationContributionTypeText + Messages.getString("RelationRolePart2", projectLanguage) + relationContributionTypeText : (relationTypeText != null ? String.valueOf(Messages.getString("RelationRolePart6", projectLanguage)) + relationTypeText : (relationContributionTypeText != null ? String.valueOf(Messages.getString("RelationRolePart5", projectLanguage)) + relationContributionTypeText : null));
                attributeSetLabel = new FrontendLabel(label, relationTypeLabel.getIcon16x16());
            }
            this.optionalAttributeSetTypeDeclaration = new FrontendAttributeSetTypeDeclaration(attributeSetTypeID, attributeSetLabel);
        } else {
            this.optionalAttributeSetTypeDeclaration = null;
        }
    }

    public FrontendAttributeSetTypeDeclaration getOptionalAttributeSetTypeDeclaration() {
        return this.optionalAttributeSetTypeDeclaration;
    }
}

