/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.settings.global;

import com.arcway.cockpit.frame.client.project.ProjectAgent;
import com.arcway.cockpit.frame.client.project.settings.global.IConfigurationManager;
import com.arcway.frontend.definition.lib.implementation.type.manager.FrontendTypeManager;
import com.arcway.frontend.definition.lib.interFace.datatype.IFrontendDataType;
import com.arcway.frontend.definition.lib.interFace.label.IFrontendLabel;
import com.arcway.frontend.definition.lib.interFace.type.IFrontendPropertyType;
import com.arcway.frontend.definition.lib.interFace.type.manager.IFrontendTypeManager;
import com.arcway.lib.codec.data.EXDataLoadingException;
import com.arcway.lib.codec.data.IDataType;
import com.arcway.lib.codec.data.codecs.canonicalstring.CanonicalStringCoDecForData;
import com.arcway.lib.java.ObjectWrapper;
import com.arcway.lib.java.collections.Collections_;
import com.arcway.lib.java.locale.PresentationContext;
import com.arcway.lib.java.maps.HashMap_;
import com.arcway.lib.java.maps.IMap_;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.repository.cockpit.interFace.declaration.frame.ModuleIDNameSpace;
import com.arcway.repository.cockpit.interFace.declaration.frame.modules.COTIDsModuleData;
import com.arcway.repository.interFace.data.RepositorySamples;
import com.arcway.repository.interFace.data.attributeset.IRepositoryAttributeSet;
import com.arcway.repository.interFace.data.attributeset.IRepositoryPropertySetSample;
import com.arcway.repository.interFace.data.data.IRepositoryData;
import com.arcway.repository.interFace.data.object.DTRepositoryObjectReference;
import com.arcway.repository.interFace.data.object.IRepositoryIterator_IRepositoryObject;
import com.arcway.repository.interFace.data.object.IRepositoryObject;
import com.arcway.repository.interFace.data.object.IRepositoryObjectReference;
import com.arcway.repository.interFace.data.object.IRepositoryObjectSample;
import com.arcway.repository.interFace.data.property.IRepositoryProperty;
import com.arcway.repository.interFace.data.property.IRepositoryPropertyReference;
import com.arcway.repository.interFace.dataaccess.EXNotReproducibleSnapshot;
import com.arcway.repository.interFace.dataaccess.IRepositoryInterfaceRO;
import com.arcway.repository.interFace.dataaccess.IRepositorySnapshotRO;
import com.arcway.repository.interFace.dataaccess.IWithCurrentSnapshotProcessor;
import com.arcway.repository.interFace.dataaccess.RepositoryInterfaces;
import com.arcway.repository.interFace.dataaccess.locksandpermissions.ILockDeprecated;
import com.arcway.repository.interFace.dataaccess.locksandpermissions.exceptions.EXLockDenied;
import com.arcway.repository.interFace.dataaccess.locksandpermissions.exceptions.EXPermissionDenied;
import com.arcway.repository.interFace.declaration.data.key.KeySegment;
import com.arcway.repository.interFace.declaration.type.object.IRepositoryObjectTypeID;
import com.arcway.repository.interFace.declaration.type.property.IRepositoryPropertyTypeID;
import com.arcway.repository.interFace.implementation.workspace.IRepositoryWorkspaceRO;
import com.arcway.repository.interFace.implementation.workspace.IRepositoryWorkspaceRW;
import com.arcway.repository.interFace.registration.type.IRepositoryTypeManagerRO;
import com.arcway.repository.interFace.registration.type.attributeset.IRepositoryAttributeSetType;
import com.arcway.repository.interFace.registration.type.data.IRepositoryDataType;
import com.arcway.repository.interFace.registration.type.object.IRepositoryObjectType;
import com.arcway.repository.interFace.registration.type.property.IRepositoryPropertyType;
import com.arcway.repository.interFace.transactions.AbstractRepositoryAction;
import com.arcway.repository.interFace.transactions.IRepositoryTransaction;
import com.arcway.repository.interFace.transactions.exceptions.EXTransactionExecution;
import com.arcway.repository.lib.high.declaration.data.item.IDNameSpace;
import com.arcway.repository.lib.high.declaration.type.object.RepositoryObjectTypeID;
import com.arcway.repository.lib.high.declaration.type.property.RepositoryPropertyTypeID;
import com.arcway.repository.lib.high.genericmodifications.implementation.type.manager.GenericModificationTypeManager;
import com.arcway.repository.lib.high.genericmodifications.interFace.transactions.RSAComplexGenericModification;
import com.arcway.repository.lib.high.genericmodifications.interFace.transactions.RepositoryObjectSampleWithParentObjectReference;
import com.arcway.repository.lib.high.genericmodifications.interFace.type.IGenericModificationObjectType;
import com.arcway.repository.lib.high.genericmodifications.interFace.type.manager.IGenericModificationTypeManager;
import com.arcway.repository.lib.high.implementation.access.RepositoryObjectReference;
import com.arcway.repository.lib.high.implementation.access.RepositoryObjectSample;
import com.arcway.repository.lib.high.implementation.access.RepositoryPropertyReference;
import com.arcway.repository.lib.high.implementation.access.RepositoryPropertySample;
import com.arcway.repository.lib.high.registration.data.lib.AbstractRepositoryStringDataType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;

public class ConfigurationManager
implements IConfigurationManager {
    private static final ILogger LOGGER = Logger.getLogger(ConfigurationManager.class);
    private static final String XMLTAG_UID_IN_CONFIGURATION = "uid";
    private static final String OBJECTREFERENCE_IN_CONFIGURATION_START_MARKER = "//++uid+in+configuration+start++/";
    private static final String OBJECTREFERENCE_IN_CONFIGURATION_END_MARKER = "/++uid+in+configuration++end++//";
    private static final RepositoryObjectTypeID REPOSITORY_OBJECT_TYPE_ID_CONFIGURATION_ITEM = COTIDsModuleData.OBJECT_TYPE_ID.createSubTypeID((IDNameSpace)new ModuleIDNameSpace(new KeySegment("genericmodule-projectconfigurationdata")), new KeySegment("configurationItem"));
    private static final IRepositoryPropertyTypeID REPOSITORY_PROPERTY_TYPE_ID_CONFIGURATION_ITEM_ID = new RepositoryPropertyTypeID(REPOSITORY_OBJECT_TYPE_ID_CONFIGURATION_ITEM, new KeySegment("id"));
    private static final IRepositoryPropertyTypeID REPOSITORY_PROPERTY_TYPE_ID_CONFIGURATION_VALUE = new RepositoryPropertyTypeID(REPOSITORY_OBJECT_TYPE_ID_CONFIGURATION_ITEM, new KeySegment("configurationValue"));
    private final ProjectAgent projectAgent;

    public ConfigurationManager(ProjectAgent projectAgent) {
        this.projectAgent = projectAgent;
    }

    public static final String getSerializedObjectReference(IRepositoryObjectReference objectReference, IRepositoryTypeManagerRO typeManager) {
        DTRepositoryObjectReference dataType = DTRepositoryObjectReference.getInstance((IRepositoryTypeManagerRO)typeManager);
        String serialisedURL = CanonicalStringCoDecForData.encodeIntoCanonicalString((IDataType)dataType, (Object)objectReference);
        return OBJECTREFERENCE_IN_CONFIGURATION_START_MARKER + serialisedURL + OBJECTREFERENCE_IN_CONFIGURATION_END_MARKER;
    }

    public static final IRepositoryObjectReference getDeserialisedObjectReference(String serialisedObjectReference, IRepositoryTypeManagerRO typeManager) {
        DTRepositoryObjectReference dataType = DTRepositoryObjectReference.getInstance((IRepositoryTypeManagerRO)typeManager);
        String serialisedObjectReferenceWithoutMarkers = serialisedObjectReference.substring(OBJECTREFERENCE_IN_CONFIGURATION_START_MARKER.length(), serialisedObjectReference.length() - OBJECTREFERENCE_IN_CONFIGURATION_END_MARKER.length());
        try {
            Object decodedObjectReference = CanonicalStringCoDecForData.decodeFromCanonicalString((IDataType)dataType, (String)serialisedObjectReferenceWithoutMarkers);
            if (decodedObjectReference instanceof IRepositoryObjectReference) {
                return (IRepositoryObjectReference)decodedObjectReference;
            }
            LOGGER.error("XML decoding of an object reference failed: (" + (decodedObjectReference == null ? "null" : decodedObjectReference.toString()) + ")");
            return null;
        }
        catch (EXDataLoadingException eDCF) {
            LOGGER.error("XML decoding of an object reference failed.", (Throwable)eDCF);
            return null;
        }
    }

    @Override
    public String getConfigurationValue(final String configurationItemID) {
        assert (configurationItemID != null);
        final ObjectWrapper resultWrapper = new ObjectWrapper(null);
        final IRepositoryInterfaceRO repositoryInterface = this.projectAgent.getRepositoryInterface();
        RepositoryInterfaces.doWithCurrentSnapshot((IRepositoryInterfaceRO)repositoryInterface, (IWithCurrentSnapshotProcessor)new IWithCurrentSnapshotProcessor(){

            public void doWithCurrentSnapshot(IRepositorySnapshotRO repositorySnapshot) throws EXNotReproducibleSnapshot {
                IRepositoryObjectType objectTypeConfigurationItem = repositoryInterface.getTypeManager().findObjectType((IRepositoryObjectTypeID)REPOSITORY_OBJECT_TYPE_ID_CONFIGURATION_ITEM);
                if (objectTypeConfigurationItem != null) {
                    IRepositoryAttributeSetType attributeSetTypeProperties = objectTypeConfigurationItem.findAttributeSetType(REPOSITORY_PROPERTY_TYPE_ID_CONFIGURATION_ITEM_ID);
                    IRepositoryObject configurationItem = ConfigurationManager.this.findConfigurationItem(repositorySnapshot, attributeSetTypeProperties, configurationItemID);
                    if (configurationItem != null) {
                        String configurationValue = ConfigurationManager.this.getConfigurationValueFromConfigurationItem(configurationItem, attributeSetTypeProperties, repositoryInterface.getTypeManager());
                        resultWrapper.setWrappedObject((Object)configurationValue);
                    }
                } else {
                    LOGGER.warn("The configuration data module is not installed.");
                }
            }
        });
        return (String)resultWrapper.getWrappedObject();
    }

    @Override
    public void setConfigurationValue(final String configurationItemID, final String configurationValue) throws EXPermissionDenied, EXLockDenied, EXTransactionExecution {
        assert (configurationItemID != null);
        assert (configurationValue != null);
        final IRepositoryInterfaceRO repositoryInterface = this.projectAgent.getRepositoryInterface();
        final ObjectWrapper permissionException = new ObjectWrapper(null);
        final ObjectWrapper lockException = new ObjectWrapper(null);
        final ObjectWrapper transactionException = new ObjectWrapper(null);
        RepositoryInterfaces.doWithCurrentSnapshot((IRepositoryInterfaceRO)repositoryInterface, (IWithCurrentSnapshotProcessor)new IWithCurrentSnapshotProcessor(){

            public void doWithCurrentSnapshot(IRepositorySnapshotRO repositorySnapshot) throws EXNotReproducibleSnapshot {
                IRepositoryObjectType objectTypeConfigurationItem = repositoryInterface.getTypeManager().findObjectType((IRepositoryObjectTypeID)REPOSITORY_OBJECT_TYPE_ID_CONFIGURATION_ITEM);
                if (objectTypeConfigurationItem != null) {
                    IRepositoryAttributeSetType attributeSetTypeProperties = objectTypeConfigurationItem.findAttributeSetType(REPOSITORY_PROPERTY_TYPE_ID_CONFIGURATION_ITEM_ID);
                    IRepositoryObject configurationItem = ConfigurationManager.this.findConfigurationItem(repositorySnapshot, attributeSetTypeProperties, configurationItemID);
                    try {
                        ConfigurationManager.this.createOrUpdateConfigurationItem(configurationItem, configurationItemID, configurationValue, repositorySnapshot, attributeSetTypeProperties, objectTypeConfigurationItem, repositoryInterface);
                    }
                    catch (EXPermissionDenied e) {
                        permissionException.setWrappedObject((Object)e);
                    }
                    catch (EXLockDenied e) {
                        lockException.setWrappedObject((Object)e);
                    }
                    catch (EXTransactionExecution e) {
                        LOGGER.warn("Could not store the configuration value \"" + configurationValue + "\" for the configuration item with the id \"" + configurationItemID + "\"", (Throwable)e);
                        transactionException.setWrappedObject((Object)e);
                    }
                } else {
                    LOGGER.warn("The configuration data module is not installed.");
                }
            }
        });
        if (transactionException.getWrappedObject() != null) {
            throw (EXTransactionExecution)((Object)transactionException.getWrappedObject());
        }
        if (permissionException.getWrappedObject() != null) {
            throw (EXPermissionDenied)((Object)permissionException.getWrappedObject());
        }
        if (lockException.getWrappedObject() != null) {
            throw (EXLockDenied)((Object)lockException.getWrappedObject());
        }
    }

    @Override
    public Collection<? extends ILockDeprecated> getLockForConfigurationValue(final String configurationItemID) throws EXLockDenied {
        assert (configurationItemID != null);
        final ObjectWrapper resultWrapper = new ObjectWrapper(null);
        final ObjectWrapper exceptionWrapper = new ObjectWrapper(null);
        final IRepositoryInterfaceRO repositoryInterface = this.projectAgent.getRepositoryInterface();
        RepositoryInterfaces.doWithCurrentSnapshot((IRepositoryInterfaceRO)repositoryInterface, (IWithCurrentSnapshotProcessor)new IWithCurrentSnapshotProcessor(){

            public void doWithCurrentSnapshot(IRepositorySnapshotRO repositorySnapshot) throws EXNotReproducibleSnapshot {
                block5: {
                    IRepositoryObjectType objectTypeConfigurationItem = repositoryInterface.getTypeManager().findObjectType((IRepositoryObjectTypeID)REPOSITORY_OBJECT_TYPE_ID_CONFIGURATION_ITEM);
                    if (objectTypeConfigurationItem != null) {
                        IRepositoryAttributeSetType attributeSetTypeProperties = objectTypeConfigurationItem.findAttributeSetType(REPOSITORY_PROPERTY_TYPE_ID_CONFIGURATION_ITEM_ID);
                        IRepositoryPropertyType propertyTypeID = attributeSetTypeProperties.findPropertyType(REPOSITORY_PROPERTY_TYPE_ID_CONFIGURATION_ITEM_ID);
                        IRepositoryObject configurationItem = ConfigurationManager.this.findConfigurationItem(repositorySnapshot, attributeSetTypeProperties, configurationItemID);
                        try {
                            if (configurationItem == null) {
                                ArrayList<ILockDeprecated> lockList = new ArrayList<ILockDeprecated>();
                                ILockDeprecated addLock = repositoryInterface.getLocksAndPermissionsManagerDeprecated().getLockForCreateCockpitData(repositorySnapshot.getRepositoryRootObject(), objectTypeConfigurationItem);
                                lockList.add(addLock);
                                ILockDeprecated idLock = repositoryInterface.getLocksAndPermissionsManagerDeprecated().getLockForUniqueID(((AbstractRepositoryStringDataType)propertyTypeID.getDataType()).createData(configurationItemID), propertyTypeID, objectTypeConfigurationItem);
                                lockList.add(idLock);
                                resultWrapper.setWrappedObject(lockList);
                                break block5;
                            }
                            resultWrapper.setWrappedObject(Collections.singleton(repositoryInterface.getLocksAndPermissionsManagerDeprecated().getLockForModifyCockpitData(configurationItem)));
                        }
                        catch (EXLockDenied eLD) {
                            exceptionWrapper.setWrappedObject((Object)eLD);
                        }
                    } else {
                        LOGGER.warn("The configuration data module is not installed.");
                        exceptionWrapper.setWrappedObject((Object)new EXLockDenied(new String[]{"The configuration data module is not installed."}));
                    }
                }
            }
        });
        if (exceptionWrapper.getWrappedObject() != null) {
            throw (EXLockDenied)((Object)exceptionWrapper.getWrappedObject());
        }
        return (Collection)resultWrapper.getWrappedObject();
    }

    @Override
    public boolean updateUIDsInConfigurationItems(final Map<String, String> uidReplacementMap) {
        final IRepositoryInterfaceRO repositoryInterface = this.projectAgent.getRepositoryInterface();
        final ObjectWrapper updateOfAnyConfigItemFailed = new ObjectWrapper((Object)Boolean.FALSE);
        RepositoryInterfaces.doWithCurrentSnapshot((IRepositoryInterfaceRO)repositoryInterface, (IWithCurrentSnapshotProcessor)new IWithCurrentSnapshotProcessor(){

            public void doWithCurrentSnapshot(IRepositorySnapshotRO repositorySnapshot) throws EXNotReproducibleSnapshot {
                IRepositoryObjectType objectTypeConfigurationItem = repositoryInterface.getTypeManager().findObjectType((IRepositoryObjectTypeID)REPOSITORY_OBJECT_TYPE_ID_CONFIGURATION_ITEM);
                if (objectTypeConfigurationItem != null) {
                    IRepositoryIterator_IRepositoryObject configurationItemIterator = repositorySnapshot.findAllObjectOfType(objectTypeConfigurationItem);
                    while (configurationItemIterator.hasNext()) {
                        IRepositoryObject configurationItem = configurationItemIterator.nextIRepositoryObject();
                        IRepositoryAttributeSetType attributeSetTypeProperties = objectTypeConfigurationItem.findAttributeSetType(REPOSITORY_PROPERTY_TYPE_ID_CONFIGURATION_ITEM_ID);
                        String configurationValue = ConfigurationManager.this.getConfigurationValueFromConfigurationItem(configurationItem, attributeSetTypeProperties, repositoryInterface.getTypeManager());
                        boolean configurationValueHasChanged = false;
                        int nextStartOfObjectReferenceIndex = 0;
                        while (true) {
                            nextStartOfObjectReferenceIndex = configurationValue.indexOf(ConfigurationManager.OBJECTREFERENCE_IN_CONFIGURATION_START_MARKER, nextStartOfObjectReferenceIndex);
                            int nextObjectReferenceEndTagIndex = configurationValue.indexOf(ConfigurationManager.OBJECTREFERENCE_IN_CONFIGURATION_END_MARKER, nextStartOfObjectReferenceIndex);
                            if (nextStartOfObjectReferenceIndex < 0 || nextObjectReferenceEndTagIndex < 0) break;
                            int nextEndOfObjectReferenceIndex = nextObjectReferenceEndTagIndex + ConfigurationManager.OBJECTREFERENCE_IN_CONFIGURATION_END_MARKER.length();
                            String oldObjectReferenceString = configurationValue.substring(nextStartOfObjectReferenceIndex, nextEndOfObjectReferenceIndex);
                            IRepositoryObjectReference oldObjectReference = ConfigurationManager.getDeserialisedObjectReference(oldObjectReferenceString, repositoryInterface.getTypeManager());
                            String oldUID = ConfigurationManager.this.projectAgent.getCockpitDataUID(oldObjectReference.getObjectID());
                            int objectReferenceLengthDifference = 0;
                            String newUID = (String)uidReplacementMap.get(oldUID);
                            if (newUID != null) {
                                configurationValueHasChanged = true;
                                RepositoryObjectReference newObjectReferenceSample = new RepositoryObjectReference(oldObjectReference.getObjectTypeID(), ConfigurationManager.this.projectAgent.getRepositoryObjectID(newUID));
                                String newObjectReferenceString = ConfigurationManager.getSerializedObjectReference((IRepositoryObjectReference)newObjectReferenceSample, repositoryInterface.getTypeManager());
                                configurationValue = String.valueOf(configurationValue.substring(0, nextStartOfObjectReferenceIndex)) + newObjectReferenceString + configurationValue.substring(nextEndOfObjectReferenceIndex);
                                objectReferenceLengthDifference = newObjectReferenceString.length() - oldObjectReferenceString.length();
                            }
                            nextStartOfObjectReferenceIndex = nextEndOfObjectReferenceIndex + objectReferenceLengthDifference;
                        }
                        if (!configurationValueHasChanged) continue;
                        try {
                            ConfigurationManager.this.createOrUpdateConfigurationItem(configurationItem, null, configurationValue, repositorySnapshot, attributeSetTypeProperties, objectTypeConfigurationItem, repositoryInterface);
                        }
                        catch (EXPermissionDenied e) {
                            LOGGER.warn("Could not update the configuration value for a configuration item according to a uid mapping.", (Throwable)e);
                            updateOfAnyConfigItemFailed.setWrappedObject((Object)Boolean.TRUE);
                        }
                        catch (EXLockDenied e) {
                            LOGGER.warn("Could not update the configuration value for a configuration item according to a uid mapping.", (Throwable)e);
                            updateOfAnyConfigItemFailed.setWrappedObject((Object)Boolean.TRUE);
                        }
                        catch (EXTransactionExecution e) {
                            LOGGER.warn("Could not update the configuration value for a configuration item according to a uid mapping.", (Throwable)e);
                            updateOfAnyConfigItemFailed.setWrappedObject((Object)Boolean.TRUE);
                        }
                    }
                } else {
                    LOGGER.warn("The configuration data module is not installed.");
                }
            }
        });
        return (Boolean)updateOfAnyConfigItemFailed.getWrappedObject() == false;
    }

    private IRepositoryObject findConfigurationItem(IRepositorySnapshotRO repositorySnapshot, IRepositoryAttributeSetType attributeSetTypeProperties, String configurationItemID) throws EXNotReproducibleSnapshot {
        IRepositoryPropertyType propertyTypeConfigurationItemID = attributeSetTypeProperties.getPropertyType(REPOSITORY_PROPERTY_TYPE_ID_CONFIGURATION_ITEM_ID);
        AbstractRepositoryStringDataType dataTypeConfigurationItemID = (AbstractRepositoryStringDataType)propertyTypeConfigurationItemID.getDataType();
        IRepositoryObject configurationItem = repositorySnapshot.findObjectByIDProperty(propertyTypeConfigurationItemID, dataTypeConfigurationItemID.createData(configurationItemID));
        return configurationItem;
    }

    private String getConfigurationValueFromConfigurationItem(IRepositoryObject configurationItem, IRepositoryAttributeSetType attributeSetTypeProperties, IRepositoryTypeManagerRO typeManager) throws EXNotReproducibleSnapshot {
        IRepositoryPropertyType propertyTypeConfigurationValue = attributeSetTypeProperties.getPropertyType(REPOSITORY_PROPERTY_TYPE_ID_CONFIGURATION_VALUE);
        AbstractRepositoryStringDataType dataTypeConfigurationValue = (AbstractRepositoryStringDataType)propertyTypeConfigurationValue.getDataType();
        IFrontendTypeManager frontendTypeManager = FrontendTypeManager.getFrontendTypeManager((IRepositoryTypeManagerRO)typeManager);
        IFrontendPropertyType frontendPropertyTypeConfigurationValue = frontendTypeManager.getFrontendPropertyType(propertyTypeConfigurationValue);
        IFrontendDataType frontendDatatypeConfigurationValue = frontendTypeManager.getFrontendDataType((IRepositoryDataType)dataTypeConfigurationValue);
        IRepositoryAttributeSet attributeSetProperties = configurationItem.getAttributeSet(attributeSetTypeProperties);
        IRepositoryProperty propertyConfigurationValue = attributeSetProperties.getProperty(propertyTypeConfigurationValue);
        IRepositoryData repositoryValueConfigurationData = propertyConfigurationValue.getValue();
        IFrontendLabel configurationValue = frontendDatatypeConfigurationValue.getLabelForValue(repositoryValueConfigurationData, propertyTypeConfigurationValue.getDataTypeParameters(), frontendPropertyTypeConfigurationValue.getFrontendDataTypeParameters(), PresentationContext.getVirtualMachineUserLocaleForNow());
        return configurationValue.getText();
    }

    private void createOrUpdateConfigurationItem(IRepositoryObject configurationItem, String configurationItemID, String configurationValue, IRepositorySnapshotRO repositorySnapshot, IRepositoryAttributeSetType attributeSetTypeProperties, IRepositoryObjectType objectTypeConfigurationItem, IRepositoryInterfaceRO repositoryInterface) throws EXLockDenied, EXPermissionDenied, EXTransactionExecution, EXNotReproducibleSnapshot {
        RSAComplexGenericModification transaction = null;
        if (configurationItem == null) {
            HashMap_ propertySamples = new HashMap_(IRepositoryPropertyTypeID.IS_EQUAL_PROPERTY_TYPE_ID_HASHER);
            IGenericModificationTypeManager genericModificationTypeManager = GenericModificationTypeManager.getGenericModificationTypeManager((IRepositoryTypeManagerRO)repositoryInterface.getTypeManager());
            IGenericModificationObjectType genericModificationObjectType = genericModificationTypeManager.getGenericModificationObjectType(objectTypeConfigurationItem);
            IRepositoryPropertySetSample newObjectID = genericModificationObjectType.allocateNewObjectID();
            for (IRepositoryPropertyTypeID objectIDPropertyType : newObjectID.getPropertyTypeIDs()) {
                propertySamples.put((Object)objectIDPropertyType, (Object)newObjectID.getPropertySample(objectIDPropertyType));
            }
            IRepositoryPropertyType propertyTypeConfigurationItemID = attributeSetTypeProperties.getPropertyType(REPOSITORY_PROPERTY_TYPE_ID_CONFIGURATION_ITEM_ID);
            AbstractRepositoryStringDataType dataTypeConfigurationItemID = (AbstractRepositoryStringDataType)propertyTypeConfigurationItemID.getDataType();
            propertySamples.put((Object)REPOSITORY_PROPERTY_TYPE_ID_CONFIGURATION_ITEM_ID, (Object)new RepositoryPropertySample(dataTypeConfigurationItemID.createData(configurationItemID)));
            IRepositoryPropertyType propertyTypeConfigurationValue = attributeSetTypeProperties.getPropertyType(REPOSITORY_PROPERTY_TYPE_ID_CONFIGURATION_VALUE);
            AbstractRepositoryStringDataType dataTypeConfigurationValue = (AbstractRepositoryStringDataType)propertyTypeConfigurationValue.getDataType();
            propertySamples.put((Object)REPOSITORY_PROPERTY_TYPE_ID_CONFIGURATION_VALUE, (Object)new RepositoryPropertySample(dataTypeConfigurationValue.createData(configurationValue)));
            RepositoryObjectSampleWithParentObjectReference configurationItemToCreate = new RepositoryObjectSampleWithParentObjectReference((IRepositoryObjectSample)new RepositoryObjectSample((IRepositoryObjectTypeID)REPOSITORY_OBJECT_TYPE_ID_CONFIGURATION_ITEM, null, (IMap_)propertySamples), (IRepositoryObjectReference)new RepositoryObjectReference(repositorySnapshot.getRepositoryRootObject()));
            transaction = new RSAComplexGenericModification(null, null, Collections_.singletonList((Object)configurationItemToCreate), null, null, null, null, null);
        } else {
            HashMap_ configurationValueToModify = new HashMap_(IRepositoryPropertyReference.REFERENCES_EQUAL_PROPERTY_HASHER);
            IRepositoryAttributeSet attributeSetProperties = configurationItem.getAttributeSet(attributeSetTypeProperties);
            IRepositoryPropertyType propertyTypeConfigurationValue = attributeSetTypeProperties.getPropertyType(REPOSITORY_PROPERTY_TYPE_ID_CONFIGURATION_VALUE);
            IRepositoryProperty propertyConfigurationValue = attributeSetProperties.getProperty(propertyTypeConfigurationValue);
            AbstractRepositoryStringDataType dataTypeConfigurationValue = (AbstractRepositoryStringDataType)propertyTypeConfigurationValue.getDataType();
            configurationValueToModify.put((Object)new RepositoryPropertyReference(propertyConfigurationValue), (Object)new RepositoryPropertySample(dataTypeConfigurationValue.createData(configurationValue)));
            transaction = new RSAComplexGenericModification(null, null, null, null, null, (IMap_)configurationValueToModify, null, null);
        }
        IRepositoryWorkspaceRO workspace = repositoryInterface.getWorkspace();
        assert (workspace instanceof IRepositoryWorkspaceRW);
        IRepositoryWorkspaceRW workspaceRW = (IRepositoryWorkspaceRW)workspace;
        IRepositoryTransaction repositoryTransaction = workspaceRW.getTransactionManager().openTransaction(RepositorySamples.getSnapshotID((IRepositoryObjectSample)repositorySnapshot.getSnapshotInformation(), (IRepositoryTypeManagerRO)repositoryInterface.getTypeManager()));
        try {
            repositoryTransaction.appendAction((AbstractRepositoryAction)transaction);
        }
        finally {
            repositoryTransaction.closeTransaction();
        }
    }
}

