/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.planeditors;

import com.arcway.cockpit.frame.client.project.core.framedata.EXModificationProblem;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.IUniqueElement;
import com.arcway.cockpit.frame.client.project.planagents.IPlanAgentUniqueElementManager;
import com.arcway.cockpit.frame.client.project.planeditors.FMCAEditorMgrCommand;
import com.arcway.cockpit.frame.client.project.planeditors.IExternalPlanEditorControllerExtension;
import com.arcway.cockpit.frame.shared.message.IUniqueElementOccurrence;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class FMCAEditorMgrCommandMakeLocal
extends FMCAEditorMgrCommand {
    private static final ILogger logger = Logger.getLogger(FMCAEditorMgrCommandMakeLocal.class);
    private final IUniqueElementOccurrence[] occurrences;
    private Map<String, String> removedOccurrences_as_planElementUIDs2uniqueElementUID;
    private final Set<IUniqueElementOccurrence> occurencesToRemove = new HashSet<IUniqueElementOccurrence>();
    private final IPlanAgentUniqueElementManager uniqueElementMgr;

    protected FMCAEditorMgrCommandMakeLocal(IExternalPlanEditorControllerExtension controller, IUniqueElementOccurrence[] occurrences) {
        super(controller);
        assert (occurrences != null);
        this.occurrences = occurrences;
        this.uniqueElementMgr = this.getProjectAgent().getPlanAgentUniqueElementManager();
    }

    public boolean canExecuteInGeneral() {
        return true;
    }

    public boolean canExecuteNow() {
        IUniqueElementOccurrence[] iUniqueElementOccurrenceArray = this.occurrences;
        int n = this.occurrences.length;
        int n2 = 0;
        while (n2 < n) {
            IUniqueElementOccurrence occurrence = iUniqueElementOccurrenceArray[n2];
            this.occurencesToRemove.add(occurrence);
            ++n2;
        }
        return true;
    }

    public boolean makesPlanRelatedChanges() {
        return true;
    }

    public void execute() {
        this.getProjectAgent().getPropertyChangesListenerManager().runWithDeferredPropertyChangePropagation(new Runnable(){

            @Override
            public void run() {
                FMCAEditorMgrCommandMakeLocal.this.removedOccurrences_as_planElementUIDs2uniqueElementUID = new HashMap(2 * FMCAEditorMgrCommandMakeLocal.this.occurencesToRemove.size());
                for (IUniqueElementOccurrence occurence : FMCAEditorMgrCommandMakeLocal.this.occurencesToRemove) {
                    IUniqueElement uniqueElement = FMCAEditorMgrCommandMakeLocal.this.getProjectAgent().getPlanAgentUniqueElementManager().getUniqueElementOfOccurrence(occurence);
                    FMCAEditorMgrCommandMakeLocal.this.removedOccurrences_as_planElementUIDs2uniqueElementUID.put(occurence.getPlanElementUID(), occurence.getElementUID());
                }
                FMCAEditorMgrCommandMakeLocal.this.uniqueElementMgr.deleteUniqueElementOccurencesUnsaved(FMCAEditorMgrCommandMakeLocal.this.getPlanEditorControllerExtension(), FMCAEditorMgrCommandMakeLocal.this.removedOccurrences_as_planElementUIDs2uniqueElementUID.keySet());
            }
        });
    }

    public boolean canUndoNow() {
        return true;
    }

    public void undo() {
        this.getProjectAgent().getPropertyChangesListenerManager().runWithDeferredPropertyChangePropagation(new Runnable(){

            @Override
            public void run() {
                Iterator i = FMCAEditorMgrCommandMakeLocal.this.removedOccurrences_as_planElementUIDs2uniqueElementUID.entrySet().iterator();
                while (i.hasNext()) {
                    Map.Entry currentEntry = i.next();
                    String uniqueElementUID = (String)currentEntry.getValue();
                    if (FMCAEditorMgrCommandMakeLocal.this.uniqueElementMgr.getUniqueElement(uniqueElementUID) != null) continue;
                    i.remove();
                    logger.debug("undo of make local failed for some UEs because the UEs are deleted in the meantime");
                }
                try {
                    FMCAEditorMgrCommandMakeLocal.this.uniqueElementMgr.createUniqueElementOccurencesUnsaved(FMCAEditorMgrCommandMakeLocal.this.getPlanEditorControllerExtension(), FMCAEditorMgrCommandMakeLocal.this.removedOccurrences_as_planElementUIDs2uniqueElementUID);
                }
                catch (EXModificationProblem e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    public void redo() {
        this.execute();
    }
}

