/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.planeditors;

import com.arcway.cockpit.frame.client.project.IPlanElement;
import com.arcway.cockpit.frame.client.project.core.framedata.EXModificationProblem;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.IUniqueElement;
import com.arcway.cockpit.frame.client.project.planagents.IPlanAgentUniqueElementManager;
import com.arcway.cockpit.frame.client.project.planeditors.FMCAEditorMgrCommand;
import com.arcway.cockpit.frame.client.project.planeditors.IExternalPlanEditorControllerExtension;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FMCAEditorMgrCommandDeletePlanElements
extends FMCAEditorMgrCommand {
    private final List planElements;
    private final Map<String, String> resignedUniqueElementUIDs;
    private final IPlanAgentUniqueElementManager uniqueElementMgr;

    protected FMCAEditorMgrCommandDeletePlanElements(IExternalPlanEditorControllerExtension controller, List planElements) {
        super(controller);
        assert (planElements != null) : "planElements is null";
        this.planElements = planElements;
        this.resignedUniqueElementUIDs = new HashMap<String, String>();
        this.uniqueElementMgr = this.getProjectAgent().getPlanAgentUniqueElementManager();
    }

    public boolean canExecuteInGeneral() {
        return true;
    }

    public boolean makesPlanRelatedChanges() {
        return true;
    }

    public boolean canExecuteNow() {
        return true;
    }

    public void execute() {
        this.getProjectAgent().getPropertyChangesListenerManager().runWithDeferredPropertyChangePropagation(new Runnable(){

            @Override
            public void run() {
                ArrayList<String> planElementUIDsOfOccurrencesToDelete = new ArrayList<String>(FMCAEditorMgrCommandDeletePlanElements.this.planElements.size());
                int i = 0;
                while (i < FMCAEditorMgrCommandDeletePlanElements.this.planElements.size()) {
                    IPlanElement planElement = (IPlanElement)FMCAEditorMgrCommandDeletePlanElements.this.planElements.get(i);
                    if (FMCAEditorMgrCommandDeletePlanElements.this.uniqueElementMgr.isAssignedToUniqueElement(planElement)) {
                        IUniqueElement uniqueElement = FMCAEditorMgrCommandDeletePlanElements.this.uniqueElementMgr.getUniqueElementOfOccurrence(planElement);
                        planElementUIDsOfOccurrencesToDelete.add(planElement.getPlanElementUID());
                        FMCAEditorMgrCommandDeletePlanElements.this.resignedUniqueElementUIDs.put(planElement.getPlanElementUID(), uniqueElement.getUID());
                    }
                    ++i;
                }
                FMCAEditorMgrCommandDeletePlanElements.this.uniqueElementMgr.deleteUniqueElementOccurencesUnsaved(FMCAEditorMgrCommandDeletePlanElements.this.getPlanEditorControllerExtension(), planElementUIDsOfOccurrencesToDelete);
            }
        });
    }

    public boolean canUndoNow() {
        return true;
    }

    public void undo() {
        this.getProjectAgent().getPropertyChangesListenerManager().runWithDeferredPropertyChangePropagation(new Runnable(){

            @Override
            public void run() {
                HashMap<String, String> planElementUIDs2uniqueElementUID = new HashMap<String, String>(2 * FMCAEditorMgrCommandDeletePlanElements.this.planElements.size());
                int i = 0;
                while (i < FMCAEditorMgrCommandDeletePlanElements.this.planElements.size()) {
                    IUniqueElement uniqueElement;
                    IPlanElement planElement = (IPlanElement)FMCAEditorMgrCommandDeletePlanElements.this.planElements.get(i);
                    String resignedUniqueElementUID = (String)FMCAEditorMgrCommandDeletePlanElements.this.resignedUniqueElementUIDs.get(planElement.getPlanElementUID());
                    if (resignedUniqueElementUID != null && (uniqueElement = FMCAEditorMgrCommandDeletePlanElements.this.uniqueElementMgr.getUniqueElement(resignedUniqueElementUID)) != null) {
                        planElementUIDs2uniqueElementUID.put(planElement.getPlanElementUID(), resignedUniqueElementUID);
                    }
                    ++i;
                }
                try {
                    FMCAEditorMgrCommandDeletePlanElements.this.uniqueElementMgr.createUniqueElementOccurencesUnsaved(FMCAEditorMgrCommandDeletePlanElements.this.getPlanEditorControllerExtension(), planElementUIDs2uniqueElementUID);
                }
                catch (EXModificationProblem e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    public void redo() {
        this.getProjectAgent().getPropertyChangesListenerManager().runWithDeferredPropertyChangePropagation(new Runnable(){

            @Override
            public void run() {
                ArrayList<String> planElementUIDs = new ArrayList<String>(FMCAEditorMgrCommandDeletePlanElements.this.planElements.size());
                int i = 0;
                while (i < FMCAEditorMgrCommandDeletePlanElements.this.planElements.size()) {
                    IPlanElement planElement = (IPlanElement)FMCAEditorMgrCommandDeletePlanElements.this.planElements.get(i);
                    if (FMCAEditorMgrCommandDeletePlanElements.this.uniqueElementMgr.isAssignedToUniqueElement(planElement)) {
                        planElementUIDs.add(planElement.getPlanElementUID());
                    }
                    ++i;
                }
                FMCAEditorMgrCommandDeletePlanElements.this.uniqueElementMgr.deleteUniqueElementOccurencesUnsaved(FMCAEditorMgrCommandDeletePlanElements.this.getPlanEditorControllerExtension(), planElementUIDs);
            }
        });
    }
}

