/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.migration.migrators.version3;

import com.arcway.cockpit.frame.client.project.core.uniqueelements.relationships.IUniqueElementOccurrenceMgr;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.relationships.UniqueElementRelationshipMgr;
import com.arcway.cockpit.frame.client.project.migration.ICockpitMigrator;
import com.arcway.cockpit.frame.client.project.migration.MigrationFailedException;
import com.arcway.cockpit.frame.client.project.migration.access_both.version0.EOFileHistoryItem_V0;
import com.arcway.cockpit.frame.client.project.migration.access_both.version0.EOPlan_V0;
import com.arcway.cockpit.frame.client.project.migration.access_both.version0.EOProject_V0;
import com.arcway.cockpit.frame.client.project.migration.access_both.version0.EOUniqueElementOccurrence_V0;
import com.arcway.cockpit.frame.client.project.migration.access_both.version0.EOUniqueElementRelationship_V0;
import com.arcway.cockpit.frame.client.project.migration.access_both.version0.V0_EOFactory;
import com.arcway.cockpit.frame.client.project.migration.access_dumps.IHistoricProjectDumpView;
import com.arcway.cockpit.frame.client.project.migration.access_dumps.IHistoricServerDumpView;
import com.arcway.cockpit.frame.client.project.migration.access_dumps.version3.HistoricProjectDumpView_3_;
import com.arcway.cockpit.frame.client.project.migration.access_projectfiles.IHistoricProjectFileView;
import com.arcway.cockpit.frame.client.project.migration.migrators.version3.planmigrators.PlanDataMigratorProjectFile;
import com.arcway.cockpit.frame.client.project.planagents.planimportexport.PlanImporterExporterManager;
import com.arcway.cockpit.frame.shared.message.EOUniqueElementRelationship;
import com.arcway.lib.codec.EXDecoderException;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.planagent.controllinginterface.planagent.IPlanAgentStructuredPlanElement;
import com.arcway.planagent.planmodel.persistent.EXPlanCreationException;
import de.plans.lib.xml.encoding.EOList;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.lib.xml.encoding.IEncodableObjectFactory;
import de.plans.lib.xml.encoding.MessageDataFactoryForUnknownEOs;
import de.plans.lib.xml.encoding.MultiplexEncodableObjectFactory;
import de.plans.lib.xml.encoding.XMLDecoder;
import de.plans.psc.shared.message.PSCPlainMessageDataFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UniqueElementRelationshipMigrator
implements ICockpitMigrator {
    private static final ILogger logger = Logger.getLogger(PlanDataMigratorProjectFile.class);
    public static final String KEY = "frame.UniqueElementRelationshipMigrator";
    private static XMLDecoder xmlDecoder = new XMLDecoder();

    @Override
    public String getKey() {
        return KEY;
    }

    @Override
    public int getSourceVersion() {
        return 3;
    }

    @Override
    public List<String> getRequiredPreceedingMigrators() {
        return Arrays.asList("com.arcway.cockpit.frame.client.project.migration.migrators.version3.plandatamigratorprojectdump");
    }

    @Override
    public IEncodableObjectFactory getRequiredEOFactoryForProjectFileMainData() {
        return null;
    }

    @Override
    public void migrateACT(IHistoricProjectFileView projectFile) throws MigrationFailedException {
    }

    @Override
    public void migrateACP(IHistoricProjectFileView projectFile) throws MigrationFailedException {
    }

    @Override
    public void migrateProjectDump(IHistoricProjectDumpView projectDump) throws MigrationFailedException {
        try {
            HistoricProjectDumpView_3_ historicView = (HistoricProjectDumpView_3_)projectDump;
            List<EOProject_V0> projects = historicView.getAllProjects();
            if (projects != null) {
                for (final EOProject_V0 currentProject : projects) {
                    EOList ueRelationships = new EOList();
                    File projectDirectory = historicView.getProjectDirectory(currentProject);
                    File filesDirectory = new File(projectDirectory, "files");
                    File fileFilesDirectory = new File(filesDirectory, "file");
                    EOList ueOccurrences = (EOList)historicView.readDataFile(currentProject, "uniqueElementOccurences.xml", null, (IEncodableObjectFactory)new MultiplexEncodableObjectFactory(new IEncodableObjectFactory[]{V0_EOFactory.getDefault(), PSCPlainMessageDataFactory.getDefault()}));
                    Map<String, Map<String, String>> map_planUID_ueOccurrenceMapping = this.getUEOccurrenceMapping((EOList<EOUniqueElementOccurrence_V0>)ueOccurrences);
                    EOList plans = (EOList)historicView.readDataFile(currentProject, "plans.xml", null, (IEncodableObjectFactory)new MultiplexEncodableObjectFactory(new IEncodableObjectFactory[]{V0_EOFactory.getDefault(), PSCPlainMessageDataFactory.getDefault(), MessageDataFactoryForUnknownEOs.getDefault()}));
                    for (final EOPlan_V0 plan : plans) {
                        File planFileDirectory = new File(fileFilesDirectory, "versions_" + plan.getUID());
                        File planVersionsFile = new File(planFileDirectory, "versions1");
                        if (planVersionsFile.exists() && planVersionsFile.canRead()) {
                            String error;
                            try {
                                EOList fileHistory = (EOList)xmlDecoder.decodeXML((InputStream)new FileInputStream(planVersionsFile), (IEncodableObjectFactory)new MultiplexEncodableObjectFactory(new IEncodableObjectFactory[]{V0_EOFactory.getDefault(), PSCPlainMessageDataFactory.getDefault()}), true);
                                EOFileHistoryItem_V0 latestVersion = (EOFileHistoryItem_V0)fileHistory.get(fileHistory.size() - 1);
                                File planFile = new File(planFileDirectory, String.valueOf(latestVersion.getVersionNumber()));
                                if (planFile.exists() && planFile.canRead()) {
                                    try {
                                        Collection<? extends IPlanAgentStructuredPlanElement> planElements = PlanImporterExporterManager.readPlanStructure(planFile);
                                        final Map<String, String> ueOccurrenceMappingForPlan = map_planUID_ueOccurrenceMapping.get(plan.getUID());
                                        Collection<EOUniqueElementRelationship> newUERelationships = UniqueElementRelationshipMgr.getUniqueElementRelationshipsForPlan(new IUniqueElementOccurrenceMgr(){

                                            @Override
                                            public String getPlanUID() {
                                                return plan.getUID();
                                            }

                                            @Override
                                            public String getProjectUID() {
                                                return currentProject.getUID();
                                            }

                                            @Override
                                            public String getUIDOfRelatedUniqueElement(String planElementUID) {
                                                return ueOccurrenceMappingForPlan != null ? (String)ueOccurrenceMappingForPlan.get(planElementUID) : null;
                                            }
                                        }, planElements);
                                        ueRelationships.addAll(this.transformUERelationships(newUERelationships));
                                        continue;
                                    }
                                    catch (EXPlanCreationException ePCE) {
                                        String error2 = "Can't read versions file for plan \"" + plan.getUID() + "\". Model Element Relationships will not be migrated.";
                                        logger.error(error2, (Throwable)ePCE);
                                        throw new MigrationFailedException(error2);
                                    }
                                }
                                String error3 = "Plan file for plan \"" + plan.getUID() + "\" does not exist. Model Element Relationships will not be migrated.";
                                logger.error(error3);
                                throw new MigrationFailedException(error3);
                            }
                            catch (EXDecoderException eDE) {
                                error = "Can't read versions file for plan \"" + plan.getUID() + "\". Model Element Relationships will not be migrated.";
                                logger.error(error, (Throwable)eDE);
                                throw new MigrationFailedException(error);
                            }
                            catch (IOException ioE) {
                                error = "Can't access versions file for plan \"" + plan.getUID() + "\". Model Element Relationships will not be migrated.";
                                logger.error(error, (Throwable)ioE);
                                throw new MigrationFailedException(error);
                            }
                        }
                        String error = "Versions file for plan \"" + plan.getUID() + "\" does not exist. Model Element Relationships will not be migrated.";
                        logger.error(error);
                        throw new MigrationFailedException(error);
                    }
                    historicView.writeDataFile(currentProject, "uniqueElementRelationships.xml", null, (EncodableObjectBase)ueRelationships);
                }
            }
        }
        catch (EXDecoderException e) {
            throw new MigrationFailedException(e);
        }
    }

    private Map<String, Map<String, String>> getUEOccurrenceMapping(EOList<EOUniqueElementOccurrence_V0> ueOccurrences) {
        HashMap<String, Map<String, String>> map_planUID_ueOccurrenceMapping = new HashMap<String, Map<String, String>>();
        for (EOUniqueElementOccurrence_V0 ueOccurrence : ueOccurrences) {
            HashMap<String, String> ueOccurrenceMapping = (HashMap<String, String>)map_planUID_ueOccurrenceMapping.get(ueOccurrence.getPlanUID());
            if (ueOccurrenceMapping == null) {
                ueOccurrenceMapping = new HashMap<String, String>();
                map_planUID_ueOccurrenceMapping.put(ueOccurrence.getPlanUID(), ueOccurrenceMapping);
            }
            ueOccurrenceMapping.put(ueOccurrence.getPlanElementUID(), ueOccurrence.getElementUID());
        }
        return map_planUID_ueOccurrenceMapping;
    }

    private Collection<EOUniqueElementRelationship_V0> transformUERelationships(Collection<EOUniqueElementRelationship> ueRelationships) {
        ArrayList<EOUniqueElementRelationship_V0> transformedUERelationships = new ArrayList<EOUniqueElementRelationship_V0>(ueRelationships.size());
        for (EOUniqueElementRelationship ueRelationship : ueRelationships) {
            EOUniqueElementRelationship_V0 transformedUERelationship = new EOUniqueElementRelationship_V0(ueRelationship.getUID(), ueRelationship.getProjectUID(), ueRelationship.getRelationshipTypeID(), ueRelationship.getUniqueElementUID1(), ueRelationship.getUniqueElementUID2(), ueRelationship.getPlanUID());
            transformedUERelationships.add(transformedUERelationship);
        }
        return transformedUERelationships;
    }

    @Override
    public void migrateServerDump(IHistoricServerDumpView serverDump) {
    }
}

