/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.migration.migrators.version0;

import com.arcway.cockpit.frame.client.project.migration.ICockpitMigrator;
import com.arcway.cockpit.frame.client.project.migration.MigrationFailedException;
import com.arcway.cockpit.frame.client.project.migration.access_both.version0.EOProject_V0;
import com.arcway.cockpit.frame.client.project.migration.access_dumps.IHistoricProjectDumpView;
import com.arcway.cockpit.frame.client.project.migration.access_dumps.IHistoricServerDumpView;
import com.arcway.cockpit.frame.client.project.migration.access_dumps.version0.HistoricProjectDumpView_0_;
import com.arcway.cockpit.frame.client.project.migration.access_projectfiles.IHistoricProjectFileView;
import com.arcway.lib.io.FileHelper;
import com.arcway.lib.resource.JvmExternalResourceInteractionException;
import de.plans.lib.xml.encoding.IEncodableObjectFactory;
import java.io.File;
import java.util.Collections;
import java.util.List;

public class ModuleDumpDirectoryMigrator
implements ICockpitMigrator {
    public static final String KEY = "com.arcway.cockpit.frame.client.project.migration.migrators.version0.moduledumpdirectorymigrator";
    private static final String OLD_REQUIREMENT_MODULE_DIRECTORY = "de.plans.fmca.requirementsmodule.server.DumpAgent";
    private static final String OLD_PROJECTP_PLANNING_MODULE_DIRECTORY = "de.plans.fmca.msprojectmodule.server.DumpAgent";
    private static final String OLD_SHORTDESC_MODULE_DIRECTORY = "de.plans.fmca.modulecollaboration.server.DumpShortDescMgr";
    private static final String OLD_ISSUE_MODULE_DIRECTORY = "ac1.ism_dump_agent";
    private static final String TARGET_REQUIREMENT_MODULE_DIRECTORY = "RQM";
    private static final String TARGET_PROJECTP_PLANNING_DIRECTORY = "PPM";
    private static final String TARGET_SHORTDESC_MODULE_DIRECTORY = "SDM";
    private static final String TARGET_ISSUE_MODULE_DIRECTORY = "ISM";

    @Override
    public String getKey() {
        return KEY;
    }

    @Override
    public IEncodableObjectFactory getRequiredEOFactoryForProjectFileMainData() {
        return null;
    }

    @Override
    public List<String> getRequiredPreceedingMigrators() {
        return Collections.singletonList("FrameDumpDirectoryMigrator");
    }

    @Override
    public int getSourceVersion() {
        return 0;
    }

    @Override
    public void migrateACP(IHistoricProjectFileView projectFile) throws MigrationFailedException {
    }

    @Override
    public void migrateACT(IHistoricProjectFileView projectFile) throws MigrationFailedException {
    }

    @Override
    public void migrateProjectDump(IHistoricProjectDumpView projectDump) throws MigrationFailedException {
        try {
            HistoricProjectDumpView_0_ historicView = (HistoricProjectDumpView_0_)projectDump;
            List<EOProject_V0> projects = historicView.getAllProjects();
            if (projects != null) {
                for (EOProject_V0 currentProject : projects) {
                    File cmmDataDirectory;
                    File oldSDMDirectory;
                    File oldISMDirectory;
                    File oldPPMDirectory;
                    File projectDirectory = historicView.getProjectDirectory(currentProject);
                    File oldRQMDirectory = new File(projectDirectory, OLD_REQUIREMENT_MODULE_DIRECTORY);
                    if (oldRQMDirectory.exists()) {
                        File targetRQMDir = new File(projectDirectory, TARGET_REQUIREMENT_MODULE_DIRECTORY);
                        targetRQMDir.mkdir();
                        FileHelper.copyDirectoryContent((File)oldRQMDirectory, (File)targetRQMDir);
                        FileHelper.deleteExistingFileOrDirectory((File)oldRQMDirectory);
                    }
                    if ((oldPPMDirectory = new File(projectDirectory, OLD_PROJECTP_PLANNING_MODULE_DIRECTORY)).exists()) {
                        File targetPPMDir = new File(projectDirectory, TARGET_PROJECTP_PLANNING_DIRECTORY);
                        targetPPMDir.mkdir();
                        FileHelper.copyDirectoryContent((File)oldPPMDirectory, (File)targetPPMDir);
                        FileHelper.deleteExistingFileOrDirectory((File)oldPPMDirectory);
                    }
                    if ((oldISMDirectory = new File(projectDirectory, OLD_ISSUE_MODULE_DIRECTORY)).exists()) {
                        File targetISMDir = new File(projectDirectory, TARGET_ISSUE_MODULE_DIRECTORY);
                        targetISMDir.mkdir();
                        FileHelper.copyDirectoryContent((File)oldISMDirectory, (File)targetISMDir);
                        FileHelper.deleteExistingFileOrDirectory((File)oldISMDirectory);
                    }
                    if ((oldSDMDirectory = new File(projectDirectory, OLD_SHORTDESC_MODULE_DIRECTORY)).exists()) {
                        File targetSDMDir = new File(projectDirectory, TARGET_SHORTDESC_MODULE_DIRECTORY);
                        targetSDMDir.mkdir();
                        FileHelper.copyDirectoryContent((File)oldSDMDirectory, (File)targetSDMDir);
                        FileHelper.deleteExistingFileOrDirectory((File)oldSDMDirectory);
                    }
                    if ((cmmDataDirectory = new File(projectDirectory, "cmm")).exists() || cmmDataDirectory.mkdir()) continue;
                    throw new MigrationFailedException("Unable to create common module data directory");
                }
            }
        }
        catch (JvmExternalResourceInteractionException e) {
            throw new MigrationFailedException(e);
        }
    }

    @Override
    public void migrateServerDump(IHistoricServerDumpView serverDump) throws MigrationFailedException {
    }
}

