/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.migration.migrators.special;

import com.arcway.cockpit.cockpitlib.client.files.IFileContentProviderForXMLFiles;
import com.arcway.cockpit.cockpitlib.client.files.XMLFileAccessor;
import com.arcway.cockpit.frame.client.project.migration.access_dumps.ProjectDumpFileAccess_ForClient;
import com.arcway.cockpit.frame.client.project.migration.migrators.special.UserGroupDataMigrationMap;
import com.arcway.cockpit.frame.shared.message.EOProject;
import com.arcway.cockpit.frame.shared.message.EOStakeholder;
import com.arcway.cockpit.frame.shared.message.MessageDataFactory;
import com.arcway.cockpit.frame.shared.message.genericframedata.EOAttribute;
import com.arcway.lib.codec.EXDecoderException;
import com.arcway.lib.io.FileHelper;
import com.arcway.lib.resource.JvmExternalResourceInteractionException;
import de.plans.lib.xml.encoding.EOEncodableObject;
import de.plans.lib.xml.encoding.EOList;
import de.plans.lib.xml.encoding.EOTuple;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.lib.xml.encoding.IEncodableObjectFactory;
import de.plans.lib.xml.encoding.MessageDataFactoryForUnknownEOs;
import de.plans.lib.xml.encoding.MultiplexEncodableObjectFactory;
import de.plans.lib.xml.encoding.XMLDecoderPool;
import de.plans.lib.xml.primitiveTypes.EOString;
import de.plans.psc.client.dump.ServerDumpFileAccess_ForClient;
import de.plans.psc.shared.DumpFileAccessException;
import de.plans.psc.shared.message.EOAddUserRequest;
import de.plans.psc.shared.message.EOGroup;
import de.plans.psc.shared.message.EOPermission;
import de.plans.psc.shared.message.EOUser;
import java.io.File;
import java.io.FileNotFoundException;

public class UserAndGroupRenamer {
    private static final IEncodableObjectFactory eoFactory = new MultiplexEncodableObjectFactory(new IEncodableObjectFactory[]{MessageDataFactory.getInstance(), MessageDataFactoryForUnknownEOs.getDefault()});
    private static final String FILENAME_GROUPS = "pscGroupTable.xml";
    private static final String FILENAME_PERMISSIONS = "pscPermissionTable.xml";
    private static final String FILENAME_USERGROUPS = "pscUserGroupTable.xml";
    private static final String FILENAME_USERS = "pscUserTable.xml";
    public static final String FILENAME_PRJ_PERMISSIONS = "permissions.xml";
    private static final String FILENAME_PRJ_STAKEHOLDERS = "Stakeholders.xml";
    private static final String FILENAME_PROJECTS = "projects.xml";
    private final UserGroupDataMigrationMap userGroupDataMigrationMap;

    public UserAndGroupRenamer(UserGroupDataMigrationMap userGroupDataMigrationMap) {
        this.userGroupDataMigrationMap = userGroupDataMigrationMap;
    }

    public void migrateServerDump(ServerDumpFileAccess_ForClient serverDump) throws DumpFileAccessException {
        File serverDumpRootDir = serverDump.getRootDirectoryOfUnzippedServerDumpFile();
        File groupsfile = new File(serverDumpRootDir, FILENAME_GROUPS);
        Object groups = UserAndGroupRenamer.readEOListFromFile(groupsfile);
        for (EOGroup group : groups) {
            group.setGroupName(this.userGroupDataMigrationMap.translateGroupname(group.getGroupName()));
        }
        UserAndGroupRenamer.writeEOToDumpFile(groups, groupsfile);
        File permissionsfile = new File(serverDumpRootDir, FILENAME_PERMISSIONS);
        Object permissions = UserAndGroupRenamer.readEOListFromFile(permissionsfile);
        block6: for (EOPermission permission : permissions) {
            switch (permission.getOwnerType()) {
                case 1: {
                    permission.setOwnerID(this.userGroupDataMigrationMap.translateGroupname(permission.getOwnerID()));
                    break;
                }
                case 0: {
                    permission.setOwnerID(this.userGroupDataMigrationMap.translateUsername(permission.getOwnerID()));
                    break;
                }
                case 2: {
                    break;
                }
                default: {
                    assert (false);
                    continue block6;
                }
            }
        }
        UserAndGroupRenamer.writeEOToDumpFile(permissions, permissionsfile);
        File usergroupsfile = new File(serverDumpRootDir, FILENAME_USERGROUPS);
        Object usergroups = UserAndGroupRenamer.readEOListFromFile(usergroupsfile);
        for (EOTuple tuple : usergroups) {
            String[] values = tuple.getValues();
            String user = values[0];
            String group = values[1];
            tuple.addValue(0, this.userGroupDataMigrationMap.translateUsername(user));
            tuple.addValue(1, this.userGroupDataMigrationMap.translateGroupname(group));
        }
        UserAndGroupRenamer.writeEOToDumpFile(usergroups, usergroupsfile);
        File addUserRequestsfile = new File(serverDumpRootDir, FILENAME_USERS);
        Object addUserRequests = UserAndGroupRenamer.readEOListFromFile(addUserRequestsfile);
        for (EOAddUserRequest addUserRequest : addUserRequests) {
            EOUser user = addUserRequest.getUser();
            user.setUserName(this.userGroupDataMigrationMap.translateUsername(user.getUserName()));
        }
        UserAndGroupRenamer.writeEOToDumpFile(addUserRequests, addUserRequestsfile);
        File frameModuleDirectory = new File(serverDumpRootDir, "COCKPIT_FRAME");
        this.migrateProjectDump(frameModuleDirectory);
    }

    public void migrateProjectDump(ProjectDumpFileAccess_ForClient projectDumpAccess) throws DumpFileAccessException {
        this.migrateProjectDump(projectDumpAccess.getRootDirectoryOfUnzippedProjectDumpFile());
    }

    public void migrateProjectDump(File projectDumpRootDir) throws DumpFileAccessException {
        File projectsfile = new File(projectDumpRootDir, FILENAME_PROJECTS);
        Object projects = UserAndGroupRenamer.readEOListFromFile(projectsfile);
        for (EOProject project : projects) {
            File frameDir = new File(new File(projectDumpRootDir, project.getProjectUID()), "frame");
            File permissionsfile = new File(frameDir, FILENAME_PRJ_PERMISSIONS);
            Object permissions = UserAndGroupRenamer.readEOListFromFile(permissionsfile);
            block6: for (EOPermission permission : permissions) {
                switch (permission.getOwnerType()) {
                    case 1: {
                        permission.setOwnerID(this.userGroupDataMigrationMap.translateGroupname(permission.getOwnerID()));
                        break;
                    }
                    case 0: {
                        permission.setOwnerID(this.userGroupDataMigrationMap.translateUsername(permission.getOwnerID()));
                        break;
                    }
                    case 2: {
                        break;
                    }
                    default: {
                        assert (false);
                        continue block6;
                    }
                }
            }
            UserAndGroupRenamer.writeEOToDumpFile(permissions, permissionsfile);
            File stakeholdersfile = new File(frameDir, FILENAME_PRJ_STAKEHOLDERS);
            Object stakeholders = UserAndGroupRenamer.readEOListFromFile(stakeholdersfile);
            for (EOStakeholder stakeholder : stakeholders) {
                for (EOAttribute attribute : stakeholder.getAttributes()) {
                    if (!"frame.stakeholder.username".equals(attribute.getAttributeTypeUID().getEOAttributeTypeID())) continue;
                    EOString valueAsEO = (EOString)attribute.getValueAsEO();
                    attribute.setValueAsEO((EOEncodableObject)new EOString(this.userGroupDataMigrationMap.translateUsername(valueAsEO.getString()), valueAsEO.getRole()));
                }
            }
            UserAndGroupRenamer.writeEOToDumpFile(stakeholders, stakeholdersfile);
        }
    }

    public static <EOL extends EOList<?>> EOL readEOListFromFile(File sourceFile) throws DumpFileAccessException {
        EncodableObjectBase eo = UserAndGroupRenamer.readEOFromFile(sourceFile);
        if (eo instanceof EOList) {
            return (EOL)((EOList)eo);
        }
        throw new DumpFileAccessException("Unexpected data format of server dump file.");
    }

    private static EncodableObjectBase readEOFromFile(File sourceFile) throws DumpFileAccessException {
        try {
            return XMLDecoderPool.decodeXMLFile((File)sourceFile, (IEncodableObjectFactory)eoFactory, (boolean)true);
        }
        catch (FileNotFoundException e) {
            throw new DumpFileAccessException((Exception)e);
        }
        catch (EXDecoderException e) {
            throw new DumpFileAccessException((Exception)((Object)e));
        }
    }

    private static <EO extends EOEncodableObject> void writeEOToDumpFile(final EO eo, File targetFile) throws DumpFileAccessException {
        if (eo != null) {
            try {
                if (targetFile.exists()) {
                    FileHelper.deleteExistingFileOrDirectory((File)targetFile);
                }
                XMLFileAccessor permissionsXMLFileAccessor = new XMLFileAccessor(targetFile, null);
                permissionsXMLFileAccessor.write(new IFileContentProviderForXMLFiles<EO>(){

                    public EO getFileContent() {
                        return eo;
                    }
                });
            }
            catch (JvmExternalResourceInteractionException jeriE) {
                throw new DumpFileAccessException((Exception)((Object)jeriE));
            }
        }
    }
}

